/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.installer.export;

import com.izforge.izpack.panels.process.AbstractUIProcessHandler;
import com.logicaldoc.installer.util.FileUtil;
import com.logicaldoc.installer.util.JavaUtil;
import com.logicaldoc.installer.util.Log;
import com.logicaldoc.installer.util.Replace;
import com.logicaldoc.util.config.ContextProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class ApplyConfiguration {
    public void run(AbstractUIProcessHandler handler, String[] args) {
        try {
            String rootDir = args[0].trim();
            String url = args[1].trim();
            String apikey = args[2].trim();
            String localFolderPath = args[3].trim();
            String remoteFolderId = args[4].trim();
            String javahome = this.detectJDK();
            String jrehome = this.detectJRE();
            File contextFile = new File(args[0] + "/conf/context.properties");
            Log.info("Save configuration into " + contextFile.getAbsolutePath(), null);
            ContextProperties prop = new ContextProperties(contextFile);
            prop.setProperty("url", url);
            prop.setProperty("apikey", apikey);
            prop.setProperty("target", localFolderPath);
            prop.setProperty("source", remoteFolderId);
            prop.setProperty("pid.file", rootDir + "/pid");
            prop.write();
            handler.logOutput("Saved configurations file", false);
            File file = new File(rootDir + "/conf/log4j2.xml");
            Replace.replace(file.getAbsolutePath(), "INSTALL_PATH", rootDir.replaceAll("\\\\", "/"));
            file = new File(rootDir + "/bin/service.bat");
            Replace.replace(file.getAbsolutePath(), "INSTALL_PATH", rootDir.replaceAll("\\\\", "/"));
            file = new File(rootDir + "/bin/servicesettings.bat");
            Replace.replace(file.getAbsolutePath(), "INSTALL_PATH", rootDir.replaceAll("\\\\", "/"));
            file = new File(rootDir + "/bin/export.bat");
            Replace.replace(file.getAbsolutePath(), "INSTALL_PATH", rootDir.replaceAll("\\\\", "/"));
            file = new File(rootDir + "/bin/export.sh");
            Replace.replace(file.getAbsolutePath(), "INSTALL_PATH", rootDir.replaceAll("\\\\", "/"));
            file = new File(rootDir + "/bin/manager.bat");
            Replace.replace(file.getAbsolutePath(), "INSTALL_PATH", rootDir.replaceAll("\\\\", "/"));
            handler.logOutput("Updated logs path", false);
            if (!FileUtil.isWindows()) {
                File[] files;
                for (File f : files = new File(rootDir + "/bin").listFiles()) {
                    if (!f.getName().contains("export") && !f.getName().endsWith(".sh")) continue;
                    handler.logOutput("Make executable " + f.getName(), false);
                    Log.info("Make executable " + f.getName(), null);
                    f.setExecutable(true);
                    Runtime.getRuntime().exec("chmod 777 " + f.getAbsolutePath());
                }
            }
            file = new File(rootDir + "/conf/log4j2.xml");
            String serviceBat = this.readFileAsString(file);
            if (!"-".equals(javahome)) {
                serviceBat = serviceBat.replaceAll("setlocal", "set \"JAVA_HOME=" + javahome.replaceAll("\\\\", "\\\\\\\\") + "\"\r\nset JRE_HOME=\r\nsetlocal\r\n");
            } else if (!"-".equals(jrehome)) {
                serviceBat = serviceBat.replaceAll("setlocal", "set \"JRE_HOME=" + jrehome.replaceAll("\\\\", "\\\\\\\\") + "\"\r\nset JAVA_HOME=\r\nsetlocal\r\n");
            }
        }
        catch (Throwable e) {
            Log.error(e.getMessage(), e);
        }
    }

    private String detectJDK() {
        Log.info("Checking Java JDK availability", null);
        String javahome = JavaUtil.getJDK();
        if (javahome == null) {
            javahome = "-";
        }
        Log.info("Found JDK home: " + javahome, null);
        return javahome;
    }

    private String detectJRE() {
        Log.info("Checking Java JRE availability", null);
        String jrehome = JavaUtil.getJRE();
        if (jrehome == null) {
            jrehome = "-";
        }
        Log.info("Found JRE home: " + jrehome, null);
        return jrehome;
    }

    private String readFileAsString(File file) throws IOException {
        StringBuffer fileData = new StringBuffer(1000);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        reader.close();
        return fileData.toString();
    }
}

