/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.installer.backup;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.installer.console.ConsolePanel;
import com.izforge.izpack.installer.panel.PanelView;
import com.izforge.izpack.panels.target.TargetConsolePanel;
import com.izforge.izpack.panels.target.TargetPanelHelper;
import com.izforge.izpack.util.Console;
import com.logicaldoc.installer.backup.LDTargetPanel;
import java.io.File;
import java.util.Properties;

public class LDTargetConsolePanel
extends TargetConsolePanel {
    private static final long serialVersionUID = 1L;

    public LDTargetConsolePanel(PanelView<ConsolePanel> panel, InstallData installData, Prompt prompt) {
        super(panel, installData, prompt);
    }

    @Override
    public boolean run(InstallData installData, Properties properties) {
        String path = properties.getProperty("INSTALL_PATH");
        if (LDTargetPanel.isExistingInstallation(path)) {
            System.err.println(installData.getMessages().get("TargetPanel.existingLogicalDOC", new Object[0]));
            return false;
        }
        return super.run(installData, properties);
    }

    @Override
    public boolean run(InstallData installData, Console console) {
        String path;
        String defaultPath = installData.getVariable("INSTALL_PATH");
        if (defaultPath == null) {
            defaultPath = "";
        }
        if ((path = console.promptLocation("Select target path [" + defaultPath + "] ", defaultPath)) != null) {
            if ((path = path.trim()).isEmpty()) {
                path = defaultPath;
            }
            if (LDTargetPanel.isExistingInstallation(path = installData.getVariables().replace(path))) {
                console.println(installData.getMessages().get("TargetPanel.existingLogicalDOC", new Object[0]));
                return false;
            }
            if (TargetPanelHelper.isIncompatibleInstallation(path, false)) {
                console.println(this.getIncompatibleInstallationMsg(installData));
                return this.run(installData, console);
            }
            if (!path.isEmpty()) {
                File selectedDir = new File(path);
                if (selectedDir.exists() && selectedDir.isDirectory() && selectedDir.list().length > 0) {
                    console.println(installData.getMessages().get("TargetPanel.warn", new Object[0]));
                }
                installData.setInstallPath(path);
                return this.promptEndPanel(installData, console);
            }
            return this.run(installData, console);
        }
        return false;
    }

    private String getIncompatibleInstallationMsg(InstallData installData) {
        return installData.getMessages().get("TargetPanel.incompatibleInstallation", new Object[0]);
    }
}

