/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.installer.backup;

import com.izforge.izpack.panels.process.AbstractUIProcessHandler;
import com.logicaldoc.installer.util.Log;
import com.logicaldoc.util.config.ContextProperties;
import java.io.File;

public class ApplyConfiguration {
    public void run(AbstractUIProcessHandler handler, String[] args) {
        try {
            String installDir = args[0].trim();
            String backupTarget = args[1].trim();
            String logicaldocHome = args[2].trim();
            String dbuser = args[3].trim();
            String dbpassword = args[4].trim();
            String dbhost = args[5].trim();
            String dbport = args[6].trim();
            String dbdatabase = args[7].trim();
            String dbbackupcommand = args[8].trim();
            String dbrestorecommand = args[9].trim();
            File backupConfigFile = new File(installDir + "/conf/context.properties");
            ContextProperties backupConfig = new ContextProperties(backupConfigFile);
            Log.info("Using backup target path: " + backupTarget, null);
            backupConfig.setProperty("backup.targetdir", backupTarget);
            Log.info("Using LogicalDOC path: " + logicaldocHome, null);
            backupConfig.setProperty("logicaldoc.home", logicaldocHome);
            backupConfig.setProperty("db.username", dbuser);
            backupConfig.setProperty("db.password", dbpassword);
            backupConfig.setProperty("db.host", dbhost);
            backupConfig.setProperty("db.port", dbport);
            backupConfig.setProperty("db.name", dbdatabase);
            backupConfig.setProperty("backup.db.command", dbbackupcommand);
            backupConfig.setProperty("restore.db.command", dbrestorecommand);
            backupConfig.setProperty("backup.db.dir", new File(installDir, "dump").getAbsolutePath());
            backupConfig.write();
            Log.info("Save configurations into " + backupConfigFile.getAbsolutePath(), null);
            handler.logOutput("Save configurations into " + backupConfigFile.getAbsolutePath(), false);
            File fwkConfigFile = new File(installDir + "/conf/fwk.properties");
            ContextProperties fwkConfig = new ContextProperties(fwkConfigFile);
            fwkConfig.setProperty("log.location.override", new File(installDir, "logs").getAbsolutePath());
            fwkConfig.write();
            Log.info("Save configurations into " + fwkConfigFile.getAbsolutePath(), null);
            handler.logOutput("Save configurations into " + fwkConfigFile.getAbsolutePath(), false);
        }
        catch (Throwable e) {
            Log.error(e.getMessage(), e);
        }
    }
}

