/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.importfolder.webservice.soap.endpoint;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.enterprise.license.FeatureNotEnabledException;
import com.logicaldoc.importfolder.ImportFolder;
import com.logicaldoc.importfolder.ImportFolderDAO;
import com.logicaldoc.importfolder.webservice.model.WSImportFolder;
import com.logicaldoc.importfolder.webservice.soap.ImportFolderService;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.webservice.AbstractService;
import com.logicaldoc.webservice.WebserviceException;
import com.logicalobjects.jlicense.license.LicenseManager;
import java.util.ArrayList;
import java.util.List;

public class SoapImportFolderService
extends AbstractService
implements ImportFolderService {
    @Override
    public List<WSImportFolder> list(String sid) throws FeatureNotEnabledException, WebserviceException, PersistenceException {
        this.checkAdministrator(sid);
        User user = this.validateSession(sid);
        if (!LicenseManager.getInstance().isEnabled("Feature_1") && !LicenseManager.getInstance().isEnabled("Feature_61")) {
            throw new FeatureNotEnabledException();
        }
        ArrayList<WSImportFolder> folders = new ArrayList<WSImportFolder>();
        ImportFolderDAO dao = Context.get(ImportFolderDAO.class);
        for (ImportFolder s : dao.findAll(user.getTenantId())) {
            folders.add(WSImportFolder.fromImportFolder(s));
        }
        return folders;
    }

    @Override
    public long store(String sid, WSImportFolder wsImportFolder) throws WebserviceException, PersistenceException, FeatureNotEnabledException {
        this.checkAdministrator(sid);
        User user = this.validateSession(sid);
        if (wsImportFolder.getProvider().equals("smb") && !LicenseManager.getInstance().isEnabled("Feature_1")) {
            throw new FeatureNotEnabledException();
        }
        if (wsImportFolder.getProvider().equals("file") && !LicenseManager.getInstance().isEnabled("Feature_61")) {
            throw new FeatureNotEnabledException();
        }
        ImportFolderDAO dao = Context.get(ImportFolderDAO.class);
        ImportFolder importFolder = wsImportFolder.toImportFolder();
        if (wsImportFolder.getId() != 0L) {
            importFolder = (ImportFolder)dao.findById(wsImportFolder.getId());
            importFolder.setDelImport(wsImportFolder.getDelImport());
            importFolder.setDepth(wsImportFolder.getDepth());
            importFolder.setDomain(wsImportFolder.getDomain());
            importFolder.setEnabled(wsImportFolder.getEnabled());
            importFolder.setExcludes(wsImportFolder.getExcludes());
            importFolder.setHost(wsImportFolder.getHost());
            importFolder.setIncludes(wsImportFolder.getIncludes());
            importFolder.setLanguage(wsImportFolder.getLanguage());
            importFolder.setMaxSize(wsImportFolder.getMaxSize());
            importFolder.setPassword(wsImportFolder.getPassword());
            importFolder.setPath(wsImportFolder.getPath());
            importFolder.setPort(wsImportFolder.getPort());
            importFolder.setProvider(wsImportFolder.getProvider());
            importFolder.setTags(wsImportFolder.getTags());
            importFolder.setTargetFolderId(wsImportFolder.getTargetFolderId());
            importFolder.setTemplateId(wsImportFolder.getTemplateId());
            importFolder.setOcrTemplateId(wsImportFolder.getOcrTemplateId());
            importFolder.setBarcodeTemplateId(wsImportFolder.getBarcodeTemplateId());
            importFolder.setUsername(wsImportFolder.getUsername());
            importFolder.setTenantId(user.getTenantId());
            importFolder.setInheritRights(wsImportFolder.getInheritRights());
            importFolder.setPreventDuplications(wsImportFolder.getPreventDuplications());
        }
        if ("smb".equals(importFolder.getProvider())) {
            importFolder.setPath(importFolder.getPath().replace("\\", "/").trim());
        }
        return wsImportFolder.getId();
    }

    @Override
    public void delete(String sid, long folderId) throws PersistenceException, WebserviceException {
        this.checkAdministrator(sid);
        ImportFolderDAO dao = Context.get(ImportFolderDAO.class);
        dao.delete(folderId);
    }
}

