/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.importfolder.webservice.model;

import com.logicaldoc.importfolder.ImportFolder;
import com.logicaldoc.webservice.AbstractService;

public class WSImportFolder {
    private long id;
    private String path;
    private String domain;
    private String username;
    private String password;
    private String host;
    private String port;
    private String provider = "smb";
    private Long targetFolderId;
    private int enabled = 1;
    private Integer maxSize = null;
    private String includes = "*.pdf,*.doc*,*.txt";
    private String excludes = "*~,#*#,.#*,%*%,._*,.DS_Store";
    private String tags = "";
    private String language = "";
    private Long templateId;
    private Long ocrTemplateId;
    private Long barcodeTemplateId;
    private int depth = 5;
    private int delImport = 0;
    private int inheritRights = 1;
    private int recordHistory = 0;
    private int preventDuplications = 0;
    private String lastModified;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public Long getTargetFolderId() {
        return this.targetFolderId;
    }

    public void setTargetFolderId(Long targetFolderId) {
        this.targetFolderId = targetFolderId;
    }

    public int getEnabled() {
        return this.enabled;
    }

    public void setEnabled(int enabled) {
        this.enabled = enabled;
    }

    public Integer getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(Integer maxSize) {
        this.maxSize = maxSize;
    }

    public String getIncludes() {
        return this.includes;
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public Long getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public int getDelImport() {
        return this.delImport;
    }

    public void setDelImport(int delImport) {
        this.delImport = delImport;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public ImportFolder toImportFolder() {
        ImportFolder importFolder = new ImportFolder();
        try {
            importFolder.setId(this.getId());
            importFolder.setDelImport(this.getDelImport());
            importFolder.setDepth(this.getDepth());
            importFolder.setDomain(this.getDomain());
            importFolder.setEnabled(this.getEnabled());
            importFolder.setExcludes(this.getExcludes());
            importFolder.setHost(this.getHost());
            importFolder.setIncludes(this.getIncludes());
            importFolder.setLanguage(this.getLanguage());
            importFolder.setMaxSize(this.getMaxSize());
            importFolder.setPassword(this.getPassword());
            importFolder.setPath(this.getPath());
            importFolder.setPort(this.getPort());
            importFolder.setProvider(this.getProvider());
            importFolder.setTags(this.getTags());
            importFolder.setTargetFolderId(this.getTargetFolderId());
            importFolder.setTemplateId(this.getTemplateId());
            importFolder.setOcrTemplateId(this.getOcrTemplateId());
            importFolder.setBarcodeTemplateId(this.getBarcodeTemplateId());
            importFolder.setUsername(this.getUsername());
            importFolder.setRecordHistory(this.getRecordHistory());
            importFolder.setPreventDuplications(this.getPreventDuplications());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return importFolder;
    }

    public static WSImportFolder fromImportFolder(ImportFolder importFolder) {
        WSImportFolder wsImportFolder = new WSImportFolder();
        try {
            wsImportFolder.setId(importFolder.getId());
            wsImportFolder.setDelImport(importFolder.getDelImport());
            wsImportFolder.setDepth(importFolder.getDepth());
            wsImportFolder.setDomain(importFolder.getDomain());
            wsImportFolder.setEnabled(importFolder.getEnabled());
            wsImportFolder.setExcludes(importFolder.getExcludes());
            wsImportFolder.setHost(importFolder.getHost());
            wsImportFolder.setIncludes(importFolder.getIncludes());
            wsImportFolder.setLanguage(importFolder.getLanguage());
            wsImportFolder.setMaxSize(importFolder.getMaxSize());
            wsImportFolder.setPassword(importFolder.getPassword());
            wsImportFolder.setPath(importFolder.getPath());
            wsImportFolder.setPort(importFolder.getPort());
            wsImportFolder.setProvider(importFolder.getProvider());
            wsImportFolder.setTags(importFolder.getTags());
            wsImportFolder.setTargetFolderId(importFolder.getTargetFolderId());
            wsImportFolder.setTemplateId(importFolder.getTemplateId());
            wsImportFolder.setOcrTemplateId(importFolder.getOcrTemplateId());
            wsImportFolder.setBarcodeTemplateId(importFolder.getBarcodeTemplateId());
            wsImportFolder.setUsername(importFolder.getUsername());
            wsImportFolder.setInheritRights(importFolder.getInheritRights());
            wsImportFolder.setRecordHistory(importFolder.getRecordHistory());
            wsImportFolder.setPreventDuplications(importFolder.getPreventDuplications());
            wsImportFolder.setLastModified(AbstractService.convertDateToString(importFolder.getLastModified()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return wsImportFolder;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getInheritRights() {
        return this.inheritRights;
    }

    public void setInheritRights(int inheritRights) {
        this.inheritRights = inheritRights;
    }

    public Long getBarcodeTemplateId() {
        return this.barcodeTemplateId;
    }

    public void setBarcodeTemplateId(Long barcodeTemplateId) {
        this.barcodeTemplateId = barcodeTemplateId;
    }

    public Long getOcrTemplateId() {
        return this.ocrTemplateId;
    }

    public void setOcrTemplateId(Long ocrTemplateId) {
        this.ocrTemplateId = ocrTemplateId;
    }

    public int getRecordHistory() {
        return this.recordHistory;
    }

    public void setRecordHistory(int recordHistory) {
        this.recordHistory = recordHistory;
    }

    public int getPreventDuplications() {
        return this.preventDuplications;
    }

    public void setPreventDuplications(int preventDuplications) {
        this.preventDuplications = preventDuplications;
    }
}

