/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.importfolder.web;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.sequence.SequenceDAO;
import com.logicaldoc.i18n.I18N;
import com.logicaldoc.importfolder.ImportFolder;
import com.logicaldoc.importfolder.ImportFolderDAO;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.data.AbstractDataServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;

public class ImportFoldersDataServlet
extends AbstractDataServlet {
    private static final long serialVersionUID = 1L;

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response, Session session, Integer max, Locale locale) throws PersistenceException, IOException {
        PrintWriter writer = response.getWriter();
        writer.write("<list>");
        SequenceDAO sDao = Context.get(SequenceDAO.class);
        for (ImportFolder importFolder : Context.get(ImportFolderDAO.class).findAll(session.getTenantId())) {
            writer.print("<folder>");
            writer.print("<id>" + importFolder.getId() + "</id>");
            writer.print("<targetFolderId>" + String.valueOf(importFolder.getTargetFolderId()) + "</targetFolderId>");
            writer.print("<src><![CDATA[" + importFolder.getDisplayUrl() + "]]></src>");
            writer.print("<provider><![CDATA[" + importFolder.getProvider() + "]]></provider>");
            String type = "";
            if (importFolder.getProvider() != null) {
                if (importFolder.getProvider().startsWith("smb")) {
                    type = I18N.message(importFolder.getProvider() + "share", locale);
                } else if (importFolder.getProvider().equals("ftp")) {
                    type = I18N.message("fftp", locale);
                } else if (importFolder.getProvider().equals("ftps")) {
                    type = I18N.message("ftps", locale);
                } else if (importFolder.getProvider().equals("sftp")) {
                    type = I18N.message("sftp", locale);
                } else if (importFolder.getProvider().equals("file")) {
                    type = I18N.message("localfolder", locale);
                }
            }
            writer.print("<type><![CDATA[" + type + "]]></type>");
            writer.print("<docs>" + sDao.getCurrentValue("ifcounter", importFolder.getId(), importFolder.getTenantId()) + "</docs>");
            writer.print("<eenabled>" + Boolean.toString(importFolder.getEnabled() == 1) + "</eenabled>");
            writer.print("</folder>");
        }
        writer.write("</list>");
    }
}

