/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.importfolder.web;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.sequence.SequenceDAO;
import com.logicaldoc.gui.common.client.ServerException;
import com.logicaldoc.gui.common.client.beans.GUIFolder;
import com.logicaldoc.gui.common.client.beans.GUIImportFolder;
import com.logicaldoc.gui.frontend.client.services.ImportFolderService;
import com.logicaldoc.importfolder.Crawler;
import com.logicaldoc.importfolder.ImportFolder;
import com.logicaldoc.importfolder.ImportFolderCacheManager;
import com.logicaldoc.importfolder.ImportFolderCrawler;
import com.logicaldoc.importfolder.ImportFolderDAO;
import com.logicaldoc.importfolder.helper.CrawlerHelper;
import com.logicaldoc.importfolder.helper.fs.FSHelper;
import com.logicaldoc.importfolder.helper.ftp.FTPHelper;
import com.logicaldoc.importfolder.helper.sftp.SFTPHelper;
import com.logicaldoc.importfolder.helper.smb.SMBHelper;
import com.logicaldoc.importfolder.helper.smb3.SMB3Helper;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.service.AbstractRemoteService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportFolderServiceImpl
extends AbstractRemoteService
implements ImportFolderService {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ImportFolderServiceImpl.class);

    public void delete(long id) throws ServerException {
        Session session = this.validateSession();
        try {
            Context.get(ImportFolderDAO.class).delete(id);
        }
        catch (PersistenceException pe) {
            this.throwServerException(session, log, new PersistenceException("Import Folder has not been deleted", pe));
        }
        catch (Exception t) {
            this.throwServerException(session, log, t);
        }
    }

    public GUIImportFolder save(GUIImportFolder guiImportFolder) throws ServerException {
        Session session = this.validateSession();
        ImportFolder importFolder = new ImportFolder();
        try {
            Context context = Context.get();
            ImportFolderDAO dao = context.getBean(ImportFolderDAO.class);
            if (guiImportFolder.getId() > 0L) {
                importFolder = (ImportFolder)dao.findById(guiImportFolder.getId());
            }
            if (guiImportFolder.getMaxSize() == null) {
                importFolder.setMaxSize(null);
            } else {
                importFolder.setMaxSize(guiImportFolder.getMaxSize() * 1024);
            }
            if (guiImportFolder.getProvider().startsWith("smb")) {
                String str = guiImportFolder.getPath().replace("\\", "/").trim();
                while (str.startsWith("/")) {
                    str = str.substring(1);
                }
                String host = str.substring(0, str.indexOf(47));
                String path = str.substring(str.indexOf(47));
                importFolder.setHost(host);
                importFolder.setPath(path);
                importFolder.setPort(null);
            } else {
                importFolder.setPath(guiImportFolder.getPath());
                importFolder.setHost(guiImportFolder.getHost());
                importFolder.setPort(guiImportFolder.getPort() != null ? Integer.toString(guiImportFolder.getPort()) : null);
            }
            importFolder.setTenantId(session.getTenantId());
            importFolder.setProvider(guiImportFolder.getProvider());
            importFolder.setDomain(guiImportFolder.getDomain());
            importFolder.setUsername(guiImportFolder.getUsername());
            importFolder.setPassword(ImportFolder.encryptPassword(guiImportFolder.getPassword()));
            importFolder.setDelImport(guiImportFolder.isDelImport() ? 1 : 0);
            importFolder.setImportEmpty(guiImportFolder.isImportEmpty() ? 1 : 0);
            importFolder.setEnabled(guiImportFolder.getEnabled());
            importFolder.setExcludes(guiImportFolder.getExcludes());
            importFolder.setIncludes(guiImportFolder.getIncludes());
            importFolder.setLanguage(guiImportFolder.getLanguage());
            importFolder.setDepth(guiImportFolder.getDepth());
            importFolder.setTags(guiImportFolder.getTags());
            importFolder.setTargetFolderId(guiImportFolder.getTarget().getId());
            importFolder.setTemplateId(guiImportFolder.getTemplateId());
            importFolder.setOcrTemplateId(guiImportFolder.getOcrTemplateId());
            importFolder.setBarcodeTemplateId(guiImportFolder.getBarcodeTemplateId());
            importFolder.setStartDate(guiImportFolder.getStartDate());
            importFolder.setUpdatePolicy(guiImportFolder.getUpdatePolicy());
            importFolder.setInheritRights(guiImportFolder.isInheritRights() ? 1 : 0);
            importFolder.setPreventDuplications(guiImportFolder.isPreventDuplications() ? 1 : 0);
            importFolder.setRecordHistory(guiImportFolder.isRecordHistory() ? 1 : 0);
            importFolder.setBatch(guiImportFolder.getBatch());
            importFolder.setAutomation(guiImportFolder.getAutomation());
            importFolder.setAutomationAfter(guiImportFolder.getAutomationAfter());
            importFolder.setAutomationEnd(guiImportFolder.getAutomationEnd());
            this.store(importFolder);
        }
        catch (Exception t) {
            this.throwServerException(session, log, t);
        }
        guiImportFolder.setId(importFolder.getId());
        return guiImportFolder;
    }

    private void store(ImportFolder importFolder) throws PersistenceException {
        try {
            Context.get(ImportFolderDAO.class).store(importFolder);
        }
        catch (Exception e) {
            throw new PersistenceException(String.format("Import Follder has not been %s", importFolder.getId() != 0L ? "updated" : "stored"), e);
        }
    }

    private boolean isSMB(ImportFolder importFolder) {
        return importFolder.getProvider().equals("smb") || importFolder.getProvider().equals("smb2") || importFolder.getProvider().equals("smb3");
    }

    public GUIImportFolder get(long id) throws ServerException {
        Session session = this.validateSession();
        try {
            Context context = Context.get();
            ImportFolderDAO dao = context.getBean(ImportFolderDAO.class);
            ImportFolder importFolder = (ImportFolder)dao.findById(id);
            GUIImportFolder guiImportFolder = new GUIImportFolder();
            guiImportFolder.setId(importFolder.getId());
            guiImportFolder.setPath(this.isSMB(importFolder) ? importFolder.getDisplayUrl() : importFolder.getPath());
            guiImportFolder.setDomain(importFolder.getDomain());
            guiImportFolder.setUsername(importFolder.getUsername());
            guiImportFolder.setPassword(ImportFolder.decryptPassword(importFolder.getPassword()));
            guiImportFolder.setHost(importFolder.getHost());
            guiImportFolder.setPort(importFolder.getPort() != null ? Integer.valueOf(Integer.parseInt(importFolder.getPort())) : null);
            guiImportFolder.setDepth(importFolder.getDepth());
            guiImportFolder.setEnabled(importFolder.getEnabled());
            guiImportFolder.setDelImport(importFolder.getDelImport() == 1);
            guiImportFolder.setImportEmpty(importFolder.getImportEmpty() == 1);
            guiImportFolder.setExcludes(importFolder.getExcludes());
            guiImportFolder.setIncludes(importFolder.getIncludes());
            if (importFolder.getMaxSize() != null) {
                guiImportFolder.setMaxSize(Integer.valueOf(importFolder.getMaxSize() / 1024));
            }
            guiImportFolder.setProvider(importFolder.getProvider());
            guiImportFolder.setTags(importFolder.getTags());
            guiImportFolder.setTemplateId(importFolder.getTemplateId());
            guiImportFolder.setOcrTemplateId(importFolder.getOcrTemplateId());
            guiImportFolder.setBarcodeTemplateId(importFolder.getBarcodeTemplateId());
            guiImportFolder.setLanguage(importFolder.getLanguage());
            guiImportFolder.setStartDate(importFolder.getStartDate());
            guiImportFolder.setUpdatePolicy(importFolder.getUpdatePolicy());
            guiImportFolder.setInheritRights(importFolder.getInheritRights() == 1);
            guiImportFolder.setPreventDuplications(importFolder.getPreventDuplications() == 1);
            guiImportFolder.setRecordHistory(importFolder.getRecordHistory() == 1);
            guiImportFolder.setBatch(Long.valueOf(importFolder.getBatch()));
            guiImportFolder.setAutomation(importFolder.getAutomation());
            guiImportFolder.setAutomationAfter(importFolder.getAutomationAfter());
            guiImportFolder.setAutomationEnd(importFolder.getAutomationEnd());
            this.setTargetFolder(importFolder, guiImportFolder);
            return guiImportFolder;
        }
        catch (Exception t) {
            return (GUIImportFolder)this.throwServerException(session, log, t);
        }
    }

    private void setTargetFolder(ImportFolder importFolder, GUIImportFolder guiImportFolder) throws PersistenceException {
        FolderDAO fdao = Context.get(FolderDAO.class);
        GUIFolder folder = new GUIFolder();
        Folder f = null;
        try {
            f = fdao.findFolder(importFolder.getTargetFolderId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (f != null) {
            long rootId = fdao.findRoot(f.getTenantId()).getId();
            folder.setId(f.getId());
            if (f.getId() == rootId) {
                folder.setName("/");
            } else {
                folder.setName(f.getName());
            }
        }
        guiImportFolder.setTarget(folder);
    }

    public boolean test(long id) throws ServerException {
        Session session = this.validateSession();
        try {
            ImportFolder s = (ImportFolder)Context.get(ImportFolderDAO.class).findById(id);
            CrawlerHelper helper = null;
            Crawler dummy = new Crawler(null, new ImportFolderCrawler(), log);
            if ("file".equals(s.getProvider())) {
                helper = new FSHelper(s, dummy);
            } else if ("smb".equals(s.getProvider())) {
                helper = new SMBHelper(s, dummy);
            } else if ("smb2".equals(s.getProvider()) || "smb3".equals(s.getProvider())) {
                helper = new SMB3Helper(s, dummy);
            } else if ("ftp".equals(s.getProvider()) || "ftps".equals(s.getProvider())) {
                helper = new FTPHelper(s, dummy);
            } else if ("sftp".equals(s.getProvider())) {
                helper = new SFTPHelper(s, dummy);
            }
            if (helper == null) {
                throw new ServerException("No helper");
            }
            if (!((CrawlerHelper)helper).testConnection()) {
                throw new ServerException("Can't read");
            }
            return true;
        }
        catch (Exception t) {
            this.throwServerException(session, log, t);
            return false;
        }
    }

    public void changeStatus(long id, boolean enabled) throws ServerException {
        Session session = this.validateSession();
        try {
            ImportFolderDAO dao = Context.get(ImportFolderDAO.class);
            ImportFolder s = (ImportFolder)dao.findById(id);
            if (s.getEnabled() == 0) {
                s.setEnabled(1);
            } else {
                s.setEnabled(0);
            }
            dao.store(s);
        }
        catch (PersistenceException pe) {
            this.throwServerException(session, log, new PersistenceException("Import Folder has not been updated", pe));
        }
        catch (Exception t) {
            this.throwServerException(session, log, t);
        }
    }

    public void resetCache(long id) throws ServerException {
        Session session = this.validateSession();
        try {
            Context.get(ImportFolderCacheManager.class).deleteCache(id);
        }
        catch (Exception t) {
            this.throwServerException(session, log, t);
        }
    }

    public void resetCounter(long id) throws ServerException {
        Session session = this.validateSession();
        try {
            ImportFolder importFolder = (ImportFolder)Context.get(ImportFolderDAO.class).findById(id);
            Context.get(SequenceDAO.class).reset("ifcounter", importFolder.getId(), importFolder.getTenantId(), 0L);
        }
        catch (Exception t) {
            this.throwServerException(session, log, t);
        }
    }

    public GUIImportFolder clone(long id) throws ServerException {
        Session session = this.validateSession();
        try {
            ImportFolderDAO dao = Context.get(ImportFolderDAO.class);
            ImportFolder a = (ImportFolder)dao.findById(id);
            dao.initialize(a);
            ImportFolder clone = new ImportFolder(a);
            dao.store(clone);
            return this.get(clone.getId());
        }
        catch (Exception t) {
            return (GUIImportFolder)this.throwServerException(session, log, t);
        }
    }
}

