/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.importfolder.web;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.DocumentHistoryDAO;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.util.IconSelector;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.data.AbstractDataServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class ImportFolderHistoriesDataServlet
extends AbstractDataServlet {
    private static final String EVENT = "event";
    private static final String IMPORT_FOLDER_ID = "importFolderId";
    private static final long serialVersionUID = 1L;

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response, Session session, Integer max, Locale locale) throws PersistenceException, IOException {
        DateFormat df = this.getDateFormat();
        PrintWriter writer = response.getWriter();
        writer.write("<list>");
        for (Object gridRecord : this.retrieveRecords(request, max)) {
            Object[] cols = (Object[])gridRecord;
            this.printRecord(writer, cols, df);
        }
        writer.write("</list>");
    }

    private void printRecord(PrintWriter writer, Object[] cols, DateFormat df) {
        writer.print("<history>");
        writer.write("<id>" + String.valueOf(cols[10]) + "</id>");
        writer.print("<event>" + String.valueOf(cols[0]) + "</event>");
        writer.print("<date>" + df.format((Date)cols[1]) + "</date>");
        if (cols[2] != null) {
            writer.print("<comment><![CDATA[" + String.valueOf(cols[2]) + "]]></comment>");
        }
        if (cols[3] != null) {
            writer.print("<filename><![CDATA[" + String.valueOf(cols[3]) + "]]></filename>");
            writer.print("<icon>" + FileUtil.getBaseName(IconSelector.selectIcon(FileUtil.getExtension((String)cols[3]))) + "</icon>");
        }
        if (cols[4] != null) {
            writer.print("<folderId>" + String.valueOf(cols[4]) + "</folderId>");
        }
        if (cols[5] != null) {
            writer.print("<docId>" + String.valueOf(cols[5]) + "</docId>");
        }
        if (cols[6] != null) {
            writer.print("<path><![CDATA[" + String.valueOf(cols[6]) + "]]></path>");
        }
        if (cols[7] != null) {
            writer.write("<color><![CDATA[" + String.valueOf(cols[7]) + "]]></color>");
        }
        if (cols[8] != null) {
            writer.write("<source><![CDATA[" + String.valueOf(cols[8]) + String.valueOf(cols[9]) + "]]></source>");
        }
        if (cols[11] != null) {
            writer.write("<size>" + String.valueOf(cols[11]) + "</size>");
        }
        writer.print("</history>");
    }

    private List<?> retrieveRecords(HttpServletRequest request, Integer max) throws PersistenceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        DocumentHistoryDAO dao = Context.get(DocumentHistoryDAO.class);
        StringBuilder query = new StringBuilder("select A.event, A.date, A.comment, A.filename, A.folderId, A.docId, A.path, A.color, A.pathOld, A.filenameOld, A.id, A.fileSize from ImportFolderHistory A where 1=1 and A.deleted = 0 ");
        if (request.getParameter(IMPORT_FOLDER_ID) != null) {
            query.append(" and A.importFolderId = :importFolderId");
            params.put(IMPORT_FOLDER_ID, Long.parseLong(request.getParameter(IMPORT_FOLDER_ID)));
        }
        if (request.getParameter(EVENT) != null) {
            query.append(" and A.event = :event");
            params.put(EVENT, request.getParameter(EVENT));
        }
        query.append(" order by A.date desc ");
        return dao.findByQuery(query.toString(), params, max != null ? max : 100);
    }
}

