/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.importfolder.helper.smb3;

import com.hierynomus.msfscc.fileinformation.FileAllInformation;
import com.hierynomus.msfscc.fileinformation.FileIdBothDirectoryInformation;
import com.hierynomus.smbj.SMBClient;
import com.hierynomus.smbj.SmbConfig;
import com.hierynomus.smbj.auth.AuthenticationContext;
import com.hierynomus.smbj.connection.Connection;
import com.hierynomus.smbj.session.Session;
import com.hierynomus.smbj.share.DiskShare;
import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.metadata.Template;
import com.logicaldoc.core.metadata.TemplateDAO;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.impex.Index;
import com.logicaldoc.impex.IndexHandler;
import com.logicaldoc.impex.IndexHeaderHandler;
import com.logicaldoc.importfolder.Crawler;
import com.logicaldoc.importfolder.ImportFolder;
import com.logicaldoc.importfolder.ImportFolderCache;
import com.logicaldoc.importfolder.ImportFolderIndexHandler;
import com.logicaldoc.importfolder.IndexCSV;
import com.logicaldoc.importfolder.helper.CrawlerHelper;
import com.logicaldoc.importfolder.helper.smb3.SMB3File;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMB3Helper
extends CrawlerHelper {
    private static final String SLASH = "/";
    private static final String INDEX_CSV = "index.csv";
    private static final String INDEX_XML = "index.xml";
    private static final Logger log = LoggerFactory.getLogger(SMB3Helper.class);

    public SMB3Helper(ImportFolder importFolder, Crawler crawler) throws PersistenceException {
        super(importFolder, crawler);
    }

    @Override
    public void checkinFile(Object file, long docId, User owner) throws IOException, PersistenceException {
        File localFile = null;
        try {
            SMB3File smbFile = (SMB3File)file;
            localFile = this.downloadFile(smbFile);
            this.checkin(file, docId, owner, smbFile.getName(), smbFile.getPath(), localFile);
        }
        catch (Throwable throwable) {
            if (localFile != null) {
                FileUtil.delete(localFile);
            }
            throw throwable;
        }
        if (localFile != null) {
            FileUtil.delete(localFile);
        }
    }

    @Override
    public Document importFile(Object file, Folder folder, User owner, boolean timestamp) throws IOException, PersistenceException {
        Document document;
        File localFile = null;
        try {
            SMB3File smbFile = (SMB3File)file;
            localFile = this.downloadFile(smbFile);
            if (!localFile.exists() || localFile.length() <= 0L) {
                throw new IOException("Unable to download remote file");
            }
            document = this.create(file, folder, owner, timestamp, smbFile.getName(), smbFile.getPath(), localFile);
        }
        catch (Throwable throwable) {
            FileUtil.delete(localFile);
            throw throwable;
        }
        FileUtil.delete(localFile);
        return document;
    }

    /*
     * Exception decompiling
     */
    private File downloadFile(SMB3File f) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 20[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String getName(Object file) {
        SMB3File smbFile = (SMB3File)file;
        return smbFile.getName();
    }

    @Override
    public String getPath(Object file) {
        String path = ((SMB3File)file).getPath();
        Object importFolderPath = this.importFolder.getPath();
        if (((String)importFolderPath).startsWith(SLASH)) {
            importFolderPath = ((String)importFolderPath).substring(1);
        }
        if (((String)(importFolderPath = ((String)importFolderPath).substring(((String)importFolderPath).indexOf(47) + 1))).startsWith(SLASH)) {
            importFolderPath = ((String)importFolderPath).substring(1);
        }
        if (!((String)importFolderPath).endsWith(SLASH)) {
            importFolderPath = (String)importFolderPath + SLASH;
        }
        if (path.startsWith((String)importFolderPath)) {
            path = path.substring(((String)importFolderPath).length());
        }
        return path;
    }

    @Override
    public Date getLastModified(Object file) {
        try {
            return ((SMB3File)file).getLastModified();
        }
        catch (Exception e) {
            return new Date();
        }
    }

    @Override
    public Date getCreationDate(Object file) {
        try {
            return ((SMB3File)file).getCreation();
        }
        catch (Exception e) {
            return this.getLastModified(file);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void importUsingIndex(Crawler crawler) {
        File indexFile;
        block66: {
            indexFile = null;
            try {
                try {
                    SMB3File indexSmbFile;
                    String indexPath;
                    DiskShare share;
                    Session session;
                    Object var15_24;
                    Throwable throwable;
                    String[] shareAndPath;
                    AuthenticationContext ac;
                    Connection connection;
                    SMBClient client;
                    Object var9_12;
                    Throwable throwable2;
                    FolderDAO folderDao;
                    TemplateDAO templateDao = Context.get(TemplateDAO.class);
                    List allTemplates = templateDao.findAll();
                    HashMap<String, Template> templates = new HashMap<String, Template>();
                    Iterator iterator = allTemplates.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            folderDao = Context.get(FolderDAO.class);
                            List<Folder> workspaces = folderDao.findWorkspaces(this.importFolder.getTenantId());
                            throwable2 = null;
                            var9_12 = null;
                            try {
                                client = this.getSMBClient();
                                try {
                                    block63: {
                                        connection = client.connect(this.importFolder.getHost());
                                        try {
                                            ac = new AuthenticationContext(this.importFolder.getUsername(), this.importFolder.getPasswordDecrypted().toCharArray(), this.importFolder.getDomain());
                                            shareAndPath = this.getShareAndPath();
                                            throwable = null;
                                            var15_24 = null;
                                            try {
                                                session = connection.authenticate(ac);
                                                try {
                                                    share = (DiskShare)session.connectShare(shareAndPath[0]);
                                                    try {
                                                        indexPath = shareAndPath[1] + INDEX_XML;
                                                        if (share.fileExists(indexPath) && (indexFile = this.downloadFile(indexSmbFile = new SMB3File(indexPath, INDEX_XML, share.getFileInformation(indexPath)))).exists() && indexFile.length() > 0L) {
                                                            log.debug("Analyzing index file: {}", (Object)indexFile.getName());
                                                            ImportFolderIndexHandler handler = new ImportFolderIndexHandler(this.importFolder, crawler, templates, workspaces, this.tenant);
                                                            new Index(FileUtils.readFileToByteArray(indexFile), (IndexHandler)handler);
                                                        }
                                                    }
                                                    finally {
                                                        if (share != null) {
                                                            share.close();
                                                        }
                                                    }
                                                    if (session == null) break block63;
                                                }
                                                catch (Throwable throwable3) {
                                                    if (throwable == null) {
                                                        throwable = throwable3;
                                                    } else if (throwable != throwable3) {
                                                        throwable.addSuppressed(throwable3);
                                                    }
                                                    if (session == null) throw throwable;
                                                    session.close();
                                                    throw throwable;
                                                }
                                                session.close();
                                            }
                                            catch (Throwable throwable4) {
                                                if (throwable == null) {
                                                    throwable = throwable4;
                                                    throw throwable;
                                                }
                                                if (throwable == throwable4) throw throwable;
                                                throwable.addSuppressed(throwable4);
                                                throw throwable;
                                            }
                                        }
                                        finally {
                                            if (connection != null) {
                                                connection.close();
                                            }
                                        }
                                    }
                                    if (client == null) break;
                                }
                                catch (Throwable throwable5) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable5;
                                    } else if (throwable2 != throwable5) {
                                        throwable2.addSuppressed(throwable5);
                                    }
                                    if (client == null) throw throwable2;
                                    client.close();
                                    throw throwable2;
                                }
                                client.close();
                                break;
                            }
                            catch (Throwable throwable6) {
                                if (throwable2 == null) {
                                    throwable2 = throwable6;
                                    throw throwable2;
                                }
                                if (throwable2 == throwable6) throw throwable2;
                                throwable2.addSuppressed(throwable6);
                                throw throwable2;
                            }
                        }
                        Template template = (Template)iterator.next();
                        templates.put(template.getName(), template);
                    }
                    throwable2 = null;
                    var9_12 = null;
                    try {
                        client = this.getSMBClient();
                        try {
                            block65: {
                                connection = client.connect(this.importFolder.getHost());
                                try {
                                    ac = new AuthenticationContext(this.importFolder.getUsername(), this.importFolder.getPasswordDecrypted().toCharArray(), this.importFolder.getDomain());
                                    shareAndPath = this.getShareAndPath();
                                    throwable = null;
                                    var15_24 = null;
                                    try {
                                        session = connection.authenticate(ac);
                                        try {
                                            block64: {
                                                share = (DiskShare)session.connectShare(shareAndPath[0]);
                                                try {
                                                    indexPath = shareAndPath[1] + "/index.csv";
                                                    if (!share.fileExists(indexPath) || !(indexFile = this.downloadFile(indexSmbFile = new SMB3File(indexPath, INDEX_CSV, share.getFileInformation(indexPath)))).exists() || indexFile.length() <= 0L) break block64;
                                                    log.debug("Analyzing index file: {}", (Object)indexFile.getName());
                                                    Throwable throwable7 = null;
                                                    Object var21_35 = null;
                                                    try (IndexCSV index = new IndexCSV(crawler, this.importFolder, templates, folderDao.findWorkspaces(this.importFolder.getTenantId()), indexFile);){
                                                        index.importDocuments();
                                                    }
                                                    catch (Throwable throwable8) {
                                                        if (throwable7 == null) {
                                                            throwable7 = throwable8;
                                                            throw throwable7;
                                                        }
                                                        if (throwable7 == throwable8) throw throwable7;
                                                        throwable7.addSuppressed(throwable8);
                                                        throw throwable7;
                                                    }
                                                }
                                                finally {
                                                    if (share != null) {
                                                        share.close();
                                                    }
                                                }
                                            }
                                            if (session == null) break block65;
                                        }
                                        catch (Throwable throwable9) {
                                            if (throwable == null) {
                                                throwable = throwable9;
                                            } else if (throwable != throwable9) {
                                                throwable.addSuppressed(throwable9);
                                            }
                                            if (session == null) throw throwable;
                                            session.close();
                                            throw throwable;
                                        }
                                        session.close();
                                    }
                                    catch (Throwable throwable10) {
                                        if (throwable == null) {
                                            throwable = throwable10;
                                            throw throwable;
                                        }
                                        if (throwable == throwable10) throw throwable;
                                        throwable.addSuppressed(throwable10);
                                        throw throwable;
                                    }
                                }
                                finally {
                                    if (connection != null) {
                                        connection.close();
                                    }
                                }
                            }
                            if (client == null) break block66;
                        }
                        catch (Throwable throwable11) {
                            if (throwable2 == null) {
                                throwable2 = throwable11;
                            } else if (throwable2 != throwable11) {
                                throwable2.addSuppressed(throwable11);
                            }
                            if (client == null) throw throwable2;
                            client.close();
                            throw throwable2;
                        }
                        client.close();
                    }
                    catch (Throwable throwable12) {
                        if (throwable2 == null) {
                            throwable2 = throwable12;
                            throw throwable2;
                        }
                        if (throwable2 == throwable12) throw throwable2;
                        throwable2.addSuppressed(throwable12);
                        throw throwable2;
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), e);
                    if (indexFile == null) return;
                    FileUtil.delete(indexFile);
                    return;
                }
            }
            catch (Throwable throwable) {
                if (indexFile == null) throw throwable;
                FileUtil.delete(indexFile);
                throw throwable;
            }
        }
        if (indexFile == null) return;
        FileUtil.delete(indexFile);
    }

    @Override
    public int importDocumentsCount() {
        int count = this.importDocumentsCountWihtIndexXML();
        if (count <= 0) {
            count = this.importDocumentsCountWithIndexCSV(count);
        }
        return count;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int importDocumentsCountWithIndexCSV(int count) {
        File indxFile = null;
        try {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try {
                    SMBClient client = this.getSMBClient();
                    try {
                        block37: {
                            try (Connection connection = client.connect(this.importFolder.getHost());){
                                AuthenticationContext ac = new AuthenticationContext(this.importFolder.getUsername(), this.importFolder.getPasswordDecrypted().toCharArray(), this.importFolder.getDomain());
                                String[] shareAndPath = this.getShareAndPath();
                                Throwable throwable2 = null;
                                Object var10_15 = null;
                                try {
                                    Session session = connection.authenticate(ac);
                                    try {
                                        block36: {
                                            try (DiskShare share = (DiskShare)session.connectShare(shareAndPath[0]);){
                                                SMB3File indexSmbFile;
                                                String indexPath = shareAndPath[1] + "/index.csv";
                                                if (!share.fileExists(indexPath) || !(indxFile = this.downloadFile(indexSmbFile = new SMB3File(indexPath, INDEX_CSV, share.getFileInformation(indexPath)))).exists() || indxFile.length() <= 0L) break block36;
                                                Throwable throwable3 = null;
                                                Object var16_24 = null;
                                                try (IndexCSV index = new IndexCSV(this.importFolder, indxFile);){
                                                    count = (int)index.count();
                                                }
                                                catch (Throwable throwable4) {
                                                    if (throwable3 == null) {
                                                        throwable3 = throwable4;
                                                        throw throwable3;
                                                    }
                                                    if (throwable3 == throwable4) throw throwable3;
                                                    throwable3.addSuppressed(throwable4);
                                                    throw throwable3;
                                                }
                                            }
                                        }
                                        if (session == null) break block37;
                                    }
                                    catch (Throwable throwable5) {
                                        if (throwable2 == null) {
                                            throwable2 = throwable5;
                                        } else if (throwable2 != throwable5) {
                                            throwable2.addSuppressed(throwable5);
                                        }
                                        if (session == null) throw throwable2;
                                        session.close();
                                        throw throwable2;
                                    }
                                    session.close();
                                }
                                catch (Throwable throwable6) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable6;
                                        throw throwable2;
                                    }
                                    if (throwable2 == throwable6) throw throwable2;
                                    throwable2.addSuppressed(throwable6);
                                    throw throwable2;
                                }
                            }
                        }
                        if (client == null) return count;
                    }
                    catch (Throwable throwable7) {
                        if (throwable == null) {
                            throwable = throwable7;
                        } else if (throwable != throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                        if (client == null) throw throwable;
                        client.close();
                        throw throwable;
                    }
                    client.close();
                    return count;
                }
                catch (Throwable throwable8) {
                    if (throwable == null) {
                        throwable = throwable8;
                        throw throwable;
                    }
                    if (throwable == throwable8) throw throwable;
                    throwable.addSuppressed(throwable8);
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), e);
                count = -1;
                FileUtil.delete(indxFile);
                return count;
            }
        }
        finally {
            FileUtil.delete(indxFile);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int importDocumentsCountWihtIndexXML() {
        int count = -1;
        File indexFile = null;
        try {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try {
                    SMBClient client = this.getSMBClient();
                    try {
                        block31: {
                            try (Connection connection = client.connect(this.importFolder.getHost());){
                                AuthenticationContext ac = new AuthenticationContext(this.importFolder.getUsername(), this.importFolder.getPasswordDecrypted().toCharArray(), this.importFolder.getDomain());
                                String[] shareAndPath = this.getShareAndPath();
                                Throwable throwable2 = null;
                                Object var10_15 = null;
                                try {
                                    Session session = connection.authenticate(ac);
                                    try {
                                        try (DiskShare share = (DiskShare)session.connectShare(shareAndPath[0]);){
                                            SMB3File indexSmbFile;
                                            String indexPath = shareAndPath[1] + INDEX_XML;
                                            if (share.fileExists(indexPath) && (indexFile = this.downloadFile(indexSmbFile = new SMB3File(indexPath, INDEX_XML, share.getFileInformation(indexPath)))).exists() && indexFile.length() > 0L) {
                                                IndexHeaderHandler handler = new IndexHeaderHandler();
                                                Index index = new Index(FileUtils.readFileToByteArray(indexFile), (IndexHandler)handler);
                                                count = (int)index.getCount();
                                            }
                                        }
                                        if (session == null) break block31;
                                    }
                                    catch (Throwable throwable3) {
                                        if (throwable2 == null) {
                                            throwable2 = throwable3;
                                        } else if (throwable2 != throwable3) {
                                            throwable2.addSuppressed(throwable3);
                                        }
                                        if (session == null) throw throwable2;
                                        session.close();
                                        throw throwable2;
                                    }
                                    session.close();
                                }
                                catch (Throwable throwable4) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable4;
                                        throw throwable2;
                                    }
                                    if (throwable2 == throwable4) throw throwable2;
                                    throwable2.addSuppressed(throwable4);
                                    throw throwable2;
                                }
                            }
                        }
                        if (client == null) return count;
                    }
                    catch (Throwable throwable5) {
                        if (throwable == null) {
                            throwable = throwable5;
                        } else if (throwable != throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        if (client == null) throw throwable;
                        client.close();
                        throw throwable;
                    }
                    client.close();
                    return count;
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                        throw throwable;
                    }
                    if (throwable == throwable6) throw throwable;
                    throwable.addSuppressed(throwable6);
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), e);
                count = -1;
                FileUtil.delete(indexFile);
                return count;
            }
        }
        finally {
            FileUtil.delete(indexFile);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean deleteFile(Object file) {
        try {
            var2_2 = null;
            var3_5 = null;
            try {
                block38: {
                    block37: {
                        client = this.getSMBClient();
                        connection = client.connect(this.importFolder.getHost());
                        ac = new AuthenticationContext(this.importFolder.getUsername(), this.importFolder.getPasswordDecrypted().toCharArray(), this.importFolder.getDomain());
                        shareAndPath = this.getShareAndPath();
                        deleted = false;
                        var9_13 = null;
                        var10_15 = null;
                        try {
                            session = connection.authenticate(ac);
                            try {
                                share = (DiskShare)session.connectShare(shareAndPath[0]);
                                try {
                                    smbFile = (SMB3File)file;
                                    if (smbFile.isDirectory()) {
                                        share.rmdir(smbFile.getPath(), true);
                                    } else {
                                        share.rm(smbFile.getPath());
                                    }
                                    deleted = share.fileExists(smbFile.getPath()) == false;
                                }
                                finally {
                                    if (share != null) {
                                        share.close();
                                    }
                                }
                                ** if (session == null) goto lbl-1000
                            }
                            catch (Throwable var10_16) {
                                if (var9_13 == null) {
                                    var9_13 = var10_16;
                                } else if (var9_13 != var10_16) {
                                    var9_13.addSuppressed(var10_16);
                                }
                                if (session != null) {
                                    session.close();
                                }
                                throw var9_13;
                            }
lbl-1000:
                            // 1 sources

                            {
                                session.close();
                            }
lbl-1000:
                            // 2 sources

                            {
                            }
                        }
                        catch (Throwable var10_17) {
                            if (var9_13 == null) {
                                var9_13 = var10_17;
                            } else if (var9_13 != var10_17) {
                                var9_13.addSuppressed(var10_17);
                            }
                            throw var9_13;
                        }
                        v0 = deleted;
                        if (connection == null) break block37;
                        connection.close();
                    }
                    if (client == null) break block38;
                    client.close();
                }
                return v0;
                {
                    catch (Throwable var2_3) {
                        try {
                            if (connection != null) {
                                connection.close();
                            }
                            throw var2_3;
                        }
                        catch (Throwable var3_6) {
                            if (var2_2 == null) {
                                var2_2 = var3_6;
                            } else if (var2_2 != var3_6) {
                                var2_2.addSuppressed(var3_6);
                            }
                            if (client != null) {
                                client.close();
                            }
                            throw var2_2;
                        }
                    }
                }
            }
            catch (Throwable var3_7) {
                if (var2_2 == null) {
                    var2_2 = var3_7;
                } else if (var2_2 != var3_7) {
                    var2_2.addSuppressed(var3_7);
                }
                throw var2_2;
            }
        }
        catch (Exception e) {
            SMB3Helper.log.error(e.getMessage(), e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void list(Object parent, int depth, List<Object> folders, List<Object> files, long max, ImportFolderCache cache) {
        try {
            Throwable throwable = null;
            Object var9_10 = null;
            try {
                SMBClient client = this.getSMBClient();
                try {
                    block27: {
                        try (Connection connection = client.connect(this.importFolder.getHost());){
                            AuthenticationContext ac = new AuthenticationContext(this.importFolder.getUsername(), this.importFolder.getPasswordDecrypted().toCharArray(), this.importFolder.getDomain());
                            String[] shareAndPath = this.getShareAndPath();
                            Throwable throwable2 = null;
                            Object var15_19 = null;
                            try {
                                Session session = connection.authenticate(ac);
                                try {
                                    try (DiskShare share = (DiskShare)session.connectShare(shareAndPath[0]);){
                                        SMB3File parentSmb = this.getParent(parent, shareAndPath, share);
                                        this.list(parentSmb, files, folders, max, depth, cache, share);
                                    }
                                    if (session == null) break block27;
                                }
                                catch (Throwable throwable3) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable3;
                                    } else if (throwable2 != throwable3) {
                                        throwable2.addSuppressed(throwable3);
                                    }
                                    if (session == null) throw throwable2;
                                    session.close();
                                    throw throwable2;
                                }
                                session.close();
                            }
                            catch (Throwable throwable4) {
                                if (throwable2 == null) {
                                    throwable2 = throwable4;
                                    throw throwable2;
                                }
                                if (throwable2 == throwable4) throw throwable2;
                                throwable2.addSuppressed(throwable4);
                                throw throwable2;
                            }
                        }
                    }
                    if (client == null) return;
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                    } else if (throwable != throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    if (client == null) throw throwable;
                    client.close();
                    throw throwable;
                }
                client.close();
                return;
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                    throw throwable;
                }
                if (throwable == throwable6) throw throwable;
                throwable.addSuppressed(throwable6);
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    private void list(SMB3File parentSmb, List<Object> files, List<Object> folders, long max, int depth, ImportFolderCache cache, DiskShare share) throws IOException {
        for (FileIdBothDirectoryInformation f : share.list(parentSmb.getPath())) {
            if (f.getFileName().startsWith(".")) continue;
            String fullPath = this.getFullPath(parentSmb, f);
            FileAllInformation info = share.getFileInformation(fullPath);
            SMB3File smbFile = new SMB3File(fullPath, f.getFileName(), info);
            if (!this.validateFile(smbFile, f)) continue;
            this.list(smbFile, files, folders, max, depth, cache);
        }
    }

    private void list(SMB3File smbFile, List<Object> files, List<Object> folders, long max, int depth, ImportFolderCache cache) throws IOException {
        if (smbFile.isDirectory() && depth >= 1) {
            this.list((Object)smbFile, depth - 1, folders, files, max, cache);
        }
        if (smbFile.isDirectory()) {
            folders.add(smbFile);
        } else if (this.toBeImported(smbFile, cache)) {
            files.add(smbFile);
        }
    }

    private boolean validateFile(SMB3File smbFile, FileIdBothDirectoryInformation f) {
        boolean accepted = true;
        if (!smbFile.isDirectory()) {
            accepted = this.importFolder.isAllowed(f.getFileName());
            if (this.importFolder.getMaxSize() != null && this.importFolder.getMaxSize() > 0 && smbFile.getSize() > (long)this.importFolder.getMaxSize().intValue()) {
                accepted = false;
            }
            if (this.importFolder.getStartDate() != null && this.importFolder.getStartDate().after(smbFile.getLastModified())) {
                accepted = false;
            }
        }
        return accepted;
    }

    private String getFullPath(SMB3File parentSmb, FileIdBothDirectoryInformation f) {
        Object filePath = parentSmb.getPath() + SLASH + f.getFileName();
        if (((String)filePath).startsWith(SLASH)) {
            filePath = ((String)filePath).substring(1);
        }
        return filePath;
    }

    private SMB3File getParent(Object parent, String[] shareAndPath, DiskShare share) {
        SMB3File parentSmb = null;
        if (parent == null) {
            FileAllInformation fileInfo = share.getFileInformation(shareAndPath[1]);
            parentSmb = new SMB3File(shareAndPath[1], "", fileInfo);
        } else {
            parentSmb = (SMB3File)parent;
        }
        return parentSmb;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean testConnection() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 21[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private SMBClient getSMBClient() {
        SmbConfig config = SmbConfig.builder().withTimeout(180L, TimeUnit.SECONDS).withSoTimeout(180L, TimeUnit.SECONDS).build();
        return new SMBClient(config);
    }

    private String[] getShareAndPath() {
        String pathInShare = "";
        String shareName = this.importFolder.getPath().replace("\\", SLASH);
        if (shareName.startsWith(SLASH)) {
            shareName = shareName.substring(1);
        }
        if (shareName.contains(SLASH)) {
            pathInShare = shareName.substring(shareName.indexOf(SLASH) + 1);
            shareName = shareName.substring(0, shareName.indexOf(SLASH));
        }
        return new String[]{shareName, pathInShare};
    }

    /*
     * Exception decompiling
     */
    @Override
    public Object getFile(String path) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 19[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public File getContentFile(String path) {
        try {
            return this.downloadFile((SMB3File)this.getFile(path));
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }
}

