/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.importfolder.helper.smb;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.metadata.Template;
import com.logicaldoc.core.metadata.TemplateDAO;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.impex.Index;
import com.logicaldoc.impex.IndexHandler;
import com.logicaldoc.impex.IndexHeaderHandler;
import com.logicaldoc.importfolder.Crawler;
import com.logicaldoc.importfolder.ImportFolder;
import com.logicaldoc.importfolder.ImportFolderCache;
import com.logicaldoc.importfolder.ImportFolderIndexHandler;
import com.logicaldoc.importfolder.IndexCSV;
import com.logicaldoc.importfolder.helper.CrawlerHelper;
import com.logicaldoc.util.exception.StopException;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import jcifs.CIFSContext;
import jcifs.Credentials;
import jcifs.context.SingletonContext;
import jcifs.smb.NtlmPasswordAuthenticator;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileFilter;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class SMBHelper
extends CrawlerHelper {
    private static final Logger log = LoggerFactory.getLogger(SMBHelper.class);

    public SMBHelper(ImportFolder importFolder, Crawler crawler) throws PersistenceException {
        super(importFolder, crawler);
    }

    @Override
    public void checkinFile(Object file, long docId, User owner) throws IOException, PersistenceException {
        File localFile = null;
        try {
            Throwable throwable = null;
            Object var7_7 = null;
            try (SmbFile smbFile = (SmbFile)file;){
                localFile = SMBHelper.downloadFile(smbFile);
                this.checkin(file, docId, owner, smbFile.getName(), smbFile.getPath(), localFile);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            FileUtil.delete(localFile);
            throw throwable;
        }
        FileUtil.delete(localFile);
    }

    /*
     * Exception decompiling
     */
    @Override
    public Document importFile(Object file, Folder folder, User owner, boolean timestamp) throws IOException, PersistenceException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void list(Object parent, int depth, List<Object> folders, List<Object> files, long max, ImportFolderCache cache) throws IOException {
        Throwable throwable = null;
        Object var9_9 = null;
        try (SmbFile parentSmb = parent == null ? new SmbFile(this.importFolder.getUrl(), SMBHelper.getSmbContext(this.importFolder)) : (SmbFile)parent;){
            SmbFile[] filesArray = null;
            try {
                filesArray = parentSmb.listFiles((SmbFileFilter)new ImportFolderFilter(this.importFolder));
            }
            catch (SmbAuthException e) {
                log.error("Access denied on {}", (Object)this.getPathWithoutPassword(parentSmb));
                if (parentSmb != null) {
                    parentSmb.close();
                }
                return;
            }
            int i = 0;
            while (i < filesArray.length) {
                try {
                    SmbFile child = filesArray[i];
                    this.list(child, depth, folders, files, cache, max);
                }
                catch (StopException se) {
                    break;
                }
                ++i;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void list(SmbFile parentFolder, int depth, List<Object> folders, List<Object> files, ImportFolderCache cache, long max) throws StopException, IOException {
        if (parentFolder.isDirectory() && depth >= 1) {
            this.list((Object)parentFolder, depth - 1, folders, files, max, cache);
        }
        if (parentFolder.isFile()) {
            if (max > 0L && (long)files.size() >= max) {
                throw new StopException(String.format("Reached max %d entries", max));
            }
            if (this.toBeImported(parentFolder, cache)) {
                files.add(parentFolder);
            }
        } else {
            folders.add(parentFolder);
        }
    }

    public static File downloadFile(SmbFile f) throws IOException {
        File tmpFile = FileUtil.createTempFile("smb", null);
        FileUtil.writeFile(f.getInputStream(), tmpFile.getAbsolutePath());
        return tmpFile;
    }

    @Override
    public File getContentFile(String path) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (SmbFile smbFile = new SmbFile(this.importFolder.getUrl() + path, SMBHelper.getSmbContext(this.importFolder));){
                File tmpFile = FileUtil.createTempFile("smb", null);
                if (smbFile.exists()) {
                    tmpFile = SMBHelper.downloadFile(smbFile);
                }
                return tmpFile;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception t) {
            log.error(t.getMessage(), t);
            return null;
        }
    }

    public SmbFile getFile(String path) {
        try {
            return new SmbFile(this.importFolder.getUrl() + path, SMBHelper.getSmbContext(this.importFolder));
        }
        catch (Exception t) {
            log.error(t.getMessage(), t);
            return null;
        }
    }

    @Override
    public String getName(Object file) {
        SmbFile smbFile = (SmbFile)file;
        return smbFile.getName();
    }

    /*
     * Loose catch block
     */
    @Override
    public String getPath(Object file) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            String string;
            SmbFile root;
            SmbFile smbFile;
            block16: {
                block15: {
                    smbFile = (SmbFile)file;
                    root = new SmbFile(this.importFolder.getUrl(), SMBHelper.getSmbContext(this.importFolder));
                    String path = smbFile.getUncPath().substring(root.getUncPath().length());
                    string = path.replace("\\", "/");
                    if (root == null) break block15;
                    root.close();
                }
                if (smbFile == null) break block16;
                smbFile.close();
            }
            return string;
            {
                catch (Throwable throwable2) {
                    try {
                        if (root != null) {
                            root.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (smbFile != null) {
                            smbFile.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public Date getLastModified(Object file) {
        try {
            return new Date(((SmbFile)file).lastModified());
        }
        catch (Exception e) {
            return new Date();
        }
    }

    @Override
    public Date getCreationDate(Object file) {
        try {
            return new Date(((SmbFile)file).createTime());
        }
        catch (Exception e) {
            return this.getLastModified(file);
        }
    }

    public static CIFSContext getSmbContext(ImportFolder importFolder) {
        SingletonContext base = SingletonContext.getInstance();
        return base.withCredentials((Credentials)new NtlmPasswordAuthenticator(importFolder.getDomain(), importFolder.getUsername(), importFolder.getPasswordDecrypted()));
    }

    @Override
    public void importUsingIndex(Crawler crawler) throws IOException, PersistenceException, ParserConfigurationException, SAXException {
        File indexFile;
        block32: {
            indexFile = null;
            try {
                SmbFile indexSmbFile;
                TemplateDAO templateDao = Context.get(TemplateDAO.class);
                List allTemplates = templateDao.findAll();
                HashMap<String, Template> templates = new HashMap<String, Template>();
                for (Template template : allTemplates) {
                    templates.put(template.getName(), template);
                }
                FolderDAO folderDao = Context.get(FolderDAO.class);
                List<Folder> workspaces = folderDao.findWorkspaces(this.importFolder.getTenantId());
                Throwable throwable = null;
                Object var9_11 = null;
                try {
                    indexSmbFile = new SmbFile(this.importFolder.getUrl() + "index.xml", SMBHelper.getSmbContext(this.importFolder));
                    try {
                        if (indexSmbFile.exists() && (indexFile = SMBHelper.downloadFile(indexSmbFile)).exists() && indexFile.length() > 0L) {
                            log.debug("Analyzing index file: {}", (Object)indexFile.getName());
                            ImportFolderIndexHandler handler = new ImportFolderIndexHandler(this.importFolder, crawler, templates, workspaces, this.tenant);
                            new Index(FileUtils.readFileToByteArray(indexFile), (IndexHandler)handler);
                        }
                    }
                    finally {
                        if (indexSmbFile != null) {
                            indexSmbFile.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                if (indexFile != null && indexFile.exists() && indexFile.length() != 0L) break block32;
                throwable = null;
                var9_11 = null;
                try {
                    indexSmbFile = new SmbFile(this.importFolder.getUrl() + "index.csv", SMBHelper.getSmbContext(this.importFolder));
                    try {
                        if (!indexSmbFile.exists() || !(indexFile = SMBHelper.downloadFile(indexSmbFile)).exists() || indexFile.length() <= 0L) break block32;
                        log.debug("Analyzing index file: {}", (Object)indexFile.getName());
                        Throwable throwable3 = null;
                        Object var12_17 = null;
                        try (IndexCSV index = new IndexCSV(crawler, this.importFolder, templates, folderDao.findWorkspaces(this.importFolder.getTenantId()), indexFile);){
                            index.importDocuments();
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    finally {
                        if (indexSmbFile != null) {
                            indexSmbFile.close();
                        }
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                    } else if (throwable != throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                FileUtil.delete(indexFile);
                throw throwable;
            }
        }
        FileUtil.delete(indexFile);
    }

    @Override
    public int importDocumentsCount() throws IOException, PersistenceException, ParserConfigurationException, SAXException {
        int count;
        block38: {
            SmbFile indexSmbFile;
            Object var4_6;
            Throwable throwable;
            File indexFile = null;
            count = -1;
            try {
                throwable = null;
                var4_6 = null;
                try {
                    indexSmbFile = new SmbFile(this.importFolder.getUrl() + "index.xml", SMBHelper.getSmbContext(this.importFolder));
                    try {
                        if (indexSmbFile.exists() && (indexFile = SMBHelper.downloadFile(indexSmbFile)).exists() && indexFile.length() > 0L) {
                            IndexHeaderHandler handler = new IndexHeaderHandler();
                            Index index = new Index(FileUtils.readFileToByteArray(indexFile), (IndexHandler)handler);
                            count = (int)index.getCount();
                        }
                    }
                    finally {
                        if (indexSmbFile != null) {
                            indexSmbFile.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                if (indexFile != null) {
                    FileUtil.delete(indexFile);
                }
                throw throwable3;
            }
            if (indexFile != null) {
                FileUtil.delete(indexFile);
            }
            if (count == -1) {
                try {
                    throwable = null;
                    var4_6 = null;
                    try {
                        indexSmbFile = new SmbFile(this.importFolder.getUrl() + "index.csv", SMBHelper.getSmbContext(this.importFolder));
                        try {
                            if (!indexSmbFile.exists() || !(indexFile = SMBHelper.downloadFile(indexSmbFile)).exists() || indexFile.length() <= 0L) break block38;
                            Throwable throwable4 = null;
                            Object var7_12 = null;
                            try (IndexCSV index = new IndexCSV(this.importFolder, indexFile);){
                                count = (int)index.count();
                            }
                            catch (Throwable throwable5) {
                                if (throwable4 == null) {
                                    throwable4 = throwable5;
                                } else if (throwable4 != throwable5) {
                                    throwable4.addSuppressed(throwable5);
                                }
                                throw throwable4;
                            }
                        }
                        finally {
                            if (indexSmbFile != null) {
                                indexSmbFile.close();
                            }
                        }
                    }
                    catch (Throwable throwable6) {
                        if (throwable == null) {
                            throwable = throwable6;
                        } else if (throwable != throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        throw throwable;
                    }
                }
                finally {
                    if (indexFile != null) {
                        FileUtil.delete(indexFile);
                    }
                }
            }
        }
        return count;
    }

    @Override
    public boolean deleteFile(Object file) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (SmbFile smbFile = (SmbFile)file;){
                smbFile.delete();
                boolean bl = !smbFile.exists();
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SmbException e) {
            log.error(e.getMessage(), e);
            return false;
        }
    }

    @Override
    public boolean testConnection() {
        block13: {
            Throwable throwable = null;
            Object var2_4 = null;
            SmbFile smbFile = new SmbFile(this.importFolder.getUrl(), SMBHelper.getSmbContext(this.importFolder));
            try {
                if (!smbFile.canRead()) {
                    throw new IOException("Can't read");
                }
                smbFile.listFiles();
                if (smbFile == null) break block13;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        if (smbFile != null) {
                            smbFile.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    return false;
                }
            }
            smbFile.close();
        }
        return true;
    }

    private String getPathWithoutPassword(SmbFile file) {
        String decryptedPassword = ImportFolder.decryptPassword(this.importFolder.getPassword());
        String passwordEncoded = "";
        try {
            passwordEncoded = URLEncoder.encode(decryptedPassword, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return file.getPath().replace(passwordEncoded, "xxxxx");
    }

    private class ImportFolderFilter
    implements SmbFileFilter {
        private ImportFolder importFolder;

        public ImportFolderFilter(ImportFolder importFolder) {
            this.importFolder = importFolder;
        }

        public boolean accept(SmbFile file) throws SmbException {
            if (file.isDirectory()) {
                return true;
            }
            boolean accepted = this.importFolder.isAllowed(file.getName());
            if (this.importFolder.getMaxSize() != null && this.importFolder.getMaxSize() > 0 && file.length() > (long)this.importFolder.getMaxSize().intValue()) {
                accepted = false;
            }
            if (this.importFolder.getStartDate() != null && this.importFolder.getStartDate().after(new Date(file.getLastModified()))) {
                accepted = false;
            }
            return accepted;
        }
    }
}

