/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.importfolder.helper.sftp;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.metadata.Template;
import com.logicaldoc.core.metadata.TemplateDAO;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.impex.Index;
import com.logicaldoc.impex.IndexHandler;
import com.logicaldoc.importfolder.Crawler;
import com.logicaldoc.importfolder.ImportFolder;
import com.logicaldoc.importfolder.ImportFolderCache;
import com.logicaldoc.importfolder.ImportFolderIndexHandler;
import com.logicaldoc.importfolder.IndexCSV;
import com.logicaldoc.importfolder.helper.CrawlerHelper;
import com.logicaldoc.importfolder.helper.sftp.SFTPClient;
import com.logicaldoc.importfolder.helper.sftp.SFTPFile;
import com.logicaldoc.util.exception.SkipException;
import com.logicaldoc.util.exception.StopException;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class SFTPHelper
extends CrawlerHelper {
    private static final Logger log = LoggerFactory.getLogger(SFTPHelper.class);

    public SFTPHelper(ImportFolder importFolder, Crawler crawler) throws PersistenceException {
        super(importFolder, crawler);
    }

    @Override
    public void checkinFile(Object file, long docId, User owner) throws IOException, PersistenceException {
        SFTPFile ftpFile = (SFTPFile)file;
        SFTPClient ftp = this.getFTPClient();
        File localFile = null;
        try {
            localFile = this.downloadFile(ftpFile, ftp);
            this.checkin(file, docId, owner, ftpFile.getName(), ftpFile.getPath(), localFile);
        }
        catch (Throwable throwable) {
            FileUtil.delete(localFile);
            this.logout(ftp);
            throw throwable;
        }
        FileUtil.delete(localFile);
        this.logout(ftp);
    }

    @Override
    public Document importFile(Object file, Folder folder, User owner, boolean timestamp) throws IOException, PersistenceException {
        Document document;
        log.debug("SFTPHelper.importFile()");
        SFTPFile ftpFile = (SFTPFile)file;
        SFTPClient ftp = this.getFTPClient();
        File localFile = null;
        try {
            localFile = this.downloadFile(ftpFile, ftp);
            if (localFile == null || !localFile.exists() || localFile.length() <= 0L) {
                throw new IOException("Unable to download remote file");
            }
            document = this.create(file, folder, owner, timestamp, ftpFile.getName(), ftpFile.getPath(), localFile);
        }
        catch (Throwable throwable) {
            FileUtil.delete(localFile);
            this.logout(ftp);
            throw throwable;
        }
        FileUtil.delete(localFile);
        this.logout(ftp);
        return document;
    }

    @Override
    public void list(Object parent, int depth, List<Object> folders, List<Object> files, long max, ImportFolderCache cache) throws IOException {
        SFTPClient ftp = this.getFTPClient();
        try {
            List<ChannelSftp.LsEntry> ftpFiles;
            String dir = this.importFolder.getPath();
            SFTPFile ftpParent = new SFTPFile(dir, null);
            if (parent != null) {
                ftpParent = (SFTPFile)parent;
                dir = ftpParent.getPath();
            }
            if (CollectionUtils.isEmpty(ftpFiles = ftp.ls(dir))) {
                return;
            }
            try {
                this.list(ftpFiles, depth, folders, files, max, cache, dir);
            }
            catch (SftpException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        finally {
            this.logout(ftp);
        }
    }

    private void list(List<ChannelSftp.LsEntry> ftpFiles, int depth, List<Object> folders, List<Object> files, long max, ImportFolderCache cache, String dir) throws IOException {
        for (ChannelSftp.LsEntry ftpFile : ftpFiles) {
            try {
                SFTPFile f = this.getFullPathFile(dir, ftpFile);
                this.list(f, folders, files, depth, max, cache);
            }
            catch (SkipException f) {
            }
            catch (StopException e) {
                break;
            }
        }
    }

    private void list(SFTPFile f, List<Object> folders, List<Object> files, int depth, long max, ImportFolderCache cache) throws SkipException, StopException, IOException {
        this.validateFile(f);
        this.listsNotEmptyDirectory(f, folders, files, depth, max, cache);
        if (f.isDirectory()) {
            folders.add(f);
        } else {
            if (max > 0L && (long)files.size() >= max) {
                throw new StopException();
            }
            if (this.toBeImported(f, cache)) {
                files.add(f);
                log.debug("Listing file {}", (Object)f.getPath());
            }
        }
    }

    private void validateFile(SFTPFile f) throws SkipException {
        if (f.getName().startsWith(".")) {
            throw new SkipException();
        }
        if (!f.isDirectory()) {
            boolean accepted = this.importFolder.isAllowed(f.getName());
            if (this.importFolder.getMaxSize() != null && this.importFolder.getMaxSize() > 0 && f.getSize() > (long)this.importFolder.getMaxSize().intValue()) {
                accepted = false;
            }
            if (this.importFolder.getStartDate() != null && this.importFolder.getStartDate().after(f.getLastModified())) {
                accepted = false;
            }
            if (!accepted) {
                throw new SkipException();
            }
        }
    }

    private void listsNotEmptyDirectory(SFTPFile f, List<Object> folders, List<Object> files, int depth, long max, ImportFolderCache cache) {
        if (f.isDirectory() && depth >= 1) {
            try {
                this.list((Object)f, depth - 1, folders, files, max, cache);
            }
            catch (Exception e) {
                log.error("Access denied on {}", (Object)f.getName());
            }
        }
    }

    private SFTPFile getFullPathFile(String dir, ChannelSftp.LsEntry ftpFile) {
        Object fullPath = dir;
        if (!((String)fullPath).endsWith("/")) {
            fullPath = (String)fullPath + "/";
        }
        fullPath = (String)fullPath + ftpFile.getFilename();
        return new SFTPFile((String)fullPath, ftpFile);
    }

    private File downloadFile(SFTPFile f, SFTPClient ftp) throws IOException {
        File tmpFile = FileUtil.createTempFile("ftp-", null);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(tmpFile), 10240);){
                ftp.retrieveFile(f.getPath(), os);
                return tmpFile;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SftpException t) {
            log.warn("File {} not found", (Object)f.getPath());
            return tmpFile;
        }
    }

    @Override
    public String getName(Object file) {
        SFTPFile ftpFile = (SFTPFile)file;
        return ftpFile.getName();
    }

    @Override
    public String getPath(Object file) {
        SFTPFile ftpFile = (SFTPFile)file;
        return ftpFile.getPath().substring(this.importFolder.getPath().length());
    }

    @Override
    public Date getLastModified(Object file) {
        try {
            return ((SFTPFile)file).getLastModified();
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            return new Date();
        }
    }

    @Override
    public Date getCreationDate(Object file) {
        return this.getLastModified(file);
    }

    @Override
    public void importUsingIndex(Crawler crawler) throws IOException, PersistenceException, ParserConfigurationException, SAXException {
        File indexFile;
        SFTPClient ftp;
        block13: {
            ftp = this.getFTPClient();
            TemplateDAO templateDao = Context.get(TemplateDAO.class);
            List allTemplates = templateDao.findAll();
            HashMap<String, Template> templates = new HashMap<String, Template>();
            for (Template template : allTemplates) {
                templates.put(template.getName(), template);
            }
            FolderDAO folderDao = Context.get(FolderDAO.class);
            List<Folder> workspaces = folderDao.findWorkspaces(this.importFolder.getTenantId());
            indexFile = null;
            try {
                indexFile = this.downloadFile(new SFTPFile(this.importFolder.getPath() + "/index.xml", null), ftp);
                if (indexFile.exists() && indexFile.length() > 0L) {
                    log.debug("Analyzing index file: {}", (Object)indexFile.getName());
                    ImportFolderIndexHandler handler = new ImportFolderIndexHandler(this.importFolder, crawler, templates, workspaces, this.tenant);
                    new Index(FileUtils.readFileToByteArray(indexFile), (IndexHandler)handler);
                    break block13;
                }
                indexFile = this.downloadFile(new SFTPFile(this.importFolder.getPath() + "/index.csv", null), ftp);
                if (!indexFile.exists() || indexFile.length() <= 0L) break block13;
                log.debug("Analyzing index file: {}", (Object)indexFile.getName());
                Throwable throwable = null;
                Object var10_12 = null;
                try (IndexCSV index = new IndexCSV(crawler, this.importFolder, templates, folderDao.findWorkspaces(this.importFolder.getTenantId()), indexFile);){
                    index.importDocuments();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                FileUtil.delete(indexFile);
                this.logout(ftp);
                throw throwable;
            }
        }
        FileUtil.delete(indexFile);
        this.logout(ftp);
    }

    /*
     * Exception decompiling
     */
    @Override
    public int importDocumentsCount() throws IOException, PersistenceException, ParserConfigurationException, SAXException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean deleteFile(Object file) {
        SFTPFile ftpFile = (SFTPFile)file;
        SFTPClient ftp = null;
        try {
            ftp = this.getFTPClient();
            if (ftpFile.isDirectory()) {
                ftp.rmdir(ftpFile.getPath());
            } else {
                ftp.rm(ftpFile.getPath());
            }
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            return false;
        }
        finally {
            this.logout(ftp);
        }
    }

    private void logout(SFTPClient ftp) {
        if (ftp != null) {
            try {
                ftp.logout();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private SFTPClient getFTPClient() throws IOException {
        JSch jsch = new JSch();
        Session session = null;
        Channel channel = null;
        ChannelSftp sftpChannel = null;
        try {
            int port = -1;
            if (this.importFolder.getPort() != null) {
                port = Integer.parseInt(this.importFolder.getPort());
            }
            session = port > 0 ? jsch.getSession(this.importFolder.getUsername(), this.importFolder.getHost(), port) : jsch.getSession(this.importFolder.getUsername(), this.importFolder.getHost());
            log.debug("***  SFTP Session created.   ***");
            session.setPassword(ImportFolder.decryptPassword(this.importFolder.getPassword()));
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            session.setConfig(config);
            session.connect();
            log.debug("***   Session connected.   ***");
            log.debug("***   Opening FTP Channel.   ***");
            channel = session.openChannel("sftp");
            channel.connect();
            sftpChannel = (ChannelSftp)channel;
            log.debug("***   Changing to FTP remote dir: {}   ***", (Object)this.importFolder.getPath());
            sftpChannel.cd(this.importFolder.getPath());
            return new SFTPClient(session, channel, sftpChannel);
        }
        catch (JSchException | SftpException | NumberFormatException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public boolean testConnection() {
        SFTPClient ftp = null;
        try {
            ftp = this.getFTPClient();
            ftp.ls(".");
            return true;
        }
        catch (Exception t) {
            return false;
        }
        finally {
            this.logout(ftp);
        }
    }

    @Override
    public Object getFile(String path) {
        return new SFTPFile(path, null);
    }

    @Override
    public File getContentFile(String path) {
        try {
            return this.downloadFile((SFTPFile)this.getFile(path), this.getFTPClient());
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }
}

