/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.importfolder.helper.sftp;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import com.jcraft.jsch.SftpStatVFS;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SFTPClient {
    private static final Logger log = LoggerFactory.getLogger(SFTPClient.class);
    private Session session = null;
    private Channel channel = null;
    private ChannelSftp channelSftp = null;

    public SFTPClient(Session session, Channel channel, ChannelSftp channelSftp) {
        this.session = session;
        this.channel = channel;
        this.channelSftp = channelSftp;
    }

    public void pput(InputStream arg0, String arg1, SftpProgressMonitor arg2, int arg3) throws SftpException {
        this.channelSftp._put(arg0, arg1, arg2, arg3);
    }

    public void cd(String arg0) throws SftpException {
        this.channelSftp.cd(arg0);
    }

    public void chgrp(int arg0, String arg1) throws SftpException {
        this.channelSftp.chgrp(arg0, arg1);
    }

    public void chmod(int arg0, String arg1) throws SftpException {
        this.channelSftp.chmod(arg0, arg1);
    }

    public void chown(int arg0, String arg1) throws SftpException {
        this.channelSftp.chown(arg0, arg1);
    }

    public void connect() throws JSchException {
        this.channelSftp.connect();
    }

    public void connect(int arg0) throws JSchException {
        this.channelSftp.connect(arg0);
    }

    public void disconnect() {
        this.channelSftp.disconnect();
    }

    public boolean equals(Object obj) {
        return this.channelSftp.equals(obj);
    }

    public void exit() {
        this.channelSftp.exit();
    }

    public void get(String arg0, OutputStream arg1, SftpProgressMonitor arg2, int arg3, long arg4) throws SftpException {
        this.channelSftp.get(arg0, arg1, arg2, arg3, arg4);
    }

    public void get(String src, OutputStream dst, SftpProgressMonitor monitor) throws SftpException {
        this.channelSftp.get(src, dst, monitor);
    }

    public void get(String src, OutputStream dst) throws SftpException {
        this.channelSftp.get(src, dst);
    }

    public InputStream get(String src, SftpProgressMonitor monitor) throws SftpException {
        return this.channelSftp.get(src, monitor);
    }

    public void get(String arg0, String arg1, SftpProgressMonitor arg2, int arg3) throws SftpException {
        this.channelSftp.get(arg0, arg1, arg2, arg3);
    }

    public void get(String src, String dst, SftpProgressMonitor monitor) throws SftpException {
        this.channelSftp.get(src, dst, monitor);
    }

    public void get(String src, String dst) throws SftpException {
        this.channelSftp.get(src, dst);
    }

    public InputStream get(String src) throws SftpException {
        return this.channelSftp.get(src);
    }

    public int getBulkRequests() {
        return this.channelSftp.getBulkRequests();
    }

    public int getExitStatus() {
        return this.channelSftp.getExitStatus();
    }

    public InputStream getExtInputStream() throws IOException {
        return this.channelSftp.getExtInputStream();
    }

    public String getExtension(String key) {
        return this.channelSftp.getExtension(key);
    }

    public String getHome() throws SftpException {
        return this.channelSftp.getHome();
    }

    public int getId() {
        return this.channelSftp.getId();
    }

    public InputStream getInputStream() throws IOException {
        return this.channelSftp.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.channelSftp.getOutputStream();
    }

    public int getServerVersion() throws SftpException {
        return this.channelSftp.getServerVersion();
    }

    public Session getSession() throws JSchException {
        return this.channelSftp.getSession();
    }

    public void hardlink(String arg0, String arg1) throws SftpException {
        this.channelSftp.hardlink(arg0, arg1);
    }

    public int hashCode() {
        return this.channelSftp.hashCode();
    }

    public boolean isClosed() {
        return this.channelSftp.isClosed();
    }

    public boolean isConnected() {
        return this.channelSftp.isConnected();
    }

    public boolean isEOF() {
        return this.channelSftp.isEOF();
    }

    public void lcd(String arg0) throws SftpException {
        this.channelSftp.lcd(arg0);
    }

    public String lpwd() {
        return this.channelSftp.lpwd();
    }

    public void ls(String arg0, ChannelSftp.LsEntrySelector arg1) throws SftpException {
        this.channelSftp.ls(arg0, arg1);
    }

    public List<ChannelSftp.LsEntry> ls(String path) throws SftpException {
        log.info("ls {}", (Object)path);
        return this.channelSftp.ls(path);
    }

    public SftpATTRS lstat(String arg0) throws SftpException {
        return this.channelSftp.lstat(arg0);
    }

    public void mkdir(String arg0) throws SftpException {
        this.channelSftp.mkdir(arg0);
    }

    public void put(InputStream src, String dst, int mode) throws SftpException {
        this.channelSftp.put(src, dst, mode);
    }

    public void put(InputStream arg0, String arg1, SftpProgressMonitor arg2, int arg3) throws SftpException {
        this.channelSftp.put(arg0, arg1, arg2, arg3);
    }

    public void put(InputStream src, String dst, SftpProgressMonitor monitor) throws SftpException {
        this.channelSftp.put(src, dst, monitor);
    }

    public void put(InputStream src, String dst) throws SftpException {
        this.channelSftp.put(src, dst);
    }

    public OutputStream put(String dst, int mode) throws SftpException {
        return this.channelSftp.put(dst, mode);
    }

    public OutputStream put(String arg0, SftpProgressMonitor arg1, int arg2, long arg3) throws SftpException {
        return this.channelSftp.put(arg0, arg1, arg2, arg3);
    }

    public OutputStream put(String dst, SftpProgressMonitor monitor, int mode) throws SftpException {
        return this.channelSftp.put(dst, monitor, mode);
    }

    public void put(String src, String dst, int mode) throws SftpException {
        this.channelSftp.put(src, dst, mode);
    }

    public void put(String arg0, String arg1, SftpProgressMonitor arg2, int arg3) throws SftpException {
        this.channelSftp.put(arg0, arg1, arg2, arg3);
    }

    public void put(String src, String dst, SftpProgressMonitor monitor) throws SftpException {
        this.channelSftp.put(src, dst, monitor);
    }

    public void put(String src, String dst) throws SftpException {
        this.channelSftp.put(src, dst);
    }

    public OutputStream put(String dst) throws SftpException {
        return this.channelSftp.put(dst);
    }

    public String pwd() throws SftpException {
        return this.channelSftp.pwd();
    }

    public void quit() {
        this.channelSftp.quit();
    }

    public String readlink(String arg0) throws SftpException {
        return this.channelSftp.readlink(arg0);
    }

    public String realpath(String arg0) throws SftpException {
        return this.channelSftp.realpath(arg0);
    }

    public void rename(String arg0, String arg1) throws SftpException {
        this.channelSftp.rename(arg0, arg1);
    }

    public void rm(String arg0) throws SftpException {
        this.channelSftp.rm(arg0);
    }

    public void rmdir(String arg0) throws SftpException {
        this.channelSftp.rmdir(arg0);
    }

    public void run() {
        this.channelSftp.run();
    }

    public void sendSignal(String signal) throws Exception {
        this.channelSftp.sendSignal(signal);
    }

    public void setAgentForwarding(boolean enable) {
        this.channelSftp.setAgentForwarding(enable);
    }

    public void setBulkRequests(int bulkRequests) throws JSchException {
        this.channelSftp.setBulkRequests(bulkRequests);
    }

    public void setEnv(byte[] name, byte[] value) {
        this.channelSftp.setEnv(name, value);
    }

    public void setEnv(String name, String value) {
        this.channelSftp.setEnv(name, value);
    }

    public void setExtOutputStream(OutputStream out, boolean dontclose) {
        this.channelSftp.setExtOutputStream(out, dontclose);
    }

    public void setExtOutputStream(OutputStream out) {
        this.channelSftp.setExtOutputStream(out);
    }

    public void setFilenameEncoding(String encoding) throws SftpException {
        this.channelSftp.setFilenameEncoding(encoding);
    }

    public void setInputStream(InputStream in, boolean dontclose) {
        this.channelSftp.setInputStream(in, dontclose);
    }

    public void setInputStream(InputStream in) {
        this.channelSftp.setInputStream(in);
    }

    public void setMtime(String arg0, int arg1) throws SftpException {
        this.channelSftp.setMtime(arg0, arg1);
    }

    public void setOutputStream(OutputStream out, boolean dontclose) {
        this.channelSftp.setOutputStream(out, dontclose);
    }

    public void setOutputStream(OutputStream out) {
        this.channelSftp.setOutputStream(out);
    }

    public void setPty(boolean enable) {
        this.channelSftp.setPty(enable);
    }

    public void setPtySize(int arg0, int arg1, int arg2, int arg3) {
        this.channelSftp.setPtySize(arg0, arg1, arg2, arg3);
    }

    public void setPtyType(String ttype, int col, int row, int wp, int hp) {
        this.channelSftp.setPtyType(ttype, col, row, wp, hp);
    }

    public void setPtyType(String ttype) {
        this.channelSftp.setPtyType(ttype);
    }

    public void setStat(String arg0, SftpATTRS arg1) throws SftpException {
        this.channelSftp.setStat(arg0, arg1);
    }

    public void setTerminalMode(byte[] terminalMode) {
        this.channelSftp.setTerminalMode(terminalMode);
    }

    public void setXForwarding(boolean enable) {
        this.channelSftp.setXForwarding(enable);
    }

    public void start() throws JSchException {
        this.channelSftp.start();
    }

    public SftpATTRS stat(String arg0) throws SftpException {
        return this.channelSftp.stat(arg0);
    }

    public SftpStatVFS statVFS(String arg0) throws SftpException {
        return this.channelSftp.statVFS(arg0);
    }

    public void symlink(String arg0, String arg1) throws SftpException {
        this.channelSftp.symlink(arg0, arg1);
    }

    public String toString() {
        return this.channelSftp.toString();
    }

    public String version() {
        return this.channelSftp.version();
    }

    public void retrieveFile(String path, OutputStream os) throws SftpException {
        this.get(path, os);
    }

    public void logout() {
        try {
            if (this.session != null) {
                this.session.disconnect();
            }
            if (this.channel != null) {
                this.channel.disconnect();
            }
            if (this.channelSftp != null) {
                this.channelSftp.quit();
            }
        }
        catch (Exception exc) {
            log.error("***   Unable to disconnect from FTP server. ***", exc);
        }
        log.info("***   SFTP Process Complete.   ***");
    }
}

