/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.importfolder.helper.ftp;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.metadata.Template;
import com.logicaldoc.core.metadata.TemplateDAO;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.impex.Index;
import com.logicaldoc.impex.IndexHandler;
import com.logicaldoc.importfolder.Crawler;
import com.logicaldoc.importfolder.ImportFolder;
import com.logicaldoc.importfolder.ImportFolderCache;
import com.logicaldoc.importfolder.ImportFolderIndexHandler;
import com.logicaldoc.importfolder.IndexCSV;
import com.logicaldoc.importfolder.helper.CrawlerHelper;
import com.logicaldoc.importfolder.helper.ftp.FtpFile;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.net.ssl.TrustManager;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileFilter;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;
import org.apache.commons.net.util.TrustManagerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class FTPHelper
extends CrawlerHelper {
    private static final Logger log = LoggerFactory.getLogger(FTPHelper.class);

    public FTPHelper(ImportFolder importFolder, Crawler crawler) throws PersistenceException {
        super(importFolder, crawler);
    }

    @Override
    public void checkinFile(Object file, long docId, User owner) throws IOException, PersistenceException {
        FtpFile ftpFile = (FtpFile)((Object)file);
        File localFile = null;
        try {
            localFile = this.downloadFile(ftpFile);
            this.checkin(file, docId, owner, ftpFile.getName(), ftpFile.getPath(), localFile);
        }
        finally {
            if (localFile != null) {
                FileUtil.delete(localFile);
            }
        }
    }

    @Override
    public Document importFile(Object file, Folder folder, User owner, boolean timestamp) throws IOException, PersistenceException {
        FtpFile ftpFile = (FtpFile)((Object)file);
        File localFile = null;
        try {
            localFile = this.downloadFile(ftpFile);
            if (!localFile.exists() || localFile.length() <= 0L) {
                throw new IOException("Unable to download remote file");
            }
            Document document = this.create(file, folder, owner, timestamp, ftpFile.getName(), ftpFile.getPath(), localFile);
            return document;
        }
        catch (SocketException se) {
            throw new IOException(se.getMessage(), se);
        }
        finally {
            FileUtil.delete(localFile);
        }
    }

    @Override
    public void list(Object parent, int depth, List<Object> folders, List<Object> files, long max, ImportFolderCache cache) throws IOException {
        FTPClient ftp = this.getFTPClient();
        try {
            Object[] ftpFiles;
            String remoteRootDir = this.importFolder.getPath();
            FtpFile ftpParent = new FtpFile(remoteRootDir, null);
            if (parent != null) {
                ftpParent = (FtpFile)((Object)parent);
                remoteRootDir = ftpParent.getPath();
            }
            if (ArrayUtils.isEmpty(ftpFiles = ftp.listFiles(remoteRootDir, (FTPFileFilter)new ImportFolderFTPFileFilter(this.importFolder)))) {
                return;
            }
            this.list((FTPFile[])ftpFiles, folders, files, remoteRootDir, max, cache, depth);
        }
        finally {
            this.logout(ftp);
        }
    }

    private void list(FTPFile[] ftpFiles, List<Object> folders, List<Object> files, String remoteRootDir, long max, ImportFolderCache cache, int depth) throws IOException {
        FTPFile[] fTPFileArray = ftpFiles;
        int n = ftpFiles.length;
        int n2 = 0;
        while (n2 < n) {
            FTPFile ftpFile = fTPFileArray[n2];
            FtpFile f = this.getFullPathFile(remoteRootDir, ftpFile);
            this.listNotEmptyDir(f, folders, files, max, cache, depth);
            if (ftpFile.isDirectory()) {
                folders.add((Object)f);
            } else {
                if (max > 0L && (long)files.size() >= max) break;
                if (this.toBeImported((Object)f, cache)) {
                    files.add((Object)f);
                    log.debug("Listing file {}", (Object)f.getPath());
                }
            }
            ++n2;
        }
    }

    private void listNotEmptyDir(FtpFile f, List<Object> folders, List<Object> files, long max, ImportFolderCache cache, int depth) {
        if (f.isDirectory() && depth >= 1) {
            try {
                this.list((Object)f, depth - 1, folders, files, max, cache);
            }
            catch (Exception e) {
                log.error("Access denied on {}", (Object)f.getName());
            }
        }
    }

    private FtpFile getFullPathFile(String remoteRootDir, FTPFile ftpFile) {
        Object fullPath = remoteRootDir;
        if (!((String)fullPath).endsWith("/")) {
            fullPath = (String)fullPath + "/";
        }
        fullPath = (String)fullPath + ftpFile.getName();
        return new FtpFile((String)fullPath, ftpFile);
    }

    private File downloadFile(FtpFile ftpFile) throws IOException {
        log.debug("Downloading remote file {}", (Object)ftpFile.getPath());
        File tmpFile = FileUtil.createTempFile("ftp-", null);
        FTPClient ftp = this.getFTPClient();
        try {
            File file;
            block15: {
                Throwable throwable = null;
                Object var5_7 = null;
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(tmpFile), 1024);
                try {
                    ftp.retrieveFile(ftpFile.getPath(), (OutputStream)os);
                    ((OutputStream)os).flush();
                    log.debug("Downloaded remote file {}, total size: {} bytes", (Object)ftpFile.getPath(), (Object)tmpFile.length());
                    file = tmpFile;
                    if (os == null) break block15;
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            if (os != null) {
                                ((OutputStream)os).close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException t) {
                        log.warn("File {} not found", (Object)ftpFile.getPath());
                        File file2 = tmpFile;
                        return file2;
                    }
                }
                ((OutputStream)os).close();
            }
            return file;
        }
        finally {
            this.logout(ftp);
        }
    }

    @Override
    public String getName(Object file) {
        FtpFile ftpFile = (FtpFile)((Object)file);
        return ftpFile.getName();
    }

    @Override
    public String getPath(Object file) {
        FtpFile ftpFile = (FtpFile)((Object)file);
        return ftpFile.getPath().substring(this.importFolder.getPath().length());
    }

    @Override
    public Date getLastModified(Object file) {
        try {
            return ((FtpFile)((Object)file)).getTimestamp().getTime();
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            return new Date();
        }
    }

    @Override
    public Date getCreationDate(Object file) {
        return this.getLastModified(file);
    }

    @Override
    public void importUsingIndex(Crawler crawler) throws IOException, PersistenceException, ParserConfigurationException, SAXException {
        File indexFile;
        block15: {
            indexFile = null;
            try {
                TemplateDAO templateDao = Context.get(TemplateDAO.class);
                List allTemplates = templateDao.findAll();
                HashMap<String, Template> templates = new HashMap<String, Template>();
                for (Template template : allTemplates) {
                    templates.put(template.getName(), template);
                }
                FolderDAO folderDao = Context.get(FolderDAO.class);
                List<Folder> workspaces = folderDao.findWorkspaces(this.importFolder.getTenantId());
                indexFile = this.downloadFile(new FtpFile(this.importFolder.getPath() + "/index.xml", null));
                if (indexFile.exists() && indexFile.length() > 0L) {
                    log.debug("Analyzing index file: {}", (Object)indexFile.getName());
                    ImportFolderIndexHandler indexHandler = new ImportFolderIndexHandler(this.importFolder, crawler, templates, workspaces, this.tenant);
                    new Index(FileUtils.readFileToByteArray(indexFile), (IndexHandler)indexHandler);
                    break block15;
                }
                indexFile = this.downloadFile(new FtpFile(this.importFolder.getPath() + "/index.csv", null));
                if (!indexFile.exists() || indexFile.length() <= 0L) break block15;
                log.debug("Analyzing index file: {}", (Object)indexFile.getName());
                Throwable throwable = null;
                Object var9_11 = null;
                try (IndexCSV index = new IndexCSV(crawler, this.importFolder, templates, workspaces, indexFile);){
                    index.importDocuments();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                if (indexFile != null) {
                    FileUtil.delete(indexFile);
                }
                throw throwable;
            }
        }
        if (indexFile != null) {
            FileUtil.delete(indexFile);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public int importDocumentsCount() throws IOException, PersistenceException, ParserConfigurationException, SAXException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean deleteFile(Object file) {
        FtpFile ftpFile = (FtpFile)((Object)file);
        FTPClient ftp = null;
        try {
            boolean deleted = false;
            ftp = this.getFTPClient();
            deleted = ftpFile.isDirectory() ? ftp.removeDirectory(ftpFile.getPath()) : ftp.deleteFile(ftpFile.getPath());
            boolean bl = deleted;
            return bl;
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            return false;
        }
        finally {
            this.logout(ftp);
        }
    }

    private void logout(FTPClient ftp) {
        if (ftp != null) {
            try {
                ftp.logout();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private FTPClient getFTPClient() throws IOException {
        FTPClient ftp;
        if ("ftp".equals(this.importFolder.getProvider())) {
            ftp = new FTPClient();
        } else {
            FTPSClient ftps = new FTPSClient("ftps");
            ftp = ftps;
            ftps.setTrustManager((TrustManager)TrustManagerUtils.getAcceptAllTrustManager());
        }
        FTPClientConfig config = new FTPClientConfig();
        ftp.configure(config);
        int port = -1;
        if (this.importFolder.getPort() != null) {
            port = Integer.parseInt(this.importFolder.getPort());
        }
        if (port > 0) {
            ftp.connect(this.importFolder.getHost(), port);
        } else {
            ftp.connect(this.importFolder.getHost());
        }
        log.debug("Connected to {} on {}", (Object)this.importFolder.getHost(), (Object)(port > 0 ? port : ftp.getDefaultPort()));
        if (!ftp.login(this.importFolder.getUsername(), ImportFolder.decryptPassword(this.importFolder.getPassword()))) {
            ftp.logout();
            throw new IOException("FTP acces denied");
        }
        log.debug("Remote system is {}", (Object)ftp.getSystemType());
        ftp.setFileType(2);
        ftp.setBufferSize(1024);
        ftp.enterLocalPassiveMode();
        ftp.setAutodetectUTF8(true);
        int reply = ftp.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)reply)) {
            ftp.disconnect();
            throw new IOException("FTP server refused connection");
        }
        return ftp;
    }

    @Override
    public boolean testConnection() {
        FTPClient ftp = null;
        try {
            ftp = this.getFTPClient();
            ftp.listFiles(this.importFolder.getPath());
            return true;
        }
        catch (Exception t) {
            return false;
        }
        finally {
            this.logout(ftp);
        }
    }

    @Override
    public Object getFile(String path) {
        FTPClient ftp = null;
        try {
            ftp = this.getFTPClient();
            FTPFile fTPFile = ftp.mlistFile(path);
            return fTPFile;
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            Boolean bl = false;
            return bl;
        }
        finally {
            this.logout(ftp);
        }
    }

    @Override
    public File getContentFile(String path) {
        try {
            String completePath = path.startsWith("/") ? path : FilenameUtils.normalize(this.importFolder.getPath() + "/" + path, true);
            log.debug("Get content of file {}", (Object)completePath);
            return this.downloadFile(new FtpFile(completePath, null));
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    private class ImportFolderFTPFileFilter
    implements FTPFileFilter {
        private ImportFolder importFolder;

        public ImportFolderFTPFileFilter(ImportFolder importFolder) {
            this.importFolder = importFolder;
        }

        public boolean accept(FTPFile file) {
            if (file.getName().startsWith(".")) {
                return false;
            }
            if (file.isDirectory()) {
                return true;
            }
            boolean accepted = this.importFolder.isAllowed(file.getName());
            if (this.importFolder.getMaxSize() != null && this.importFolder.getMaxSize() > 0 && file.getSize() > (long)this.importFolder.getMaxSize().intValue()) {
                accepted = false;
            }
            if (this.importFolder.getStartDate() != null && this.importFolder.getStartDate().after(file.getTimestamp().getTime())) {
                accepted = false;
            }
            return accepted;
        }
    }
}

