/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.importfolder.helper.fs;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.metadata.Template;
import com.logicaldoc.core.metadata.TemplateDAO;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.impex.Index;
import com.logicaldoc.impex.IndexHandler;
import com.logicaldoc.impex.IndexHeaderHandler;
import com.logicaldoc.importfolder.Crawler;
import com.logicaldoc.importfolder.ImportFolder;
import com.logicaldoc.importfolder.ImportFolderCache;
import com.logicaldoc.importfolder.ImportFolderIndexHandler;
import com.logicaldoc.importfolder.IndexCSV;
import com.logicaldoc.importfolder.helper.CrawlerHelper;
import com.logicaldoc.util.SystemUtil;
import com.logicaldoc.util.exception.SkipException;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class FSHelper
extends CrawlerHelper {
    private static final Logger log = LoggerFactory.getLogger(FSHelper.class);

    public FSHelper(ImportFolder importFolder, Crawler crawler) throws PersistenceException {
        super(importFolder, crawler);
    }

    @Override
    public void checkinFile(Object file, long docId, User owner) throws IOException, PersistenceException {
        File localFile = (File)file;
        this.checkin(file, docId, owner, localFile.getName(), localFile.getPath(), localFile);
    }

    @Override
    public Document importFile(Object file, Folder folder, User owner, boolean timestamp) throws PersistenceException, IOException {
        File localFile = (File)file;
        return this.create(file, folder, owner, timestamp, localFile.getName(), localFile.getPath(), localFile);
    }

    @Override
    public void list(Object parent, int depth, List<Object> folders, List<Object> files, long max, ImportFolderCache cache) {
        if (max > 0L && (long)files.size() >= max) {
            return;
        }
        File parentFolder = this.getParentFolder(parent);
        Object[] parentChildren = null;
        try {
            parentChildren = parentFolder.listFiles(new ImportFolderFilter(this.importFolder));
        }
        catch (Exception e) {
            log.error("Access denied on {}", (Object)parentFolder.getPath());
            return;
        }
        if (ArrayUtils.isEmpty(parentChildren)) {
            return;
        }
        int i = 0;
        while (i < parentChildren.length) {
            try {
                Object child = parentChildren[i];
                this.listChild((File)child, depth, folders, files, cache, max);
            }
            catch (Exception e) {
                if (e instanceof SkipException) break;
                log.error("Access denied on {}", (Object)parentFolder.getPath());
                break;
            }
            ++i;
        }
    }

    private void listChild(File child, int depth, List<Object> folders, List<Object> files, ImportFolderCache cache, long max) throws SkipException, IOException {
        if (child.isDirectory() && depth >= 1) {
            this.list(child, depth - 1, folders, files, max, cache);
        }
        if (child.isFile()) {
            if ((long)files.size() >= max) {
                throw new SkipException(String.format("Alrteady listed %d entries", max));
            }
            if (this.toBeImported(child, cache)) {
                files.add(child);
            }
        } else {
            folders.add(child);
        }
    }

    private File getParentFolder(Object parent) {
        File parentFile = null;
        parentFile = parent == null ? new File(this.importFolder.getPath()) : (File)parent;
        return parentFile;
    }

    @Override
    public String getPath(Object file) {
        File localFile = (File)file;
        File root = new File(this.importFolder.getPath());
        String path = localFile.getPath().substring(root.getPath().length());
        String string = path = SystemUtil.isWindows() ? path.replace('\\', '/') : path;
        if (path.startsWith("/")) {
            path = path.length() > 1 ? path.substring(1) : "";
        }
        return path;
    }

    @Override
    public String getName(Object file) {
        File localFile = (File)file;
        return localFile.getName();
    }

    @Override
    public Date getLastModified(Object file) {
        return new Date(((File)file).lastModified());
    }

    @Override
    public Date getCreationDate(Object file) {
        try {
            File localFile = (File)file;
            Path p = Paths.get(localFile.getAbsolutePath(), new String[0]);
            BasicFileAttributes view = Files.getFileAttributeView(p, BasicFileAttributeView.class, new LinkOption[0]).readAttributes();
            return new Date(view.creationTime().toMillis());
        }
        catch (Exception t) {
            return this.getLastModified(file);
        }
    }

    @Override
    public void importUsingIndex(Crawler crawler) throws PersistenceException, IOException, ParserConfigurationException, SAXException {
        FolderDAO folderDao = Context.get(FolderDAO.class);
        TemplateDAO templateDao = Context.get(TemplateDAO.class);
        List allTemplates = templateDao.findAll();
        HashMap<String, Template> templates = new HashMap<String, Template>();
        for (Template template : allTemplates) {
            templates.put(template.getName(), template);
        }
        File indexFile = new File(this.importFolder.getPath(), "index.xml");
        if (indexFile.exists() && indexFile.length() > 0L) {
            log.info("Analyzing index file: {}", (Object)indexFile.getName());
            ImportFolderIndexHandler handler = new ImportFolderIndexHandler(this.importFolder, crawler, templates, folderDao.findWorkspaces(this.importFolder.getTenantId()), this.tenant);
            new Index(indexFile, (IndexHandler)handler);
        } else {
            indexFile = new File(this.importFolder.getPath(), "index.csv");
            if (indexFile.exists() && indexFile.length() > 0L) {
                log.info("Analyzing index file: {}", (Object)indexFile.getName());
                Object object = null;
                Object var8_9 = null;
                try (IndexCSV index = new IndexCSV(crawler, this.importFolder, templates, folderDao.findWorkspaces(this.importFolder.getTenantId()), indexFile);){
                    index.importDocuments();
                }
                catch (Throwable throwable) {
                    if (object == null) {
                        object = throwable;
                    } else if (object != throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    throw object;
                }
            }
        }
    }

    @Override
    public int importDocumentsCount() throws IOException, PersistenceException, ParserConfigurationException, SAXException {
        File indexFile = new File(this.importFolder.getPath(), "index.xml");
        if (indexFile.exists()) {
            IndexHeaderHandler handler = new IndexHeaderHandler();
            Index index = new Index(indexFile, (IndexHandler)handler);
            return (int)index.getCount();
        }
        indexFile = new File(this.importFolder.getPath(), "index.csv");
        if (indexFile.exists()) {
            Throwable throwable = null;
            Object var3_6 = null;
            try (IndexCSV index = new IndexCSV(this.importFolder, indexFile);){
                return (int)index.count();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return -1;
    }

    @Override
    public boolean deleteFile(Object file) {
        File localFile = (File)file;
        try {
            if (localFile != null) {
                FileUtil.delete(localFile);
            }
            return localFile != null && !localFile.exists();
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            return false;
        }
    }

    @Override
    public boolean testConnection() {
        File dir = new File(this.importFolder.getPath());
        return dir.canRead();
    }

    @Override
    public File getContentFile(String path) {
        return this.getFile(path);
    }

    @Override
    public File getFile(String path) {
        return new File(this.importFolder.getPath() + File.separator + path);
    }

    private class ImportFolderFilter
    implements FileFilter {
        private ImportFolder importFolder;

        public ImportFolderFilter(ImportFolder importFolder) {
            this.importFolder = importFolder;
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            boolean accepted = this.importFolder.isAllowed(file.getName());
            if (this.importFolder.getMaxSize() != null && this.importFolder.getMaxSize() > 0 && file.length() > (long)this.importFolder.getMaxSize().intValue()) {
                accepted = false;
            }
            if (this.importFolder.getStartDate() != null && this.importFolder.getStartDate().after(new Date(file.lastModified()))) {
                accepted = false;
            }
            return accepted;
        }
    }
}

