/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.importfolder.helper;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.DocumentEvent;
import com.logicaldoc.core.document.DocumentHistory;
import com.logicaldoc.core.document.DocumentManager;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.security.Tenant;
import com.logicaldoc.core.security.TenantDAO;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.importfolder.Crawler;
import com.logicaldoc.importfolder.ImportFolder;
import com.logicaldoc.importfolder.ImportFolderCache;
import com.logicaldoc.importfolder.helper.fs.FSHelper;
import com.logicaldoc.importfolder.helper.ftp.FTPHelper;
import com.logicaldoc.importfolder.helper.sftp.SFTPHelper;
import com.logicaldoc.importfolder.helper.smb.SMBHelper;
import com.logicaldoc.importfolder.helper.smb3.SMB3Helper;
import com.logicaldoc.util.TagUtil;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public abstract class CrawlerHelper {
    private static final Logger log = LoggerFactory.getLogger(CrawlerHelper.class);
    protected ImportFolder importFolder;
    protected Crawler crawler;
    protected DocumentManager documentManager;
    protected DocumentDAO documentDao;
    protected Tenant tenant;

    public static final CrawlerHelper getInstance(ImportFolder importFolder, Crawler crawler) throws PersistenceException {
        if ("smb".equals(importFolder.getProvider())) {
            return new SMBHelper(importFolder, crawler);
        }
        if ("smb2".equals(importFolder.getProvider()) || "smb3".equals(importFolder.getProvider())) {
            return new SMB3Helper(importFolder, crawler);
        }
        if ("ftp".equals(importFolder.getProvider()) || "ftps".equals(importFolder.getProvider())) {
            return new FTPHelper(importFolder, crawler);
        }
        if ("sftp".equals(importFolder.getProvider())) {
            return new SFTPHelper(importFolder, crawler);
        }
        if ("file".equals(importFolder.getProvider())) {
            return new FSHelper(importFolder, crawler);
        }
        return null;
    }

    protected CrawlerHelper(ImportFolder importFolder, Crawler crawler) throws PersistenceException {
        this.importFolder = importFolder;
        this.crawler = crawler;
        this.documentDao = Context.get(DocumentDAO.class);
        this.documentManager = Context.get(DocumentManager.class);
        TenantDAO tenantDao = Context.get(TenantDAO.class);
        this.tenant = (Tenant)tenantDao.findById(importFolder.getTenantId());
    }

    public abstract boolean testConnection();

    public abstract void list(Object var1, int var2, List<Object> var3, List<Object> var4, long var5, ImportFolderCache var7) throws IOException;

    public abstract Document importFile(Object var1, Folder var2, User var3, boolean var4) throws PersistenceException, IOException;

    public abstract void checkinFile(Object var1, long var2, User var4) throws IOException, PersistenceException;

    public abstract String getPath(Object var1) throws IOException;

    public abstract String getName(Object var1);

    public abstract Date getLastModified(Object var1);

    public abstract Date getCreationDate(Object var1);

    public boolean toBeImported(Object file, ImportFolderCache cache) throws IOException {
        String path = this.getPath(file);
        Date lastModified = this.getLastModified(file);
        ImportFolderCache.CacheEntry entry = cache.get(path);
        if (entry == null) {
            log.debug("Path {} not in cache so it should be imported", (Object)path);
            return true;
        }
        boolean toImport = entry.getDate().before(lastModified);
        if (toImport) {
            log.debug("Path {} already in cache but last modified is newer so it should be imported", (Object)path);
        } else {
            log.debug("Path {} already in cache and with a newer date so it should not be imported", (Object)path);
        }
        return toImport;
    }

    protected Document create(Object file, Folder folder, User owner, boolean timestamp, String remoteFileName, String remoteFilePath, File localFile) throws PersistenceException, IOException {
        Set<String> tags = null;
        if (StringUtils.isNotEmpty(this.importFolder.getTags())) {
            tags = TagUtil.extractTags(this.tenant.getName(), this.importFolder.getTags());
        }
        DocumentHistory transaction = new DocumentHistory();
        transaction.setTenantId(folder.getTenantId());
        transaction.setEvent(DocumentEvent.STORED);
        transaction.setComment("");
        transaction.setUser(owner);
        Document doc = new Document();
        doc.setTenantId(folder.getTenantId());
        doc.setFileName(remoteFileName);
        doc.setFolder(folder);
        doc.setLocale(this.importFolder.getLocale());
        doc.setTemplateId(this.importFolder.getTemplateId());
        doc.setOcrTemplateId(this.importFolder.getOcrTemplateId());
        doc.setBarcodeTemplateId(this.importFolder.getBarcodeTemplateId());
        doc.setDate(this.getLastModified(file));
        doc.setCreation(this.getCreationDate(file));
        doc.setTagsFromWords(tags);
        if (timestamp) {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd_HHmmss");
            String title = FileUtil.getBaseName(localFile.getName()) + "_" + df.format(new Date());
            doc.setFileName(title + (String)(StringUtils.isNotEmpty(FileUtil.getExtension(localFile.getName())) ? "." + FileUtil.getExtension(localFile.getName()) : ""));
        }
        String path = this.getPath(file);
        transaction.setDocument(doc);
        transaction.setPathOld(path);
        Crawler.beforeDocumentImported(this.importFolder, transaction);
        doc = this.documentManager.create(localFile, doc, transaction).getDocument();
        log.info("Imported new file {} into document {}", (Object)path, (Object)doc.getFileName());
        transaction.setPathOld(path);
        this.crawler.afterDocumentImported(this.importFolder, transaction);
        return doc;
    }

    protected void checkin(Object remoteFile, long docId, User owner, String remoteFileName, String remoteFilePath, File localFile) throws IOException, PersistenceException {
        if (!localFile.exists() || localFile.length() <= 0L) {
            throw new IOException("Unable to download remote file");
        }
        DocumentHistory transaction = new DocumentHistory();
        transaction.setEvent(DocumentEvent.CHECKEDIN);
        transaction.setComment("remote file changed");
        transaction.setUser(owner);
        Document doc = (Document)this.documentDao.findById(docId);
        this.documentDao.initialize(doc);
        String path = this.getPath(remoteFile);
        transaction.setDocument(doc);
        transaction.setPathOld(path);
        Crawler.beforeDocumentImported(this.importFolder, transaction);
        this.documentManager.checkin(docId, localFile, remoteFileName, true, new Document(), transaction);
        log.info("Updated document from file {}", (Object)path);
        doc = (Document)this.documentDao.findById(docId);
        this.documentDao.initialize(doc);
        doc.setDate(this.getLastModified(remoteFile));
        doc.setCreation(this.getCreationDate(remoteFile));
        this.documentDao.store(doc);
        this.crawler.afterDocumentImported(this.importFolder, transaction);
    }

    public abstract void importUsingIndex(Crawler var1) throws PersistenceException, IOException, ParserConfigurationException, SAXException;

    public abstract int importDocumentsCount() throws IOException, PersistenceException, ParserConfigurationException, SAXException;

    public abstract boolean deleteFile(Object var1);

    public abstract Object getFile(String var1);

    public abstract File getContentFile(String var1);
}

