/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.importfolder;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.DocumentEvent;
import com.logicaldoc.core.document.DocumentHistory;
import com.logicaldoc.core.document.DocumentManager;
import com.logicaldoc.core.document.DocumentStatus;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.folder.FolderHistory;
import com.logicaldoc.core.metadata.Attribute;
import com.logicaldoc.core.metadata.Template;
import com.logicaldoc.core.metadata.TemplateDAO;
import com.logicaldoc.core.security.Tenant;
import com.logicaldoc.core.security.TenantDAO;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.impex.Index;
import com.logicaldoc.importfolder.Crawler;
import com.logicaldoc.importfolder.ImportFolder;
import com.logicaldoc.importfolder.ImportFolderCache;
import com.logicaldoc.importfolder.ImportFolderCacheManager;
import com.logicaldoc.importfolder.helper.CrawlerHelper;
import com.logicaldoc.importfolder.helper.ftp.FtpFile;
import com.logicaldoc.importfolder.helper.sftp.SFTPFile;
import com.logicaldoc.importfolder.helper.smb3.SMB3File;
import com.logicaldoc.util.TagUtil;
import com.logicaldoc.util.csv.CSVFileReader;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexCSV
extends CSVFileReader
implements Closeable {
    private static final String ERROR_PARSING_DATE = "Error parsing date {}";
    private static final String TEMPLATE = "template";
    private static final String OCRTEMPLATE = "ocrtemplate";
    private static final String BARCODETEMPLATE = "barcodetemplate";
    private static final String PUBLISHED = "published";
    private static final String STOPPUBLISHING = "stoppublishing";
    private static final String STARTPUBLISHING = "startpublishing";
    private static final String DATE = "date";
    private static final String CREATION = "creation";
    private static final String IMMUTABLE = "immutable";
    private static final String SIGNED = "signed";
    private static final String TAGS = "tags";
    private static final String STATUS = "status";
    private static final String LANGUAGE = "language";
    private static final String PATHEXTENDED = "pathextended";
    private static final String PATH = "path";
    private static final String FILENAME = "filename";
    private static final String CUSTOMID = "customid";
    private static final String COLOR = "color";
    private static final String ID = "id";
    private Logger log = LoggerFactory.getLogger(IndexCSV.class);
    private File inputFile;
    private Map<String, Integer> header = new HashMap<String, Integer>();
    private Map<String, Template> templates;
    private Collection<Folder> workspaces;
    private Crawler crawler;
    private ImportFolder importFolder;
    private boolean interruptRequested = false;
    private Folder targetFolder;
    private File docFile;
    private Object sourceFile;
    private Tenant tenant;

    public IndexCSV(ImportFolder importFolder, File inputFile) throws IOException, PersistenceException {
        this(null, importFolder, null, null, inputFile);
    }

    public IndexCSV(Crawler crawler, ImportFolder importFolder, Map<String, Template> templates, Collection<Folder> workspaces, File inputFile) throws IOException, PersistenceException {
        super(inputFile.getAbsolutePath(), ';', '\"');
        this.inputFile = inputFile;
        this.importFolder = importFolder;
        this.crawler = crawler;
        this.templates = templates;
        this.workspaces = workspaces;
        FolderDAO folderDao = Context.get(FolderDAO.class);
        this.targetFolder = folderDao.findFolder(importFolder.getTargetFolderId());
        if (this.targetFolder == null) {
            throw new IOException("Target Folder " + String.valueOf(importFolder.getTargetFolderId()) + " not found.");
        }
        TenantDAO tenantDao = Context.get(TenantDAO.class);
        this.tenant = (Tenant)tenantDao.findById(importFolder.getTenantId());
        if (templates != null) {
            TemplateDAO templateDao = Context.get(TemplateDAO.class);
            for (Template template : templates.values()) {
                templateDao.initialize(template);
            }
        }
        List<String> row = this.readFields();
        int column = 0;
        for (String name : row) {
            this.header.put(name, column++);
        }
        if (crawler != null) {
            this.log = crawler.getLog();
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Extreacted header line: {}", (Object)row.stream().collect(Collectors.joining(",")));
        }
    }

    public long count() throws IOException {
        long count = 0L;
        Throwable throwable = null;
        Object var4_4 = null;
        try (CSVFileReader csv = new CSVFileReader(this.inputFile.getAbsolutePath(), ';', '\"');){
            List<String> row = csv.readFields();
            while (!row.isEmpty()) {
                row = csv.readFields();
                if (row.isEmpty()) continue;
                ++count;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return count;
    }

    private Document readLine(List<String> row, User owner) throws IOException {
        if (row == null || row.isEmpty()) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        String currentField = null;
        Document doc = new Document();
        doc.setTenantId(this.tenant.getId());
        doc = this.readId(row, doc);
        try {
            currentField = this.readCustomID(row, doc);
            currentField = this.readFileName(row, doc);
            currentField = this.readLanguage(row, doc);
            currentField = this.readTemplate(row, doc);
            currentField = this.readOcrTemplate(row, doc);
            currentField = this.readBarcodeTemplate(row, doc);
            currentField = this.readTags(row, doc);
            currentField = this.readColor(row, doc);
            currentField = this.readStatus(row, doc);
            currentField = this.readSigned(row, doc);
            currentField = this.readImmutable(row, doc);
            currentField = this.readPublished(row, doc);
            currentField = this.readCreation(row, df, doc);
            currentField = this.readDate(row, df, doc);
            currentField = this.readStartPublishing(row, df, doc);
            currentField = this.readStopPublishing(row, df, doc);
            currentField = this.readPathExtended(row, owner, doc);
            if (doc.getTemplate() != null && this.templates.containsKey(doc.getTemplate().getName())) {
                this.readExtendedAttributes(row, df, doc);
            }
            return doc;
        }
        catch (Exception e) {
            if (currentField != null) {
                this.log.error("Error processing field {}", (Object)currentField);
            }
            throw new IOException(e);
        }
    }

    private String readExtendedAttributes(List<String> row, DateFormat df, Document doc) {
        String currentField = null;
        Iterator<String> iterator = doc.getTemplate().getAttributeNames().stream().filter(name -> this.header.get(name) != null).toList().iterator();
        while (iterator.hasNext()) {
            Attribute att;
            String attName;
            currentField = attName = iterator.next();
            Integer headerIndex = this.header.get(attName);
            String val = row.get(headerIndex);
            if (!StringUtils.isNotEmpty((CharSequence)val) || (att = doc.getTemplate().getAttribute(attName)) == null) continue;
            try {
                Attribute attribute = new Attribute(att);
                switch (attribute.getType()) {
                    case 5: {
                        attribute.setBooleanValue("1".equals(val.trim()));
                        break;
                    }
                    case 3: {
                        attribute.setDateValue(df.parse(val.trim()));
                        break;
                    }
                    case 2: {
                        attribute.setDoubleValue(Double.parseDouble(val.trim()));
                        break;
                    }
                    case 1: {
                        attribute.setIntValue(Long.parseLong(val.trim()));
                        break;
                    }
                    case 4: {
                        attribute.setIntValue(Long.parseLong(val.trim()));
                        break;
                    }
                    default: {
                        attribute.setStringValue(val.trim());
                    }
                }
                doc.setAttribute(attName, attribute);
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), e);
            }
        }
        return currentField;
    }

    private String adjustPathExtended(List<String> row) {
        Object pathExtended = row.get(this.header.get(PATHEXTENDED));
        if (StringUtils.isNotEmpty((CharSequence)pathExtended) && !((String)pathExtended).startsWith("/")) {
            pathExtended = "/" + ((String)pathExtended).trim();
        }
        return pathExtended;
    }

    private String readPathExtended(List<String> row, User owner, Document doc) throws PersistenceException {
        String specifiedPathExtended;
        if (this.header.containsKey(PATHEXTENDED) && StringUtils.isNotEmpty((CharSequence)(specifiedPathExtended = this.adjustPathExtended(row)))) {
            Object targetPathExtended = specifiedPathExtended;
            Folder workspace = this.workspaces.stream().filter(w -> specifiedPathExtended.startsWith("/" + w.getName())).findFirst().orElse(null);
            if (workspace == null) {
                targetPathExtended = "/Default" + specifiedPathExtended;
                this.log.debug("Forcing path {} to {}", (Object)specifiedPathExtended, targetPathExtended);
            }
            FolderDAO folderDAO = Context.get(FolderDAO.class);
            Folder root = folderDAO.findRoot(doc.getTenantId());
            FolderHistory transaction = new FolderHistory();
            transaction.setUser(owner);
            Folder docFolder = folderDAO.createPath(root, StringUtils.substringAfter((String)targetPathExtended, (String)"/"), true, transaction);
            doc.setFolder(docFolder);
        }
        return PATHEXTENDED;
    }

    private String readStopPublishing(List<String> row, DateFormat df, Document doc) {
        String stoppublishing;
        if (this.header.containsKey(STOPPUBLISHING) && StringUtils.isNotEmpty((CharSequence)(stoppublishing = row.get(this.header.get(STOPPUBLISHING))))) {
            try {
                doc.setStopPublishing(df.parse(stoppublishing.trim()));
            }
            catch (ParseException e) {
                this.log.error(ERROR_PARSING_DATE, (Object)stoppublishing);
            }
        }
        return STOPPUBLISHING;
    }

    private String readStartPublishing(List<String> row, DateFormat df, Document doc) {
        String startpublishing;
        if (this.header.containsKey(STARTPUBLISHING) && StringUtils.isNotEmpty((CharSequence)(startpublishing = row.get(this.header.get(STARTPUBLISHING))))) {
            try {
                doc.setStartPublishing(df.parse(startpublishing.trim()));
            }
            catch (ParseException e) {
                this.log.error(ERROR_PARSING_DATE, (Object)startpublishing);
            }
        }
        return STARTPUBLISHING;
    }

    private String readDate(List<String> row, DateFormat df, Document doc) {
        String date;
        if (this.header.containsKey(DATE) && StringUtils.isNotEmpty((CharSequence)(date = row.get(this.header.get(DATE))))) {
            try {
                doc.setDate(df.parse(date.trim()));
            }
            catch (ParseException e) {
                this.log.error(ERROR_PARSING_DATE, (Object)date);
            }
        }
        return DATE;
    }

    private String readCreation(List<String> row, DateFormat df, Document doc) {
        String creation;
        if (this.header.containsKey(CREATION) && StringUtils.isNotEmpty((CharSequence)(creation = row.get(this.header.get(CREATION))))) {
            try {
                doc.setCreation(df.parse(creation.trim()));
            }
            catch (ParseException e) {
                this.log.error(ERROR_PARSING_DATE, (Object)creation);
            }
        }
        return CREATION;
    }

    private String readPublished(List<String> row, Document doc) {
        String published;
        if (this.header.containsKey(PUBLISHED) && StringUtils.isNotEmpty((CharSequence)(published = row.get(this.header.get(PUBLISHED))))) {
            doc.setPublished(Integer.parseInt(published.trim()));
        }
        return PUBLISHED;
    }

    private String readImmutable(List<String> row, Document doc) {
        String immutable;
        if (this.header.containsKey(IMMUTABLE) && StringUtils.isNotEmpty((CharSequence)(immutable = row.get(this.header.get(IMMUTABLE))))) {
            doc.setImmutable(Integer.parseInt(immutable.trim()));
        }
        return IMMUTABLE;
    }

    private String readSigned(List<String> row, Document doc) {
        String signed;
        if (this.header.containsKey(SIGNED) && StringUtils.isNotEmpty((CharSequence)(signed = row.get(this.header.get(SIGNED))))) {
            doc.setSigned(Integer.parseInt(signed.trim()));
        }
        return SIGNED;
    }

    private String readStatus(List<String> row, Document doc) {
        String status;
        if (this.header.containsKey(STATUS) && StringUtils.isNotEmpty((CharSequence)(status = row.get(this.header.get(STATUS))))) {
            int code = Integer.parseInt(status.trim());
            doc.setStatus(DocumentStatus.values()[code]);
        }
        return STATUS;
    }

    private String readColor(List<String> row, Document doc) {
        if (this.header.containsKey(COLOR)) {
            String color = row.get(this.header.get(COLOR));
            doc.setColor(color);
        }
        return COLOR;
    }

    private String readTags(List<String> row, Document doc) {
        String tags;
        if (this.header.containsKey(TAGS) && StringUtils.isNotEmpty((CharSequence)(tags = row.get(this.header.get(TAGS))))) {
            doc.setTagsFromWords(TagUtil.extractTags(this.tenant.getName(), tags.trim()));
        }
        return TAGS;
    }

    private String readBarcodeTemplate(List<String> row, Document doc) throws PersistenceException {
        String barcodeTemplate;
        if (this.header.containsKey(BARCODETEMPLATE) && StringUtils.isNotEmpty((CharSequence)(barcodeTemplate = row.get(this.header.get(BARCODETEMPLATE))))) {
            if (this.isDelete(barcodeTemplate)) {
                doc.setBarcodeTemplateId(null);
            } else {
                doc.setBarcodeTemplateId(Index.getBarcodeTemplateId(barcodeTemplate));
            }
        }
        return BARCODETEMPLATE;
    }

    private String readOcrTemplate(List<String> row, Document doc) throws PersistenceException {
        String ocrTemplate;
        if (this.header.containsKey(OCRTEMPLATE) && StringUtils.isNotEmpty((CharSequence)(ocrTemplate = row.get(this.header.get(OCRTEMPLATE))))) {
            if (this.isDelete(ocrTemplate)) {
                doc.setOcrTemplateId(null);
            } else {
                doc.setOcrTemplateId(Index.getOcrTemplateId(ocrTemplate));
            }
        }
        return OCRTEMPLATE;
    }

    private String readTemplate(List<String> row, Document doc) {
        String template;
        if (this.header.containsKey(TEMPLATE) && StringUtils.isNotEmpty((CharSequence)(template = row.get(this.header.get(TEMPLATE))))) {
            if (this.isDelete(template)) {
                doc.setTemplate(null);
                doc.setTemplateId(null);
                doc.setTemplateName(null);
            } else if (this.templates.get(template) != null) {
                doc.setTemplate(this.templates.get(template));
                doc.setTemplateId(doc.getTemplate().getId());
                doc.setTemplateName(doc.getTemplate().getName());
            }
        }
        return TEMPLATE;
    }

    private String readLanguage(List<String> row, Document doc) {
        String language;
        if (this.header.containsKey(LANGUAGE) && StringUtils.isNotEmpty((CharSequence)(language = row.get(this.header.get(LANGUAGE))))) {
            doc.setLanguage(language.trim());
        }
        return LANGUAGE;
    }

    private String readFileName(List<String> row, Document doc) {
        String fileName;
        String currentField = FILENAME;
        if (this.header.containsKey(currentField) && StringUtils.isNotEmpty((CharSequence)(fileName = row.get(this.header.get(currentField))))) {
            doc.setFileName(fileName.trim());
        }
        return currentField;
    }

    private String readCustomID(List<String> row, Document doc) {
        String customId;
        if (this.header.containsKey(CUSTOMID) && StringUtils.isNotEmpty((CharSequence)(customId = row.get(this.header.get(CUSTOMID))))) {
            if (this.isDelete(customId)) {
                doc.setCustomId(null);
            } else {
                doc.setCustomId(customId.trim());
            }
        }
        return CUSTOMID;
    }

    private Document readId(List<String> row, Document doc) throws IOException {
        if (this.header.get(ID) != null && StringUtils.isNotEmpty((CharSequence)row.get(this.header.get(ID)))) {
            doc.setId(Long.parseLong(row.get(this.header.get(ID)).trim()));
        }
        if (doc.getId() != 0L) {
            DocumentDAO docDAO = Context.get(DocumentDAO.class);
            try {
                Document referencedDocument = (Document)docDAO.findById(doc.getId());
                if (referencedDocument == null) {
                    throw new IOException("referenced document not found");
                }
                docDAO.initialize(referencedDocument);
                doc = referencedDocument;
            }
            catch (Exception e) {
                throw new IOException("Referenced document " + doc.getId() + " not found");
            }
        }
        return doc;
    }

    private boolean isDelete(String val) {
        return val != null && "#del#".equals(val.trim());
    }

    public void importDocuments() throws PersistenceException {
        ImportFolderCache cache = Context.get(ImportFolderCacheManager.class).getCache(this.importFolder.getId());
        UserDAO userDao = Context.get(UserDAO.class);
        User owner = userDao.findByUsername("_importfolder");
        CrawlerHelper helper = CrawlerHelper.getInstance(this.importFolder, this.crawler);
        while (this.processRow(cache, helper, owner) && !this.checkInterruptRequest()) {
        }
    }

    private boolean processRow(ImportFolderCache cache, CrawlerHelper helper, User owner) {
        Document currentDocument = null;
        int rowIndex = 0;
        try {
            boolean documentFileExists;
            List<String> row = this.readFields();
            ++rowIndex;
            if (CollectionUtils.isEmpty(row)) {
                return false;
            }
            currentDocument = this.readLine(row, owner);
            if (currentDocument == null) {
                this.log.warn("Unable read line {}", (Object)rowIndex);
                return false;
            }
            this.log.debug("Row {}: Inspecting document {}", (Object)rowIndex, (Object)currentDocument.getFileName());
            String currentPath = this.readPath(row);
            this.setTargetFolder(currentDocument, currentPath, owner);
            this.log.debug("currentPath: {}", (Object)currentPath);
            this.docFile = helper.getContentFile(currentPath);
            boolean bl = documentFileExists = this.docFile != null && this.docFile.exists();
            if (currentDocument.getId() == 0L && !documentFileExists) {
                this.log.warn("Unable to find the file for document {}", (Object)currentDocument.getFileName());
                return false;
            }
            try {
                this.sourceFile = helper.getFile(currentPath);
                this.log.debug("originalFile: {}", this.sourceFile);
                DocumentHistory transaction = new DocumentHistory();
                transaction.setEvent(DocumentEvent.STORED);
                transaction.setComment("");
                transaction.setUser(owner);
                if (currentDocument.getId() == 0L && cache.get(currentPath) != null) {
                    this.processDocumentInCache(currentDocument, currentPath, rowIndex, transaction, cache);
                } else {
                    this.processDocumentNotInCache(currentDocument, currentPath, documentFileExists, rowIndex, transaction, cache);
                }
                this.crawler.deleteImportedFile(this.sourceFile, currentPath, helper, this.importFolder, owner, currentDocument);
            }
            catch (Exception t) {
                this.crawler.onError(this.importFolder, currentDocument, "", t);
                this.log.error("Row {}: Error importing document '{}'", rowIndex, currentDocument != null ? currentDocument.getFileName() : "", t);
            }
        }
        finally {
            this.deleteDocumentFile();
        }
        return true;
    }

    private void processDocumentNotInCache(Document currentDocument, String currentPath, boolean docFileExists, int rowIndex, DocumentHistory transaction, ImportFolderCache cache) {
        try {
            try {
                if (currentDocument.getId() != 0L) {
                    this.updateExistingDocument(currentDocument, currentPath, docFileExists, transaction);
                } else {
                    currentDocument = this.importNewDocument(currentDocument, currentPath, transaction);
                }
                if (currentPath != null) {
                    cache.put(new ImportFolderCache.CacheEntry(currentPath, new Date(), currentDocument.getId()));
                }
            }
            catch (Exception e) {
                this.crawler.onError(this.importFolder, currentDocument, currentPath, e);
                this.log.error("Row {}: Error importing {}", (Object)rowIndex, (Object)currentPath);
                this.log.error(e.getMessage(), e);
                this.deleteDocumentFile();
            }
        }
        finally {
            this.deleteDocumentFile();
        }
    }

    private Document importNewDocument(Document currentDocument, String currentPath, DocumentHistory transaction) throws PersistenceException {
        DocumentDAO documentDao = Context.get(DocumentDAO.class);
        DocumentManager documentManager = Context.get(DocumentManager.class);
        Document doc = new Document();
        if (StringUtils.isNotEmpty((CharSequence)currentDocument.getFileName())) {
            doc.setFileName(currentDocument.getFileName());
        } else {
            doc.setFileName(this.docFile.getName());
        }
        doc.setFolder(currentDocument.getFolder());
        doc.setLocale(currentDocument.getLocale());
        doc.setTags(currentDocument.getTags());
        doc.setOcrTemplateId(currentDocument.getOcrTemplateId());
        doc.setBarcodeTemplateId(currentDocument.getBarcodeTemplateId());
        doc.setTemplate(currentDocument.getTemplate());
        doc.setAttributes(currentDocument.getAttributes());
        transaction.setDocument(doc);
        transaction.setPathOld(currentPath);
        Crawler.beforeDocumentImported(this.importFolder, transaction);
        Document document = documentManager.create(this.docFile, doc, transaction).getDocument();
        documentDao.initialize(document);
        if (documentDao.findByCustomId(currentDocument.getCustomId(), currentDocument.getTenantId()) == null) {
            document.setCustomId(currentDocument.getCustomId());
        }
        if (currentDocument.getImmutable() >= 0) {
            document.setImmutable(currentDocument.getImmutable());
        }
        if (currentDocument.getDate() != null) {
            document.setDate(currentDocument.getDate());
        }
        if (currentDocument.getCreation() != null) {
            document.setCreation(currentDocument.getCreation());
        }
        documentDao.store(document);
        this.crawler.afterDocumentImported(this.importFolder, transaction);
        currentDocument = document;
        return currentDocument;
    }

    private void updateExistingDocument(Document currentDocument, String currentPath, boolean docFileExists, DocumentHistory transaction) throws PersistenceException {
        DocumentDAO documentDao = Context.get(DocumentDAO.class);
        DocumentManager documentManager = Context.get(DocumentManager.class);
        if (docFileExists) {
            transaction.setComment("new document release version");
            documentManager.checkin(currentDocument.getId(), this.docFile, this.docFile.getName(), true, currentDocument, transaction);
        } else {
            transaction.setComment("metadata updated");
            documentManager.update((Document)documentDao.findById(currentDocument.getId()), currentDocument, transaction);
        }
        transaction.setDocument(currentDocument);
        transaction.setPathOld(currentPath);
        this.crawler.afterDocumentImported(this.importFolder, transaction);
    }

    private void processDocumentInCache(Document currentDocument, String currentPath, int rowIndex, DocumentHistory transaction, ImportFolderCache cache) throws IOException, PersistenceException {
        ImportFolderCache.CacheEntry entry = cache.get(currentPath);
        Date lastImported = entry.getDate();
        long sourceFileTimeMillis = 0L;
        if ("smb".equals(this.importFolder.getProvider())) {
            sourceFileTimeMillis = this.getSMBSourceFileLastModified(sourceFileTimeMillis);
        } else if (this.isRecentSMB()) {
            sourceFileTimeMillis = this.getSMB3SourceFileLastModified(sourceFileTimeMillis);
        } else if ("ftp".equals(this.importFolder.getProvider())) {
            sourceFileTimeMillis = this.getFTPSourceFileLastModified(sourceFileTimeMillis);
        } else if (this.isSecureFTP()) {
            sourceFileTimeMillis = this.getSecureFTPSourceFileLastModified(sourceFileTimeMillis);
        } else if ("file".equals(this.importFolder.getProvider())) {
            sourceFileTimeMillis = ((File)this.sourceFile).lastModified();
        }
        if (lastImported.compareTo(new Date(sourceFileTimeMillis)) < 0) {
            this.reImportExistingDocument(currentDocument, currentPath, rowIndex, transaction, cache, entry);
        }
    }

    private long getSecureFTPSourceFileLastModified(long sourceFileTimeMillis) {
        SFTPFile ftpFile = (SFTPFile)this.sourceFile;
        this.log.debug("ftpFile: {}", (Object)ftpFile);
        if (ftpFile == null) {
            this.log.error("ftpFile IS NULL");
        } else {
            this.log.debug("ftpFile.getLastModified(): {}", (Object)ftpFile.getLastModified());
            sourceFileTimeMillis = ftpFile.getLastModified().getTime();
        }
        return sourceFileTimeMillis;
    }

    private long getFTPSourceFileLastModified(long sourceFileTimeMillis) {
        FtpFile ftpFile = (FtpFile)((Object)this.sourceFile);
        if (ftpFile == null) {
            this.log.error("ftpFile IS NULL");
        } else {
            this.log.debug("ftpFile.getTimestamp(): {}", (Object)ftpFile.getTimestamp().getTimeInMillis());
            sourceFileTimeMillis = ftpFile.getTimestamp().getTimeInMillis();
        }
        return sourceFileTimeMillis;
    }

    private long getSMB3SourceFileLastModified(long sourceFileTimeMillis) {
        SMB3File smbFile = (SMB3File)this.sourceFile;
        if (smbFile == null) {
            this.log.error("smbFile IS NULL");
        } else {
            this.log.debug("smbFile.getLastModified(): {}", (Object)smbFile.getLastModified().getTime());
            sourceFileTimeMillis = smbFile.getLastModified().getTime();
        }
        return sourceFileTimeMillis;
    }

    private long getSMBSourceFileLastModified(long sourceFileTimeMillis) throws SmbException {
        SmbFile smbFile = (SmbFile)this.sourceFile;
        if (smbFile == null) {
            this.log.error("smbFile IS NULL");
        } else {
            this.log.debug("smbFile.lastModified(): {}", (Object)smbFile.lastModified());
            sourceFileTimeMillis = smbFile.lastModified();
        }
        return sourceFileTimeMillis;
    }

    private boolean isSecureFTP() {
        return "sftp".equals(this.importFolder.getProvider()) || "ftps".equals(this.importFolder.getProvider());
    }

    private boolean isRecentSMB() {
        return "smb2".equals(this.importFolder.getProvider()) || "smb3".equals(this.importFolder.getProvider());
    }

    private void reImportExistingDocument(Document currentDocument, String currentPath, int rowIndex, DocumentHistory transaction, ImportFolderCache cache, ImportFolderCache.CacheEntry entry) throws PersistenceException {
        DocumentDAO documentDao = Context.get(DocumentDAO.class);
        Document document = (Document)documentDao.findById(entry.getDocId());
        transaction.setPathOld(currentPath);
        try {
            try {
                if (document != null) {
                    transaction.setComment("new document release version");
                    transaction.setDocument(document);
                    Crawler.beforeDocumentImported(this.importFolder, transaction);
                    DocumentManager documentManager = Context.get(DocumentManager.class);
                    documentManager.checkin(entry.getDocId(), this.docFile, this.docFile.getName(), true, currentDocument, transaction);
                    this.crawler.afterDocumentImported(this.importFolder, transaction);
                } else {
                    document = this.reimportDocument(currentDocument, currentPath, transaction);
                }
                cache.put(new ImportFolderCache.CacheEntry(currentPath, new Date(), document.getId()));
            }
            catch (Exception e) {
                this.crawler.onError(this.importFolder, document, currentPath, e);
                this.log.error("Row {}: Error importing {}", (Object)rowIndex, (Object)currentPath);
                this.log.error(e.getMessage(), e);
                this.deleteDocumentFile();
            }
        }
        finally {
            this.deleteDocumentFile();
        }
    }

    private Document reimportDocument(Document currentDocument, String currentPath, DocumentHistory transaction) throws PersistenceException {
        DocumentDAO documentDao = Context.get(DocumentDAO.class);
        DocumentManager documentManager = Context.get(DocumentManager.class);
        Document doc = new Document();
        doc.setTenantId(this.targetFolder.getTenantId());
        if (StringUtils.isNotEmpty((CharSequence)currentDocument.getFileName())) {
            doc.setFileName(currentDocument.getFileName());
        } else {
            doc.setFileName(this.docFile.getName());
        }
        doc.setFolder(currentDocument.getFolder());
        doc.setLocale(currentDocument.getLocale());
        doc.setTags(currentDocument.getTags());
        doc.setOcrTemplateId(currentDocument.getOcrTemplateId());
        doc.setBarcodeTemplateId(currentDocument.getBarcodeTemplateId());
        doc.setTemplate(currentDocument.getTemplate());
        doc.setStatus(currentDocument.getStatus());
        doc.setImmutable(currentDocument.getImmutable());
        doc.setSigned(currentDocument.getSigned());
        doc.setAttributes(currentDocument.getAttributes());
        transaction.setDocument(doc);
        transaction.setPathOld(currentPath);
        Crawler.beforeDocumentImported(this.importFolder, transaction);
        Document document = documentManager.create(this.docFile, doc, transaction).getDocument();
        if (documentDao.findByCustomId(currentDocument.getCustomId(), this.targetFolder.getTenantId()) == null) {
            document.setCustomId(currentDocument.getCustomId());
        }
        if (currentDocument.getImmutable() >= 0) {
            document.setImmutable(currentDocument.getImmutable());
        }
        if (currentDocument.getDate() != null) {
            document.setDate(currentDocument.getDate());
        }
        if (currentDocument.getCreation() != null) {
            document.setCreation(currentDocument.getCreation());
        }
        documentDao.store(document);
        this.crawler.afterDocumentImported(this.importFolder, transaction);
        return document;
    }

    private void setTargetFolder(Document currentDocument, String currentPath, User owner) throws PersistenceException {
        if (currentDocument.getFolder() == null) {
            String docPathInLogicalDOC = currentPath;
            if (docPathInLogicalDOC != null && docPathInLogicalDOC.contains("/")) {
                docPathInLogicalDOC = currentPath.substring(0, currentPath.lastIndexOf(47));
                FolderHistory transaction = new FolderHistory();
                transaction.setUser(owner);
                FolderDAO folderDAO = Context.get(FolderDAO.class);
                currentDocument.setFolder(folderDAO.createPath(this.targetFolder, docPathInLogicalDOC, true, transaction));
            } else {
                currentDocument.setFolder(this.targetFolder);
            }
        }
    }

    private String readPath(List<String> row) {
        String currentPath = null;
        if (this.header.get(PATH) != null) {
            currentPath = row.get(this.header.get(PATH));
        }
        return currentPath;
    }

    private boolean checkInterruptRequest() {
        if (this.crawler.isInterrupt()) {
            if (!this.interruptRequested) {
                this.log.warn("Interrupt was requested, the elaboration of the index file has been stopped");
                this.interruptRequested = true;
            }
            return true;
        }
        return false;
    }

    private void deleteDocumentFile() {
        if (!(this.docFile == null || this.sourceFile instanceof File && this.docFile.equals(this.sourceFile))) {
            FileUtil.delete(this.docFile);
        }
    }
}

