/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.importfolder;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.AbstractDocument;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.DocumentEvent;
import com.logicaldoc.core.document.DocumentHistory;
import com.logicaldoc.core.document.DocumentManager;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.folder.FolderHistory;
import com.logicaldoc.core.metadata.Attribute;
import com.logicaldoc.core.metadata.Template;
import com.logicaldoc.core.metadata.TemplateDAO;
import com.logicaldoc.core.security.Tenant;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.impex.AbstractIndexImportHandler;
import com.logicaldoc.impex.Index;
import com.logicaldoc.importfolder.Crawler;
import com.logicaldoc.importfolder.ImportFolder;
import com.logicaldoc.importfolder.ImportFolderCache;
import com.logicaldoc.importfolder.ImportFolderCacheManager;
import com.logicaldoc.importfolder.helper.CrawlerHelper;
import com.logicaldoc.importfolder.helper.ftp.FtpFile;
import com.logicaldoc.importfolder.helper.sftp.SFTPFile;
import com.logicaldoc.importfolder.helper.smb3.SMB3File;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jcifs.smb.SmbFile;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ImportFolderIndexHandler
extends AbstractIndexImportHandler {
    private static final Logger log = LoggerFactory.getLogger(ImportFolderIndexHandler.class);
    protected Crawler crawler;
    protected Map<String, Template> templates;
    protected Folder targetFolder;
    protected ImportFolder importFolder;
    protected File documentFile;
    protected Object sourceFile;
    private String currentPath;
    private boolean interruptRequested = false;
    private boolean referencedDocumentExists = true;

    public ImportFolderIndexHandler(ImportFolder importFolder, Crawler crawler, Map<String, Template> templates, Collection<Folder> workspaces, Tenant tenant) throws PersistenceException {
        this.importFolder = importFolder;
        this.crawler = crawler;
        this.templates = templates;
        this.workspaces = workspaces;
        this.tenant = tenant;
        this.importOwner = "_importfolder";
        FolderDAO folderDao = Context.get(FolderDAO.class);
        this.targetFolder = folderDao.findFolder(importFolder.getTargetFolderId());
        if (this.targetFolder == null) {
            throw new PersistenceException("Target Folder " + String.valueOf(importFolder.getTargetFolderId()) + " not found.");
        }
    }

    @Override
    public void startElement(String uri, String localname, String tagName, Attributes attributes) throws SAXException {
        if (this.checkInterruptRequest() || !localname.equalsIgnoreCase("document")) {
            return;
        }
        this.currentDocument = new Document();
        this.getCurrentDocument().setTenantId(this.targetFolder.getTenantId());
        this.currentAttribute = null;
        if (attributes.getLength() != 0) {
            this.setDocumentAttributes(attributes);
        }
        try {
            DocumentDAO documentDao = Context.get(DocumentDAO.class);
            Document existingDocument = null;
            if (this.currentDocument.getId() != 0L && (existingDocument = (Document)documentDao.findById(this.currentDocument.getId())) == null) {
                this.crawler.getLog().warn("cannot find referenced document ID: {}", (Object)this.currentDocument.getId());
            }
            boolean bl = this.referencedDocumentExists = existingDocument != null;
            if (this.referencedDocumentExists) {
                documentDao.initialize(existingDocument);
                if (StringUtils.isNotEmpty(this.currentDocument.getCustomId())) {
                    existingDocument.setCustomId(this.currentDocument.getCustomId());
                }
                this.currentDocument = existingDocument;
            }
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
        }
    }

    private void setDocumentAttributes(Attributes attributes) {
        int length = attributes.getLength();
        int i = 0;
        while (i < length) {
            if (attributes.getQName(i).equals("id")) {
                this.currentDocument.setId(Long.parseLong(attributes.getValue(i)));
            }
            if (attributes.getQName(i).equals("customid")) {
                this.currentDocument.setCustomId(attributes.getValue(i));
            }
            ++i;
        }
    }

    private boolean checkInterruptRequest() {
        if (this.crawler != null && this.crawler.isInterrupt()) {
            if (!this.interruptRequested) {
                this.crawler.getLog().warn("Interrupt was requested, the elaboration of the index file has been stopped");
                this.interruptRequested = true;
            }
            return true;
        }
        return false;
    }

    @Override
    protected void endDocumentElement() {
        ImportFolderCache cache = Context.get(ImportFolderCacheManager.class).getCache(this.importFolder.getId());
        try {
            User owner = Context.get(UserDAO.class).findByUsername("_importfolder");
            this.crawler.getLog().debug("Inspecting document {}({}) - {}", this.getCurrentDocument().getId(), this.getCurrentDocument().getCustomId(), this.getCurrentDocument().getFileName());
            if (this.currentDocument.getId() != 0L && !this.referencedDocumentExists) {
                this.crawler.getLog().debug("Skip referenced document {}({}) - {} because not found in the repository", this.getCurrentDocument().getId(), this.getCurrentDocument().getCustomId(), this.getCurrentDocument().getFileName());
                return;
            }
            try {
                this.fixCurrentDocumentTargetFolder(owner);
                DocumentHistory transaction = new DocumentHistory();
                transaction.setEvent(DocumentEvent.STORED);
                transaction.setComment("");
                transaction.setUser(owner);
                if (this.currentPath != null && cache.get(this.currentPath) != null) {
                    this.endDocumentElementWithPathInCache(cache, transaction);
                } else {
                    this.endDocumentElementWithoutPathInCache(cache, transaction);
                }
                CrawlerHelper helper = CrawlerHelper.getInstance(this.importFolder, this.crawler);
                this.crawler.deleteImportedFile(this.sourceFile, this.currentPath, helper, this.importFolder, owner, this.getCurrentDocument());
            }
            catch (Exception t) {
                this.crawler.onError(this.importFolder, (Document)this.currentDocument, this.currentPath, t);
                this.crawler.getLog().error("Error importing document '{}'", (Object)this.getCurrentDocument().getFileName());
            }
        }
        finally {
            this.deleteDocumentFile();
        }
    }

    private void endDocumentElementWithoutPathInCache(ImportFolderCache cache, DocumentHistory transaction) {
        DocumentDAO documentDao = Context.get(DocumentDAO.class);
        try {
            try {
                if (this.currentDocument.getId() != 0L) {
                    transaction.setDocument(this.currentDocument);
                    this.checkinOrUpdateDocument(transaction);
                } else if (this.importFolder.getPreventDuplications() == 1) {
                    List<Document> existingDocs = documentDao.findByFileNameAndParentFolderId(this.currentDocument.getFolderId(), this.currentDocument.getFileName(), null, this.currentDocument.getTenantId(), null);
                    if (existingDocs.isEmpty()) {
                        this.createDocument(transaction);
                    } else {
                        transaction.setDocument(existingDocs.get(0));
                        this.checkinOrUpdateDocument(transaction);
                    }
                } else {
                    this.createDocument(transaction);
                }
                if (this.currentPath != null) {
                    cache.put(new ImportFolderCache.CacheEntry(this.currentPath, new Date(), this.currentDocument.getId()));
                }
            }
            catch (Exception e) {
                this.crawler.onError(this.importFolder, (Document)this.currentDocument, this.currentPath, e);
                this.crawler.getLog().error("Error importing {}", (Object)this.currentPath, (Object)e);
                this.deleteDocumentFile();
            }
        }
        finally {
            this.deleteDocumentFile();
        }
    }

    private void endDocumentElementWithPathInCache(ImportFolderCache cache, DocumentHistory transaction) throws IOException, PersistenceException {
        ImportFolderCache.CacheEntry entry = cache.get(this.currentPath);
        Date lastImported = entry.getDate();
        long sourceFileTimeMillis = 0L;
        if (this.isDocFileAvailable() && this.sourceFile != null) {
            if ("smb".equals(this.importFolder.getProvider())) {
                SmbFile smbFile = (SmbFile)this.sourceFile;
                sourceFileTimeMillis = smbFile.lastModified();
            } else if ("smb2".equals(this.importFolder.getProvider()) || "smb3".equals(this.importFolder.getProvider())) {
                SMB3File smbFile = (SMB3File)this.sourceFile;
                sourceFileTimeMillis = smbFile.getLastModified().getTime();
            } else if ("ftp".equals(this.importFolder.getProvider())) {
                FtpFile ftpFile = (FtpFile)((Object)this.sourceFile);
                sourceFileTimeMillis = ftpFile.getTimestamp().getTimeInMillis();
            } else if ("sftp".equals(this.importFolder.getProvider()) || "ftps".equals(this.importFolder.getProvider())) {
                SFTPFile ftpFile = (SFTPFile)this.sourceFile;
                sourceFileTimeMillis = ftpFile.getLastModified().getTime();
            } else if ("file".equals(this.importFolder.getProvider())) {
                sourceFileTimeMillis = ((File)this.sourceFile).lastModified();
            }
        } else if (this.currentDocument.getDate() != null) {
            sourceFileTimeMillis = this.currentDocument.getDate().getTime();
        }
        if (lastImported.compareTo(new Date(sourceFileTimeMillis)) < 0) {
            this.reimportExistingEntry(entry, cache, transaction);
        }
    }

    private void reimportExistingEntry(ImportFolderCache.CacheEntry entry, ImportFolderCache cache, DocumentHistory transaction) throws PersistenceException {
        this.currentDocument.setId(entry.getDocId());
        DocumentDAO documentDao = Context.get(DocumentDAO.class);
        Document existingDocument = (Document)documentDao.findById(entry.getDocId());
        try {
            try {
                if (existingDocument != null) {
                    transaction.setDocument(existingDocument);
                    this.checkinOrUpdateDocument(transaction);
                } else {
                    this.createDocument(transaction);
                }
                cache.put(new ImportFolderCache.CacheEntry(this.currentPath, new Date(), existingDocument != null ? existingDocument.getId() : this.currentDocument.getId()));
            }
            catch (Exception e) {
                this.crawler.onError(this.importFolder, existingDocument, this.currentPath, e);
                this.crawler.getLog().error("Error importing {}", (Object)this.currentPath, (Object)e);
                this.deleteDocumentFile();
            }
        }
        finally {
            this.deleteDocumentFile();
        }
    }

    private void fixCurrentDocumentTargetFolder(User owner) throws PersistenceException {
        Document document;
        AbstractDocument abstractDocument = this.getCurrentDocument();
        if (abstractDocument instanceof Document && (document = (Document)abstractDocument).getFolder() == null) {
            String path = this.currentPath;
            if (path.contains("/")) {
                path = path.substring(0, path.lastIndexOf(47));
                FolderHistory transaction = new FolderHistory();
                transaction.setUser(owner);
                FolderDAO folderDAO = Context.get(FolderDAO.class);
                document.setFolder(folderDAO.createPath(this.targetFolder, path, true, transaction));
            } else {
                document.setFolder(this.targetFolder);
            }
        }
    }

    private boolean isDocFileAvailable() {
        return this.documentFile != null && this.documentFile.exists() && this.documentFile.length() > 0L;
    }

    private void createDocument(DocumentHistory transaction) throws PersistenceException {
        if (!(this.currentDocument.getId() != 0L || this.documentFile != null && this.documentFile.exists())) {
            throw new PersistenceException("Unable to find the file for document " + this.getCurrentDocument().getFileName());
        }
        this.updateTemplate((Document)this.currentDocument);
        DocumentDAO documentDao = Context.get(DocumentDAO.class);
        DocumentManager documentManager = Context.get(DocumentManager.class);
        Document doc = new Document();
        if (StringUtils.isNotEmpty(this.getCurrentDocument().getFileName())) {
            doc.setFileName(this.getCurrentDocument().getFileName());
        } else {
            doc.setFileName(this.documentFile.getName());
        }
        AbstractDocument abstractDocument = this.getCurrentDocument();
        if (abstractDocument instanceof Document) {
            Document document = (Document)abstractDocument;
            doc.setFolder(document.getFolder());
            doc.setTags(document.getTags());
        }
        doc.setLocale(this.getCurrentDocument().getLocale());
        doc.setColor(this.getCurrentDocument().getColor());
        doc.setOcrTemplateId(this.getCurrentDocument().getOcrTemplateId());
        doc.setBarcodeTemplateId(this.getCurrentDocument().getBarcodeTemplateId());
        if (this.getCurrentDocument().getTemplate() != null) {
            TemplateDAO tDao = Context.get(TemplateDAO.class);
            Template currentDocTemplate = (Template)tDao.findById(this.getCurrentDocument().getTemplate().getId());
            tDao.initialize(currentDocTemplate);
            doc.setTemplate(currentDocTemplate);
        }
        doc.setAttributes(this.getCurrentDocument().getAttributes());
        transaction.setDocument(doc);
        transaction.setPathOld(this.currentPath);
        Crawler.beforeDocumentImported(this.importFolder, transaction);
        Document document = documentManager.create(this.documentFile, doc, transaction).getDocument();
        documentDao.initialize(document);
        if (documentDao.findByCustomId(this.getCurrentDocument().getCustomId(), this.getCurrentDocument().getTenantId()) == null) {
            document.setCustomId(this.getCurrentDocument().getCustomId());
        }
        if (this.getCurrentDocument().getImmutable() >= 0) {
            document.setImmutable(this.getCurrentDocument().getImmutable());
        }
        if (this.getCurrentDocument().getDate() != null) {
            document.setDate(this.getCurrentDocument().getDate());
        }
        documentDao.store(document);
        this.crawler.afterDocumentImported(this.importFolder, transaction);
        this.currentDocument = document;
    }

    private void checkinOrUpdateDocument(DocumentHistory transaction) throws PersistenceException {
        DocumentDAO documentDao = Context.get(DocumentDAO.class);
        DocumentManager documentManager = Context.get(DocumentManager.class);
        AbstractDocument abstractDocument = this.currentDocument;
        if (abstractDocument instanceof Document) {
            Document doc = (Document)abstractDocument;
            transaction.setDocument(doc);
            transaction.setPathOld(this.currentPath);
            Crawler.beforeDocumentImported(this.importFolder, transaction);
            if (this.isDocFileAvailable()) {
                transaction.setComment("imported new file version");
                documentManager.checkin((long)transaction.getDocId(), this.documentFile, this.documentFile.getName(), true, doc, transaction);
            } else {
                transaction.setComment("updated new metadata");
                documentManager.update((Document)documentDao.findById(transaction.getDocId()), doc, transaction);
            }
            this.crawler.afterDocumentImported(this.importFolder, transaction);
        }
    }

    private void updateTemplate(Document doc) throws PersistenceException {
        Template template = doc.getTemplate();
        if (template == null) {
            return;
        }
        TemplateDAO templateDao = Context.get(TemplateDAO.class);
        templateDao.initialize(template);
        boolean updated = false;
        for (String name : doc.getAttributeNames()) {
            if (template.getAttributes().containsKey(name)) continue;
            Attribute extAttribute = new Attribute();
            if (StringUtils.isNotEmpty(doc.getAttributes().get(name).getLabel())) {
                extAttribute.setLabel(doc.getAttributes().get(name).getLabel());
            } else {
                extAttribute.setLabel(name);
            }
            extAttribute.setMandatory(doc.getAttributes().get(name).getMandatory());
            extAttribute.setHidden(doc.getAttributes().get(name).getHidden());
            extAttribute.setReadonly(doc.getAttributes().get(name).getReadonly());
            extAttribute.setType(doc.getAttributes().get(name).getType());
            template.getAttributes().put(name, extAttribute);
            updated = true;
        }
        if (updated) {
            templateDao.store(template);
            this.templates.put(template.getName(), template);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (this.checkInterruptRequest()) {
            return;
        }
        try {
            if (this.currentDocument == null || "impex".equals(localName) || "attributes".equals(localName) || "attribute".equals(localName)) {
                return;
            }
            this.endElementLegacyAttributes(localName);
            Template template = null;
            if ("template".equals(localName)) {
                TemplateDAO templateDao = Context.get(TemplateDAO.class);
                if (StringUtils.isNotEmpty(this.buffer.toString().trim())) {
                    if (this.templates.keySet().contains(this.buffer.toString().trim())) {
                        template = this.templates.get(this.buffer.toString().trim());
                    } else {
                        template = new Template();
                        template.setTenantId(this.targetFolder.getTenantId());
                        template.setName(this.buffer.toString().trim());
                        template.setDescription("");
                        templateDao.store(template);
                        this.templates.put(this.buffer.toString().trim(), template);
                    }
                    this.getCurrentDocument().setTemplate(template);
                }
            }
            if ("path".equals(localName)) {
                String path;
                this.currentPath = path = this.buffer.toString().trim();
                CrawlerHelper helper = CrawlerHelper.getInstance(this.importFolder, this.crawler);
                this.documentFile = helper.getContentFile(path);
                this.sourceFile = helper.getFile(path);
            }
            if ("ocrTemplate".equals(localName)) {
                this.getCurrentDocument().setOcrTemplateId(Index.getOcrTemplateId(this.buffer.toString().trim()));
            }
            if ("barcodeTemplate".equals(localName)) {
                this.getCurrentDocument().setBarcodeTemplateId(Index.getBarcodeTemplateId(this.buffer.toString().trim()));
            }
        }
        catch (Exception e) {
            this.crawler.getLog().error("Error retrieving values of document '{}'", (Object)this.getCurrentDocument().getFileName(), (Object)e);
        }
        this.buffer = new StringBuilder();
    }

    private void deleteDocumentFile() {
        if (!(this.documentFile == null || this.sourceFile instanceof File && this.documentFile.equals(this.sourceFile))) {
            FileUtil.delete(this.documentFile);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        int i = 0;
        while (i < length) {
            this.buffer.append(ch[i + start]);
            ++i;
        }
    }
}

