/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.importfolder;

import com.logicaldoc.core.document.AbstractDocumentHistory;
import com.logicaldoc.core.history.History;
import com.logicaldoc.importfolder.ImportFolderEvent;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="ld_importfolder_history")
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class ImportFolderHistory
extends AbstractDocumentHistory {
    private static final long serialVersionUID = 1L;
    @Column(name="ld_importfolderid")
    private long importFolderId;
    @Column(name="ld_color", length=255)
    protected String color;

    public ImportFolderHistory() {
    }

    public ImportFolderHistory(ImportFolderHistory source) {
        this.copyAttributesFrom(source);
    }

    public void setEvent(ImportFolderEvent event) {
        this.event = event != null ? event.toString() : null;
    }

    @Override
    public void setEvent(String event) {
        this.setEvent(ImportFolderEvent.fromKey(event));
    }

    public ImportFolderEvent getEventEnum() {
        if (this.event == null) {
            return null;
        }
        return ImportFolderEvent.fromKey(this.event);
    }

    @Override
    protected void copyAttributesFrom(History source) {
        super.copyAttributesFrom(source);
        if (source instanceof ImportFolderHistory) {
            ImportFolderHistory ifh = (ImportFolderHistory)source;
            this.importFolderId = ifh.importFolderId;
            this.color = ifh.color;
        }
    }

    public long getImportFolderId() {
        return this.importFolderId;
    }

    public void setImportFolderId(long importFolderId) {
        this.importFolderId = importFolderId;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.importFolderId ^ this.importFolderId >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImportFolderHistory other = (ImportFolderHistory)obj;
        return this.importFolderId == other.importFolderId;
    }
}

