/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.importfolder;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.task.Task;
import com.logicaldoc.core.threading.ThreadPools;
import com.logicaldoc.i18n.I18N;
import com.logicaldoc.importfolder.CrawlStats;
import com.logicaldoc.importfolder.Crawler;
import com.logicaldoc.importfolder.ImportFolder;
import com.logicaldoc.importfolder.ImportFolderDAO;
import com.logicaldoc.importfolder.helper.CrawlerHelper;
import com.logicaldoc.util.CollectionUtil;
import com.logicaldoc.util.concurrent.SerialFuture;
import com.logicalobjects.jlicense.license.LicenseManager;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import org.slf4j.LoggerFactory;

public class ImportFolderCrawler
extends Task {
    public static final String NAME = "ImportFolderCrawler";
    @Resource(name="importFolderDAO")
    private ImportFolderDAO importFolderDao;
    @Resource(name="threadPools")
    private ThreadPools threadPools;
    private long totalImportedDocs = 0L;
    private long totalUpdatedDocs = 0L;
    private long totalErrors = 0L;
    private int remoteFoldersCount = 0;
    private int localFoldersCount = 0;
    private List<Crawler> threads = new ArrayList<Crawler>();

    public ImportFolderCrawler() {
        super(NAME);
        this.log = LoggerFactory.getLogger(ImportFolderCrawler.class);
    }

    private void crawlImportFolders() {
        List<ImportFolder> importFolders = this.getEnabledImportFolders();
        this.log.info("Found {} folders to import: {} remote and {} local", importFolders.size(), this.remoteFoldersCount, this.localFoldersCount);
        int threadsTotal = this.config.getInt("threadpool.ImportFolderCrawler.max", 1);
        this.log.info("Distribute the crawling among {} threads", (Object)threadsTotal);
        Collection<List<ImportFolder>> segments = CollectionUtil.partition(importFolders.stream().filter(f -> "file".equals(f.getProvider()) && LicenseManager.getInstance().isEnabled("Feature_61") || !"file".equals(f.getProvider()) && LicenseManager.getInstance().isEnabled("Feature_1")).toList(), (int)Math.ceil((double)importFolders.size() / (double)threadsTotal));
        ArrayList futures = new ArrayList();
        for (List<ImportFolder> segment : segments) {
            Crawler task = new Crawler(segment, this, this.log);
            this.threads.add(task);
            futures.add(this.threadPools.schedule(task, NAME, 1L));
        }
        try {
            List stats = new SerialFuture(futures).getAll();
            for (CrawlStats stat : stats) {
                this.totalErrors += stat.getErrors();
                this.totalImportedDocs += stat.getImported();
                this.totalUpdatedDocs += stat.getUpdated();
            }
        }
        catch (InterruptedException ie) {
            this.log.error("Import Folder Crawler has been interrupted", ie);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            this.log.error(e.getMessage(), e);
        }
        this.log.info("All crawlers have completed");
    }

    void onFileImported() {
        this.next();
    }

    void onImportFolderCompleted(CrawlStats stats, ImportFolder importFolder) {
        if (stats.getTotalCreated() < importFolder.getBatch()) {
            this.setProgress(this.getProgress() + (importFolder.getBatch() - stats.getTotalCreated()));
        }
    }

    @Override
    public synchronized void interrupt() {
        super.interrupt();
        for (Crawler thread : this.threads) {
            thread.interrupt();
        }
    }

    private List<ImportFolder> getEnabledImportFolders() {
        ArrayList<ImportFolder> importFolders = new ArrayList();
        try {
            importFolders = this.importFolderDao.findByWhere("_entity.enabled=1", null, null);
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
        }
        return importFolders;
    }

    private boolean isFeatureEnabled() {
        return LicenseManager.getInstance().isEnabled("Feature_1") || LicenseManager.getInstance().isEnabled("Feature_61");
    }

    @Override
    public boolean isIndeterminate() {
        return false;
    }

    @Override
    public boolean isConcurrent() {
        return false;
    }

    private long count() {
        long count = 0L;
        List<Object> importFolders = new ArrayList();
        try {
            importFolders = this.importFolderDao.findAll();
        }
        catch (PersistenceException persistenceException) {
            this.log.error(persistenceException.getMessage(), persistenceException);
        }
        for (ImportFolder importFolder : importFolders) {
            if (importFolder.getEnabled() < 1) continue;
            try {
                int indexCount = this.countDocsInIndexFile(importFolder);
                count += indexCount >= 0 ? (long)indexCount : importFolder.getBatch();
            }
            catch (PersistenceException e) {
                this.log.warn(e.getMessage(), e);
            }
            if (!"file".equals(importFolder.getProvider())) {
                ++this.remoteFoldersCount;
                continue;
            }
            if (!"file".equals(importFolder.getProvider())) continue;
            ++this.localFoldersCount;
        }
        return count;
    }

    private int countDocsInIndexFile(ImportFolder importFolder) throws PersistenceException {
        CrawlerHelper helper = CrawlerHelper.getInstance(importFolder, new Crawler(null, this, this.log));
        int indexCount = -1;
        try {
            indexCount = helper.importDocumentsCount();
        }
        catch (Exception e) {
            this.log.warn(e.getMessage(), (Object)2);
        }
        return indexCount;
    }

    @Override
    protected void runTask() {
        if (!this.isFeatureEnabled()) {
            this.log.error("Feature not enabled, exit crawling");
            return;
        }
        this.log.info("Start crawling of all folders");
        this.totalImportedDocs = 0L;
        this.totalUpdatedDocs = 0L;
        this.totalErrors = 0L;
        this.remoteFoldersCount = 0;
        this.localFoldersCount = 0;
        this.threads.clear();
        try {
            this.size = this.count();
            this.log.info("Found a total of possible {} files to process", (Object)this.size);
            this.crawlImportFolders();
        }
        finally {
            this.log.info("Crawl completed");
            this.log.info("Imported documents: {}", (Object)this.totalImportedDocs);
            this.log.info("Updated documents: {}", (Object)this.totalUpdatedDocs);
            this.log.info("Errors: {}", (Object)this.totalErrors);
        }
    }

    @Override
    protected String prepareReport(Locale locale) {
        StringBuilder sb = new StringBuilder();
        sb.append(I18N.message("importeddocs", locale) + ": ");
        sb.append(this.totalImportedDocs);
        sb.append("\n");
        sb.append(I18N.message("updateddocs", locale) + ": ");
        sb.append(this.totalUpdatedDocs);
        sb.append("\n");
        sb.append(I18N.message("errors", locale) + ": ");
        sb.append(this.totalErrors);
        return sb.toString();
    }

    public ImportFolderDAO getImportFolderDao() {
        return this.importFolderDao;
    }

    public void setImportFolderDao(ImportFolderDAO importFolderDao) {
        this.importFolderDao = importFolderDao;
    }
}

