/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.importfolder;

import com.logicaldoc.enterprise.cleaner.Cleaner;
import com.logicaldoc.util.config.ContextProperties;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.GregorianCalendar;

public class ImportFolderCleaner
extends Cleaner {
    public ImportFolderCleaner() {
        this.setDbScript("sql/clean-importfolder.sql");
    }

    public ImportFolderCleaner(Connection con) {
        super(con);
        this.setDbScript("sql/clean-importfolder.sql");
    }

    protected void afterDbUpdate() {
    }

    protected void beforeDbUpdate() {
        try {
            int ttl = new ContextProperties().getInt("history.importfolder.ttl", -1);
            if (ttl <= 0) {
                return;
            }
            Date date = new Date();
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(date);
            cal.add(5, -ttl);
            date = cal.getTime();
            Throwable throwable = null;
            Object var5_7 = null;
            try (PreparedStatement stmt = this.connection.prepareStatement("update ld_importfolder_history set ld_deleted=1 where ld_deleted = 0 and ld_date < ?");){
                stmt.setTimestamp(1, new Timestamp(date.getTime()));
                int count = stmt.executeUpdate();
                this.log.debug("The number of obsolete entries is: {}", (Object)count);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), e);
        }
    }
}

