/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.importfolder;

import com.logicaldoc.importfolder.ImportFolderCache;
import com.logicaldoc.util.plugin.LogicalDOCPlugin;
import com.logicaldoc.util.plugin.PluginRegistry;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportFolderCacheManager {
    private static final Logger log = LoggerFactory.getLogger(ImportFolderCacheManager.class);

    public ImportFolderCache getCache(long importFolderId) {
        File root = new File(this.getCacheDirectory(), "" + importFolderId);
        return new ImportFolderCache(root);
    }

    public void deleteCache(long importFolderId) {
        File root = new File(this.getCacheDirectory(), "" + importFolderId);
        new ImportFolderCache(root).empty();
    }

    protected File getCacheDirectory() {
        File file = new File("cache");
        try {
            LogicalDOCPlugin importFolderPlugin = (LogicalDOCPlugin)PluginRegistry.getInstance().getManager().getPlugin("logicaldoc-importfolder");
            file = importFolderPlugin.resolveDataPath("cache");
        }
        catch (Exception t) {
            log.error(t.getMessage(), t);
        }
        if (!file.exists()) {
            file.mkdir();
        }
        return file;
    }
}

