/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.importfolder;

import com.logicaldoc.util.StringUtil;
import com.logicaldoc.util.csv.CSVFileReader;
import com.logicaldoc.util.csv.CSVFileWriter;
import com.logicaldoc.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportFolderCache {
    private static final String YYYY_M_MDD_H_HMMSS = "yyyyMMddHHmmss";
    private static final Logger log = LoggerFactory.getLogger(ImportFolderCache.class);
    private File root;
    private Map<String, CacheEntry> lastEntries = new HashMap<String, CacheEntry>();
    private String lastFolder = null;

    public ImportFolderCache(File root) {
        this.root = root;
        if (!root.exists()) {
            try {
                FileUtils.forceMkdir(root);
            }
            catch (IOException e) {
                log.error("Unable to create root: {}", (Object)root.getPath());
            }
        }
    }

    public File getRoot() {
        return this.root;
    }

    public CacheEntry get(String filePath) throws IOException {
        String fpath = filePath.startsWith("/") ? filePath.substring(1) : filePath;
        String path = FileUtil.getPath(fpath);
        int hash = path.hashCode();
        File cachefile = this.getCacheFile(hash);
        if (!cachefile.exists()) {
            return null;
        }
        if (!path.equals(this.lastFolder)) {
            this.lastEntries.clear();
            this.lastFolder = path;
            long i = 0L;
            try (CSVFileReader reader = new CSVFileReader(cachefile.getPath(), ',');){
                SimpleDateFormat df = new SimpleDateFormat(YYYY_M_MDD_H_HMMSS);
                List<String> fields = reader.readFields();
                while (!fields.isEmpty()) {
                    try {
                        this.lastEntries.put(path + fields.get(0), new CacheEntry(path + fields.get(0), df.parse(fields.get(1)), Long.parseLong(fields.get(2))));
                    }
                    catch (Exception e) {
                        log.warn("Line {} error: {}", (Object)i, (Object)e.getMessage());
                    }
                    fields = reader.readFields();
                }
            }
        }
        return this.lastEntries.get(fpath);
    }

    public void put(CacheEntry entry) throws IOException {
        Serializable df;
        String path = FileUtil.getPath(entry.getPath());
        int hash = path.hashCode();
        File cachefile = this.getCacheFile(hash);
        if (!cachefile.exists()) {
            FileUtils.touch(cachefile);
        }
        if (!path.equals(this.lastFolder)) {
            this.lastEntries.clear();
            Throwable throwable = null;
            Object var6_7 = null;
            try (CSVFileReader reader = new CSVFileReader(cachefile.getPath(), ',');){
                df = new SimpleDateFormat(YYYY_M_MDD_H_HMMSS);
                List<String> fields = reader.readFields();
                while (!fields.isEmpty()) {
                    try {
                        CacheEntry tmp = new CacheEntry(path + fields.get(0), ((DateFormat)df).parse(fields.get(1)), Integer.parseInt(fields.get(2)));
                        this.lastEntries.put(tmp.getPath(), tmp);
                        if (entry.getPath().equals(tmp.getPath())) {
                            tmp.setDocId(entry.getDocId());
                            tmp.setDate(entry.getDate());
                        }
                    }
                    catch (Exception e) {
                        log.error(e.getMessage());
                    }
                    fields = reader.readFields();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        log.debug("Put entry {}", (Object)entry.getPath());
        this.lastEntries.put(entry.getPath(), entry);
        File tmpFile = new File(cachefile.getParentFile(), cachefile.getName() + ".tmp");
        long i = 0L;
        df = null;
        Throwable throwable = null;
        try (CSVFileWriter writer = new CSVFileWriter(tmpFile.getPath(), ',');){
            for (CacheEntry item : this.lastEntries.values()) {
                SimpleDateFormat df2 = new SimpleDateFormat(YYYY_M_MDD_H_HMMSS);
                ArrayList<String> fields = new ArrayList<String>();
                fields.add(FileUtil.getName(item.getPath()));
                fields.add(df2.format(item.getDate()));
                fields.add(Long.toString(item.getDocId()));
                writer.writeFields(fields);
                ++i;
            }
        }
        catch (Throwable throwable3) {
            if (df == null) {
                df = throwable3;
            } else if (df != throwable3) {
                ((Throwable)df).addSuppressed(throwable3);
            }
            throw df;
        }
        FileUtils.forceDelete(cachefile);
        FileUtils.moveFile(tmpFile, cachefile);
        File pathFile = new File(cachefile.getParentFile(), hash + ".path");
        throwable = null;
        Object var10_16 = null;
        try (CSVFileWriter writer = new CSVFileWriter(pathFile.getPath(), ',');){
            ArrayList<String> fields = new ArrayList<String>();
            fields.add(path);
            fields.add("" + hash);
            writer.writeFields(fields);
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        log.debug("Written {} entries", (Object)i);
    }

    protected File getCacheFile(long hash) {
        return new File(this.getCacheDirectory(hash), hash + ".cache");
    }

    protected File getCacheDirectory(long hash) {
        String relativePath = this.computeRelativePath(hash);
        return new File(this.root, relativePath);
    }

    protected String computeRelativePath(long hash) {
        return StringUtil.split(Long.toString(hash), '/', 3);
    }

    public void empty() {
        try {
            FileUtils.forceDelete(this.root);
        }
        catch (IOException e) {
            log.error("Unable to delete cache: {}", (Object)this.root.getPath());
        }
    }

    public static class CacheEntry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Date date;
        private long docId;
        private String path;

        public CacheEntry(String path, Date date, long docId) {
            this.setPath(path);
            this.date = date;
            this.docId = docId;
        }

        public Date getDate() {
            return this.date;
        }

        public long getDocId() {
            return this.docId;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path.startsWith("/") ? path.substring(1) : path;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        public void setDocId(long docId) {
            this.docId = docId;
        }
    }
}

