/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.importfolder;

import com.logicaldoc.core.PersistentObject;
import com.logicaldoc.util.LocaleUtil;
import com.logicaldoc.util.crypt.CryptUtil;
import com.logicaldoc.util.io.FileUtil;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.jfree.util.Log;
import org.springframework.beans.BeanUtils;

@Entity
@Table(name="ld_importfolder")
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class ImportFolder
extends PersistentObject {
    private static final String UTF_8 = "UTF-8";
    private static final long serialVersionUID = 1L;
    public static final String PROVIDER_SMB = "smb";
    public static final String PROVIDER_SMB2 = "smb2";
    public static final String PROVIDER_SMB3 = "smb3";
    public static final String PROVIDER_FILE = "file";
    public static final String PROVIDER_FTP = "ftp";
    public static final String PROVIDER_FTPS = "ftps";
    public static final String PROVIDER_SFTP = "sftp";
    public static final int POLICY_NEW_VERSION = 0;
    public static final int POLICY_NEW_DOCUMENT = 1;
    @Column(name="ld_domain")
    private String domain;
    @Column(name="ld_username")
    private String username;
    @Column(name="ld_password")
    private String password;
    @Column(name="ld_path")
    private String path;
    @Column(name="ld_provider")
    private String provider = "smb";
    @Column(name="ld_host")
    private String host;
    @Column(name="ld_port")
    private String port;
    @Column(name="ld_includes")
    private String includes = "*.*";
    @Column(name="ld_excludes")
    private String excludes = "~*,*~,#*#,.#*,%*%,._*,.DS_Store,Desktop.ini,Thumbs.db";
    @Column(name="ld_maxsize")
    private Integer maxSize = null;
    @Column(name="ld_language")
    private String language = "";
    @Column(name="ld_depth")
    private int depth = 5;
    @Column(name="ld_enabled")
    private int enabled = 1;
    @Column(name="ld_templateId")
    private Long templateId;
    @Column(name="ld_tags", length=4000)
    private String tags = "";
    @Column(name="ld_targetfolderid")
    private Long targetFolderId;
    @Column(name="ld_delimport")
    private int delImport = 0;
    @Column(name="ld_importempty")
    private int importEmpty = 0;
    @Column(name="ld_recordhistory")
    private int recordHistory = 0;
    @Column(name="ld_startdate", columnDefinition="DATETIME(3)")
    private Date startDate;
    @Column(name="ld_updatepolicy")
    private int updatePolicy = 0;
    @Column(name="ld_inheritrights")
    private int inheritRights = 1;
    @Column(name="ld_preventduplications")
    private int preventDuplications = 0;
    @Column(name="ld_batch", nullable=false)
    private long batch = 10000L;
    @Column(name="ld_ocrtemplateid")
    private Long ocrTemplateId;
    @Column(name="ld_barcodetemplateid")
    private Long barcodeTemplateId;
    @Column(name="ld_automation")
    private String automation;
    @Column(name="ld_automationafter")
    private String automationAfter;
    @Column(name="ld_automationend")
    private String automationEnd;

    public ImportFolder() {
    }

    public ImportFolder(ImportFolder folder) {
        BeanUtils.copyProperties((Object)folder, (Object)this, (String[])new String[]{"id", "lastModified", "recordVersion", "creation"});
    }

    public long getBatch() {
        return this.batch;
    }

    public void setBatch(long batch) {
        this.batch = batch;
    }

    public Long getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String url) {
        this.path = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String userName) {
        this.username = userName;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPasswordDecrypted() {
        return ImportFolder.decryptPassword(this.getPassword());
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public static String encryptPassword(String password) {
        try {
            CryptUtil crypt = new CryptUtil("sjkl1fhrsjl.tg/,289o2n4!brfj1l23ti36453g2qwe42535");
            return crypt.encrypt(password);
        }
        catch (Exception e) {
            Log.error((Object)e.getMessage(), (Exception)e);
            return null;
        }
    }

    public static String decryptPassword(String password) {
        try {
            CryptUtil crypt = new CryptUtil("sjkl1fhrsjl.tg/,289o2n4!brfj1l23ti36453g2qwe42535");
            return crypt.decrypt(password);
        }
        catch (Exception e) {
            Log.error((Object)e.getMessage(), (Exception)e);
            return null;
        }
    }

    public String getUrl() {
        String prov = this.getProvider();
        if (prov.startsWith(PROVIDER_SMB)) {
            prov = PROVIDER_SMB;
        }
        StringBuilder url = new StringBuilder(prov);
        url.append("://");
        if (!prov.equals(PROVIDER_SMB) && !prov.equals(PROVIDER_FILE)) {
            this.appendModernSMBUrlSpec(url);
        }
        if (!prov.equals(PROVIDER_FILE)) {
            if (StringUtils.isNotEmpty(this.getHost())) {
                url.append(this.getHost());
            }
            if (StringUtils.isNotEmpty(this.getPort())) {
                url.append(":" + this.getPort());
            }
        }
        if (StringUtils.isNotEmpty(this.getPath()) && !this.getPath().startsWith("/")) {
            url.append("/");
        }
        url.append(this.getPath());
        if (StringUtils.isNotEmpty(this.getPath()) && !this.getPath().endsWith("/")) {
            url.append("/");
        }
        return url.toString();
    }

    private void appendModernSMBUrlSpec(StringBuilder url) {
        if (StringUtils.isNotEmpty(this.getDomain())) {
            try {
                url.append(URLEncoder.encode(this.getDomain(), UTF_8));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (StringUtils.isNotEmpty(this.getUsername())) {
            if (StringUtils.isNotEmpty(this.getDomain())) {
                url.append(";");
            }
            try {
                url.append(URLEncoder.encode(this.getUsername(), UTF_8));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (StringUtils.isNotEmpty(this.getPassword())) {
            if (StringUtils.isNotEmpty(this.getUsername())) {
                url.append(":");
            }
            try {
                url.append(URLEncoder.encode(ImportFolder.decryptPassword(this.getPassword()), UTF_8));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (StringUtils.isNotEmpty(this.getUsername())) {
            url.append("@");
        }
    }

    public String getDisplayUrl() {
        StringBuilder url = new StringBuilder();
        if (PROVIDER_FILE.equals(this.getProvider())) {
            if (StringUtils.isNotEmpty(this.getPath())) {
                url.append(this.getPath());
            }
        } else if (this.getProvider().startsWith(PROVIDER_SMB)) {
            if (StringUtils.isEmpty(this.getHost()) || StringUtils.isEmpty(this.getPath())) {
                return "";
            }
            url.append("\\\\");
            url.append(this.getHost());
            Object pth = this.getPath().replace("/", "\\");
            if (!((String)pth).startsWith("\\")) {
                pth = "\\" + (String)pth;
            }
            url.append((String)pth);
        } else {
            url.append(this.getProvider());
            url.append("://");
            url.append(this.getHost());
            if (this.getPort() != null && Integer.parseInt(this.getPort()) > 0) {
                url.append(":");
                url.append(this.getPort());
            }
            if (!this.getPath().startsWith("/")) {
                url.append("/");
            }
            url.append(this.getPath());
        }
        return url.toString();
    }

    public boolean isAllowed(String filename) {
        return FileUtil.matches(filename, this.includes, this.excludes);
    }

    public int getEnabled() {
        return this.enabled;
    }

    public void setEnabled(int enabled) {
        this.enabled = enabled;
    }

    public Integer getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(Integer maxSize) {
        this.maxSize = maxSize;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public Locale getLocale() {
        return LocaleUtil.toLocale(this.getLanguage());
    }

    public void setLocale(Locale locale) {
        this.setLanguage(locale.toString());
    }

    public Long getTargetFolderId() {
        return this.targetFolderId;
    }

    public void setTargetFolderId(Long targetFolderId) {
        this.targetFolderId = targetFolderId;
    }

    public int getDelImport() {
        return this.delImport;
    }

    public void setDelImport(int delImport) {
        this.delImport = delImport;
    }

    public String getIncludes() {
        return this.includes;
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public int getUpdatePolicy() {
        return this.updatePolicy;
    }

    public void setUpdatePolicy(int updatePolicy) {
        this.updatePolicy = updatePolicy;
    }

    public int getImportEmpty() {
        return this.importEmpty;
    }

    public void setImportEmpty(int importEmpty) {
        this.importEmpty = importEmpty;
    }

    public int getInheritRights() {
        return this.inheritRights;
    }

    public void setInheritRights(int inheritRights) {
        this.inheritRights = inheritRights;
    }

    public Long getOcrTemplateId() {
        return this.ocrTemplateId;
    }

    public void setOcrTemplateId(Long ocrTemplateId) {
        this.ocrTemplateId = ocrTemplateId;
    }

    public Long getBarcodeTemplateId() {
        return this.barcodeTemplateId;
    }

    public void setBarcodeTemplateId(Long barcodeTemplateId) {
        this.barcodeTemplateId = barcodeTemplateId;
    }

    public int getRecordHistory() {
        return this.recordHistory;
    }

    public void setRecordHistory(int recordHistory) {
        this.recordHistory = recordHistory;
    }

    public int getPreventDuplications() {
        return this.preventDuplications;
    }

    public void setPreventDuplications(int preventDuplications) {
        this.preventDuplications = preventDuplications;
    }

    public String getAutomation() {
        return this.automation;
    }

    public void setAutomation(String automation) {
        this.automation = automation;
    }

    public String getAutomationAfter() {
        return this.automationAfter;
    }

    public void setAutomationAfter(String automationAfter) {
        this.automationAfter = automationAfter;
    }

    public String getAutomationEnd() {
        return this.automationEnd;
    }

    public void setAutomationEnd(String automationEnd) {
        this.automationEnd = automationEnd;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.port == null ? 0 : this.port.hashCode());
        result = 31 * result + (this.provider == null ? 0 : this.provider.hashCode());
        result = 31 * result + (this.targetFolderId == null ? 0 : this.targetFolderId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImportFolder other = (ImportFolder)obj;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        if (this.port == null ? other.port != null : !this.port.equals(other.port)) {
            return false;
        }
        if (this.provider == null ? other.provider != null : !this.provider.equals(other.provider)) {
            return false;
        }
        return !(this.targetFolderId == null ? other.targetFolderId != null : !this.targetFolderId.equals(other.targetFolderId));
    }
}

