/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.importfolder;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.history.HibernateHistoryDAO;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.importfolder.ImportFolderHistory;
import com.logicaldoc.importfolder.ImportFolderHistoryDAO;
import com.logicaldoc.util.sql.SqlUtil;
import jakarta.annotation.Resource;
import jakarta.transaction.Transactional;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="importFolderHistoryDAO")
@Transactional
public class HibernateImportFolderHistoryDAO
extends HibernateHistoryDAO<ImportFolderHistory>
implements ImportFolderHistoryDAO {
    @Resource(name="folderDAO")
    private FolderDAO folderDAO;
    @Resource(name="userDAO")
    private UserDAO userDAO;

    private HibernateImportFolderHistoryDAO() {
        super(ImportFolderHistory.class);
        this.log = LoggerFactory.getLogger(HibernateImportFolderHistoryDAO.class);
    }

    public void setFolderDAO(FolderDAO folderDAO) {
        this.folderDAO = folderDAO;
    }

    public void setUserDAO(UserDAO userDAO) {
        this.userDAO = userDAO;
    }

    @Override
    public List<ImportFolderHistory> findByImportFolderId(long importFolderId, String event) throws PersistenceException {
        StringBuilder query = new StringBuilder("_entity.importFolderId = '" + importFolderId + "'");
        if (StringUtils.isNotEmpty(event)) {
            query.append(" and _entity.event='" + SqlUtil.doubleQuotes(event) + "'");
        }
        return this.findByWhere(query.toString(), "_entity.date desc", null);
    }

    @Override
    public void cleanOldHistories(int ttl) throws PersistenceException {
        this.log.info("cleanOldHistories rows updated: {}", (Object)this.cleanOldRecords(ttl, "ld_importfolder_history"));
    }

    @Override
    public void store(ImportFolderHistory history) throws PersistenceException {
        if (history.getUserId() == null) {
            history.setUser(this.userDAO.findByUsername("_importfolder"));
        }
        super.store(history);
    }

    @Override
    public void store(ImportFolderHistory history, Document document) throws PersistenceException {
        if (document != null) {
            history.setTenantId(document.getTenantId());
            history.setFilename(document.getFileName());
            history.setFileSize(document.getFileSize());
            history.setRevision(document.getRevision());
            history.setDocId(document.getId());
            history.setColor(document.getColor());
            if (document.getFolder() != null) {
                history.setFolderId(document.getFolder().getId());
                history.setPath(this.folderDAO.computePathExtended(document.getFolder().getId()));
            }
        }
        this.store(history);
    }
}

