/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.importfolder;

import com.logicaldoc.core.HibernatePersistentObjectDAO;
import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.importfolder.ImportFolder;
import com.logicaldoc.importfolder.ImportFolderCacheManager;
import com.logicaldoc.importfolder.ImportFolderDAO;
import jakarta.annotation.Resource;
import jakarta.transaction.Transactional;
import java.util.List;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="importFolderDAO")
@Transactional
public class HibernateImportFolderDAO
extends HibernatePersistentObjectDAO<ImportFolder>
implements ImportFolderDAO {
    @Resource(name="ImportFolderCacheManager")
    private ImportFolderCacheManager cacheManager;

    private HibernateImportFolderDAO() {
        super(ImportFolder.class);
        this.log = LoggerFactory.getLogger(HibernateImportFolderDAO.class);
    }

    public ImportFolderCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(ImportFolderCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public void delete(long importFolderId, int code) throws PersistenceException {
        if (code == 0) {
            throw new IllegalArgumentException("code cannot be 0");
        }
        if (!this.checkStoringAspect()) {
            return;
        }
        ImportFolder importFolder = (ImportFolder)this.findById(importFolderId);
        if (importFolder != null) {
            importFolder.setDeleted(code);
            this.saveOrUpdate(importFolder);
            this.cacheManager.deleteCache(importFolder.getId());
        }
    }

    @Override
    public List<ImportFolder> findByProvider(String provider) throws PersistenceException {
        return this.findByWhere("_entity.provider='" + provider + "'", null, null);
    }
}

