/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.impex.webservice.soap.endpoint;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.security.SessionManager;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.gui.common.client.ServerException;
import com.logicaldoc.impex.Archive;
import com.logicaldoc.impex.ArchiveDAO;
import com.logicaldoc.impex.ImpexServiceImpl;
import com.logicaldoc.impex.webservice.soap.ImpexService;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.webservice.AbstractService;
import com.logicaldoc.webservice.WebserviceException;
import java.util.List;

public class SoapImpexService
extends AbstractService
implements ImpexService {
    @Override
    public long createExportArchive(String sid, String name, String description) throws WebserviceException, PersistenceException {
        this.checkAdministrator(sid);
        User user = this.validateSession(sid);
        ArchiveDAO archiveDao = Context.get(ArchiveDAO.class);
        Archive arc = archiveDao.findByName(name, user.getTenantId());
        if (arc != null) {
            throw new PersistenceException("Archive named " + name + " already exists");
        }
        arc = new Archive();
        arc.setName(name);
        arc.setDescription(description);
        arc.setTenantId(user.getTenantId());
        arc.setCreatorId(user.getId());
        arc.setCreatorName(user.getFullName());
        arc.setType(0);
        arc.setStatus(0);
        arc.setMode(1);
        archiveDao.store(arc);
        return arc.getId();
    }

    @Override
    public void addDocumentToExportArchive(String sid, long archiveId, long docId) throws WebserviceException, PersistenceException {
        this.checkAdministrator(sid);
        ImpexServiceImpl service = new ImpexServiceImpl();
        try {
            service.addDocuments(SessionManager.get().get(sid), archiveId, List.of(Long.valueOf(docId)));
        }
        catch (ServerException e) {
            throw new WebserviceException(e.getMessage(), e);
        }
    }

    @Override
    public void closeExportArchive(String sid, long archiveId) throws WebserviceException, PersistenceException {
        this.checkAdministrator(sid);
        ImpexServiceImpl service = new ImpexServiceImpl();
        try {
            service.setStatus(SessionManager.get().get(sid), archiveId, 1);
        }
        catch (ServerException e) {
            throw new WebserviceException(e.getMessage(), e);
        }
    }

    @Override
    public void deleteExportArchive(String sid, long archiveId) throws WebserviceException, PersistenceException {
        this.checkAdministrator(sid);
        ImpexServiceImpl service = new ImpexServiceImpl();
        try {
            service.delete(SessionManager.get().get(sid), archiveId);
        }
        catch (ServerException e) {
            throw new WebserviceException(e.getMessage(), e);
        }
    }

    @Override
    public Long getArchiveIdByName(String sid, String name) throws WebserviceException, PersistenceException {
        this.checkAdministrator(sid);
        User user = this.validateSession(sid);
        ArchiveDAO archiveDao = Context.get(ArchiveDAO.class);
        Archive arc = archiveDao.findByName(name, user.getTenantId());
        if (arc != null) {
            return arc.getId();
        }
        return null;
    }
}

