/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.impex.application;

import com.logicaldoc.core.i18n.Language;
import com.logicaldoc.core.metadata.Attribute;
import com.logicaldoc.core.metadata.Template;
import com.logicaldoc.i18n.I18N;
import com.logicaldoc.impex.application.Database;
import com.logicaldoc.impex.application.Item;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;

public class Util {
    public static void openFile(File file) {
        String os = System.getProperty("os.name");
        String filePath = file.getPath();
        try {
            if (os.toLowerCase().contains("windows")) {
                String url = "file:///" + filePath.replace("\\\\", "/");
                Runtime.getRuntime().exec(new String[]{"rundll32", "url.dll,FileProtocolHandler " + url});
            } else if (os.toLowerCase().contains("mac os x")) {
                Runtime.getRuntime().exec(new String[]{"open", "-e " + filePath});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Item[] getAndOr() {
        return new Item[]{new Item("and", I18N.message("and", Locale.getDefault())), new Item("or", I18N.message("or", Locale.getDefault()))};
    }

    public static Item[] getAvailableFields(String selectedTemplate) {
        Template template;
        ArrayList<Item> items = new ArrayList<Item>(Arrays.asList(Util.getDocumentFields()));
        if (selectedTemplate != null && !selectedTemplate.isEmpty() && (template = Database.getInstance().getTemplates().get(selectedTemplate)) != null) {
            for (String name : template.getAttributeNames()) {
                Attribute attr;
                Item item = new Item(name + " type:" + (attr = template.getAttributes().get(name)).getType(), name + " (" + template.getName() + ")");
                if (items.contains(item)) continue;
                items.add(item);
            }
        }
        Item[] correctItems = new Item[items.size()];
        return items.toArray(correctItems);
    }

    public static Item[] getDocumentFields() {
        ArrayList<Item> items = new ArrayList<Item>();
        items.add(new Item("id", I18N.message("id", Locale.getDefault())));
        items.add(new Item("fileName", I18N.message("file", Locale.getDefault())));
        items.add(new Item("customId", I18N.message("customid", Locale.getDefault())));
        items.add(new Item("version", I18N.message("version", Locale.getDefault())));
        items.add(new Item("date", I18N.message("date", Locale.getDefault())));
        items.add(new Item("creation", I18N.message("createdon", Locale.getDefault())));
        items.add(new Item("fileSize", I18N.message("size", Locale.getDefault()) + " (byte)"));
        items.add(new Item("createdBy", I18N.message("creator", Locale.getDefault())));
        items.add(new Item("publishedBy", I18N.message("publisher", Locale.getDefault())));
        items.add(new Item("type", I18N.message("type", Locale.getDefault())));
        items.add(new Item("language", I18N.message("language", Locale.getDefault())));
        items.add(new Item("signed", I18N.message("sign", Locale.getDefault())));
        items.add(new Item("tgs", I18N.message("tags", Locale.getDefault())));
        return items.toArray(new Item[0]);
    }

    public static Item[] getOperators(int type) {
        if (type == 0) {
            return new Item[]{new Item("equals", I18N.message("equals", Locale.getDefault()).toLowerCase()), new Item("notequal", I18N.message("notequal", Locale.getDefault()).toLowerCase()), new Item("contains", I18N.message("contains", Locale.getDefault()).toLowerCase()), new Item("notcontains", I18N.message("notcontains", Locale.getDefault()).toLowerCase())};
        }
        if (type == 1 || type == 2) {
            return new Item[]{new Item("equals", I18N.message("equals", Locale.getDefault()).toLowerCase()), new Item("notequal", I18N.message("notequal", Locale.getDefault()).toLowerCase()), new Item("greaterthan", I18N.message("greaterthan", Locale.getDefault()).toLowerCase()), new Item("lessthan", I18N.message("lessthan", Locale.getDefault()).toLowerCase())};
        }
        if (type == 100) {
            return new Item[]{new Item("equals", I18N.message("equals", Locale.getDefault()).toLowerCase()), new Item("notequal", I18N.message("notequal", Locale.getDefault()).toLowerCase())};
        }
        if (type == 102 || type == 5 || type == 4 || type == 6 || type == 7) {
            return new Item[]{new Item("equals", I18N.message("equals", Locale.getDefault()).toLowerCase()), new Item("notequal", I18N.message("notequal", Locale.getDefault()).toLowerCase())};
        }
        if (type == 104) {
            return new Item[]{new Item("equals", I18N.message("equals", Locale.getDefault()).toLowerCase())};
        }
        if (type == 3) {
            return new Item[]{new Item("greaterthan", I18N.message("greaterthan", Locale.getDefault()).toLowerCase()), new Item("lessthan", I18N.message("lessthan", Locale.getDefault()).toLowerCase())};
        }
        return new Item[0];
    }

    public static Item[] getLanguages() {
        Collection<Language> coll = Database.getInstance().getLanguages().values();
        ArrayList<Item> items = new ArrayList<Item>();
        for (Language language : coll) {
            items.add(new Item(language.getLocale().toString(), language.getDisplayLanguage()));
        }
        Item[] correctItems = new Item[items.size()];
        return items.toArray(correctItems);
    }

    public static Item[] getTemplates() {
        ArrayList<Item> items = new ArrayList<Item>();
        items.add(new Item("", ""));
        if (Database.getInstance().getTemplates() != null && !Database.getInstance().getTemplates().isEmpty()) {
            Collection<Template> coll = Database.getInstance().getTemplates().values();
            for (Template template : coll) {
                items.add(new Item(template.getName(), template.getName()));
            }
        }
        Item[] correctItems = new Item[items.size()];
        return items.toArray(correctItems);
    }

    public static Item[] getYesNo() {
        return new Item[]{new Item("0", I18N.message("no", Locale.getDefault())), new Item("1", I18N.message("yes", Locale.getDefault()))};
    }

    private Util() {
    }
}

