/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.impex.application;

import com.logicaldoc.enterprise.search.Criterion;
import com.logicaldoc.i18n.I18N;
import com.logicaldoc.impex.application.ArchiveViewer;
import com.logicaldoc.impex.application.BrowsePanel;
import com.logicaldoc.impex.application.Database;
import com.logicaldoc.impex.application.Item;
import com.logicaldoc.impex.application.SearchLine;
import com.logicaldoc.impex.application.Util;
import com.logicaldoc.util.sql.SqlUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ItemListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.application.Application;

public class SearchPanel
extends JPanel {
    private static final String NOT = "(not ";
    private static final String EQUAL = ") = '";
    private static final String LOWER = "lower(";
    private static final long serialVersionUID = 1L;
    private transient Database database = Database.getInstance();
    private transient ArchiveViewer viewer;
    private static Map<String, Integer> typeBinding = new HashMap<String, Integer>();
    private JPanel linesPanel;
    private JScrollPane linesScrollPanel;
    private JTextField maxResultsField;
    private JComboBox<Item> templatesComboBox;
    private String searchErrors = "";
    private static List<Criterion> criteria = new ArrayList<Criterion>();
    private static SearchPanel instance;
    private static List<SearchLine> searchLines;

    static {
        searchLines = new ArrayList<SearchLine>();
        typeBinding.put("date", 3);
        typeBinding.put("creation", 3);
        typeBinding.put("fileSize", 1);
        typeBinding.put("id", 1);
        typeBinding.put("language", 100);
        typeBinding.put("template", 102);
        typeBinding.put("signed", 104);
    }

    public SearchPanel(ArchiveViewer viewer) {
        this.viewer = viewer;
        this.initGUI();
    }

    public static SearchPanel getInstance(ArchiveViewer viewer) {
        if (instance == null) {
            instance = new SearchPanel(viewer);
        } else {
            int selectedTemplateIndex = SearchPanel.instance.templatesComboBox.getSelectedIndex();
            instance.removeAll();
            instance.initGUI();
            SearchPanel.instance.templatesComboBox.setSelectedIndex(selectedTemplateIndex);
            int i = 0;
            for (Criterion criterion : instance.getCriteria()) {
                if (criterion.getType() == 102) continue;
                SearchLine line = new SearchLine(instance, criterion);
                instance.getLinesPanel().add((Component)line, new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
                ++i;
            }
            instance.validate();
        }
        return instance;
    }

    public static void clean() {
        instance = null;
        criteria.clear();
        searchLines.clear();
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.setPreferredSize(new Dimension(400, 300));
            this.setLayout(thisLayout);
            JPanel searchJPanel = new JPanel();
            GridBagLayout searchPanelLayout = new GridBagLayout();
            searchPanelLayout.columnWidths = new int[]{51, 87, 76, 10, 2, 15};
            searchPanelLayout.rowHeights = new int[]{31};
            searchPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1, 0.1, 0.1};
            searchPanelLayout.rowWeights = new double[]{0.0};
            this.add((Component)searchJPanel, "North");
            searchJPanel.setLayout(searchPanelLayout);
            JButton addButton = new JButton();
            searchJPanel.add((Component)addButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            addButton.setText(I18N.message("add", Locale.getDefault()));
            addButton.addActionListener(evt -> this.addButtonActionPerformed());
            JLabel maxResultsLabel = new JLabel();
            searchJPanel.add((Component)maxResultsLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            maxResultsLabel.setText(I18N.message("maxresults", Locale.getDefault()) + ":");
            this.maxResultsField = new JTextField();
            searchJPanel.add((Component)this.maxResultsField, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 9, 0, 0), 0, 0));
            this.maxResultsField.setText(Integer.toString(this.database.getMaxResults()));
            JButton searchButton = new JButton();
            searchJPanel.add((Component)searchButton, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            searchButton.setText(I18N.message("search", Locale.getDefault()));
            searchButton.addActionListener(evt -> this.searchButtonActionPerformed());
            JLabel templatesLabel = new JLabel();
            searchJPanel.add((Component)templatesLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            templatesLabel.setText(I18N.message("template", Locale.getDefault()) + ":");
            this.templatesComboBox = new JComboBox<Item>(Util.getTemplates());
            searchJPanel.add(this.templatesComboBox, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 9, 0, 0), 0, 0));
            this.templatesComboBox.setEnabled(true);
            this.templatesComboBox.setPreferredSize(new Dimension(120, 20));
            this.templatesComboBox.addItemListener(evt -> {
                if (evt.getStateChange() == 1) {
                    this.onTemplateSelection();
                    this.updateFieldsList(true);
                } else {
                    evt.getStateChange();
                }
            });
            this.linesScrollPanel = new JScrollPane();
            this.add((Component)this.linesScrollPanel, "Center");
            this.linesScrollPanel.setAutoscrolls(true);
            this.linesScrollPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.linesScrollPanel.setPreferredSize(new Dimension(390, 350));
            this.linesPanel = new JPanel();
            this.linesScrollPanel.setViewportView(this.linesPanel);
            this.linesPanel.setBounds(0, searchLines.size(), 390, searchLines.size() * 25);
            this.linesPanel.setPreferredSize(new Dimension(390, searchLines.size() * 25));
            Application.getInstance().getContext().getResourceMap(this.getClass()).injectComponents((Component)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<Criterion> getCriteria() {
        return criteria;
    }

    private void searchButtonActionPerformed() {
        StringBuilder query = new StringBuilder();
        this.appendTemplateCriterion(criteria);
        this.prepareJoinsForExtendedAttributes(query, criteria);
        query.append(" where A.ld_deleted=0 ");
        this.appendAllCriteria(query, criteria);
        if (!this.searchErrors.isEmpty()) {
            JFrame queryMessageFrame = new JFrame(I18N.message("warning", Locale.getDefault()));
            queryMessageFrame.setDefaultCloseOperation(1);
            queryMessageFrame.setSize(350, 150);
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension screenSize = toolkit.getScreenSize();
            int x = (screenSize.width - queryMessageFrame.getWidth()) / 2;
            int y = (screenSize.height - queryMessageFrame.getHeight()) / 2;
            queryMessageFrame.setLocation(x, y);
            TextArea textArea = new TextArea();
            textArea.append(this.searchErrors);
            textArea.setBackground(new Color(236, 233, 216));
            textArea.setEditable(false);
            queryMessageFrame.add(textArea);
            textArea.setName("textArea");
            queryMessageFrame.setAlwaysOnTop(true);
            queryMessageFrame.setVisible(true);
            this.searchErrors = "";
        } else {
            this.setMaxResults();
            this.database.search(query.toString());
            this.viewer.showContentPanel(new BrowsePanel(this.viewer));
        }
    }

    private void appendAllCriteria(StringBuilder query, List<Criterion> criteria) {
        boolean first = true;
        int counter = 0;
        for (Criterion criterion : criteria) {
            if (!criterion.isExtendedAttribute() && !this.checkCriterion(criterion)) continue;
            this.appendComposition(query, criterion, first);
            first = false;
            query.append("(");
            Object columnName = "";
            columnName = criterion.isExtendedAttribute() ? this.appendExtendedAttributeJoin(query, criterion, ++counter) : "A." + this.getColumnName(criterion);
            this.appendCriterionValue(query, criterion, (String)columnName);
            if (criterion.isExtendedAttribute()) {
                query.append(")");
            }
            query.append(")");
        }
        if (!first) {
            query.append(")");
        }
    }

    private String appendExtendedAttributeJoin(StringBuilder query, Criterion criterion, int counter) {
        query.append("(C" + counter + ".ld_versionid=A.ld_id");
        query.append(" and C" + counter + ".ld_name='");
        query.append(criterion.getFieldName());
        query.append("' and ");
        String columnName = "C" + counter + ".";
        switch (criterion.getType()) {
            case 0: {
                columnName = columnName + "ld_stringvalue";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                columnName = columnName + "ld_intvalue";
                break;
            }
            case 2: {
                columnName = columnName + "ld_doublevalue";
                break;
            }
            case 3: {
                columnName = columnName + "ld_datevalue";
                break;
            }
        }
        return columnName;
    }

    private void appendComposition(StringBuilder query, Criterion criterion, boolean first) {
        if (first) {
            query.append(" and ( ");
        } else {
            query.append(" " + criterion.getComposition());
        }
    }

    private void appendTemplateCriterion(List<Criterion> criteria) {
        if (this.getSelectedTemplate() != null && !this.getSelectedTemplate().isEmpty()) {
            Criterion templateCriterion = new Criterion();
            templateCriterion.setType(102);
            templateCriterion.setOperator("equals");
            templateCriterion.setStringValue(this.getSelectedTemplate());
            criteria.add(templateCriterion);
        }
    }

    private void setMaxResults() {
        try {
            this.database.setMaxResults(Integer.parseInt(this.maxResultsField.getText()));
        }
        catch (NumberFormatException e) {
            this.database.setMaxResults(1000);
        }
    }

    private void appendCriterionValue(StringBuilder query, Criterion criterion, String columnName) {
        switch (criterion.getType()) {
            case 0: {
                this.appendCriterionStringValue(query, criterion, columnName);
                break;
            }
            case 1: {
                this.appendCriterionIntValue(query, criterion, columnName);
                break;
            }
            case 5: {
                this.appendCriterionBooleanValue(query, criterion, columnName);
                break;
            }
            case 4: {
                this.appendCriterionBooleanValue(query, criterion, columnName);
                break;
            }
            case 2: {
                this.appendCriterionDoubleValue(query, criterion, columnName);
                break;
            }
            case 3: {
                this.appendCriterionDateValue(query, criterion, columnName);
                break;
            }
            case 102: {
                this.appendCriterionTemplateValue(query, criterion, columnName);
                break;
            }
            case 100: {
                this.appendCriterionLanguageValue(query, criterion, columnName);
                break;
            }
            case 104: {
                this.appendCriterionSignedValue(query, criterion, columnName);
                break;
            }
        }
    }

    private void appendCriterionSignedValue(StringBuilder query, Criterion criterion, String columnName) {
        if ("equals".equals(criterion.getOperator())) {
            query.append("(" + columnName + ") = " + String.valueOf(criterion.getLongValue()));
        }
    }

    private void appendCriterionLanguageValue(StringBuilder query, Criterion criterion, String columnName) {
        String val2 = criterion.getStringValue();
        if ("equals".equals(criterion.getOperator())) {
            query.append(columnName + " = '" + val2 + "'");
        } else if ("notequal".equals(criterion.getOperator())) {
            query.append(NOT + columnName + " = '" + val2 + "')");
        }
    }

    private void appendCriterionTemplateValue(StringBuilder query, Criterion criterion, String columnName) {
        if ("equals".equals(criterion.getOperator())) {
            query.append(LOWER + columnName + EQUAL + criterion.getStringValue().toLowerCase() + "'");
        } else if ("notequal".equals(criterion.getOperator())) {
            query.append("(not lower(" + columnName + EQUAL + criterion.getStringValue().toLowerCase() + "')");
        }
    }

    private void appendCriterionDateValue(StringBuilder query, Criterion criterion, String columnName) {
        String val1 = SqlUtil.doubleQuotes(criterion.getStringValue());
        if ("greaterthan".equals(criterion.getOperator())) {
            query.append(columnName + " > '" + val1 + "'");
        } else if ("lessthan".equals(criterion.getOperator())) {
            query.append(columnName + " < '" + val1 + "'");
        }
    }

    private void appendCriterionDoubleValue(StringBuilder query, Criterion criterion, String columnName) {
        if ("equals".equals(criterion.getOperator())) {
            query.append(columnName + " = " + String.valueOf(criterion.getDoubleValue()));
        } else if ("notequal".equals(criterion.getOperator())) {
            query.append(NOT + columnName + " = " + String.valueOf(criterion.getDoubleValue()) + ")");
        } else if ("greaterthan".equals(criterion.getOperator())) {
            query.append(columnName + " > " + String.valueOf(criterion.getDoubleValue()));
        } else if ("lessthan".equals(criterion.getOperator())) {
            query.append(columnName + " < " + String.valueOf(criterion.getDoubleValue()));
        }
    }

    private void appendCriterionBooleanValue(StringBuilder query, Criterion criterion, String columnName) {
        if ("equals".equals(criterion.getOperator())) {
            query.append(columnName + " = " + String.valueOf(criterion.getLongValue()));
        } else if ("notequal".equals(criterion.getOperator())) {
            query.append(NOT + columnName + " = " + String.valueOf(criterion.getLongValue()) + ")");
        }
    }

    private void appendCriterionIntValue(StringBuilder query, Criterion criterion, String columnName) {
        if ("equals".equals(criterion.getOperator())) {
            query.append(columnName + " = " + String.valueOf(criterion.getLongValue()));
        } else if ("notequal".equals(criterion.getOperator())) {
            query.append(NOT + columnName + " = " + String.valueOf(criterion.getLongValue()) + ")");
        } else if ("greaterthan".equals(criterion.getOperator())) {
            query.append(columnName + " > " + String.valueOf(criterion.getLongValue()));
        } else if ("lessthan".equals(criterion.getOperator())) {
            query.append(columnName + " < " + String.valueOf(criterion.getLongValue()));
        }
    }

    private void appendCriterionStringValue(StringBuilder query, Criterion criterion, String columnName) {
        String val = SqlUtil.doubleQuotes(criterion.getStringValue().toLowerCase());
        if ("equals".equals(criterion.getOperator())) {
            query.append(LOWER + columnName + EQUAL + val + "'");
        } else if ("notequal".equals(criterion.getOperator())) {
            query.append("(not lower(" + columnName + EQUAL + val + "')");
        } else if ("contains".equals(criterion.getOperator())) {
            query.append(LOWER + columnName + ") like '%" + val + "%'");
        } else if ("notcontains".equals(criterion.getOperator())) {
            query.append("not (lower(" + columnName + ") like '%" + val + "%')");
        }
    }

    private void prepareJoinsForExtendedAttributes(StringBuilder query, List<Criterion> criteria) {
        int counter = 0;
        for (Criterion criterion : criteria) {
            if (!criterion.isExtendedAttribute() || !this.checkCriterion(criterion)) continue;
            query.append(", ld_version_ext C" + ++counter);
        }
    }

    public boolean checkCriterion(Criterion criterion) {
        StringBuilder sb = new StringBuilder();
        boolean criterionValid = true;
        if (criterion.getField().equals("id") && criterion.getType() == 0) {
            return false;
        }
        if (criterion.getStringValue() == null) {
            return false;
        }
        if (criterion.getType() == 104) {
            criterion.setLongValue(Long.valueOf(Long.parseLong(criterion.getStringValue())));
        } else if (criterion.getType() == 1) {
            criterionValid = this.checkCriterionInt(criterion, sb, criterionValid);
        } else if (criterion.getType() == 2) {
            criterionValid = this.checkCriterionDouble(criterion, sb, criterionValid);
        } else if (criterion.getType() == 3) {
            criterionValid = this.checkCriterionDate(criterion, sb, criterionValid);
        }
        if (!criterionValid) {
            this.searchErrors = String.valueOf(this.searchErrors) + sb.toString();
        }
        return !this.isValidationNotRequired(criterion);
    }

    private boolean isValidationNotRequired(Criterion criterion) {
        return criterion.getType() == 0 && StringUtils.isEmpty(criterion.getStringValue().trim()) || criterion.getType() == 102 && criterion.getStringValue() == null || criterion.getType() == 100 && criterion.getStringValue() == null || criterion.getType() == 104 && criterion.getLongValue() == null;
    }

    private boolean checkCriterionDate(Criterion criterion, StringBuilder sb, boolean criterionValid) {
        String val1 = SqlUtil.doubleQuotes(criterion.getStringValue());
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            sf.parse(val1);
        }
        catch (Exception ex1) {
            criterionValid = false;
            sb.append(I18N.message("errordate", Locale.getDefault(), this.getLabelFromArray(Util.getAvailableFields(this.getSelectedTemplate()), criterion.getField())));
            sb.append("\n");
        }
        return criterionValid;
    }

    private boolean checkCriterionDouble(Criterion criterion, StringBuilder sb, boolean criterionValid) {
        try {
            criterion.setDoubleValue(Double.valueOf(Double.parseDouble(criterion.getStringValue())));
        }
        catch (Exception ex1) {
            criterionValid = false;
            sb.append(I18N.message("errordouble", Locale.getDefault(), this.getLabelFromArray(Util.getAvailableFields(this.getSelectedTemplate()), criterion.getField())));
            sb.append("\n");
        }
        return criterionValid;
    }

    private boolean checkCriterionInt(Criterion criterion, StringBuilder sb, boolean criterionValid) {
        try {
            criterion.setLongValue(Long.valueOf(Long.parseLong(criterion.getStringValue())));
        }
        catch (Exception ex1) {
            criterionValid = false;
            sb.append(I18N.message("errorinteger", Locale.getDefault(), this.getLabelFromArray(Util.getAvailableFields(this.templatesComboBox.getSelectedItem().toString()), criterion.getField())));
            sb.append("\n");
        }
        return criterionValid;
    }

    public String getColumnName(Criterion criterion) {
        if (criterion.getType() == 102) {
            return "ld_templatename";
        }
        if (criterion.getType() == 3 && criterion.getFieldName().equalsIgnoreCase("creation")) {
            return "ld_creation";
        }
        if (criterion.getFieldName().equalsIgnoreCase("createdby")) {
            return "ld_creator";
        }
        if (criterion.getFieldName().equalsIgnoreCase("publishedby")) {
            return "ld_publisher";
        }
        return "ld_" + criterion.getFieldName().toLowerCase();
    }

    public String getSearchErrors() {
        return this.searchErrors;
    }

    private void addButtonActionPerformed() {
        criteria.add(new Criterion());
        this.cleanReload();
        this.linesPanel.validate();
        this.validate();
    }

    public void removeLine(SearchLine searchLine) {
        try {
            Criterion criterion = searchLine.getCriterion();
            criteria.remove(criterion);
            searchLines.remove(searchLine);
            Component[] componentArray = this.linesPanel.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component comp = componentArray[n2];
                if (comp instanceof SearchLine) {
                    this.linesPanel.remove(comp);
                }
                ++n2;
            }
            this.validate();
            this.cleanReload();
            this.linesPanel.validate();
            this.validate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void cleanReload() {
        ArrayList<SearchLine> newSearchLines = new ArrayList<SearchLine>();
        int selectedTemplateIndex = this.templatesComboBox.getSelectedIndex();
        this.removeAll();
        this.initGUI();
        this.templatesComboBox.setSelectedIndex(selectedTemplateIndex);
        if (!criteria.isEmpty()) {
            int i = 0;
            for (Criterion crit : criteria) {
                if (crit.getType() == 102) continue;
                SearchLine line = new SearchLine(this, crit);
                GridBagConstraints c = new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 5), 0, 0);
                this.linesPanel.add((Component)line, c);
                ++i;
                newSearchLines.add(line);
            }
            searchLines.clear();
            searchLines.addAll(newSearchLines);
        }
    }

    public String getLabelFromArray(Item[] items, String value) {
        String label = null;
        int i = 0;
        while (i < items.length) {
            if (value.equals(items[i].getValue())) {
                label = items[i].getLabel();
                break;
            }
            ++i;
        }
        return label;
    }

    public void updateFieldsList(boolean updateOperatorsAndValues) {
        try {
            Item[] fieldsItem = Util.getAvailableFields(this.getSelectedTemplate());
            Component[] componentArray = this.linesPanel.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component comp = componentArray[n2];
                if (comp instanceof SearchLine) {
                    SearchLine line = (SearchLine)comp;
                    Criterion criterion = line.getCriterion();
                    JComboBox<Item> lineFieldComboBox = line.getFieldComboBox();
                    int fieldComboBoxIndex = lineFieldComboBox.getSelectedIndex();
                    lineFieldComboBox.removeAllItems();
                    ItemListener fieldItemListener = lineFieldComboBox.getItemListeners()[0];
                    lineFieldComboBox.removeItemListener(fieldItemListener);
                    int i = 0;
                    while (i < fieldsItem.length) {
                        lineFieldComboBox.addItem(fieldsItem[i]);
                        ++i;
                    }
                    lineFieldComboBox.setSelectedIndex(fieldComboBoxIndex);
                    lineFieldComboBox.addItemListener(fieldItemListener);
                    lineFieldComboBox.validate();
                    if (updateOperatorsAndValues) {
                        Item[] operatorsItem = Util.getOperators(criterion.getType());
                        JComboBox<Item> operatorComboBox = line.getOperatorComboBox();
                        int index = operatorComboBox.getSelectedIndex();
                        operatorComboBox.removeAllItems();
                        ItemListener operatorItemListener = operatorComboBox.getItemListeners()[0];
                        operatorComboBox.removeItemListener(operatorItemListener);
                        int i2 = 0;
                        while (i2 < operatorsItem.length) {
                            operatorComboBox.addItem(operatorsItem[i2]);
                            ++i2;
                        }
                        criterion.setOperator(((Item)operatorComboBox.getSelectedItem()).getValue().toString());
                        operatorComboBox.setSelectedIndex(index);
                        operatorComboBox.addItemListener(operatorItemListener);
                        operatorComboBox.validate();
                        line.updateSearchOption();
                    }
                    line.validate();
                }
                ++n2;
            }
            this.linesPanel.validate();
            this.linesScrollPanel.validate();
            this.validate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateOperatorsList() {
        Component[] componentArray = this.linesPanel.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            if (comp instanceof SearchLine) {
                SearchLine line = (SearchLine)comp;
                Criterion criterion = line.getCriterion();
                Item[] operatorsItem = Util.getOperators(criterion.getType());
                JComboBox<Item> operatorComboBox = line.getOperatorComboBox();
                int operatorComboBoxIndex = operatorComboBox.getSelectedIndex();
                operatorComboBox.removeAllItems();
                ItemListener operatorItemListener = operatorComboBox.getItemListeners()[0];
                operatorComboBox.removeItemListener(operatorItemListener);
                int i = 0;
                while (i < operatorsItem.length) {
                    operatorComboBox.addItem(operatorsItem[i]);
                    ++i;
                }
                operatorComboBox.setSelectedIndex(operatorComboBoxIndex);
                criterion.setOperator(((Item)operatorComboBox.getSelectedItem()).getValue().toString());
                operatorComboBox.addItemListener(operatorItemListener);
                operatorComboBox.validate();
                line.validate();
            }
            this.updateFieldsList(false);
            ++n2;
        }
        this.linesPanel.validate();
        this.linesScrollPanel.validate();
        this.validate();
    }

    public static List<SearchLine> getSearchLines() {
        return searchLines;
    }

    public JPanel getLinesPanel() {
        return this.linesPanel;
    }

    public String getSelectedTemplate() {
        if (this.templatesComboBox.getSelectedItem() != null) {
            return this.templatesComboBox.getSelectedItem().toString();
        }
        return null;
    }

    private void onTemplateSelection() {
        Component[] componentArray = this.linesPanel.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            SearchLine line;
            Criterion criterion;
            Component comp = componentArray[n2];
            if (comp instanceof SearchLine && (criterion = (line = (SearchLine)comp).getCriterion()).isExtendedAttribute()) {
                this.removeLine(line);
            }
            ++n2;
        }
    }
}

