/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.impex.application;

import com.logicaldoc.enterprise.search.Criterion;
import com.logicaldoc.i18n.I18N;
import com.logicaldoc.impex.application.Item;
import com.logicaldoc.impex.application.SearchPanel;
import com.logicaldoc.impex.application.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.application.Application;

public class SearchLine
extends JPanel {
    public static final int LINE_HEIGHT = 25;
    private static final long serialVersionUID = 1L;
    private JComboBox<Item> compositionComboBox;
    private JComboBox<Item> fieldComboBox;
    private JComboBox<Item> operatorComboBox;
    private JComboBox<Item> valueComboBox;
    private JTextField valueTextField;
    private int type = 1;
    private String field = "id";
    private static Map<String, Integer> typeBinding = new HashMap<String, Integer>();
    private Criterion criterion = null;
    private SearchPanel searchPanel;

    static {
        typeBinding.put("date", 3);
        typeBinding.put("creation", 3);
        typeBinding.put("fileSize", 1);
        typeBinding.put("id", 1);
        typeBinding.put("language", 100);
        typeBinding.put("template", 102);
        typeBinding.put("signed", 104);
    }

    public SearchLine(SearchPanel searchPanel, Criterion criterion) {
        this.searchPanel = searchPanel;
        this.prepareCriterion(criterion);
        this.initGUI();
        this.initComposition(criterion);
        this.prepareFieldItem(searchPanel, criterion);
        this.prepareOperatorItem(criterion);
        this.prepareValueItem(criterion);
        this.validate();
    }

    private void prepareValueItem(Criterion criterion) {
        if (criterion.getType() == 102) {
            this.prepareTemplateValueItem(criterion);
        } else if (criterion.getType() == 100) {
            this.prepareLanguageValueItem(criterion);
        } else if (criterion.getType() == 104) {
            this.prepareSignedValueItem(criterion);
        } else {
            this.valueTextField.setText(criterion.getStringValue());
        }
    }

    private void prepareSignedValueItem(Criterion criterion) {
        if ("0".equals(criterion.getStringValue())) {
            this.valueComboBox.setSelectedIndex(0);
        } else {
            this.valueComboBox.setSelectedIndex(1);
        }
    }

    private void prepareLanguageValueItem(Criterion criterion) {
        Item[] languageItems = Util.getLanguages();
        int i = 0;
        while (i < languageItems.length) {
            if (languageItems[i].getValue().toString().equals(criterion.getStringValue())) {
                this.valueComboBox.setSelectedIndex(i);
                break;
            }
            ++i;
        }
    }

    private void prepareTemplateValueItem(Criterion criterion) {
        Item[] templateItems = Util.getTemplates();
        int i = 0;
        while (i < templateItems.length) {
            if (templateItems[i].getLabel().equals(criterion.getStringValue())) {
                this.valueComboBox.setSelectedIndex(i);
                break;
            }
            ++i;
        }
    }

    private void prepareCriterion(Criterion criterion) {
        this.criterion = criterion;
        if (this.criterion.getField() == null) {
            this.criterion.setField(this.field);
            this.criterion.setType(this.type);
            this.criterion.setStringValue("");
        } else {
            this.type = criterion.getType();
        }
    }

    private void prepareOperatorItem(Criterion criterion) {
        Item[] operatorItems = Util.getOperators(criterion.getType());
        int i = 0;
        while (i < operatorItems.length) {
            if (operatorItems[i].getValue().toString().equals(criterion.getOperator())) {
                this.operatorComboBox.setSelectedIndex(i);
                break;
            }
            ++i;
        }
    }

    private void prepareFieldItem(SearchPanel searchPanel, Criterion criterion) {
        Item[] fieldItems = Util.getAvailableFields(searchPanel.getSelectedTemplate());
        int i = 0;
        while (i < fieldItems.length) {
            if (fieldItems[i].getValue().toString().equals(criterion.getField())) {
                this.fieldComboBox.setSelectedIndex(i);
                break;
            }
            ++i;
        }
    }

    private void initComposition(Criterion criterion) {
        if ("and".equals(criterion.getComposition())) {
            this.compositionComboBox.setSelectedIndex(0);
        } else {
            this.compositionComboBox.setSelectedIndex(1);
        }
    }

    public SearchLine(SearchPanel searchPanel) {
        this(searchPanel, new Criterion());
    }

    private void initGUI() {
        try {
            GridBagLayout thisLayout = new GridBagLayout();
            this.setPreferredSize(new Dimension(750, 25));
            thisLayout.rowWeights = new double[]{0.1};
            thisLayout.rowHeights = new int[]{25};
            thisLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1, 0.1};
            thisLayout.columnWidths = new int[]{50, 200, 100, 150, 100};
            this.setLayout(thisLayout);
            this.prepareCompositionComboBox();
            this.prepareFieldComboBox();
            this.prepareOperatorComboBox();
            this.prepareValueComboBox();
            JButton deleteButton = new JButton();
            this.add((Component)deleteButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            deleteButton.setText(I18N.message("ddelete", Locale.getDefault()));
            deleteButton.addActionListener(evt -> this.deleteButtonActionPerformed());
            Application.getInstance().getContext().getResourceMap(this.getClass()).injectComponents((Component)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void prepareValueComboBox() {
        this.valueComboBox = null;
        if (this.criterion.getType() == 100) {
            this.valueComboBox = new JComboBox<Item>(Util.getLanguages());
        } else if (this.criterion.getType() == 102) {
            this.valueComboBox = new JComboBox<Item>(Util.getTemplates());
        } else if (this.criterion.getType() == 104) {
            this.valueComboBox = new JComboBox<Item>(Util.getYesNo());
        }
        if (this.valueComboBox != null) {
            this.add(this.valueComboBox, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.valueComboBox.setPreferredSize(new Dimension(150, 20));
            this.valueComboBox.addItemListener(evt -> {
                if (evt.getStateChange() == 1) {
                    if (this.criterion.getType() == 102) {
                        this.criterion.setStringValue(this.valueComboBox.getSelectedItem().toString());
                    } else {
                        this.criterion.setStringValue(((Item)this.valueComboBox.getSelectedItem()).getValue().toString());
                    }
                } else {
                    evt.getStateChange();
                }
            });
        } else {
            this.valueTextField = new JTextField();
            this.add((Component)this.valueTextField, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.valueTextField.setPreferredSize(new Dimension(150, 20));
            this.valueTextField.setSize(150, 20);
            this.valueTextField.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    SearchLine.this.criterion.setStringValue(SearchLine.this.valueTextField.getText());
                }

                @Override
                public void keyTyped(KeyEvent e) {
                }
            });
        }
    }

    private void prepareOperatorComboBox() {
        this.operatorComboBox = new JComboBox<Item>(Util.getOperators(this.type));
        this.add(this.operatorComboBox, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.operatorComboBox.setEnabled(true);
        this.operatorComboBox.setPreferredSize(new Dimension(100, 20));
        this.operatorComboBox.addItemListener(evt -> {
            if (evt.getStateChange() == 1) {
                this.searchPanel.updateOperatorsList();
            } else {
                evt.getStateChange();
            }
        });
    }

    private void prepareFieldComboBox() {
        this.fieldComboBox = new JComboBox<Item>(Util.getAvailableFields(this.searchPanel.getSelectedTemplate()));
        this.add(this.fieldComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.fieldComboBox.setEnabled(true);
        this.fieldComboBox.setPreferredSize(new Dimension(200, 20));
        this.fieldComboBox.addItemListener(evt -> {
            if (evt.getStateChange() == 1) {
                String oldField = this.criterion.getField();
                this.criterion.setField(((Item)this.fieldComboBox.getSelectedItem()).getValue().toString());
                this.checkType(this.criterion);
                if (this.criterion.getType() == 102 && !oldField.equals(this.criterion.getField())) {
                    this.criterion.setStringValue(Util.getTemplates()[0].getLabel());
                } else if (this.criterion.getType() == 100 && !oldField.equals(this.criterion.getField())) {
                    this.criterion.setStringValue(Util.getLanguages()[0].getValue().toString());
                } else if (this.criterion.getType() == 104 && !oldField.equals(this.criterion.getField())) {
                    this.criterion.setStringValue(Util.getYesNo()[0].getValue().toString());
                } else if (!oldField.equals(this.criterion.getField())) {
                    this.criterion.setStringValue("");
                }
                this.searchPanel.updateFieldsList(true);
            } else {
                evt.getStateChange();
            }
        });
    }

    private void prepareCompositionComboBox() {
        this.compositionComboBox = new JComboBox<Item>(Util.getAndOr());
        this.add(this.compositionComboBox);
        this.compositionComboBox.setEnabled(true);
        this.compositionComboBox.setPreferredSize(new Dimension(50, 20));
        this.compositionComboBox.addItemListener(evt -> {
            if (evt.getStateChange() == 1) {
                this.criterion.setComposition(((Item)this.compositionComboBox.getSelectedItem()).getValue().toString());
            } else {
                evt.getStateChange();
            }
        });
    }

    public void checkType(Criterion criterion) {
        if (criterion.getField().equals("signed")) {
            criterion.setType(104);
        }
    }

    public void updateSearchOption() {
        if (this.valueTextField != null) {
            this.valueTextField.setText(null);
            this.valueTextField.removeAll();
            this.remove(this.valueTextField);
            this.valueTextField = null;
        }
        if (this.valueComboBox != null) {
            this.valueComboBox.setSelectedItem(null);
            this.valueComboBox.removeAll();
            this.remove(this.valueComboBox);
            this.valueComboBox = null;
        }
        this.validate();
        this.updateSearchOptionsComboBox();
        if (this.valueComboBox != null && this.valueComboBox.isEnabled()) {
            this.add(this.valueComboBox, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.valueComboBox.setPreferredSize(new Dimension(150, 20));
            this.valueComboBox.addItemListener(evt -> {
                if (evt.getStateChange() == 1) {
                    if (this.criterion.getType() == 102) {
                        this.criterion.setStringValue(this.valueComboBox.getSelectedItem().toString());
                        this.searchPanel.updateFieldsList(false);
                    } else {
                        this.criterion.setStringValue(((Item)this.valueComboBox.getSelectedItem()).getValue().toString());
                    }
                } else {
                    evt.getStateChange();
                }
            });
        } else if (this.valueTextField.isEnabled()) {
            this.add((Component)this.valueTextField, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.valueTextField.setPreferredSize(new Dimension(150, 20));
            this.valueTextField.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    SearchLine.this.criterion.setStringValue(SearchLine.this.valueTextField.getText());
                }

                @Override
                public void keyTyped(KeyEvent e) {
                }
            });
        }
        this.validate();
    }

    private void updateSearchOptionsComboBox() {
        Item[] templateItems = Util.getTemplates();
        Item[] languageItems = Util.getLanguages();
        if (this.criterion.getType() == 100) {
            this.updateSearchOptionComboBoxForLanguage(languageItems);
        } else if (this.criterion.getType() == 102) {
            this.updateSearchOptionComboBoxForTemplate(templateItems);
        } else if (this.criterion.getType() == 104) {
            this.updateSearchOptionComboBoxForSigned();
        } else {
            this.valueTextField = new JTextField();
            this.valueTextField.setText(this.criterion.getStringValue());
        }
    }

    private void updateSearchOptionComboBoxForSigned() {
        this.valueComboBox = new JComboBox<Item>(Util.getYesNo());
        if (this.criterion.getStringValue() != null) {
            if ("0".equals(this.criterion.getStringValue())) {
                this.valueComboBox.setSelectedIndex(0);
            } else {
                this.valueComboBox.setSelectedIndex(1);
            }
        } else {
            this.criterion.setStringValue(Util.getYesNo()[0].getValue().toString());
            this.valueComboBox.setSelectedIndex(0);
        }
    }

    private void updateSearchOptionComboBoxForTemplate(Item[] templateItems) {
        this.valueComboBox = new JComboBox<Item>(Util.getTemplates());
        if (this.criterion.getStringValue() != null) {
            int i = 0;
            while (i < templateItems.length) {
                if (templateItems[i].getLabel().equals(this.criterion.getStringValue())) {
                    this.valueComboBox.setSelectedIndex(i);
                    break;
                }
                ++i;
            }
        } else {
            this.criterion.setStringValue(Util.getTemplates()[0].getLabel());
            this.valueComboBox.setSelectedIndex(0);
        }
    }

    private void updateSearchOptionComboBoxForLanguage(Item[] languageItems) {
        this.valueComboBox = new JComboBox<Item>(Util.getLanguages());
        if (this.criterion.getStringValue() != null) {
            int i = 0;
            while (i < languageItems.length) {
                if (languageItems[i].getValue().toString().equals(this.criterion.getStringValue())) {
                    this.valueComboBox.setSelectedIndex(i);
                    break;
                }
                ++i;
            }
        } else {
            this.criterion.setStringValue(Util.getLanguages()[0].getValue().toString());
            this.valueComboBox.setSelectedIndex(0);
        }
    }

    private void deleteButtonActionPerformed() {
        this.searchPanel.removeLine(this);
    }

    public Criterion getCriterion() {
        return this.criterion;
    }

    public JComboBox<Item> getFieldComboBox() {
        return this.fieldComboBox;
    }

    public void setFieldComboBox(JComboBox<Item> fieldComboBox) {
        this.fieldComboBox = fieldComboBox;
    }

    public JComboBox<Item> getCompositionComboBox() {
        return this.compositionComboBox;
    }

    public JComboBox<Item> getOperatorComboBox() {
        return this.operatorComboBox;
    }

    public JComboBox<Item> getValueComboBox() {
        return this.valueComboBox;
    }

    public JTextField getValueTextField() {
        return this.valueTextField;
    }

    public void setCompositionComboBox(JComboBox<Item> compositionComboBox) {
        this.compositionComboBox = compositionComboBox;
    }

    public void setOperatorComboBox(JComboBox<Item> operatorComboBox) {
        this.operatorComboBox = operatorComboBox;
    }

    public void setValueComboBox(JComboBox<Item> valueComboBox) {
        this.valueComboBox = valueComboBox;
    }

    public void setValueTextField(JTextField valueTextField) {
        this.valueTextField = valueTextField;
    }
}

