/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.impex.application;

import com.logicaldoc.i18n.I18N;
import com.logicaldoc.impex.IndexVersion;
import com.logicaldoc.util.io.FileUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.lang.StringUtils;

public class DocumentTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private String[] columnNames = new String[]{I18N.message("id", Locale.getDefault()), I18N.message("customid", Locale.getDefault()), I18N.message("template", Locale.getDefault()), I18N.message("version", Locale.getDefault()), I18N.message("filename", Locale.getDefault()), I18N.message("createdon", Locale.getDefault()), I18N.message("size", Locale.getDefault()), " "};
    private List<IndexVersion> documents = new ArrayList<IndexVersion>();
    private DateFormat df = new SimpleDateFormat("yyyy-MM-dd");

    public DocumentTableModel(List<IndexVersion> documents) {
        this.documents = documents;
    }

    public List<IndexVersion> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<IndexVersion> documents) {
        this.documents = documents;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.documents.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.documents.get(rowIndex).getId();
            }
            case 1: {
                return StringUtils.isNotEmpty(this.documents.get(rowIndex).getCustomId()) ? this.documents.get(rowIndex).getCustomId() : "-";
            }
            case 2: {
                return StringUtils.isNotEmpty(this.documents.get(rowIndex).getTemplateName()) ? this.documents.get(rowIndex).getTemplateName() : " ";
            }
            case 3: {
                return this.documents.get(rowIndex).getVersion();
            }
            case 4: {
                return this.documents.get(rowIndex).getFileName();
            }
            case 5: {
                return this.df.format(this.documents.get(rowIndex).getCreation());
            }
            case 6: {
                return FileUtil.getDisplaySize(this.documents.get(rowIndex).getFileSize(), "en");
            }
            case 7: {
                return I18N.message("openfile", Locale.getDefault());
            }
            case -1: {
                return this.documents.get(rowIndex);
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }
}

