/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.impex.application;

import com.logicaldoc.core.document.Version;
import com.logicaldoc.i18n.I18N;
import com.logicaldoc.impex.IndexVersion;
import com.logicaldoc.impex.application.ArchiveViewer;
import com.logicaldoc.util.io.FileUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.application.Application;

public class DocInfoPanel
extends JPanel {
    private static final String TAHOMA = "Tahoma";
    private static final long serialVersionUID = 1L;
    private JLabel docInfoTitle;
    private JTable customAttributeTable;
    private JLabel templateValue;
    private JLabel pathInfoValue;
    private JLabel digestValue;
    private JLabel folderValue;
    private JLabel signedValue;
    private JLabel sizeValue;
    private JLabel filenameValue;
    private JLabel langValue;
    private JLabel typeValue;
    private JLabel publisherValue;
    private JLabel creatorValue;
    private JLabel creationDateValue;
    private JLabel dateValue;
    private JLabel versionValue;
    private JLabel tagsValue;
    private JLabel customIdValue;
    private JLabel idValue;
    private IndexVersion document;

    public DocInfoPanel() {
        this(new IndexVersion());
    }

    public DocInfoPanel(IndexVersion doc) {
        String tgs;
        this.document = doc;
        this.initGUI();
        this.customAttributeTable.setModel(new MyTableModel(doc));
        this.docInfoTitle.setText(I18N.message("docinfotitle", Locale.getDefault(), new Object[]{this.document.getCustomId()}));
        this.pathInfoValue.setText(this.document.getDiskPath());
        this.idValue.setText(Long.toString(this.document.getDocId()));
        this.customIdValue.setText(this.document.getCustomId());
        this.versionValue.setText(this.document.getVersion());
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        this.creationDateValue.setText(df.format(this.document.getCreation()));
        if (this.document.getDate() != null) {
            this.dateValue.setText(df.format(this.document.getDate()));
        }
        this.sizeValue.setText(FileUtil.getDisplaySize(this.document.getFileSize(), "en"));
        this.creatorValue.setText(this.document.getCreator());
        this.publisherValue.setText(this.document.getPublisher());
        this.filenameValue.setText(this.document.getFileName());
        this.typeValue.setText(this.document.getType());
        this.langValue.setText(this.document.getLanguage());
        this.signedValue.setText(this.document.getSigned() == 0 ? I18N.message("no", Locale.getDefault()) : I18N.message("yes", Locale.getDefault()));
        this.folderValue.setText(this.document.getPath());
        this.digestValue.setText(this.document.getDigest());
        this.templateValue.setText(StringUtils.isNotEmpty(this.document.getTemplateName()) ? this.document.getTemplateName() : " ");
        String string = tgs = this.document.getTgs() != null ? this.document.getTgs() : "";
        if (tgs.startsWith(",")) {
            tgs = tgs.substring(1);
        }
        if (tgs.endsWith(",")) {
            tgs = tgs.substring(0, tgs.length() - 1);
        }
        this.tagsValue.setText(tgs);
    }

    private void initGUI() {
        try {
            this.setLayout(null);
            GridBagLayout thisLayout = new GridBagLayout();
            thisLayout.rowWeights = new double[]{0.0, 0.0, 0.1};
            thisLayout.rowHeights = new int[]{39, 40, 7};
            thisLayout.columnWeights = new double[]{0.1};
            thisLayout.columnWidths = new int[]{7};
            this.setLayout(thisLayout);
            this.setPreferredSize(new Dimension(600, 300));
            this.setSize(600, 300);
            this.docInfoTitle = new JLabel();
            this.add((Component)this.docInfoTitle, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.docInfoTitle.setName("docInfoTitle");
            JPanel pathInfoPanel = new JPanel();
            this.add((Component)pathInfoPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            GridBagLayout pathInfoPanelLayout = new GridBagLayout();
            pathInfoPanelLayout.columnWidths = new int[]{128, 273, 7};
            pathInfoPanelLayout.rowHeights = new int[]{7};
            pathInfoPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.1};
            pathInfoPanelLayout.rowWeights = new double[]{0.1};
            pathInfoPanel.setLayout(pathInfoPanelLayout);
            JLabel pathInfoLabel = new JLabel();
            pathInfoPanel.add((Component)pathInfoLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 0, 0), 0, 0));
            pathInfoLabel.setName("pathInfoLabel");
            pathInfoLabel.setText(I18N.message("path", Locale.getDefault()) + ": ");
            this.pathInfoValue = new JLabel();
            pathInfoPanel.add((Component)this.pathInfoValue, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.pathInfoValue.setName("pathInfoValue");
            JButton openFileButton = new JButton();
            pathInfoPanel.add((Component)openFileButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            openFileButton.setName("openFileButton");
            openFileButton.setText(I18N.message("openfile", Locale.getDefault()));
            openFileButton.addActionListener(evt -> this.openFileButtonActionPerformed());
            JTabbedPane tabPane = new JTabbedPane();
            this.add((Component)tabPane, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
            tabPane.setName("tabPane");
            tabPane.setOpaque(true);
            JPanel documentInfoPanel = new JPanel();
            tabPane.addTab(I18N.message("general", Locale.getDefault()), null, documentInfoPanel, null);
            GridBagLayout docInfoPanelLayout = new GridBagLayout();
            docInfoPanelLayout.columnWidths = new int[]{77, 7, 67, 7};
            docInfoPanelLayout.rowHeights = new int[]{7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
            docInfoPanelLayout.columnWeights = new double[]{0.0, 0.1, 0.0, 0.1};
            docInfoPanelLayout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1};
            documentInfoPanel.setLayout(docInfoPanelLayout);
            documentInfoPanel.setPreferredSize(new Dimension(580, 195));
            documentInfoPanel.setSize(580, 195);
            JLabel idLabel = new JLabel();
            documentInfoPanel.add((Component)idLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
            idLabel.setName("idLabel");
            idLabel.setText(I18N.message("id", Locale.getDefault()) + ":");
            JLabel customIdLabel = new JLabel();
            documentInfoPanel.add((Component)customIdLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
            customIdLabel.setName("customIdLabel");
            customIdLabel.setText(I18N.message("customid", Locale.getDefault()) + ":");
            JLabel filenameLabel = new JLabel();
            documentInfoPanel.add((Component)filenameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
            filenameLabel.setName("filenameLabel");
            filenameLabel.setText(I18N.message("filename", Locale.getDefault()) + ":");
            this.filenameValue = new JLabel();
            documentInfoPanel.add((Component)this.filenameValue, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 9, 5, 5), 0, 0));
            this.filenameValue.setFont(new Font(TAHOMA, 1, 11));
            JLabel versionLabel = new JLabel();
            documentInfoPanel.add((Component)versionLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
            versionLabel.setName("versionLabel");
            versionLabel.setText(I18N.message("version", Locale.getDefault()) + ":");
            JLabel dateLabel = new JLabel();
            documentInfoPanel.add((Component)dateLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
            dateLabel.setName("dateLabel");
            dateLabel.setText(I18N.message("date", Locale.getDefault()) + ":");
            JLabel creationDateLabel = new JLabel();
            documentInfoPanel.add((Component)creationDateLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
            creationDateLabel.setName("creationDateLabel");
            creationDateLabel.setText(I18N.message("createdon", Locale.getDefault()) + ":");
            JLabel sizeLabel = new JLabel();
            documentInfoPanel.add((Component)sizeLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
            sizeLabel.setName("sizeLabel");
            sizeLabel.setText(I18N.message("size", Locale.getDefault()) + ":");
            JLabel creatorLabel = new JLabel();
            documentInfoPanel.add((Component)creatorLabel, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
            creatorLabel.setName("creatorLabel");
            creatorLabel.setText(I18N.message("creator", Locale.getDefault()) + ":");
            JLabel publisherLabel = new JLabel();
            documentInfoPanel.add((Component)publisherLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
            publisherLabel.setName("publisherLabel");
            publisherLabel.setText(I18N.message("publisher", Locale.getDefault()) + ":");
            JLabel languageLabel = new JLabel();
            documentInfoPanel.add((Component)languageLabel, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
            languageLabel.setName("languageLabel");
            languageLabel.setText(I18N.message("language", Locale.getDefault()) + ":");
            this.langValue = new JLabel();
            documentInfoPanel.add((Component)this.langValue, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 9, 5, 0), 0, 0));
            this.langValue.setFont(new Font(TAHOMA, 1, 11));
            JLabel typeLabel = new JLabel();
            documentInfoPanel.add((Component)typeLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
            typeLabel.setName("typeLabel");
            typeLabel.setText(I18N.message("type", Locale.getDefault()) + ":");
            JLabel folderLabel = new JLabel();
            documentInfoPanel.add((Component)folderLabel, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
            folderLabel.setName("folderLabel");
            folderLabel.setText(I18N.message("folder", Locale.getDefault()) + ":");
            this.folderValue = new JLabel();
            documentInfoPanel.add((Component)this.folderValue, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 9, 5, 0), 0, 0));
            this.folderValue.setFont(new Font(TAHOMA, 1, 11));
            JLabel signedLabel = new JLabel();
            documentInfoPanel.add((Component)signedLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
            signedLabel.setName("signedLabel");
            signedLabel.setText(I18N.message("signed", Locale.getDefault()) + ":");
            JLabel tagsLabel = new JLabel();
            documentInfoPanel.add((Component)tagsLabel, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 9, 5, 5), 0, 0));
            tagsLabel.setName("tagsLabel");
            tagsLabel.setText(I18N.message("tags", Locale.getDefault()) + ":");
            this.tagsValue = new JLabel();
            documentInfoPanel.add((Component)this.tagsValue, new GridBagConstraints(3, 6, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 9, 5, 0), 0, 0));
            this.tagsValue.setFont(new Font(TAHOMA, 1, 11));
            JLabel digestLabel = new JLabel();
            documentInfoPanel.add((Component)digestLabel, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
            digestLabel.setName("digestLabel");
            digestLabel.setText(I18N.message("digest", Locale.getDefault()) + ":");
            this.idValue = new JLabel();
            documentInfoPanel.add((Component)this.idValue, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 9, 5, 5), 0, 0));
            this.idValue.setFont(new Font(TAHOMA, 1, 11));
            this.customIdValue = new JLabel();
            documentInfoPanel.add((Component)this.customIdValue, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 9, 5, 0), 0, 0));
            this.customIdValue.setFont(new Font(TAHOMA, 1, 11));
            this.versionValue = new JLabel();
            documentInfoPanel.add((Component)this.versionValue, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 9, 5, 0), 0, 0));
            this.versionValue.setFont(new Font(TAHOMA, 1, 11));
            this.dateValue = new JLabel();
            documentInfoPanel.add((Component)this.dateValue, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 9, 5, 5), 0, 0));
            this.dateValue.setFont(new Font(TAHOMA, 1, 11));
            this.creationDateValue = new JLabel();
            documentInfoPanel.add((Component)this.creationDateValue, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 9, 5, 0), 0, 0));
            this.creationDateValue.setFont(new Font(TAHOMA, 1, 11));
            this.sizeValue = new JLabel();
            documentInfoPanel.add((Component)this.sizeValue, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 9, 5, 5), 0, 0));
            this.sizeValue.setFont(new Font(TAHOMA, 1, 11));
            this.creatorValue = new JLabel();
            documentInfoPanel.add((Component)this.creatorValue, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 9, 5, 0), 0, 0));
            this.creatorValue.setFont(new Font(TAHOMA, 1, 11));
            this.publisherValue = new JLabel();
            documentInfoPanel.add((Component)this.publisherValue, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 9, 5, 5), 0, 0));
            this.publisherValue.setFont(new Font(TAHOMA, 1, 11));
            this.typeValue = new JLabel();
            documentInfoPanel.add((Component)this.typeValue, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 9, 5, 5), 0, 0));
            this.typeValue.setFont(new Font(TAHOMA, 1, 11));
            this.signedValue = new JLabel();
            documentInfoPanel.add((Component)this.signedValue, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 9, 5, 5), 0, 0));
            this.signedValue.setFont(new Font(TAHOMA, 1, 11));
            this.digestValue = new JLabel();
            documentInfoPanel.add((Component)this.digestValue, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 9, 5, 5), 0, 0));
            this.digestValue.setFont(new Font(TAHOMA, 1, 11));
            JPanel templatePanel = new JPanel();
            GridBagLayout templatePanelLayout = new GridBagLayout();
            templatePanelLayout.columnWidths = new int[]{7};
            templatePanelLayout.rowHeights = new int[]{49, 7};
            templatePanelLayout.columnWeights = new double[]{0.1};
            templatePanelLayout.rowWeights = new double[]{0.0, 0.1};
            tabPane.addTab(I18N.message("template", Locale.getDefault()), null, templatePanel, null);
            templatePanel.setLayout(templatePanelLayout);
            JPanel templateInfo = new JPanel();
            GridBagLayout templateInfoLayout = new GridBagLayout();
            templateInfoLayout.columnWidths = new int[]{144, 7};
            templateInfoLayout.rowHeights = new int[]{35, 7, 7};
            templateInfoLayout.columnWeights = new double[]{0.0, 0.1};
            templateInfoLayout.rowWeights = new double[]{0.0, 0.1, 0.1};
            templatePanel.add((Component)templateInfo, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            templateInfo.setLayout(templateInfoLayout);
            templateInfo.setPreferredSize(new Dimension(10, 10));
            JLabel templateLabel = new JLabel();
            templateInfo.add((Component)templateLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            templateLabel.setName("templateLabel");
            templateLabel.setText(I18N.message("template", Locale.getDefault()) + ":");
            this.templateValue = new JLabel();
            templateInfo.add((Component)this.templateValue, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 9, 0, 0), 0, 0));
            this.templateValue.setFont(new Font(TAHOMA, 1, 11));
            JScrollPane customAttributeScrollPanel = new JScrollPane();
            templatePanel.add((Component)customAttributeScrollPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.customAttributeTable = new JTable();
            customAttributeScrollPanel.setViewportView(this.customAttributeTable);
            this.customAttributeTable.getTableHeader().setEnabled(false);
            this.customAttributeTable.setPreferredSize(new Dimension(567, 137));
            Application.getInstance().getContext().getResourceMap(this.getClass()).injectComponents((Component)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void openFileButtonActionPerformed() {
        String os = System.getProperty("os.name");
        String filePath = ArchiveViewer.getArchiveDir().getPath() + File.separator + this.document.getDiskPath();
        try {
            if (os.toLowerCase().contains("windows")) {
                String url = "file:///" + filePath.replace("\\\\", "/");
                Runtime.getRuntime().exec(new String[]{"rundll32", "url.dll,FileProtocolHandler " + url});
            } else if (os.toLowerCase().contains("mac os x")) {
                Runtime.getRuntime().exec(new String[]{"open", "-e " + filePath});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class MyTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private IndexVersion version;
        private String[][] rows;
        private String[] columns = new String[]{I18N.message("name", Locale.getDefault()), I18N.message("value", Locale.getDefault())};

        public MyTableModel(IndexVersion vers) {
            this.version = vers;
            if (CollectionUtils.isNotEmpty(this.version.getAttributeNames())) {
                this.rows = new String[this.version.getAttributes().size()][2];
                int m = 0;
                Iterator<String> iterator = this.version.getAttributeNames().iterator();
                while (iterator.hasNext()) {
                    String name;
                    this.rows[m][0] = name = iterator.next();
                    if (this.version.getAttributes().get(name).getType() == 3) {
                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                        this.rows[m][1] = this.version.getAttribute(name).getValue() != null ? df.format(this.version.getAttribute(name).getValue()) : "";
                    } else {
                        this.rows[m][1] = this.version.getAttributes().get(name).getType() == 4 || this.version.getAttributes().get(name).getType() == 6 || this.version.getAttributes().get(name).getType() == 7 ? this.version.getAttribute(name).getStringValue() : this.version.getAttributes().get(name).getValue().toString();
                    }
                    ++m;
                }
            }
        }

        public boolean isEditable() {
            return false;
        }

        @Override
        public int getColumnCount() {
            if (this.rows != null) {
                return this.columns.length;
            }
            return 0;
        }

        @Override
        public int getRowCount() {
            if (this.rows != null) {
                return this.rows.length;
            }
            return 0;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.rows[rowIndex][columnIndex];
        }

        @Override
        public String getColumnName(int col) {
            return this.columns[col];
        }

        public Version getVersion() {
            return this.version;
        }

        public void setVersion(IndexVersion version) {
            this.version = version;
        }
    }
}

