/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.impex.application;

import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.Version;
import com.logicaldoc.core.i18n.Language;
import com.logicaldoc.core.metadata.Attribute;
import com.logicaldoc.core.metadata.Template;
import com.logicaldoc.impex.IndexVersion;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang.StringUtils;

public class Database {
    private Connection con;
    private static Database instance;
    private List<IndexVersion> results = new ArrayList<IndexVersion>();
    private Map<String, Template> templates = new TreeMap<String, Template>();
    private Map<String, Language> languages = new TreeMap<String, Language>();
    private int maxResults = 1000;
    private boolean thereAreMoreResults = false;

    public static Database getInstance() {
        if (instance == null) {
            instance = new Database("");
        }
        return instance;
    }

    private Database(String password) {
        try {
            Class.forName("org.hsqldb.jdbcDriver");
            this.con = DriverManager.getConnection("jdbc:hsqldb:mem:aname", "sa", password);
            this.createSchema();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createSchema() {
        Statement stmt;
        Object var2_6;
        try {
            Throwable throwable = null;
            var2_6 = null;
            try {
                stmt = this.con.createStatement();
                try {
                    stmt.executeUpdate("DROP TABLE ld_version");
                    stmt.executeUpdate("DROP TABLE ld_version_ext");
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            Throwable e = null;
            var2_6 = null;
            try {
                stmt = this.con.createStatement();
                try {
                    String sqlVersion = "CREATE TABLE ld_version (ld_id BIGINT, ld_documentid BIGINT, ld_version VARCHAR(10), ld_fileversion VARCHAR(10), ld_username VARCHAR(255), ld_userid BIGINT, ld_versiondate timestamp, ld_comment VARCHAR(4000), ld_lastmodified timestamp null, ld_deleted INTEGER, ld_immutable INTEGER, ld_creation timestamp, ld_publisherid BIGINT, ld_indexed INTEGER, ld_signed INTEGER, ld_status INTEGER, ld_filesize BIGINT, ld_folderid BIGINT, ld_creator VARCHAR(255), ld_creatorid BIGINT, ld_templatename VARCHAR(4000), ld_filename VARCHAR(255), ld_customid VARCHAR(255), ld_diskpath VARCHAR(255), ld_foldername VARCHAR(4000), ld_publisher VARCHAR(255), ld_type VARCHAR(255), ld_language VARCHAR(255), ld_digest VARCHAR(255), ld_tgs varchar(1000), primary key (ld_id))";
                    stmt.executeUpdate(sqlVersion);
                    String sqlVersionExt = "CREATE TABLE ld_version_ext (ld_versionid BIGINT, ld_stringvalue VARCHAR(4000), ld_intvalue INTEGER, ld_doublevalue float, ld_datevalue timestamp null, ld_name VARCHAR(255), primary key (ld_versionid, ld_name))";
                    stmt.executeUpdate(sqlVersionExt);
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void insert(Collection<Version> versions) {
        this.disableAutoCommit();
        String sqlVersion = "INSERT INTO ld_version (ld_id, ld_documentid, ld_version, ld_fileversion, ld_username, ld_userid, ld_versiondate, ld_comment, ld_lastmodified, ld_deleted, ld_immutable, ld_creation, ld_publisherid, ld_indexed, ld_signed, ld_status, ld_filesize, ld_folderid, ld_creator, ld_creatorid, ld_templatename, ld_filename, ld_customid, ld_diskpath, ld_foldername, ld_publisher, ld_type, ld_language, ld_digest, ld_tgs) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        String sqlVersionExt = "INSERT INTO ld_version_ext (ld_versionid, ld_stringvalue, ld_intvalue, ld_doublevalue, ld_datevalue, ld_name) VALUES(?,?,?,?,?,?)";
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                PreparedStatement pstmt1 = this.con.prepareStatement(sqlVersion);
                try {
                    try (PreparedStatement insertVersionExtPreparedStatement = this.con.prepareStatement(sqlVersionExt);){
                        boolean insertVersionExtPreparedStatementBatch = false;
                        pstmt1.setLong(6, 1000L);
                        pstmt1.setString(8, "");
                        pstmt1.setTimestamp(9, new Timestamp(System.currentTimeMillis()));
                        pstmt1.setInt(10, 0);
                        pstmt1.setLong(13, 1000L);
                        pstmt1.setInt(14, 0);
                        pstmt1.setLong(18, 1000L);
                        pstmt1.setLong(20, 1000L);
                        for (Version vers : versions) {
                            IndexVersion version = (IndexVersion)vers;
                            pstmt1.setLong(1, version.getDocId());
                            pstmt1.setLong(2, version.getDocId());
                            pstmt1.setString(3, version.getVersion());
                            pstmt1.setString(4, version.getFileVersion());
                            pstmt1.setString(5, version.getUsername());
                            pstmt1.setTimestamp(7, new Timestamp(version.getVersionDate().getTime()));
                            pstmt1.setInt(11, version.getImmutable());
                            pstmt1.setTimestamp(12, new Timestamp(version.getCreation().getTime()));
                            pstmt1.setInt(15, version.getSigned());
                            pstmt1.setInt(16, version.getStatus().ordinal());
                            pstmt1.setLong(17, version.getFileSize());
                            pstmt1.setString(19, version.getCreator());
                            pstmt1.setString(21, StringUtils.trimToEmpty(version.getTemplateName()));
                            pstmt1.setString(22, version.getFileName());
                            pstmt1.setString(23, version.getCustomId());
                            pstmt1.setString(24, version.getDiskPath());
                            pstmt1.setString(25, version.getPath());
                            pstmt1.setString(26, version.getPublisher());
                            pstmt1.setString(27, version.getType());
                            pstmt1.setString(28, version.getLanguage());
                            pstmt1.setString(29, version.getDigest());
                            pstmt1.setString(30, version.getTgs());
                            pstmt1.addBatch();
                            if (!CollectionUtils.isNotEmpty(version.getAttributeNames())) continue;
                            insertVersionExtPreparedStatementBatch = this.instertExtendedAttributes(insertVersionExtPreparedStatement, insertVersionExtPreparedStatementBatch, version);
                        }
                        pstmt1.executeBatch();
                        pstmt1.clearBatch();
                        if (insertVersionExtPreparedStatementBatch) {
                            insertVersionExtPreparedStatement.executeBatch();
                            insertVersionExtPreparedStatement.clearBatch();
                        }
                        this.con.commit();
                    }
                    if (pstmt1 == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (pstmt1 == null) throw throwable;
                    pstmt1.close();
                    throw throwable;
                }
                pstmt1.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean instertExtendedAttributes(PreparedStatement insertVersionExtPreparedStatement, boolean insertVersionExtPreparedStatementBatch, IndexVersion version) throws SQLException {
        for (String attributeName : version.getAttributeNames()) {
            insertVersionExtPreparedStatement.setLong(1, version.getDocId());
            this.insertAttributeValue(insertVersionExtPreparedStatement, version, attributeName);
            insertVersionExtPreparedStatement.setString(6, attributeName);
            insertVersionExtPreparedStatement.addBatch();
            insertVersionExtPreparedStatementBatch = true;
        }
        return insertVersionExtPreparedStatementBatch;
    }

    private void insertAttributeValue(PreparedStatement insertVersionExtPreparedStatement, IndexVersion version, String attributeName) throws SQLException {
        if (version.getAttribute(attributeName).getType() == 0) {
            insertVersionExtPreparedStatement.setString(2, version.getAttributes().get(attributeName).getStringValue());
            insertVersionExtPreparedStatement.setLong(3, 0L);
            insertVersionExtPreparedStatement.setDouble(4, 0.0);
            insertVersionExtPreparedStatement.setDate(5, null);
        } else if (version.getAttribute(attributeName).getType() == 1) {
            insertVersionExtPreparedStatement.setString(2, " ");
            if (version.getAttributes().get(attributeName).getIntValue() != null) {
                insertVersionExtPreparedStatement.setLong(3, version.getAttributes().get(attributeName).getIntValue());
            }
            insertVersionExtPreparedStatement.setDouble(4, 0.0);
            insertVersionExtPreparedStatement.setDate(5, null);
        } else if (version.getAttribute(attributeName).getType() == 2) {
            insertVersionExtPreparedStatement.setString(2, " ");
            insertVersionExtPreparedStatement.setLong(3, 0L);
            if (version.getAttributes().get(attributeName).getDoubleValue() != null) {
                insertVersionExtPreparedStatement.setDouble(4, version.getAttributes().get(attributeName).getDoubleValue());
            }
            insertVersionExtPreparedStatement.setDate(5, null);
        } else if (version.getAttribute(attributeName).getType() == 3) {
            insertVersionExtPreparedStatement.setString(2, " ");
            insertVersionExtPreparedStatement.setLong(3, 0L);
            insertVersionExtPreparedStatement.setDouble(4, 0.0);
            java.util.Date date = version.getAttributes().get(attributeName).getDateValue();
            if (date != null) {
                insertVersionExtPreparedStatement.setDate(5, new Date(date.getTime()));
            } else {
                insertVersionExtPreparedStatement.setDate(5, null);
            }
        } else if (version.getAttribute(attributeName).getType() == 4 || version.getAttribute(attributeName).getType() == 6 || version.getAttribute(attributeName).getType() == 7) {
            insertVersionExtPreparedStatement.setString(2, version.getAttributes().get(attributeName).getStringValue());
            if (version.getAttributes().get(attributeName).getIntValue() != null) {
                insertVersionExtPreparedStatement.setLong(3, version.getAttributes().get(attributeName).getIntValue());
            }
            insertVersionExtPreparedStatement.setDouble(4, 0.0);
            insertVersionExtPreparedStatement.setDate(5, null);
        }
    }

    private void disableAutoCommit() {
        try {
            this.con.setAutoCommit(false);
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
    }

    public List<IndexVersion> search(String where) {
        this.results = new ArrayList<IndexVersion>();
        this.thereAreMoreResults = false;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Statement stmt = this.con.createStatement();){
                String versionQuery = "select distinct(A.*) from ld_version A " + where;
                ResultSet versionResultSet = stmt.executeQuery(versionQuery);
                IndexVersion version = null;
                int i = 0;
                while (versionResultSet.next()) {
                    version = new IndexVersion();
                    version.setId(versionResultSet.getLong(1));
                    Document dummyDoc = new Document();
                    dummyDoc.setId(versionResultSet.getLong(2));
                    version.setDocId(dummyDoc.getId());
                    version.setVersion(versionResultSet.getString(3));
                    version.setFileVersion(versionResultSet.getString(4));
                    version.setUsername(versionResultSet.getString(5));
                    version.setUserId(versionResultSet.getLong(6));
                    version.setVersionDate(new java.util.Date(versionResultSet.getTimestamp(7).getTime()));
                    version.setDate(new java.util.Date(versionResultSet.getTimestamp(7).getTime()));
                    version.setComment(versionResultSet.getString(8));
                    version.setLastModified(new java.util.Date(versionResultSet.getTimestamp(9).getTime()));
                    version.setDeleted(versionResultSet.getInt(10));
                    version.setImmutable(versionResultSet.getInt(11));
                    version.setCreation(new java.util.Date(versionResultSet.getTimestamp(12).getTime()));
                    version.setPublisherId(versionResultSet.getLong(13));
                    version.setIndexingStatus(versionResultSet.getInt(14));
                    version.setSigned(versionResultSet.getInt(15));
                    version.setStatus(versionResultSet.getInt(16));
                    version.setFileSize(versionResultSet.getLong(17));
                    version.setFolderId(versionResultSet.getLong(18));
                    version.setCreator(versionResultSet.getString(19));
                    version.setCreatorId(versionResultSet.getLong(20));
                    version.setTemplateName(versionResultSet.getString(21));
                    version.setFileName(versionResultSet.getString(22));
                    version.setCustomId(versionResultSet.getString(23));
                    version.setDiskPath(versionResultSet.getString(24));
                    version.setPath(versionResultSet.getString(25));
                    version.setFolderName(versionResultSet.getString(25));
                    version.setPublisher(versionResultSet.getString(26));
                    version.setType(versionResultSet.getString(27));
                    version.setLanguage(versionResultSet.getString(28));
                    version.setDigest(versionResultSet.getString(29));
                    version.setTgs(versionResultSet.getString(30));
                    this.fillExtendedAttributes(version);
                    if (i < this.maxResults) {
                        this.results.add(version);
                    }
                    if (++i <= this.maxResults) continue;
                    this.thereAreMoreResults = true;
                    break;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.results;
    }

    private void fillExtendedAttributes(IndexVersion version) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Statement stmt = this.con.createStatement();){
            String attributeVersionQuery = "select B.* from ld_version_ext B where B.ld_versionid = " + version.getId();
            ResultSet attributesResultSet = stmt.executeQuery(attributeVersionQuery);
            HashMap<String, Attribute> attributes = new HashMap<String, Attribute>();
            while (attributesResultSet.next()) {
                Attribute attribute = new Attribute();
                if (!attributesResultSet.getString(2).trim().isEmpty()) {
                    attribute.setType(0);
                    attribute.setStringValue(attributesResultSet.getString(2));
                } else if (attributesResultSet.getInt(3) > 0) {
                    attribute.setType(1);
                    attribute.setIntValue(attributesResultSet.getLong(3));
                } else if (attributesResultSet.getDouble(4) > 0.0) {
                    attribute.setType(2);
                    attribute.setDoubleValue(attributesResultSet.getDouble(4));
                } else {
                    attribute.setType(3);
                    attribute.setDateValue(attributesResultSet.getDate(5));
                }
                attributes.put(attributesResultSet.getString(6), attribute);
            }
            version.setAttributes(attributes);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public int countDocuments() {
        int num = 0;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Statement stmt = this.con.createStatement();){
                String docsNumberQuery = "select count(distinct(A.*)) from ld_version A";
                ResultSet docsNumberResultSet = stmt.executeQuery(docsNumberQuery);
                docsNumberResultSet.next();
                num = docsNumberResultSet.getInt(1);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return num;
    }

    public List<IndexVersion> getResults() {
        return this.results;
    }

    public void collectTemplates() {
        this.templates.clear();
        for (IndexVersion doc : this.results) {
            if (StringUtils.isEmpty(doc.getTemplateName().trim())) continue;
            Template template = this.templates.get(doc.getTemplateName());
            if (template == null) {
                template = new Template();
                template.setName(doc.getTemplateName());
                this.templates.put(doc.getTemplateName(), template);
            }
            for (String attribute : doc.getAttributeNames()) {
                if (template.getAttributes().containsKey(attribute)) continue;
                Attribute extAttribute = new Attribute();
                extAttribute.setType(doc.getAttributes().get(attribute).getType());
                template.getAttributes().put(attribute, extAttribute);
            }
        }
    }

    public void collectLanguages() {
        this.languages.clear();
        for (IndexVersion doc : this.results) {
            Language language;
            if (StringUtils.isEmpty(doc.getLanguage().trim()) || (language = this.languages.get(doc.getLanguage())) != null) continue;
            try {
                language = new Language(LocaleUtils.toLocale(doc.getLanguage()));
                this.languages.put(doc.getLanguage(), language);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public boolean isThereAreMoreResults() {
        return this.thereAreMoreResults;
    }

    public Map<String, Template> getTemplates() {
        return this.templates;
    }

    public Map<String, Language> getLanguages() {
        return this.languages;
    }
}

