/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.impex.application;

import com.logicaldoc.i18n.I18N;
import com.logicaldoc.impex.Archive;
import com.logicaldoc.impex.DefaultVerifier;
import com.logicaldoc.impex.IndexVersion;
import com.logicaldoc.impex.application.ArchiveViewer;
import com.logicaldoc.impex.application.Database;
import com.logicaldoc.impex.application.DocInfoPanel;
import com.logicaldoc.impex.application.DocumentTableModel;
import com.logicaldoc.impex.application.QueryMessagePanel;
import com.logicaldoc.impex.application.Util;
import com.logicaldoc.util.io.FileUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.jdesktop.application.Application;

public class BrowsePanel
extends JPanel {
    private static final String TAHOMA = "Tahoma";
    private static final long serialVersionUID = 1L;
    private JTable table;
    private JLabel closedOnValue;
    private JLabel closedByValue;
    private JLabel createdOnValue;
    private JLabel createdByValue;
    private JLabel archiveDocsNumValue;
    private JLabel archiveTypeValue;
    private JLabel archiveSizeValue;
    private JLabel archiveDescValue;
    private JLabel archVersValue;
    private JLabel progVersValue;
    private JLabel archiveIdValue;
    private JLabel archiveNameValue;
    private JFrame queryMessageFrame;

    public BrowsePanel(ArchiveViewer viewer) {
        this.initGUI();
        Archive archive = ArchiveViewer.getIndex().getArchive();
        this.archiveNameValue.setText(archive.getName());
        this.archiveIdValue.setText(Long.toString(archive.getId()));
        this.progVersValue.setText(ArchiveViewer.getIndex().getProgramVersion());
        this.archVersValue.setText(ArchiveViewer.getIndex().getArchiveVersion());
        if (viewer.getVerifier() instanceof DefaultVerifier) {
            this.archiveTypeValue.setText(I18N.message("default", Locale.getDefault()));
        }
        this.archiveDescValue.setText(archive.getDescription());
        this.archiveSizeValue.setText(FileUtil.getDisplaySize(archive.getSize(), "en"));
        this.archiveDocsNumValue.setText(Long.toString(ArchiveViewer.getIndex().getCount()));
        this.createdByValue.setText(archive.getCreatorName());
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        this.createdOnValue.setText(df.format(archive.getCreation()));
        this.closedByValue.setText(archive.getCloserName());
        this.closedOnValue.setText(df.format(archive.getClosure()));
        if (Database.getInstance().isThereAreMoreResults()) {
            this.queryMessageFrame = new JFrame(I18N.message("warning", Locale.getDefault()));
            this.queryMessageFrame.setDefaultCloseOperation(1);
            this.queryMessageFrame.setSize(300, 150);
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension screenSize = toolkit.getScreenSize();
            int x = (screenSize.width - this.queryMessageFrame.getWidth()) / 2;
            int y = (screenSize.height - this.queryMessageFrame.getHeight()) / 2;
            this.queryMessageFrame.setLocation(x, y);
            this.queryMessageFrame.add(new QueryMessagePanel());
            this.queryMessageFrame.setAlwaysOnTop(true);
            this.queryMessageFrame.setVisible(true);
        }
    }

    private void initGUI() {
        try {
            GridBagLayout thisLayout = new GridBagLayout();
            this.setPreferredSize(new Dimension(400, 300));
            thisLayout.rowWeights = new double[]{0.0, 0.1};
            thisLayout.rowHeights = new int[]{122, 7};
            thisLayout.columnWeights = new double[]{0.1};
            thisLayout.columnWidths = new int[]{7};
            this.setLayout(thisLayout);
            this.setName("this");
            this.setSize(400, 300);
            JScrollPane scrollPanel = new JScrollPane();
            this.add((Component)scrollPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
            this.initTable();
            scrollPanel.setViewportView(this.table);
            scrollPanel.setViewportView(this.table);
            scrollPanel.getViewport().setBackground(Color.white);
            scrollPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.gray));
            scrollPanel.setPreferredSize(new Dimension(700, 300));
            scrollPanel.setOpaque(false);
            scrollPanel.setAutoscrolls(true);
            scrollPanel.setSize(700, 300);
            this.table.addMouseListener(new MouseAdapter(){

                private void showPopup(MouseEvent e) {
                    Point p = new Point(e.getX(), e.getY());
                    int col = BrowsePanel.this.table.columnAtPoint(p);
                    int row = BrowsePanel.this.table.rowAtPoint(p);
                    IndexVersion doc = (IndexVersion)BrowsePanel.this.table.getValueAt(row, -1);
                    if (col >= 0 && col < BrowsePanel.this.table.getColumnCount() - 1) {
                        Frame[] frames = Frame.getFrames();
                        ArrayList<String> docs = new ArrayList<String>();
                        int i = 1;
                        while (i < frames.length) {
                            String fileName = "";
                            if (frames[i].isVisible()) {
                                fileName = frames[i].getTitle().substring(I18N.message("documentinfo", Locale.getDefault()).length()).trim();
                                docs.add(fileName);
                            }
                            ++i;
                        }
                        if (!docs.contains(doc.getFileName())) {
                            BrowsePanel.this.openPopup(doc);
                        }
                    } else {
                        String filePath = ArchiveViewer.getArchiveDir().getPath() + File.separator + doc.getDiskPath();
                        Util.openFile(new File(filePath));
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.showPopup(e);
                }
            });
            JPanel archiveInfoPanel = new JPanel();
            GridBagLayout archiveInfoPanelLayout = new GridBagLayout();
            archiveInfoPanelLayout.columnWidths = new int[]{7, 7, 7, 7};
            archiveInfoPanelLayout.rowHeights = new int[]{7, 7, 7, 7, 7, 7};
            archiveInfoPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            archiveInfoPanelLayout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1, 0.1, 0.1};
            this.add((Component)archiveInfoPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
            archiveInfoPanel.setLayout(archiveInfoPanelLayout);
            JLabel archiveIdLabel = new JLabel();
            archiveInfoPanel.add((Component)archiveIdLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            archiveIdLabel.setText(I18N.message("id", Locale.getDefault()) + ":");
            JLabel archiveNameLabel = new JLabel();
            archiveInfoPanel.add((Component)archiveNameLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            archiveNameLabel.setText(I18N.message("name", Locale.getDefault()) + ":");
            JLabel progVersLabel = new JLabel();
            archiveInfoPanel.add((Component)progVersLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            progVersLabel.setText(I18N.message("programversion", Locale.getDefault()) + ":");
            JLabel archVersLabel = new JLabel();
            archiveInfoPanel.add((Component)archVersLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            archVersLabel.setText(I18N.message("version", Locale.getDefault()) + ":");
            JLabel archiveTypeLabel = new JLabel();
            archiveInfoPanel.add((Component)archiveTypeLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            archiveTypeLabel.setName("archiveTypeLabel");
            archiveTypeLabel.setText(I18N.message("type", Locale.getDefault()) + ":");
            JLabel archiveSizeLabel = new JLabel();
            archiveInfoPanel.add((Component)archiveSizeLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            archiveSizeLabel.setName("archiveSizeLabel");
            archiveSizeLabel.setText(I18N.message("size", Locale.getDefault()) + ":");
            JLabel archiveDocsNumLabel = new JLabel();
            archiveInfoPanel.add((Component)archiveDocsNumLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            archiveDocsNumLabel.setName("archiveDocsNumLabel");
            archiveDocsNumLabel.setText(I18N.message("docsnum", Locale.getDefault()) + ":");
            JLabel archiveDescLabel = new JLabel();
            archiveInfoPanel.add((Component)archiveDescLabel, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            archiveDescLabel.setName("archiveDescLabel");
            archiveDescLabel.setText(I18N.message("description", Locale.getDefault()) + ":");
            JLabel createdByLabel = new JLabel();
            archiveInfoPanel.add((Component)createdByLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            createdByLabel.setText(I18N.message("creator", Locale.getDefault()) + ":");
            JLabel createdOnLabel = new JLabel();
            archiveInfoPanel.add((Component)createdOnLabel, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            createdOnLabel.setText(I18N.message("dateon", Locale.getDefault()) + ":");
            JLabel closedByLabel = new JLabel();
            archiveInfoPanel.add((Component)closedByLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            closedByLabel.setText(I18N.message("closedby", Locale.getDefault()) + ":");
            JLabel closedOnLabel = new JLabel();
            archiveInfoPanel.add((Component)closedOnLabel, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            closedOnLabel.setText(I18N.message("dateon", Locale.getDefault()) + ":");
            this.archiveIdValue = new JLabel();
            archiveInfoPanel.add((Component)this.archiveIdValue, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 9, 0, 0), 0, 0));
            this.archiveIdValue.setFont(new Font(TAHOMA, 1, 11));
            this.archiveNameValue = new JLabel();
            archiveInfoPanel.add((Component)this.archiveNameValue, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 9, 0, 0), 0, 0));
            this.archiveNameValue.setFont(new Font(TAHOMA, 1, 11));
            this.progVersValue = new JLabel();
            archiveInfoPanel.add((Component)this.progVersValue, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 9, 0, 0), 0, 0));
            this.progVersValue.setFont(new Font(TAHOMA, 1, 11));
            this.archVersValue = new JLabel();
            archiveInfoPanel.add((Component)this.archVersValue, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 9, 0, 0), 0, 0));
            this.archVersValue.setFont(new Font(TAHOMA, 1, 11));
            this.archiveTypeValue = new JLabel();
            archiveInfoPanel.add((Component)this.archiveTypeValue, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 9, 0, 0), 0, 0));
            this.archiveTypeValue.setFont(new Font(TAHOMA, 1, 11));
            this.archiveSizeValue = new JLabel();
            archiveInfoPanel.add((Component)this.archiveSizeValue, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 9, 0, 0), 0, 0));
            this.archiveSizeValue.setFont(new Font(TAHOMA, 1, 11));
            this.archiveDocsNumValue = new JLabel();
            archiveInfoPanel.add((Component)this.archiveDocsNumValue, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 9, 0, 0), 0, 0));
            this.archiveDocsNumValue.setFont(new Font(TAHOMA, 1, 11));
            this.archiveDescValue = new JLabel();
            archiveInfoPanel.add((Component)this.archiveDescValue, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 9, 0, 0), 0, 0));
            this.archiveDescValue.setFont(new Font(TAHOMA, 1, 11));
            this.createdByValue = new JLabel();
            archiveInfoPanel.add((Component)this.createdByValue, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 9, 0, 0), 0, 0));
            this.createdByValue.setFont(new Font(TAHOMA, 1, 11));
            this.createdOnValue = new JLabel();
            archiveInfoPanel.add((Component)this.createdOnValue, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 9, 0, 0), 0, 0));
            this.createdOnValue.setFont(new Font(TAHOMA, 1, 11));
            this.closedByValue = new JLabel();
            archiveInfoPanel.add((Component)this.closedByValue, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 9, 0, 0), 0, 0));
            this.closedByValue.setFont(new Font(TAHOMA, 1, 11));
            this.closedOnValue = new JLabel();
            archiveInfoPanel.add((Component)this.closedOnValue, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 9, 0, 0), 0, 0));
            this.closedOnValue.setFont(new Font(TAHOMA, 1, 11));
            Application.getInstance().getContext().getResourceMap(this.getClass()).injectComponents((Component)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initTable() {
        Database database = Database.getInstance();
        this.table = new JTable(new DocumentTableModel(new ArrayList<IndexVersion>(database.getResults())));
        this.table.setCellSelectionEnabled(true);
        this.table.setColumnSelectionAllowed(true);
        this.table.setAutoCreateRowSorter(true);
        this.table.setAutoResizeMode(0);
        TableColumn col = this.table.getColumnModel().getColumn(0);
        col.setPreferredWidth(50);
        col = this.table.getColumnModel().getColumn(1);
        col.setPreferredWidth(120);
        col = this.table.getColumnModel().getColumn(2);
        col.setPreferredWidth(130);
        col = this.table.getColumnModel().getColumn(3);
        col.setPreferredWidth(60);
        col = this.table.getColumnModel().getColumn(4);
        col.setPreferredWidth(190);
        col = this.table.getColumnModel().getColumn(5);
        col.setPreferredWidth(70);
        col = this.table.getColumnModel().getColumn(6);
        col.setPreferredWidth(70);
        col = this.table.getColumnModel().getColumn(7);
        col.setPreferredWidth(70);
    }

    private void openPopup(IndexVersion document) {
        JFrame docInfoFrame = new JFrame(I18N.message("documentinfo", Locale.getDefault()) + " - " + document.getFileName());
        docInfoFrame.setDefaultCloseOperation(2);
        docInfoFrame.setSize(600, 400);
        docInfoFrame.add(new DocInfoPanel(document));
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        int x = (screenSize.width - docInfoFrame.getWidth()) / 2;
        int y = (screenSize.height - docInfoFrame.getHeight()) / 2;
        docInfoFrame.setLocation(x, y);
        docInfoFrame.setAlwaysOnTop(true);
        docInfoFrame.setVisible(true);
    }
}

