/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.impex.application;

import com.logicaldoc.i18n.I18N;
import com.logicaldoc.impex.ArchiveVerifier;
import com.logicaldoc.impex.Index;
import com.logicaldoc.impex.application.BrowsePanel;
import com.logicaldoc.impex.application.Database;
import com.logicaldoc.impex.application.DatabaseHandler;
import com.logicaldoc.impex.application.SearchPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javax.swing.ActionMap;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.SingleFrameApplication;

public class ArchiveViewer
extends SingleFrameApplication {
    private static Index index;
    private static File archiveDir;
    private JPanel topPanel;
    private JButton browseButton;
    private JButton searchButton;
    private JPanel contentPanel;
    private ArchiveVerifier verifier;
    private String title = "";

    public void showContentPanel(JPanel panel) {
        this.topPanel.remove(this.contentPanel);
        this.contentPanel = panel;
        this.topPanel.add((Component)this.contentPanel, "Center");
        this.show(this.topPanel);
    }

    @Action
    public void open() {
        this.browseButton.setEnabled(false);
        this.searchButton.setEnabled(false);
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        try {
            File f = new File(new File(".").getCanonicalPath());
            fc.setCurrentDirectory(f);
        }
        catch (IOException f) {
            // empty catch block
        }
        String workDir = "${user.home}";
        String tmp = StrSubstitutor.replaceSystemProperties(workDir);
        fc.setCurrentDirectory(new File(FilenameUtils.separatorsToSystem(tmp)));
        fc.setPreferredSize(new Dimension(600, 400));
        fc.setSize(600, 400);
        int n = fc.showOpenDialog(this.topPanel);
        if (n != 0) {
            return;
        }
        ArchiveViewer.setArchiveDir(fc.getSelectedFile());
        this.showContentPanel(new JPanel());
        this.getMainView().getFrame().setTitle(this.title + " - " + I18N.message("archiveloading", Locale.getDefault()));
        this.initVerifier();
        SearchPanel.clean();
    }

    private void initVerifier() {
        Database database = Database.getInstance();
        database.createSchema();
        ArchiveViewer.setIndex(null);
        try {
            this.verifier = ArchiveVerifier.getInstance(ArchiveViewer.getArchiveDir(), new DatabaseHandler());
        }
        catch (Exception e) {
            this.browseButton.setEnabled(false);
            this.searchButton.setEnabled(false);
            JOptionPane.showMessageDialog(null, I18N.message("archivecheckundeterminate", Locale.getDefault()), "Error", 0);
            return;
        }
        this.verifier.setLogsLocale(Locale.getDefault());
        this.browseButton.setEnabled(true);
        this.searchButton.setEnabled(true);
        ArchiveViewer.setIndex(this.verifier.getIndex());
        database.search("");
        database.collectTemplates();
        database.collectLanguages();
        this.getMainView().getFrame().setTitle(this.title + " - " + index.getArchive().getName());
    }

    @Action
    public void browse() {
        this.topPanel.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.showContentPanel(new BrowsePanel(this));
        }
        finally {
            this.topPanel.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Action
    public void search() {
        this.topPanel.setCursor(Cursor.getPredefinedCursor(3));
        try {
            SearchPanel searchPanel = SearchPanel.getInstance(this);
            this.showContentPanel(searchPanel);
        }
        finally {
            this.topPanel.setCursor(Cursor.getDefaultCursor());
        }
    }

    private ActionMap getAppActionMap() {
        return Application.getInstance().getContext().getActionMap((Object)this);
    }

    protected void startup() {
        this.getMainFrame().setPreferredSize(new Dimension(500, 400));
        this.getMainFrame().setSize(550, 400);
        this.topPanel = new JPanel();
        BorderLayout panelLayout = new BorderLayout();
        this.topPanel.setLayout(panelLayout);
        this.topPanel.setPreferredSize(new Dimension(390, 300));
        this.topPanel.setSize(390, 224);
        this.contentPanel = new JPanel();
        this.contentPanel.setSize(550, 199);
        this.topPanel.add((Component)this.contentPanel, "Center");
        JPanel toolBarPanel = new JPanel();
        this.topPanel.add((Component)toolBarPanel, "North");
        BorderLayout jPanel1Layout = new BorderLayout();
        toolBarPanel.setLayout(jPanel1Layout);
        toolBarPanel.setSize(495, 25);
        JToolBar toolBar = new JToolBar();
        toolBarPanel.add((Component)toolBar, "Center");
        toolBar.setSize(450, 23);
        this.browseButton = new JButton();
        toolBar.add(this.browseButton);
        this.browseButton.setAction(this.getAppActionMap().get("browse"));
        this.browseButton.setName("browseButton");
        this.browseButton.setFocusable(false);
        this.browseButton.setText(I18N.message("browse", Locale.getDefault()));
        this.browseButton.setToolTipText(I18N.message("browsearchive", Locale.getDefault()));
        this.searchButton = new JButton();
        toolBar.add(this.searchButton);
        this.searchButton.setAction(this.getAppActionMap().get("search"));
        this.searchButton.setName("searchButton");
        this.searchButton.setFocusable(false);
        this.searchButton.setText(I18N.message("search", Locale.getDefault()));
        this.searchButton.setToolTipText(I18N.message("searcharchive", Locale.getDefault()));
        JSeparator jSeparator = new JSeparator();
        toolBarPanel.add((Component)jSeparator, "South");
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        menuBar.add(fileMenu);
        fileMenu.setName("fileMenu");
        JMenuItem jMenuItem2 = new JMenuItem();
        fileMenu.add(jMenuItem2);
        jMenuItem2.setAction(this.getAppActionMap().get("open"));
        jMenuItem2.setText(I18N.message("open", Locale.getDefault()));
        jMenuItem2.setToolTipText(I18N.message("openarchive", Locale.getDefault()));
        this.title = this.getMainView().getFrame().getTitle();
        this.getMainFrame().setJMenuBar(menuBar);
        this.show(this.topPanel);
        this.browseButton.setEnabled(false);
        this.searchButton.setEnabled(false);
    }

    public static void main(String[] args) {
        ArchiveViewer.launch(ArchiveViewer.class, (String[])args);
    }

    public ArchiveVerifier getVerifier() {
        return this.verifier;
    }

    public static File getArchiveDir() {
        return archiveDir;
    }

    public static void setArchiveDir(File archiveDir) {
        ArchiveViewer.archiveDir = archiveDir;
    }

    public static Index getIndex() {
        return index;
    }

    public static void setIndex(Index index) {
        ArchiveViewer.index = index;
    }
}

