/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.impex;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.AbstractDocument;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.DocumentEvent;
import com.logicaldoc.core.document.DocumentHistory;
import com.logicaldoc.core.document.DocumentManager;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.metadata.Attribute;
import com.logicaldoc.core.metadata.Template;
import com.logicaldoc.core.metadata.TemplateDAO;
import com.logicaldoc.core.security.Tenant;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.impex.AbstractIndexImportHandler;
import com.logicaldoc.impex.Archive;
import com.logicaldoc.impex.ArchiveCache;
import com.logicaldoc.impex.ArchiveCacheManager;
import com.logicaldoc.impex.ArchiveImporter;
import com.logicaldoc.impex.ArchiveManager;
import com.logicaldoc.util.spring.Context;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class IndexImportHandler
extends AbstractIndexImportHandler {
    protected Map<String, Template> templates;
    protected File docFile;
    protected ArchiveImporter importer;
    private String transactionId;

    public IndexImportHandler(Archive archive, ArchiveImporter importer, Map<String, Template> templates, Collection<Folder> workspaces, Tenant tenant, String transactionId) {
        this.archive = archive;
        this.importer = importer;
        this.templates = templates;
        this.tenant = tenant;
        this.workspaces = workspaces;
        this.transactionId = transactionId;
    }

    @Override
    public void startElement(String uri, String localname, String tagName, Attributes attributes) throws SAXException {
        if (localname.equalsIgnoreCase("document")) {
            this.currentDocument = new Document();
            this.currentDocument.setTenantId(this.archive.getTenantId());
            this.currentAttribute = null;
            if (attributes.getLength() != 0) {
                this.setDocumentAttributes(attributes);
            }
        }
    }

    private void setDocumentAttributes(Attributes attributes) {
        int i = 0;
        while (i < attributes.getLength()) {
            if (this.archive.getImportCustomId() != 0 && attributes.getQName(i).equals("customid")) {
                this.currentDocument.setCustomId(attributes.getValue(i));
            }
            ++i;
        }
    }

    @Override
    protected void endDocumentElement() {
        block6: {
            try {
                try {
                    ArchiveCacheManager cacheManager = Context.get(ArchiveCacheManager.class);
                    ArchiveCache cache = cacheManager.getCache(this.archive);
                    cache.read();
                    this.importer.getLog().info("Importing document '{}'", (Object)this.currentDocument.getFileName());
                    if (cache.containsKey(this.currentDocument.getCustomId())) {
                        this.importer.getLog().info("The document '{}' has already been imported", (Object)this.currentDocument.getFileName());
                        break block6;
                    }
                    this.importNewDocument(cache);
                }
                catch (Exception t) {
                    this.importer.getLog().error("Error reading cache for archive '{}'", (Object)this.archive.getName(), (Object)t);
                    this.importer.following();
                }
            }
            finally {
                this.importer.following();
            }
        }
    }

    private void importNewDocument(ArchiveCache cache) {
        try {
            DocumentDAO documentDao = Context.get(DocumentDAO.class);
            Document document = documentDao.findByCustomId(this.currentDocument.getCustomId(), this.currentDocument.getTenantId());
            UserDAO userDao = Context.get(UserDAO.class);
            User owner = userDao.findByUsername("_impex");
            if (document != null) {
                document = this.endDocumentElementExistingCustomId(document, owner);
            } else {
                DocumentHistory transaction = new DocumentHistory();
                transaction.setEvent(DocumentEvent.STORED);
                transaction.setComment("");
                transaction.setUser(owner);
                transaction.setTenantId(this.archive.getTenantId());
                this.updateTemplate((Document)this.currentDocument);
                document = this.createDocument(transaction);
                document.setCustomId(this.currentDocument.getCustomId());
                documentDao.store(document);
                this.importer.setImported(this.importer.getImported() + 1L);
            }
            cache.put(this.currentDocument.getCustomId(), document.getCustomId());
            cache.append();
        }
        catch (Exception e) {
            this.importer.setErrors(this.importer.getErrors() + 1L);
            this.importer.getLog().error("Error importing document '{}'", (Object)this.currentDocument.getFileName(), (Object)e);
        }
    }

    private Document endDocumentElementExistingCustomId(Document document, User owner) throws PersistenceException {
        DocumentManager documentManager = Context.get(DocumentManager.class);
        DocumentDAO documentDao = Context.get(DocumentDAO.class);
        documentDao.initialize(document);
        if (this.archive.getImportCustomId() == 3) {
            DocumentHistory transaction = new DocumentHistory();
            transaction.setEvent(DocumentEvent.STORED);
            transaction.setComment("");
            transaction.setUser(owner);
            transaction.setTenantId(this.archive.getTenantId());
            this.updateTemplate((Document)this.currentDocument);
            document = this.createDocument(transaction);
            this.importer.setImported(this.importer.getImported() + 1L);
        } else if (document.getImmutable() == 1) {
            this.importer.getLog().warn("The document '{}' is immutable, so the document '{}' cannot be imported", (Object)document.getFileName(), (Object)this.currentDocument.getFileName());
        } else {
            DocumentHistory transaction = new DocumentHistory();
            transaction.setEvent(DocumentEvent.CHECKEDIN);
            transaction.setUser(owner);
            transaction.setTenantId(this.archive.getTenantId());
            Document currentDoc = new Document(this.currentDocument);
            currentDoc.setTransactionId(this.transactionId);
            this.importer.getLog().info("Checking-in document {}", (Object)this.currentDocument);
            if (this.archive.getImportCustomId() == 1) {
                transaction.setComment("new document release version");
                documentManager.checkin(document.getId(), this.docFile, document.getFileName(), true, currentDoc, transaction);
                this.importer.setUpdated(this.importer.getUpdated() + 1L);
                this.importer.getLog().info("The document '{}' has a new release with document '{}'", (Object)document.getFileName(), (Object)this.currentDocument.getFileName());
            }
            if (this.archive.getImportCustomId() == 2) {
                transaction.setComment("new document sub-version");
                documentManager.checkin(document.getId(), this.docFile, document.getFileName(), false, currentDoc, transaction);
                this.importer.setUpdated(this.importer.getUpdated() + 1L);
                this.importer.getLog().info("The document '{}' has a new subversion with document '{}'", (Object)document.getFileName(), (Object)this.currentDocument.getFileName());
            }
        }
        return document;
    }

    protected Document createDocument(DocumentHistory transaction) throws PersistenceException {
        Document doc = new Document();
        doc.setTransactionId(this.transactionId);
        doc.setTenantId(this.currentDocument.getTenantId());
        doc.setFileName(this.docFile.getName());
        doc.setTenantId(this.currentDocument.getTenantId());
        doc.setLocale(this.currentDocument.getLocale());
        doc.setTemplate(this.currentDocument.getTemplate());
        doc.setAttributes(this.currentDocument.getAttributes());
        doc.setLanguage(this.currentDocument.getLanguage());
        doc.setPublished(this.currentDocument.getPublished());
        doc.setStartPublishing(this.currentDocument.getStartPublishing());
        doc.setStopPublishing(this.currentDocument.getStopPublishing());
        doc.setColor(this.currentDocument.getColor());
        AbstractDocument abstractDocument = this.currentDocument;
        if (abstractDocument instanceof Document) {
            Document dc = (Document)abstractDocument;
            doc.setFolder(dc.getFolder());
            doc.setTags(dc.getTags());
        }
        DocumentManager documentManager = Context.get(DocumentManager.class);
        Document document = documentManager.create(this.docFile, doc, transaction).getDocument();
        this.importer.getLog().info("The document '{}' has been imported", (Object)this.currentDocument.getFileName());
        return document;
    }

    private void updateTemplate(Document doc) throws PersistenceException {
        Template template = doc.getTemplate();
        if (template == null) {
            return;
        }
        TemplateDAO templateDao = Context.get(TemplateDAO.class);
        templateDao.initialize(template);
        boolean updated = false;
        for (String name : doc.getAttributeNames()) {
            Attribute extAttribute;
            if (template.getAttributes().containsKey(name) || StringUtils.isNotEmpty((extAttribute = new Attribute(doc.getAttributes().get(name))).getParent())) continue;
            if (StringUtils.isEmpty(extAttribute.getLabel())) {
                extAttribute.setLabel(extAttribute.getName());
            }
            template.getAttributes().put(name, extAttribute);
            updated = true;
        }
        if (updated) {
            templateDao.store(template);
            this.templates.put(template.getName(), template);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        try {
            if ("impex".equals(localName) || "attributes".equals(localName) || "attribute".equals(localName)) {
                return;
            }
            this.endElementLegacyAttributes(localName);
            if ("template".equals(localName) && StringUtils.isNotEmpty(this.buffer.toString().trim())) {
                TemplateDAO templateDao = Context.get(TemplateDAO.class);
                Template template = null;
                if (this.templates.keySet().contains(this.buffer.toString().trim())) {
                    template = this.templates.get(this.buffer.toString().trim());
                } else if (this.archive.getImportTemplate() == 1) {
                    template = new Template();
                    template.setTenantId(this.archive.getTenantId());
                    template.setName(this.buffer.toString().trim());
                    template.setDescription("");
                    templateDao.store(template);
                    this.templates.put(this.buffer.toString().trim(), template);
                }
                this.currentDocument.setTemplate(template);
            }
            if ("path".equals(localName)) {
                ArchiveManager archiveManager = Context.get(ArchiveManager.class);
                this.docFile = new File(archiveManager.getArchiveDirectory(this.archive), this.buffer.toString().trim());
            }
        }
        catch (Exception e) {
            this.importer.getLog().error("Error retrieving values of document '" + this.currentDocument.getFileName() + "'", e);
        }
        this.buffer = new StringBuilder();
    }
}

