/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.impex;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.AbstractDocument;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.metadata.Attribute;
import com.logicaldoc.impex.Archive;
import com.logicaldoc.impex.Index;
import com.logicaldoc.impex.IndexVersion;
import com.logicaldoc.util.io.FileUtil;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class IndexHandler
extends DefaultHandler {
    private static final Logger log = LoggerFactory.getLogger(IndexHandler.class);
    protected Archive archive = new Archive();
    protected AbstractDocument currentDocument;
    protected Attribute currentAttribute;
    protected long count;
    protected String sizeDiplay;
    protected StringBuilder buffer = new StringBuilder();
    protected String programVersion;
    protected String archiveVersion;

    @Override
    public void startElement(String uri, String localname, String tagName, Attributes attributes) throws SAXException {
        if (localname.equalsIgnoreCase("impex") && attributes.getLength() != 0) {
            this.readArchiveAttributes(attributes);
        }
        if (localname.equalsIgnoreCase("document")) {
            this.currentDocument = new IndexVersion();
            this.currentDocument.setTenantId(this.archive.getTenantId());
            this.currentAttribute = null;
            if (attributes.getLength() != 0) {
                this.setVersionAttributes(attributes);
            }
        }
    }

    private void readArchiveAttributes(Attributes attributes) {
        int length = attributes.getLength();
        int attrributeIndex = 0;
        while (attrributeIndex < length) {
            String attributeName = attributes.getQName(attrributeIndex);
            String attributeValue = attributes.getValue(attrributeIndex);
            this.readIndexId(attributeName, attributeValue);
            if (attributeName.equals("description")) {
                this.archive.setDescription(attributeValue);
            }
            this.readIndexDates(attributeName, attributeValue);
            this.readCreator(attributeName, attributeValue);
            this.readIndexCloser(attributeName, attributeValue);
            if (attributeName.equals("size") && StringUtils.isNotEmpty(attributeValue)) {
                this.archive.setSize(Long.parseLong(attributeValue));
            }
            if (attributeName.equals("sizedisplay")) {
                this.sizeDiplay = attributeValue;
            }
            if (attributeName.equals("count")) {
                this.count = Long.parseLong(attributeValue);
            }
            this.readIndexType(attributeName, attributeValue);
            this.readIndexVersion(attributeName, attributeValue);
            ++attrributeIndex;
        }
    }

    private void readIndexId(String attributeName, String attributeValue) {
        if (attributeName.equals("id")) {
            this.archive.setId(Long.parseLong(attributeValue));
        }
        if (attributeName.equals("name")) {
            this.archive.setName(attributeValue);
        }
    }

    private void readIndexType(String attributeName, String attributeValue) {
        if (attributeName.equals("type")) {
            this.archive.setType(attributeValue.equals("default") ? 0 : 1);
        }
    }

    private void readIndexVersion(String attributeName, String attributeValue) {
        if (attributeName.equals("programversion")) {
            this.programVersion = attributeValue;
        }
        if (attributeName.equals("archiveversion")) {
            this.archiveVersion = attributeValue;
        }
    }

    private void readIndexCloser(String attributeName, String attributeValue) {
        if (attributeName.equals("closerid")) {
            this.archive.setCloserId(Long.parseLong(attributeValue));
        }
        if (attributeName.equals("closer")) {
            this.archive.setCloserName(attributeValue);
        }
    }

    private void readCreator(String attributeName, String attributeValue) {
        if (attributeName.equals("creatorid")) {
            this.archive.setCreatorId(Long.parseLong(attributeValue));
        }
        if (attributeName.equals("creator")) {
            this.archive.setCreatorName(attributeValue);
        }
    }

    private void readIndexDates(String attributeName, String attributeValue) {
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        if (attributeName.equals("creation")) {
            try {
                this.archive.setCreation(df1.parse(attributeValue));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (attributeName.equals("closure")) {
            try {
                this.archive.setClosure(df1.parse(attributeValue));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    private void setVersionAttributes(Attributes attributes) {
        int i = 0;
        while (i < attributes.getLength()) {
            if (attributes.getQName(i).equals("id")) {
                Document dummyDoc = new Document();
                dummyDoc.setId(Long.parseLong(attributes.getValue(i)));
                ((IndexVersion)this.currentDocument).setDocId(dummyDoc.getId());
            }
            if (attributes.getQName(i).equals("customid")) {
                this.currentDocument.setCustomId(attributes.getValue(i));
            }
            ++i;
        }
    }

    protected void endDocumentElement() {
        this.archive.getEntries().add((IndexVersion)this.currentDocument);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if ("impex".equals(localName) || "attributes".equals(localName) || "attribute".equals(localName)) {
            return;
        }
        if ("document".equals(localName)) {
            this.endDocumentElement();
        }
        this.readPath(localName);
        this.readImmutable(localName);
        this.readVersions(localName);
        this.readDates(localName);
        this.readUsers(localName);
        this.readStatus(localName);
        this.readLanguage(localName);
        this.readFileName(localName);
        this.readFileSize(localName);
        this.readColor(localName);
        this.readSigned(localName);
        if ("tags".equals(localName)) {
            this.currentDocument.setTgs(this.buffer.toString().trim());
        }
        if ("comment".equals(localName)) {
            this.currentDocument.setComment(this.buffer.toString().trim());
        }
        if ("digest".equals(localName)) {
            this.currentDocument.setDigest(this.buffer.toString().trim());
        }
        if ("path".equals(localName)) {
            IndexVersion currentVersion = (IndexVersion)this.currentDocument;
            currentVersion.setDiskPath(this.buffer.toString().trim());
            if (currentVersion.getDiskPath().startsWith("/")) {
                currentVersion.setDiskPath(currentVersion.getDiskPath().substring(1));
            }
        }
        this.readPublished(localName);
        try {
            this.readTemplates(localName);
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
        }
        this.readExtendedAttributes(localName);
        this.buffer = new StringBuilder();
    }

    protected void readSigned(String localName) {
        if ("signed".equals(localName)) {
            try {
                this.currentDocument.setSigned(Integer.parseInt(this.buffer.toString().trim()));
            }
            catch (NumberFormatException e) {
                this.logElementError(localName, e);
            }
        }
    }

    protected void readColor(String localName) {
        if ("color".equals(localName)) {
            this.currentDocument.setColor(this.buffer.toString().trim());
        }
    }

    protected void readPublished(String localName) {
        if ("published".equals(localName)) {
            try {
                this.currentDocument.setPublished(Integer.parseInt(this.buffer.toString().trim()));
            }
            catch (NumberFormatException e) {
                this.logElementError(localName, e);
            }
        }
    }

    protected void readUsers(String localName) {
        if ("creator".equals(localName)) {
            this.currentDocument.setCreator(this.buffer.toString().trim());
        }
        if ("creatorid".equals(localName)) {
            this.currentDocument.setCreatorId(Long.parseLong(this.buffer.toString().trim()));
        }
        if ("publisher".equals(localName)) {
            this.currentDocument.setPublisher(this.buffer.toString().trim());
        }
        if ("publisherid".equals(localName)) {
            this.currentDocument.setPublisherId(Long.parseLong(this.buffer.toString().trim()));
        }
    }

    protected void readExtendedAttributes(String localName) {
        DecimalFormat decimalFormat = new DecimalFormat("####################.#####");
        DecimalFormat integerFormat = new DecimalFormat("####################");
        this.readExtendedAttribute(localName);
        this.readExtendedAttributeEditor(localName);
        this.readExtendedAttributeSetId(localName);
        this.readExtendedAttributeFlags(localName);
        this.readExtendedAttributeParent(localName);
        this.readExtendedAttributeType(localName);
        if ("stringvalue".equals(localName)) {
            this.readExtendedAttributeStringValue();
        } else if ("intvalue".equals(localName)) {
            this.readExtendedAttributeIntValue(localName, integerFormat);
        } else if ("doublevalue".equals(localName)) {
            this.readExtendedAttributeDoubleValue(localName, decimalFormat);
        } else if ("datevalue".equals(localName)) {
            this.readExtendedAttributeDateValue(localName);
        }
    }

    private void readExtendedAttributeType(String localName) {
        if ("valuetype".equals(localName)) {
            this.currentAttribute.setType(Integer.parseInt(this.buffer.toString().trim()));
        }
    }

    private void readExtendedAttributeParent(String localName) {
        if ("parent".equals(localName)) {
            this.currentAttribute.setParent(this.buffer.toString().trim());
        }
    }

    private void readExtendedAttributeFlags(String localName) {
        if ("hidden".equals(localName)) {
            try {
                this.currentAttribute.setHidden(Integer.parseInt(this.buffer.toString().trim()));
            }
            catch (NumberFormatException e) {
                this.logElementError(localName, e);
            }
        }
        if ("readonly".equals(localName)) {
            try {
                this.currentAttribute.setReadonly(Integer.parseInt(this.buffer.toString().trim()));
            }
            catch (NumberFormatException e) {
                this.logElementError(localName, e);
            }
        }
        if ("multiple".equals(localName)) {
            try {
                this.currentAttribute.setMultiple(Integer.parseInt(this.buffer.toString().trim()));
            }
            catch (NumberFormatException e) {
                this.logElementError(localName, e);
            }
        }
    }

    private void readExtendedAttributeEditor(String localName) {
        if ("editor".equals(localName)) {
            this.currentAttribute.setEditor(Integer.parseInt(this.buffer.toString().trim()));
        }
    }

    private void readExtendedAttribute(String localName) {
        if ("name".equals(localName)) {
            this.currentAttribute = new Attribute();
            this.currentAttribute.setType(-1);
            this.currentDocument.getAttributes().put(this.buffer.toString().trim(), this.currentAttribute);
        }
    }

    private void readExtendedAttributeDateValue(String localName) {
        if (this.currentAttribute.getType() == -1) {
            this.currentAttribute.setType(3);
        }
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
        try {
            if (StringUtils.isNotEmpty(this.buffer.toString().trim())) {
                this.currentAttribute.setDateValue(df1.parse(this.buffer.toString().trim()));
            }
        }
        catch (ParseException e) {
            this.logCustomAttributeError(localName, e);
        }
    }

    private void readExtendedAttributeDoubleValue(String localName, NumberFormat decimalFormat) {
        if (this.currentAttribute.getType() == -1) {
            this.currentAttribute.setType(2);
        }
        try {
            if (StringUtils.isNotEmpty(this.buffer.toString().trim())) {
                this.currentAttribute.setDoubleValue(decimalFormat.parse(this.buffer.toString().trim()).doubleValue());
            }
        }
        catch (ParseException e) {
            this.logCustomAttributeError(localName, e);
        }
    }

    private void readExtendedAttributeIntValue(String localName, NumberFormat integerFormat) {
        if (this.currentAttribute.getType() == -1) {
            this.currentAttribute.setType(1);
        }
        try {
            if (StringUtils.isNotEmpty(this.buffer.toString().trim())) {
                this.currentAttribute.setIntValue(integerFormat.parse(this.buffer.toString().trim()).longValue());
            }
        }
        catch (ParseException e) {
            this.logCustomAttributeError(localName, e);
        }
    }

    private void readExtendedAttributeStringValue() {
        if (this.currentAttribute.getType() == -1) {
            this.currentAttribute.setType(0);
        }
        this.currentAttribute.setStringValue(this.buffer.toString().trim());
    }

    private void readExtendedAttributeSetId(String localName) {
        if ("setid".equals(localName) && StringUtils.isNotEmpty(this.buffer.toString().trim())) {
            this.currentAttribute.setSetId(Long.parseLong(this.buffer.toString().trim()));
        }
    }

    protected void readFileSize(String localName) {
        if ("filesize".equals(localName)) {
            try {
                this.currentDocument.setFileSize(Long.parseLong(this.buffer.toString().trim()));
            }
            catch (NumberFormatException e) {
                this.logElementError(localName, e);
            }
        }
    }

    protected void readFileName(String localName) {
        if ("filename".equals(localName)) {
            this.currentDocument.setFileName(this.buffer.toString().trim());
            this.currentDocument.setType(FileUtil.getExtension(this.currentDocument.getFileName()));
        }
    }

    protected void readLanguage(String localName) {
        if ("language".equals(localName)) {
            this.currentDocument.setLanguage(this.buffer.toString().trim());
        }
    }

    protected void readStatus(String localName) {
        if ("status".equals(localName)) {
            try {
                this.currentDocument.setStatus(Integer.parseInt(this.buffer.toString().trim()));
            }
            catch (NumberFormatException e) {
                this.logElementError(localName, e);
            }
        }
    }

    protected void readTemplates(String localName) throws PersistenceException {
        if ("template".equals(localName)) {
            this.currentDocument.setTemplateName(this.buffer.toString().trim());
        }
        if ("ocrTemplate".equals(localName)) {
            this.currentDocument.setOcrTemplateId(Index.getOcrTemplateId(this.buffer.toString().trim()));
        }
        if ("barcodeTemplate".equals(localName)) {
            this.currentDocument.setBarcodeTemplateId(Index.getBarcodeTemplateId(this.buffer.toString().trim()));
        }
    }

    protected void readDates(String localName) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        if ("date".equals(localName)) {
            try {
                this.currentDocument.setDate(df.parse(this.buffer.toString().trim()));
            }
            catch (ParseException e) {
                this.logElementError(localName, e);
            }
        }
        if ("creation".equals(localName) && StringUtils.isNotEmpty(this.buffer.toString().trim())) {
            try {
                this.currentDocument.setCreation(df.parse(this.buffer.toString().trim()));
            }
            catch (ParseException e) {
                this.logElementError(localName, e);
            }
        }
        this.readPublishingDates(localName, df);
    }

    protected void readPublishingDates(String localName, DateFormat df) {
        if ("startpublishing".equals(localName)) {
            try {
                if (this.buffer != null && StringUtils.isNotEmpty(this.buffer.toString().trim())) {
                    this.currentDocument.setStartPublishing(df.parse(this.buffer.toString().trim()));
                }
            }
            catch (ParseException e) {
                this.logElementError(localName, e);
            }
        }
        if ("stoppublishing".equals(localName)) {
            try {
                if (this.buffer != null && StringUtils.isNotEmpty(this.buffer.toString().trim())) {
                    this.currentDocument.setStopPublishing(df.parse(this.buffer.toString().trim()));
                }
            }
            catch (ParseException e) {
                this.logElementError(localName, e);
            }
        }
    }

    protected void readVersions(String localName) {
        if ("version".equals(localName)) {
            this.currentDocument.setVersion(this.buffer.toString().trim());
        }
        if ("fileversion".equals(localName)) {
            this.currentDocument.setFileVersion(this.buffer.toString().trim());
        }
        if ("revision".equals(localName)) {
            this.currentDocument.setRevision(this.buffer.toString().trim());
        }
    }

    protected void readImmutable(String localName) {
        if ("immutable".equals(localName)) {
            try {
                this.currentDocument.setImmutable(Integer.parseInt(this.buffer.toString().trim()));
            }
            catch (NumberFormatException e) {
                this.logElementError(localName, e);
            }
        }
    }

    private void readPath(String localName) {
        if ("pathextended".equals(localName)) {
            try {
                ((IndexVersion)this.currentDocument).setPath(this.buffer.toString().trim());
            }
            catch (NumberFormatException e) {
                this.logElementError(localName, e);
            }
        }
    }

    private void logCustomAttributeError(String localName, ParseException e) {
        log.warn("custom attribute {}: {}", (Object)localName, (Object)e.getMessage());
    }

    private void logElementError(String localName, Exception e) {
        log.warn("element <{}>: {}", (Object)localName, (Object)e.getMessage());
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        int i = 0;
        while (i < length) {
            this.buffer.append(ch[i + start]);
            ++i;
        }
    }

    public Archive getArchive() {
        return this.archive;
    }

    public long getCount() {
        return this.count;
    }

    public String getSizediplay() {
        return this.sizeDiplay;
    }

    public String getProgramVersion() {
        return this.programVersion;
    }

    public String getArchiveVersion() {
        return this.archiveVersion;
    }

    public AbstractDocument getCurrentDocument() {
        return this.currentDocument;
    }
}

