/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.impex;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.Version;
import com.logicaldoc.core.document.VersionDAO;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.metadata.Attribute;
import com.logicaldoc.core.metadata.TemplateDAO;
import com.logicaldoc.impex.Archive;
import com.logicaldoc.impex.Index;
import com.logicaldoc.util.csv.CSVFileWriter;
import com.logicaldoc.util.spring.Context;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexCSV
extends CSVFileWriter {
    private static final String YYYY_MM_DD_T_HH_MM_SS = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String TEMPLATE = "template";
    private static final String PUBLISHED = "published";
    private static final String STOPPUBLISHING = "stoppublishing";
    private static final String STARTPUBLISHING = "startpublishing";
    private static final String DATE = "date";
    private static final String CREATION = "creation";
    private static final String IMMUTABLE = "immutable";
    private static final String TAGS = "tags";
    private static final String STATUS = "status";
    private static final String LANGUAGE = "language";
    private static final String PATHEXTENDED = "pathextended";
    private static final String PATH = "path";
    private static final String FILENAME = "filename";
    private static final String CUSTOMID = "customid";
    private static final String ID = "id";
    private static final String VERSION = "version";
    private static final String FILEVERSION = "fileversion";
    private static final String REVISION = "revision";
    private static final String FILESIZE = "filesize";
    private static final String OCRTEMPLATE = "ocrtemplate";
    private static final String BARCODETEMPLATE = "barcodetemplate";
    private static final String COLOR = "color";
    private static final String COMMENT = "comment";
    private static final Logger log = LoggerFactory.getLogger(IndexCSV.class);
    private Archive archive;
    private Map<String, Integer> header = new HashMap<String, Integer>();
    private List<String> headerLine = new ArrayList<String>();
    private Map<Long, String> templateNames = new HashMap<Long, String>();

    public IndexCSV(File file) throws IOException, PersistenceException {
        this(file, new Archive());
    }

    public IndexCSV(File file, Archive archive) throws IOException, PersistenceException {
        super(file.getAbsolutePath(), ';', '\"', false);
        this.archive = archive;
        this.headerLine.add(ID);
        this.headerLine.add(CUSTOMID);
        this.headerLine.add(FILENAME);
        this.headerLine.add(VERSION);
        this.headerLine.add(FILEVERSION);
        this.headerLine.add(REVISION);
        this.headerLine.add(FILESIZE);
        this.headerLine.add(DATE);
        this.headerLine.add(CREATION);
        this.headerLine.add(LANGUAGE);
        this.headerLine.add(STATUS);
        this.headerLine.add(PUBLISHED);
        this.headerLine.add(STARTPUBLISHING);
        this.headerLine.add(STOPPUBLISHING);
        this.headerLine.add(IMMUTABLE);
        this.headerLine.add(STATUS);
        this.headerLine.add(TAGS);
        this.headerLine.add(PATH);
        this.headerLine.add(PATHEXTENDED);
        this.headerLine.add(COLOR);
        this.headerLine.add(COMMENT);
        this.headerLine.add(OCRTEMPLATE);
        this.headerLine.add(BARCODETEMPLATE);
        this.headerLine.add(TEMPLATE);
        VersionDAO verDao = Context.get(VersionDAO.class);
        for (Version entry : archive.getEntries()) {
            verDao.initialize(entry);
            for (String attribute : entry.getAttributeNames()) {
                if (this.headerLine.contains(attribute)) continue;
                this.headerLine.add(attribute);
            }
        }
        int column = 0;
        for (String field : this.headerLine) {
            this.header.put(field, column++);
        }
        TemplateDAO tDao = Context.get(TemplateDAO.class);
        this.templateNames = tDao.findAll(archive.getTenantId()).stream().collect(Collectors.toMap(t -> t.getId(), t -> t.getName()));
    }

    public void marshall() {
        log.info("Write the CSV header");
        this.writeFields(this.headerLine);
        log.info("Iterate the archive entries");
        VersionDAO verDao = Context.get(VersionDAO.class);
        FolderDAO folderDao = Context.get(FolderDAO.class);
        int row = 1;
        for (Version entry : this.archive.getEntries()) {
            try {
                verDao.initialize(entry);
                ArrayList<String> line = new ArrayList<String>();
                int i = 0;
                while (i <= this.header.size()) {
                    line.add("");
                    ++i;
                }
                line.set(this.headerLine.indexOf(ID), Long.toString(entry.getDocId()));
                this.setCustomId(entry, line);
                this.setFileName(entry, line);
                this.setVersion(entry, line);
                line.set(this.headerLine.indexOf(FILESIZE), Long.toString(entry.getFileSize()));
                this.setDates(entry, line);
                if (entry.getLanguage() != null) {
                    line.set(this.headerLine.indexOf(LANGUAGE), entry.getLanguage());
                }
                line.set(this.headerLine.indexOf(STATUS), Integer.toString(entry.getStatus().ordinal()));
                line.set(this.headerLine.indexOf(PUBLISHED), Integer.toString(entry.getPublished()));
                line.set(this.headerLine.indexOf(IMMUTABLE), Integer.toString(entry.getImmutable()));
                this.setPublishing(entry, line);
                this.setTags(entry, line);
                String pathExtended = folderDao.computePathExtended(entry.getFolderId());
                pathExtended = pathExtended.replaceAll("/+", "/");
                line.set(this.headerLine.indexOf(PATHEXTENDED), pathExtended);
                line.set(this.headerLine.indexOf(PATH), ("docs/" + pathExtended + "/" + entry.getFileName()).replaceAll("/+", "/"));
                if (entry.getColor() != null) {
                    line.set(this.headerLine.indexOf(COLOR), entry.getColor());
                }
                if (entry.getComment() != null) {
                    line.set(this.headerLine.indexOf(COMMENT), entry.getComment());
                }
                this.setTemplate(entry, line);
                this.setExtendedAttributes(entry, line);
                this.writeFields(line);
                log.debug("Written row {}: {}", (Object)row++, (Object)entry);
            }
            catch (Exception e) {
                log.error("Error prrocessing entry {}", (Object)entry);
                log.error(e.getMessage(), e);
            }
        }
    }

    private void setExtendedAttributes(Version entry, List<String> line) {
        if (CollectionUtils.isEmpty(entry.getAttributeNames())) {
            return;
        }
        SimpleDateFormat df = new SimpleDateFormat(YYYY_MM_DD_T_HH_MM_SS);
        for (String name : entry.getAttributeNames()) {
            int column = this.headerLine.indexOf(name);
            Attribute attribute = entry.getAttribute(name);
            this.setExtendedAttribute(line, df, column, attribute);
        }
    }

    private void setExtendedAttribute(List<String> line, DateFormat df, int column, Attribute attribute) {
        switch (attribute.getType()) {
            case 5: {
                if (attribute.getBooleanValue() == null) break;
                line.set(column, attribute.getBooleanValue() != false ? "1" : "0");
                break;
            }
            case 3: {
                if (attribute.getDateValue() == null) break;
                line.set(column, df.format(attribute.getDateValue()));
                break;
            }
            case 2: {
                if (attribute.getDoubleValue() == null) break;
                line.set(column, attribute.getDoubleValue().toString());
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                if (attribute.getIntValue() == null) break;
                line.set(column, attribute.getIntValue().toString());
                break;
            }
            default: {
                if (attribute.getStringValue() == null) break;
                line.set(column, attribute.getStringValue());
            }
        }
    }

    private void setTemplate(Version entry, List<String> line) {
        if (entry.getOcrTemplateId() != null) {
            line.set(this.headerLine.indexOf(OCRTEMPLATE), Index.getOcrTemplateName(entry.getOcrTemplateId()));
        }
        if (entry.getBarcodeTemplateId() != null) {
            line.set(this.headerLine.indexOf(BARCODETEMPLATE), Index.getBarcodeTemplateName(entry.getBarcodeTemplateId()));
        }
        if (entry.getTemplateId() != null && this.templateNames.get(entry.getTemplateId()) != null) {
            line.set(this.headerLine.indexOf(TEMPLATE), this.templateNames.get(entry.getTemplateId()));
        }
    }

    private void setTags(Version entry, List<String> line) {
        if (StringUtils.isNotEmpty((CharSequence)entry.getTgs())) {
            line.set(this.headerLine.indexOf(TAGS), entry.getTgs());
        }
    }

    private void setPublishing(Version entry, List<String> line) {
        SimpleDateFormat df = new SimpleDateFormat(YYYY_MM_DD_T_HH_MM_SS);
        if (entry.getStartPublishing() != null) {
            line.set(this.headerLine.indexOf(STARTPUBLISHING), df.format(entry.getStartPublishing()));
        }
        if (entry.getStopPublishing() != null) {
            line.set(this.headerLine.indexOf(STOPPUBLISHING), df.format(entry.getStopPublishing()));
        }
    }

    private void setDates(Version entry, List<String> line) {
        SimpleDateFormat df = new SimpleDateFormat(YYYY_MM_DD_T_HH_MM_SS);
        if (entry.getDate() != null) {
            line.set(this.headerLine.indexOf(DATE), df.format(entry.getDate()));
        }
        if (entry.getCreation() != null) {
            line.set(this.headerLine.indexOf(CREATION), df.format(entry.getCreation()));
        }
    }

    private void setVersion(Version entry, List<String> line) {
        if (StringUtils.isNotEmpty((CharSequence)entry.getVersion())) {
            line.set(this.headerLine.indexOf(VERSION), entry.getVersion());
        }
        if (StringUtils.isNotEmpty((CharSequence)entry.getFileVersion())) {
            line.set(this.headerLine.indexOf(FILEVERSION), entry.getFileVersion());
        }
        if (StringUtils.isNotEmpty((CharSequence)entry.getRevision())) {
            line.set(this.headerLine.indexOf(REVISION), entry.getRevision());
        }
    }

    private void setFileName(Version entry, List<String> line) {
        if (entry.getFileName() != null) {
            line.set(this.headerLine.indexOf(FILENAME), entry.getFileName());
        }
    }

    private void setCustomId(Version entry, List<String> line) {
        if (entry.getCustomId() != null) {
            line.set(this.headerLine.indexOf(CUSTOMID), entry.getCustomId());
        }
    }
}

