/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.impex;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.Version;
import com.logicaldoc.core.document.VersionDAO;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.metadata.Attribute;
import com.logicaldoc.impex.Archive;
import com.logicaldoc.impex.ArchiveDAO;
import com.logicaldoc.impex.IndexHandler;
import com.logicaldoc.impex.IndexImportHandler;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.io.ResourceUtil;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.util.sql.SqlUtil;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.helpers.DefaultHandler;

public class Index {
    public static final String ARCHIVE_VERSION = "9.2.1";
    private static final Logger log = LoggerFactory.getLogger(Index.class);
    private DateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private NumberFormat decimalFormat = new DecimalFormat("####################,####");
    private NumberFormat integerFormat = new DecimalFormat("####################");
    private File file;
    private Archive archive;
    private long count;
    private String sizeDisplay = "";
    protected String programVersion = "";
    protected String archiveVersion = "";

    public Index(Archive archive) {
        this.archive = archive;
    }

    public Index(File file) {
        this.file = file;
    }

    public Index(byte[] indexContent, IndexHandler handler) throws ParserConfigurationException, SAXException, IOException {
        this.unmarshall(indexContent, handler);
    }

    public Index(File file, IndexHandler handler) throws IOException, ParserConfigurationException, SAXException {
        this.file = file;
        this.unmarshall(handler);
    }

    public Index(byte[] indexContent, IndexImportHandler handler) throws ParserConfigurationException, SAXException, IOException {
        this.unmarshall(indexContent, (IndexHandler)handler);
    }

    public File getFile() {
        return this.file;
    }

    public void marshall() throws IOException, PersistenceException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedWriter writer = new BufferedWriter(new PrintWriter(this.file, "UTF-8"), 4096);){
            this.marshall(writer);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void marshall(Writer writer) throws IOException, PersistenceException {
        log.info("Marshall index file");
        this.writeImpexParams(writer);
        VersionDAO verDao = Context.get(VersionDAO.class);
        for (Version version : this.archive.getEntries()) {
            if (version.getDigest() == null) {
                verDao.updateDigest(version);
            }
            version = (Version)verDao.findById(version.getId());
            verDao.initialize(version);
            this.writeDocument(writer, version);
            if (!version.getAttributes().isEmpty()) {
                writer.write("\n    <attributes>\n");
                this.writeExtendedAttributes(writer, version);
                writer.write("    </attributes>");
            }
            writer.write("\n  </document>\n");
        }
        writer.write("</impex>");
        log.info("Index file completed");
    }

    private void writeExtendedAttributes(Writer writer, Version version) throws IOException {
        for (String attributeName : version.getAttributeNames()) {
            Attribute attribute = version.getAttributes().get(attributeName);
            Object[] attributesParams = this.prepareExtendedAttributeParams(attributeName, attribute, version);
            this.writeExtendedAttribute(writer, attributeName, version, attributesParams);
            writer.write("\n");
        }
    }

    private Object[] prepareExtendedAttributeParams(String attributeName, Attribute attribute, Version version) {
        Object[] attributesParams = new Object[13];
        int i = 0;
        while (i < attributesParams.length) {
            Object value = null;
            switch (i) {
                case 0: {
                    value = attributeName;
                    break;
                }
                case 1: {
                    value = attribute.getMandatory();
                    break;
                }
                case 2: {
                    value = attribute.getPosition();
                    break;
                }
                case 3: {
                    value = this.getAttributeValue(attributeName, version);
                    break;
                }
                case 4: {
                    value = StringUtils.trimToEmpty(attribute.getLabel());
                    break;
                }
                case 5: {
                    value = attribute.getType();
                    break;
                }
                case 6: {
                    value = this.getValueForParameter6(attributeName, attribute, version);
                    break;
                }
                case 7: {
                    value = this.getValueForParameter7(attributeName, attribute, version);
                    break;
                }
                case 8: {
                    value = this.getValueForParameter8(attributeName, attribute, version);
                    break;
                }
                case 9: {
                    value = this.getValueForParameter9(attributeName, attribute, version);
                    break;
                }
                case 10: {
                    value = this.getValueForParameter10(attributeName, attribute, version);
                    break;
                }
                case 11: {
                    value = this.getValueForParameter11(attributeName, attribute, version);
                    break;
                }
                case 12: {
                    value = attribute.getReadonly();
                    break;
                }
            }
            attributesParams[i] = value;
            ++i;
        }
        return attributesParams;
    }

    private Object getValueForParameter11(String attributeName, Attribute attribute, Version version) {
        Object value = version.getAttribute(attributeName).getType() == 4 || version.getAttribute(attributeName).getType() == 6 || version.getAttribute(attributeName).getType() == 7 ? (attribute.getParent() != null ? attribute.getParent() : "") : Integer.valueOf(attribute.getReadonly());
        return value;
    }

    private Object getValueForParameter10(String attributeName, Attribute attribute, Version version) {
        Object value = version.getAttribute(attributeName).getType() == 4 || version.getAttribute(attributeName).getType() == 6 || version.getAttribute(attributeName).getType() == 7 ? Integer.valueOf(attribute.getMultiple()) : (attribute.getParent() != null ? attribute.getParent() : "");
        return value;
    }

    private Object getValueForParameter9(String attributeName, Attribute attribute, Version version) {
        Integer value = version.getAttribute(attributeName).getType() == 4 || version.getAttribute(attributeName).getType() == 6 || version.getAttribute(attributeName).getType() == 7 ? Integer.valueOf(attribute.getHidden()) : Integer.valueOf(attribute.getMultiple());
        return value;
    }

    private Object getValueForParameter8(String attributeName, Attribute attribute, Version version) {
        Integer value = version.getAttribute(attributeName).getType() == 4 || version.getAttribute(attributeName).getType() == 6 || version.getAttribute(attributeName).getType() == 7 ? Integer.valueOf(attribute.getEditor()) : Integer.valueOf(attribute.getHidden());
        return value;
    }

    private Object getValueForParameter7(String attributeName, Attribute attribute, Version version) {
        Object value = version.getAttribute(attributeName).getType() == 4 || version.getAttribute(attributeName).getType() == 6 || version.getAttribute(attributeName).getType() == 7 ? (attribute.getSetId() != null ? this.integerFormat.format(attribute.getSetId()) : "") : Integer.valueOf(attribute.getEditor());
        return value;
    }

    private Object getValueForParameter6(String attributeName, Attribute attribute, Version version) {
        String value = version.getAttribute(attributeName).getType() == 4 || version.getAttribute(attributeName).getType() == 6 || version.getAttribute(attributeName).getType() == 7 ? attribute.getStringValue() : (attribute.getSetId() != null ? this.integerFormat.format(attribute.getSetId()) : "");
        return value;
    }

    private Object getAttributeValue(String attributeName, Version version) {
        Object value = version.getAttribute(attributeName).getType() == 3 ? (version.getAttribute(attributeName).getValue() != null ? this.df.format(version.getAttribute(attributeName).getValue()) : "") : (version.getAttribute(attributeName).getType() == 2 ? (version.getAttribute(attributeName).getValue() != null ? this.decimalFormat.format(version.getAttribute(attributeName).getDoubleValue()) : "") : (version.getAttribute(attributeName).getType() == 1 || version.getAttribute(attributeName).getType() == 5 || version.getAttribute(attributeName).getType() == 4 || version.getAttribute(attributeName).getType() == 6 || version.getAttribute(attributeName).getType() == 7 ? (version.getAttribute(attributeName).getIntValue() != null ? this.integerFormat.format(version.getAttribute(attributeName).getIntValue()) : "") : (version.getAttribute(attributeName).getValue() != null ? version.getAttribute(attributeName).getValue() : "")));
        return value;
    }

    private void writeExtendedAttribute(Writer writer, String attributeName, Version version, Object[] attributesParams) throws IOException {
        if (version.getAttribute(attributeName).getType() == 0) {
            writer.write(MessageFormat.format(ResourceUtil.readAsString("/templates/attributes_template_string.xml"), attributesParams));
        } else if (version.getAttribute(attributeName).getType() == 1) {
            writer.write(MessageFormat.format(ResourceUtil.readAsString("/templates/attributes_template_int.xml"), attributesParams));
        } else if (version.getAttribute(attributeName).getType() == 5) {
            writer.write(MessageFormat.format(ResourceUtil.readAsString("/templates/attributes_template_boolean.xml"), attributesParams));
        } else if (version.getAttribute(attributeName).getType() == 2) {
            writer.write(MessageFormat.format(ResourceUtil.readAsString("/templates/attributes_template_double.xml"), attributesParams));
        } else if (version.getAttribute(attributeName).getType() == 3) {
            writer.write(MessageFormat.format(ResourceUtil.readAsString("/templates/attributes_template_date.xml"), attributesParams));
        } else if (version.getAttribute(attributeName).getType() == 4 || version.getAttribute(attributeName).getType() == 6 || version.getAttribute(attributeName).getType() == 7) {
            writer.write(MessageFormat.format(ResourceUtil.readAsString("/templates/attributes_template_user.xml"), attributesParams));
        }
    }

    private void writeDocument(Writer writer, Version version) throws PersistenceException, IOException {
        log.debug("Write version {},{},{} ({})", version.getId(), version.getFileVersion(), version.getRevision(), version.getFileName());
        FolderDAO folderDao = Context.get(FolderDAO.class);
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        Folder versionFolder = folderDao.findFolder(version.getFolderId());
        Object[] docParams = new Object[29];
        int i = 0;
        while (i < docParams.length) {
            Object value = null;
            switch (i) {
                case 0: {
                    value = this.integerFormat.format(version.getDocId());
                    break;
                }
                case 1: {
                    value = StringUtils.trimToEmpty(version.getCustomId());
                    break;
                }
                case 2: {
                    value = StringUtils.trimToEmpty(version.getFileName());
                    break;
                }
                case 3: {
                    value = StringUtils.trimToEmpty(version.getVersion());
                    break;
                }
                case 4: {
                    value = StringUtils.trimToEmpty(version.getFileVersion());
                    break;
                }
                case 5: {
                    value = version.getCreation() != null ? this.df.format(version.getCreation()) : "";
                    break;
                }
                case 6: {
                    value = StringUtils.trimToEmpty(version.getCreator());
                    break;
                }
                case 7: {
                    value = this.integerFormat.format(version.getCreatorId());
                    break;
                }
                case 8: {
                    value = version.getDate() != null ? this.df.format(version.getDate()) : "";
                    break;
                }
                case 9: {
                    value = StringUtils.trimToEmpty(version.getPublisher());
                    break;
                }
                case 10: {
                    value = this.integerFormat.format(version.getPublisherId());
                    break;
                }
                case 11: {
                    value = StringUtils.trimToEmpty(version.getLanguage());
                    break;
                }
                case 12: {
                    value = StringUtils.trimToEmpty(version.getTgs());
                    break;
                }
                case 13: {
                    value = Integer.toString(version.getStatus().ordinal());
                    break;
                }
                case 14: {
                    value = Integer.toString(version.getSigned());
                    break;
                }
                case 15: {
                    value = Integer.toString(version.getImmutable());
                    break;
                }
                case 16: {
                    value = StringUtils.trimToEmpty(version.getDigest());
                    break;
                }
                case 17: {
                    value = Integer.toString(version.getPublished());
                    break;
                }
                case 18: {
                    value = version.getStartPublishing() != null ? this.df.format(version.getStartPublishing()) : "";
                    break;
                }
                case 19: {
                    value = version.getStopPublishing() != null ? this.df.format(version.getStopPublishing()) : "";
                    break;
                }
                case 20: {
                    Object path = "docs" + folderDao.computePathExtended(versionFolder.getId()) + "/" + version.getFileName();
                    value = path = ((String)path).replace("//", "/");
                    break;
                }
                case 21: {
                    Document doc = (Document)docDao.findById(version.getDocId());
                    value = folderDao.computePathExtended(doc.getFolder().getId());
                    break;
                }
                case 22: {
                    value = StringUtils.trimToEmpty(version.getComment());
                    break;
                }
                case 23: {
                    value = StringUtils.trimToEmpty(version.getColor());
                    break;
                }
                case 24: {
                    value = this.integerFormat.format(version.getFileSize());
                    break;
                }
                case 25: {
                    value = Index.getOcrTemplateName(version.getOcrTemplateId());
                    break;
                }
                case 26: {
                    value = Index.getBarcodeTemplateName(version.getBarcodeTemplateId());
                    break;
                }
                case 27: {
                    value = StringUtils.trimToEmpty(version.getTemplateName());
                    break;
                }
                case 28: {
                    value = StringUtils.trimToEmpty(version.getRevision());
                    break;
                }
            }
            docParams[i] = value;
            ++i;
        }
        writer.write(MessageFormat.format(ResourceUtil.readAsString("/templates/document_template.xml"), docParams));
    }

    private void writeImpexParams(Writer writer) throws IOException, PersistenceException {
        ArchiveDAO archiveDao = Context.get(ArchiveDAO.class);
        ContextProperties context = new ContextProperties();
        Object[] impexParams = new Object[16];
        int i = 0;
        while (i < impexParams.length) {
            Object value = null;
            switch (i) {
                case 0: {
                    value = this.integerFormat.format(this.archive.getId());
                    break;
                }
                case 1: {
                    value = this.archive.getName();
                    break;
                }
                case 2: {
                    value = !StringUtils.isEmpty(this.archive.getDescription()) ? this.archive.getDescription() : "-";
                    break;
                }
                case 3: {
                    value = this.archive.getCreation();
                    break;
                }
                case 4: {
                    value = this.integerFormat.format(this.archive.getCreatorId());
                    break;
                }
                case 5: {
                    value = this.archive.getCreatorName();
                    break;
                }
                case 6: {
                    value = this.archive.getClosure();
                    break;
                }
                case 7: {
                    value = this.integerFormat.format(this.archive.getCloserId());
                    break;
                }
                case 8: {
                    value = this.archive.getCloserName();
                    break;
                }
                case 9: {
                    value = this.integerFormat.format(this.archive.getSize());
                    break;
                }
                case 10: {
                    value = FileUtil.getDisplaySize(this.archive.getSize(), "en");
                    break;
                }
                case 11: {
                    value = this.integerFormat.format(archiveDao.findArchivedIds(this.archive.getId()).size());
                    break;
                }
                case 12: {
                    value = context.getProperty("product.release");
                    break;
                }
                case 13: {
                    value = ARCHIVE_VERSION;
                    break;
                }
                case 14: {
                    value = this.archive.getType() == 0 ? "default" : "unknown";
                    break;
                }
            }
            impexParams[i] = value;
            ++i;
        }
        writer.write(MessageFormat.format(ResourceUtil.readAsString("/templates/impex_template.xml"), impexParams));
    }

    public static String getBarcodeTemplateName(Long id) {
        String name;
        block4: {
            if (id == null || id == 0L) {
                return "";
            }
            VersionDAO dao = Context.get(VersionDAO.class);
            try {
                name = dao.queryForString("select ld_name from ld_barcodetemplate where ld_deleted=0 and ld_id=" + String.valueOf(id));
                if (!"null".equals(name)) break block4;
                return "";
            }
            catch (PersistenceException e) {
                log.warn(e.getMessage(), e);
                return "";
            }
        }
        return name;
    }

    public static String getOcrTemplateName(Long id) {
        String name;
        block4: {
            if (id == null || id == 0L) {
                return "";
            }
            VersionDAO dao = Context.get(VersionDAO.class);
            try {
                name = dao.queryForString("select ld_name from ld_ocrtemplate where ld_deleted=0 and ld_id=" + String.valueOf(id));
                if (!"null".equals(name)) break block4;
                return "";
            }
            catch (PersistenceException e) {
                log.warn(e.getMessage(), e);
                return "";
            }
        }
        return name;
    }

    public static Long getBarcodeTemplateId(String name) throws PersistenceException {
        if (name == null || "".contentEquals(name)) {
            return null;
        }
        VersionDAO dao = Context.get(VersionDAO.class);
        return dao.queryForLong("select ld_id from ld_barcodetemplate where ld_deleted=0 and ld_name='" + SqlUtil.doubleQuotes(name) + "'");
    }

    public static Long getOcrTemplateId(String name) throws PersistenceException {
        if (name == null || "".contentEquals(name)) {
            return null;
        }
        VersionDAO dao = Context.get(VersionDAO.class);
        return dao.queryForLong("select ld_id from ld_ocrtemplate where ld_deleted=0 and ld_name='" + SqlUtil.doubleQuotes(name) + "'");
    }

    public void unmarshall() throws IOException, ParserConfigurationException, SAXException {
        this.unmarshall(null);
    }

    public void unmarshall(IndexHandler dataHandler) throws IOException, ParserConfigurationException, SAXException {
        if (this.file == null) {
            return;
        }
        this.unmarshall(FileUtils.readFileToByteArray(this.file), dataHandler);
    }

    public void unmarshall(byte[] indexContent, IndexHandler dataHandler) throws ParserConfigurationException, SAXException, IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(indexContent);
        this.unmarshall(is, dataHandler);
    }

    public void unmarshall(InputStream is, IndexHandler dataHandler) throws ParserConfigurationException, SAXException, IOException {
        IndexHandler handler;
        block16: {
            handler = dataHandler;
            if (handler == null) {
                handler = new IndexHandler();
            }
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            SAXParser saxParser = factory.newSAXParser();
            try {
                saxParser.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                saxParser.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                // empty catch block
            }
            try {
                try {
                    if (this.file != null) {
                        saxParser.parse(this.file, (DefaultHandler)handler);
                    } else {
                        saxParser.parse(new InputSource(is), (DefaultHandler)handler);
                    }
                    this.archive = handler.getArchive();
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.count = handler.getCount();
        this.sizeDisplay = handler.getSizediplay();
        this.programVersion = handler.getProgramVersion();
        this.archiveVersion = handler.getArchiveVersion();
    }

    public Archive getArchive() {
        return this.archive;
    }

    public void setArchive(Archive archive) {
        this.archive = archive;
    }

    public long getCount() {
        return this.count;
    }

    public String getSizedisplay() {
        return this.sizeDisplay;
    }

    public String getProgramVersion() {
        return this.programVersion;
    }

    public String getArchiveVersion() {
        return this.archiveVersion;
    }
}

