/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.impex;

import com.logicaldoc.core.generic.Generic;
import com.logicaldoc.core.generic.GenericDAO;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.i18n.I18N;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.util.ServletUtil;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalArchivesDataServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(IncrementalArchivesDataServlet.class);

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            Session session = ServletUtil.validateSession(request);
            String locale = request.getParameter("locale");
            int type = Integer.parseInt(request.getParameter("type"));
            response.setContentType("text/xml");
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Cache-Control", "no-cache,no-store,must-revalidate");
            response.setHeader("Expires", "0");
            response.setHeader("Pragma", "no-cache");
            GenericDAO dao = Context.get(GenericDAO.class);
            List<Generic> generics = dao.findByTypeAndSubtype("incremental_archive", null, null, session.getTenantId());
            PrintWriter writer = response.getWriter();
            writer.write("<list>");
            for (Generic generic : generics) {
                if (generic.getInteger1() != (long)type) continue;
                writer.print("<archive>");
                writer.print("<id>" + generic.getId() + "</id>");
                writer.print("<prefix><![CDATA[" + generic.getSubtype() + "]]></prefix>");
                writer.print("<frequency>" + String.valueOf(generic.getInteger2()) + "</frequency>");
                writer.print("<type>" + String.valueOf(generic.getInteger1()) + "</type>");
                writer.print("<typelabel>" + I18N.message("default", locale) + "</typelabel>");
                writer.print("</archive>");
            }
            writer.write("</list>");
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            Exception exception = e;
            Objects.requireNonNull(exception);
            Exception exception2 = exception;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ServletException.class, IOException.class}, (Object)exception2, n)) {
                case 0: {
                    ServletException se = (ServletException)((Object)exception2);
                    throw se;
                }
                case 1: {
                    IOException ioe = (IOException)exception2;
                    throw ioe;
                }
            }
            new ServletException(e.getMessage(), (Throwable)e);
        }
    }
}

