/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.impex;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.automation.AutomationException;
import com.logicaldoc.core.communication.EMail;
import com.logicaldoc.core.communication.EMailSender;
import com.logicaldoc.core.communication.Message;
import com.logicaldoc.core.communication.MessageTemplate;
import com.logicaldoc.core.communication.MessageTemplateDAO;
import com.logicaldoc.core.communication.Recipient;
import com.logicaldoc.core.communication.SystemMessage;
import com.logicaldoc.core.communication.SystemMessageDAO;
import com.logicaldoc.core.document.Version;
import com.logicaldoc.core.document.VersionDAO;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.generic.Generic;
import com.logicaldoc.core.generic.GenericDAO;
import com.logicaldoc.core.metadata.Template;
import com.logicaldoc.core.metadata.TemplateDAO;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.task.Task;
import com.logicaldoc.i18n.I18N;
import com.logicaldoc.impex.Archive;
import com.logicaldoc.impex.ArchiveDAO;
import com.logicaldoc.impex.ArchiveManager;
import com.logicaldoc.util.spring.Context;
import jakarta.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="incrementalArchiveCreator")
public class IncrementalArchiveCreator
extends Task {
    public static final String NAME = "IncrementalArchiveCreator";
    public static final String GENERIC_TYPE = "incremental_archive";
    @Resource(name="genericDAO")
    protected GenericDAO genericDao;
    @Resource(name="templateDAO")
    protected TemplateDAO templateDao;
    @Resource(name="archiveDAO")
    protected ArchiveDAO archiveDao;
    @Resource(name="archiveManager")
    protected ArchiveManager archiveManager;
    @Resource(name="versionDAO")
    protected VersionDAO versionDao;
    @Resource(name="folderDAO")
    protected FolderDAO folderDao;
    @Resource(name="messageTemplateDAO")
    protected MessageTemplateDAO messageTemplateDao;
    private static final String DATE_PATTERN = "yyyyMMdd-HHmmss";
    private long closed = 0L;
    private long created = 0L;
    private long errors = 0L;

    public IncrementalArchiveCreator() {
        super(NAME);
        this.log = LoggerFactory.getLogger(IncrementalArchiveCreator.class);
    }

    @Override
    public boolean isIndeterminate() {
        return false;
    }

    @Override
    public boolean isConcurrent() {
        return false;
    }

    @Override
    protected void runTask() {
        this.log.info("Start creation of incremental archives");
        this.closed = 0L;
        this.errors = 0L;
        this.created = 0L;
        try {
            try {
                List<Generic> incrementalConfigs = this.genericDao.findByTypeAndSubtype(GENERIC_TYPE, null, null, null);
                this.size = incrementalConfigs.size();
                this.log.info("Found a total of {} configurations to be processed", (Object)this.size);
                for (Generic config : incrementalConfigs) {
                    if (this.interruptRequested) {
                        break;
                    }
                    this.processConfigurationWithTrapping(config);
                    this.next();
                }
            }
            catch (PersistenceException pe) {
                this.log.error(pe.getMessage(), pe);
                this.log.info("Process finished");
                this.log.info("Created archives: {}", (Object)this.created);
                this.log.info("Closed archives: {}", (Object)this.closed);
                this.log.info("Errors: {}", (Object)this.errors);
            }
        }
        finally {
            this.log.info("Process finished");
            this.log.info("Created archives: {}", (Object)this.created);
            this.log.info("Closed archives: {}", (Object)this.closed);
            this.log.info("Errors: {}", (Object)this.errors);
        }
    }

    @Override
    protected String prepareReport(Locale locale) {
        StringBuilder sb = new StringBuilder();
        sb.append(I18N.message("createdarchives", locale) + ": ");
        sb.append(this.created);
        sb.append("\n");
        sb.append(I18N.message("closedarchives", locale) + ": ");
        sb.append(this.closed);
        sb.append("\n");
        sb.append(I18N.message("errors", locale) + ": ");
        sb.append(this.errors);
        return sb.toString();
    }

    private void processConfigurationWithTrapping(Generic config) {
        try {
            this.processConfig(config);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), e);
            ++this.errors;
        }
    }

    private void processConfig(Generic config) throws PersistenceException {
        this.genericDao.initialize(config);
        String prefix = config.getSubtype();
        int type = config.getInteger1().intValue();
        int frequency = config.getInteger2().intValue();
        String creatorName = config.getString2();
        long creatorId = (long)config.getDouble1().doubleValue();
        Folder folder = null;
        if (config.getInteger1() != null) {
            folder = this.folderDao.findFolder(config.getInteger1());
        }
        ArrayList<Template> templates = new ArrayList<Template>();
        StringTokenizer st = new StringTokenizer(config.getString1(), ",", false);
        while (st.hasMoreTokens()) {
            String id = st.nextToken();
            Template template = (Template)this.templateDao.findById(Long.parseLong(id));
            if (template == null && "0".equals(id)) {
                template = new Template();
            }
            if (template == null) continue;
            templates.add(template);
        }
        List<Object> lastArchives = new ArrayList();
        try {
            lastArchives = this.archiveDao.findByWhere("_entity.name like '" + prefix + "_%' and _entity.status=0 and _entity.mode=1", "_entity.creation desc", null);
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
        }
        Archive lastArchive = lastArchives.stream().findFirst().orElse(null);
        if (lastArchive != null) {
            this.archiveDao.initialize(lastArchive);
        }
        this.log.info("Found {} past archives", (Object)lastArchives.size());
        if (this.mustCreateNew(lastArchive, frequency)) {
            this.log.info("Elapsed more than {} from the last export", (Object)frequency);
            this.log.info("LastArchive after mustCreateNew: {}", (Object)lastArchive);
            if (lastArchive != null) {
                this.appendEntries(lastArchive, prefix, templates, folder);
                lastArchive.setStatus(1);
                lastArchive.setCloserId(lastArchive.getCreatorId());
                lastArchive.setCloserName(lastArchive.getCreatorName());
                lastArchive.setClosure(new Date());
                ++this.closed;
                this.log.info("Closed archive {}", (Object)lastArchive.getName());
                this.archiveDao.store(lastArchive);
                this.log.info("Send a system message to the archive closer");
                this.sendMessage(lastArchive);
                this.log.info("Send the email to the archive closer");
                this.sendEmail(lastArchive);
            }
            Archive newArchive = new Archive();
            SimpleDateFormat df = new SimpleDateFormat(DATE_PATTERN);
            newArchive.setName(prefix + "_" + df.format(newArchive.getCreation()));
            newArchive.setType(type);
            newArchive.setMode(1);
            newArchive.setStatus(0);
            newArchive.setCreatorName(creatorName);
            newArchive.setCreatorId(creatorId);
            if (lastArchive == null) {
                this.appendEntries(newArchive, prefix, templates, folder);
            }
            this.archiveDao.store(newArchive);
            ++this.created;
            this.log.info("Created new archive {}", (Object)newArchive.getName());
        } else if (lastArchive != null) {
            this.appendEntries(lastArchive, prefix, templates, folder);
            this.archiveDao.store(lastArchive);
        }
    }

    private void appendEntries(Archive archive, String prefix, List<Template> templates, Folder folder) throws PersistenceException {
        StringBuilder query = new StringBuilder("select E.ld_id from ld_document A, ld_version E ");
        this.appendWhereClause(false, prefix, templates, folder, query);
        query.append(" union select E.ld_id from ld_document A, ld_version E, ld_document REF ");
        this.appendWhereClause(true, prefix, templates, folder, query);
        List<Object> ids = new ArrayList();
        try {
            ids = this.versionDao.queryForList(query.toString(), null, Long.class, null);
        }
        catch (PersistenceException persistenceException) {
            this.log.error(persistenceException.getMessage(), persistenceException);
        }
        for (Long l : ids) {
            User creator = (User)this.userDao.findById(archive.getCreatorId());
            Version version = (Version)this.versionDao.findById(l);
            this.archiveManager.addEntry(archive, version, creator, null);
        }
        this.log.info("Added {} entries to archive {}", (Object)ids.size(), (Object)archive.getName());
    }

    private void appendWhereClause(boolean searchShortcut, String prefix, List<Template> templates, Folder folder, StringBuilder query) {
        String tableAlias = "A";
        if (searchShortcut) {
            tableAlias = "REF";
        }
        if (folder != null) {
            query.append(", ld_folder F ");
        }
        query.append(" where A.ld_version=E.ld_version ");
        query.append(" and A.ld_id=E.ld_documentid ");
        query.append(" and A.ld_deleted=0 and E.ld_deleted=0 ");
        if (searchShortcut) {
            query.append(" and " + tableAlias + ".ld_deleted=0 and " + tableAlias + ".ld_docref = A.ld_id ");
        }
        this.appendFolderCondition(query, folder, searchShortcut, tableAlias);
        this.addTemplateCondition(query, templates);
        query.append(" and E.ld_id not in ( select B.ld_versionid from ld_archive_entry B, ld_archive C, ld_version D ");
        query.append(" where B.ld_archiveid=C.ld_id ");
        query.append(" and B.ld_versionid=D.ld_id ");
        query.append(" and C.ld_deleted=0 and D.ld_deleted=0 ");
        query.append(" and C.ld_name like '");
        query.append(prefix);
        query.append("%') ");
    }

    private void addTemplateCondition(StringBuilder query, List<Template> templates) {
        if (!templates.isEmpty()) {
            query.append(" and ((E.ld_templateid in (");
            boolean first = true;
            boolean foundNoTemplate = false;
            for (Template template : templates) {
                if (!first) {
                    query.append(",");
                }
                if (template.getId() == 0L) {
                    foundNoTemplate = true;
                }
                query.append(Long.toString(template.getId()));
                first = false;
            }
            query.append(")) ");
            if (foundNoTemplate) {
                query.append(" or (E.ld_templateid is null) ");
            }
            query.append(") ");
        }
    }

    private void appendFolderCondition(StringBuilder query, Folder folder, boolean searchShortcut, String tableAlias) {
        if (folder != null) {
            if (searchShortcut) {
                query.append(" and F.ld_id=" + tableAlias + ".ld_folderid and F.ld_deleted=0 ");
            } else {
                query.append(" and F.ld_id=E.ld_folderid and F.ld_deleted=0 ");
            }
            query.append(" and F.ld_id=" + folder.getId() + " ");
        }
    }

    private boolean mustCreateNew(Archive lastArchive, int frequency) {
        if (lastArchive == null || frequency <= 0) {
            return true;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(lastArchive.getCreation());
        cal.set(14, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(10, 0);
        ((Calendar)cal).add(5, frequency);
        Date nextCreation = cal.getTime();
        return new Date().after(nextCreation);
    }

    private void sendEmail(Archive archive) {
        try {
            User user = (User)this.userDao.findById(archive.getCloserId());
            EMail email = new EMail();
            email.setTenantId(archive.getTenantId());
            email.setAccountId(-1L);
            email.setAuthor("SYSTEM");
            Recipient recipient = new Recipient();
            recipient.setRead(1);
            recipient.setAddress(user.getEmail());
            email.addRecipient(recipient);
            email.setFolder("outbox");
            email.setSentDate(new Date());
            this.prepareMessage(archive, email, user);
            email.setUsername(user.getUsername());
            EMailSender sender = new EMailSender(archive.getTenantId());
            sender.send(email);
        }
        catch (Exception e) {
            this.log.warn(e.getMessage(), e);
        }
    }

    protected void prepareMessage(Archive archive, Message message, User user) throws PersistenceException, AutomationException {
        HashMap<String, Object> dictionary = new HashMap<String, Object>();
        dictionary.put("archive", archive);
        dictionary.put("locale", user.getLocale());
        MessageTemplate template = this.messageTemplateDao.findByNameAndLanguage("impex.inc", user.getLocale().toString(), archive.getTenantId());
        if (template == null) {
            throw new PersistenceException("Unable to find template impex.inc");
        }
        message.setSubject(template.getFormattedSubject(dictionary));
        message.setMessageText(template.getFormattedBody(dictionary));
    }

    private void sendMessage(Archive archive) {
        try {
            SystemMessageDAO smdao = Context.get(SystemMessageDAO.class);
            User user = (User)this.userDao.findById(archive.getCloserId());
            Date now = new Date();
            SystemMessage sysmess = new SystemMessage();
            sysmess.setAuthor("SYSTEM");
            Recipient recipient = new Recipient();
            recipient.setName(user.getUsername());
            recipient.setAddress(user.getUsername());
            recipient.setType(0);
            recipient.setMode("");
            recipient.setRead(1);
            HashSet<Recipient> recipients = new HashSet<Recipient>();
            recipients.add(recipient);
            sysmess.setRecipients(recipients);
            this.prepareMessage(archive, sysmess, user);
            sysmess.setSentDate(now);
            sysmess.setConfirmation(0);
            sysmess.setPrio(1);
            sysmess.setDateScope(10);
            smdao.store(sysmess);
        }
        catch (Exception e) {
            this.log.warn(e.getMessage(), e);
        }
    }
}

