/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.impex;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.AbstractDocument;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.Version;
import com.logicaldoc.core.document.VersionDAO;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.generic.Generic;
import com.logicaldoc.core.generic.GenericDAO;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.gui.common.client.ServerException;
import com.logicaldoc.gui.common.client.beans.GUIArchive;
import com.logicaldoc.gui.common.client.beans.GUIFolder;
import com.logicaldoc.gui.common.client.beans.GUIIncrementalArchive;
import com.logicaldoc.gui.common.client.beans.GUITemplate;
import com.logicaldoc.gui.frontend.client.services.ImpexService;
import com.logicaldoc.impex.Archive;
import com.logicaldoc.impex.ArchiveDAO;
import com.logicaldoc.impex.ArchiveManager;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.service.AbstractRemoteService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpexServiceImpl
extends AbstractRemoteService
implements ImpexService {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ImpexServiceImpl.class);

    public void delete(Session session, long archiveId) throws ServerException {
        try {
            ArchiveManager manager = Context.get(ArchiveManager.class);
            manager.delete(archiveId, session.getUser(), null);
        }
        catch (PersistenceException pe) {
            this.throwServerException(session, log, new PersistenceException("Archive has not been deleted", pe));
        }
        catch (Exception t) {
            this.throwServerException(session, log, t);
        }
    }

    public void delete(long archiveId) throws ServerException {
        this.delete(this.validateSession(), archiveId);
    }

    public GUIArchive deleteVersions(long archiveId, List<Long> versionIds) throws ServerException {
        Session session = this.validateSession();
        try {
            ArchiveDAO archiveDao = Context.get(ArchiveDAO.class);
            boolean stored = archiveDao.removeVersions(archiveId, versionIds.stream().collect(Collectors.toSet()));
            if (!stored) {
                throw new PersistenceException("Elements have not been removed");
            }
            GUIArchive arc = new GUIArchive();
            Archive archive = (Archive)archiveDao.findById(archiveId);
            archiveDao.initialize(archive);
            long size = 0L;
            for (AbstractDocument abstractDocument : archive.getEntries()) {
                size += abstractDocument.getFileSize();
            }
            archive.setSize(size);
            arc.setId(archiveId);
            arc.setCloserId(archive.getCloserId());
            arc.setCloserName(archive.getCloserName());
            arc.setClosure(archive.getClosure());
            arc.setCreation(archive.getCreation());
            arc.setCreatorId(archive.getCreatorId());
            arc.setCreatorName(archive.getCreatorName());
            arc.setDescription(archive.getDescription());
            arc.setImportCustomId(archive.getImportCustomId());
            arc.setImportTemplate(archive.getImportTemplate());
            arc.setMode(archive.getMode());
            arc.setName(archive.getName());
            arc.setSize(archive.getSize());
            arc.setStatus(archive.getStatus());
            arc.setType(archive.getType());
            return arc;
        }
        catch (Exception t) {
            return (GUIArchive)this.throwServerException(session, log, t);
        }
    }

    public void setStatus(Session session, long archiveId, int status) throws ServerException {
        try {
            if (status == 1) {
                ArchiveManager manager = Context.get(ArchiveManager.class);
                manager.closeArchive(archiveId, session.getUser());
            } else {
                ArchiveDAO archiveDao = Context.get(ArchiveDAO.class);
                Archive archive = (Archive)archiveDao.findById(archiveId);
                archiveDao.initialize(archive);
                archive.setStatus(status);
                archiveDao.store(archive, false);
            }
        }
        catch (Exception t) {
            this.throwServerException(session, log, t);
        }
    }

    public void setStatus(long archiveId, int status) throws ServerException {
        this.setStatus(this.validateSession(), archiveId, status);
    }

    public GUIArchive save(GUIArchive archive) throws ServerException {
        Session session = this.validateSession();
        try {
            ArchiveDAO archiveDao = Context.get(ArchiveDAO.class);
            Archive arc = (Archive)archiveDao.findById(archive.getId());
            if (arc != null) {
                archiveDao.initialize(arc);
            } else {
                arc = new Archive();
            }
            arc.setTenantId(session.getTenantId());
            arc.setName(archive.getName());
            arc.setCloserId(archive.getCloserId());
            arc.setCloserName(archive.getCloserName());
            arc.setClosure(archive.getClosure());
            arc.setCreatorId(archive.getCreatorId());
            arc.setCreatorName(archive.getCreatorName());
            arc.setDescription(archive.getDescription());
            arc.setImportCustomId(archive.getImportCustomId());
            arc.setImportTemplate(archive.getImportTemplate());
            arc.setMode(archive.getMode());
            arc.setStatus(archive.getStatus());
            arc.setType(archive.getType());
            archiveDao.store(arc);
            archive.setId(arc.getId());
            return archive;
        }
        catch (PersistenceException pe) {
            return (GUIArchive)this.throwServerException(session, log, new PersistenceException(String.format("Archive has not been %s", archive.getId() != 0L ? "updated" : "stored"), pe));
        }
        catch (Exception t) {
            return (GUIArchive)this.throwServerException(session, log, t);
        }
    }

    public void deleteIncremental(long id) throws ServerException {
        Session session = this.validateSession();
        GenericDAO dao = Context.get(GenericDAO.class);
        Generic generic = null;
        try {
            generic = (Generic)dao.findById(id);
            dao.initialize(generic);
            generic.setType(generic.getType() + "." + generic.getId());
            dao.store(generic);
            dao.delete(generic.getId());
        }
        catch (Exception t) {
            this.throwServerException(session, log, t);
        }
    }

    public GUIIncrementalArchive loadIncremental(long id) throws ServerException {
        Session session = this.validateSession();
        try {
            String templateEntries;
            FolderDAO folderDao;
            Folder f;
            GUIIncrementalArchive incremental = new GUIIncrementalArchive();
            incremental.setId(id);
            GenericDAO dao = Context.get(GenericDAO.class);
            Generic generic = (Generic)dao.findById(id);
            dao.initialize(generic);
            incremental.setPrefix(generic.getSubtype());
            incremental.setType(generic.getInteger1().intValue());
            incremental.setFrequency(generic.getInteger2().intValue());
            if (generic.getInteger3() != null && (f = (folderDao = Context.get(FolderDAO.class)).findFolder(generic.getInteger3())) != null) {
                GUIFolder folder = new GUIFolder();
                folder.setId(f.getId());
                folder.setName(f.getName());
                incremental.setFolder(folder);
            }
            if (StringUtils.isNotEmpty(templateEntries = generic.getString1())) {
                String[] tokens = templateEntries.split(",");
                ArrayList<GUITemplate> templates = new ArrayList<GUITemplate>();
                int i = 0;
                while (i < tokens.length) {
                    GUITemplate template = new GUITemplate();
                    template.setId(Long.parseLong(tokens[i]));
                    templates.add(template);
                    ++i;
                }
                incremental.setTemplates(templates);
            }
            return incremental;
        }
        catch (Exception t) {
            return (GUIIncrementalArchive)this.throwServerException(session, log, t);
        }
    }

    public GUIIncrementalArchive saveIncremental(GUIIncrementalArchive incremental) throws ServerException {
        Session session = this.validateSession();
        try {
            GenericDAO dao = Context.get(GenericDAO.class);
            Generic generic = (Generic)dao.findById(incremental.getId());
            if (generic != null) {
                dao.initialize(generic);
            } else {
                generic = new Generic();
            }
            generic.setTenantId(session.getTenantId());
            generic.setType("incremental_archive");
            generic.setSubtype(incremental.getPrefix());
            generic.setInteger1(Long.valueOf(incremental.getType()));
            generic.setInteger2(Long.valueOf(incremental.getFrequency()));
            generic.setInteger3(incremental.getFolder() != null ? Long.valueOf(incremental.getFolder().getId()) : null);
            generic.setString1(incremental.getTemplateIds().stream().map(id -> Long.toString(id)).collect(Collectors.joining(",")));
            generic.setDouble1(Double.parseDouble("" + session.getUserId()));
            generic.setString2(session.getUser().getFullName());
            dao.store(generic);
            incremental.setId(generic.getId());
            return incremental;
        }
        catch (PersistenceException pe) {
            return (GUIIncrementalArchive)this.throwServerException(session, log, new PersistenceException(String.format("Incremental Archive has not been %s", incremental.getId() != 0L ? "updated" : "stored"), pe));
        }
        catch (Exception t) {
            return (GUIIncrementalArchive)this.throwServerException(session, log, t);
        }
    }

    public void addDocuments(Session session, long archiveId, List<Long> documentIds) throws ServerException {
        try {
            Callable<Void> operation = () -> {
                VersionDAO versionDao = Context.get(VersionDAO.class);
                ArchiveDAO archiveDao = Context.get(ArchiveDAO.class);
                ArchiveManager manager = Context.get(ArchiveManager.class);
                Archive archive = (Archive)archiveDao.findById(archiveId);
                archiveDao.initialize(archive);
                try {
                    try {
                        Iterator iterator = documentIds.iterator();
                        while (iterator.hasNext()) {
                            long docId = (Long)iterator.next();
                            List<Version> list2 = versionDao.findByDocId(docId);
                            if (list2 == null || list2.isEmpty()) {
                                log.warn("No versions found for document {}. Was this document deleted?", (Object)docId);
                                continue;
                            }
                            Version version = list2.get(0);
                            boolean stored = manager.addEntry(archive, version, session.getUser(), session.getSid());
                            if (stored) continue;
                            log.error("Documents have not been added");
                        }
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), e);
                        archiveDao.store(archive, true);
                    }
                }
                finally {
                    archiveDao.store(archive, true);
                }
                return null;
            };
            this.executeLongRunningOperation("Add documents to export archive", operation, session);
        }
        catch (Exception t) {
            this.throwServerException(session, log, t);
        }
    }

    public void addDocuments(long archiveId, List<Long> documentIds) throws ServerException {
        this.addDocuments(this.validateSession(), archiveId, documentIds);
    }

    public void addFolder(long archiveId, long rootId) throws ServerException {
        Session session = this.validateSession();
        this.executeLongRunningOperation("Add folder to export archive", () -> {
            try {
                this.addFolder(archiveId, rootId, session);
            }
            catch (PersistenceException e) {
                log.error(e.getMessage(), e);
            }
            return null;
        }, session);
    }

    private void addFolder(long archiveId, long rootId, Session session) throws PersistenceException {
        DocumentDAO documentDao = Context.get(DocumentDAO.class);
        FolderDAO folderDao = Context.get(FolderDAO.class);
        Folder root = folderDao.findFolder(rootId);
        Collection<Long> folderIds = folderDao.findFolderIdInTree(root.getId(), false);
        for (long id : folderIds) {
            if (!folderDao.isReadAllowed(id, session.getUserId())) {
                return;
            }
            try {
                List<Long> docIds = documentDao.findDocIdByFolder(id, null);
                if (docIds.isEmpty()) continue;
                this.addDocuments(session, archiveId, docIds);
            }
            catch (Exception t) {
                log.warn(t.getMessage(), t);
            }
        }
    }

    public void deleteFolder(String folderName) throws ServerException {
        Session session = this.validateSession();
        try {
            File[] files = ImpexServiceImpl.getImportDirectory(session.getTenantName()).listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory() && files[i].getName().equals(folderName)) {
                    FileUtil.delete(files[i]);
                    break;
                }
                ++i;
            }
        }
        catch (Exception t) {
            this.throwServerException(session, log, t);
        }
    }

    public void startImport(String name) throws ServerException {
        Session session = this.validateSession();
        try {
            ArchiveDAO archiveDao = Context.get(ArchiveDAO.class);
            if (CollectionUtils.isNotEmpty(archiveDao.findByModeAndName(0, name, session.getTenantId()))) {
                throw new ServerException("An imported archive with name '" + name + "' already exists.");
            }
            Archive archive = new Archive();
            archive.setTenantId(session.getTenantId());
            archive.setName(name);
            archive.setMode(0);
            archive.setSize(0L);
            archive.setType(0);
            archive.setCreatorId(session.getUserId());
            archive.setCreatorName(session.getUser().getFullName());
            archiveDao.store(archive, false);
            File[] files = ImpexServiceImpl.getImportDirectory(session.getTenantName()).listFiles();
            File renamedDir = null;
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory() && files[i].getName().equals(archive.getName())) {
                    renamedDir = new File(String.valueOf(files[i]) + ".archive." + archive.getId());
                    boolean renamed = files[i].renameTo(renamedDir);
                    if (!renamed) {
                        log.warn("Cannot rename dir to {}", (Object)renamedDir.getAbsolutePath());
                    }
                    break;
                }
                ++i;
            }
        }
        catch (Exception t) {
            this.throwServerException(session, log, t);
        }
    }

    public static File getImportDirectory(String tenantName) {
        ContextProperties config = Context.get().getProperties();
        File importDir = new File(config.getProperty("conf.importdir") + File.separator + tenantName);
        if (!importDir.exists()) {
            importDir.mkdirs();
            importDir.mkdir();
        }
        return importDir;
    }

    public GUIArchive load(long archiveId) throws ServerException {
        Session session = this.validateSession();
        try {
            ArchiveDAO archiveDao = Context.get(ArchiveDAO.class);
            GUIArchive arc = new GUIArchive();
            Archive archive = (Archive)archiveDao.findById(archiveId);
            arc.setId(archiveId);
            arc.setCloserId(archive.getCloserId());
            arc.setCloserName(archive.getCloserName());
            arc.setClosure(archive.getClosure());
            arc.setCreation(archive.getCreation());
            arc.setCreatorId(archive.getCreatorId());
            arc.setCreatorName(archive.getCreatorName());
            arc.setDescription(archive.getDescription());
            arc.setImportCustomId(archive.getImportCustomId());
            arc.setImportTemplate(archive.getImportTemplate());
            arc.setMode(archive.getMode());
            arc.setName(archive.getName());
            arc.setSize(archive.getSize());
            arc.setStatus(archive.getStatus());
            arc.setType(archive.getType());
            return arc;
        }
        catch (Exception t) {
            return (GUIArchive)this.throwServerException(session, log, t);
        }
    }
}

