/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.impex;

import com.logicaldoc.impex.ArchiveBuilder;
import com.logicaldoc.impex.ArchiveImporter;
import com.logicaldoc.impex.ArchivesDataServlet;
import com.logicaldoc.impex.ImpexFoldersDataServlet;
import com.logicaldoc.impex.ImpexServiceImpl;
import com.logicaldoc.impex.IncrementalArchiveCreator;
import com.logicaldoc.impex.IncrementalArchivesDataServlet;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.plugin.LogicalDOCPlugin;
import com.logicaldoc.util.plugin.PluginException;
import java.io.IOException;

public class ImpexPlugin
extends LogicalDOCPlugin {
    @Override
    public void install() throws PluginException {
        super.install();
        this.addScheduling("ArchiveBuilder");
        this.addScheduling("ArchiveImporter");
        this.addScheduling("IncrementalArchiveCreator");
        try {
            ContextProperties pbean = new ContextProperties();
            pbean.setProperty("schedule.enabled.ArchiveImporter", "false");
            pbean.setProperty("schedule.enabled.IncrementalArchiveCreator", "false");
            pbean.write();
        }
        catch (IOException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        this.addLogger(ArchiveBuilder.class.getName(), "ArchiveBuilder");
        this.addLogger(ArchiveImporter.class.getName(), "ArchiveImporter");
        this.addLogger(IncrementalArchiveCreator.class.getName(), "IncrementalArchiveCreator");
        this.addServlet("ImpexService", ImpexServiceImpl.class, "/frontend/archive");
        this.addServlet("ArchivesData", ArchivesDataServlet.class, "/data/archives.xml");
        this.addServlet("IncrementalArchivesData", IncrementalArchivesDataServlet.class, "/data/incrementalarchives.xml");
        this.addServlet("ImpexFoldersData", ImpexFoldersDataServlet.class, "/data/impexfolders.xml");
        this.setRestartRequired();
    }
}

