/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.impex;

import com.logicaldoc.core.HibernatePersistentObjectDAO;
import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.AbstractDocument;
import com.logicaldoc.core.document.Version;
import com.logicaldoc.impex.Archive;
import com.logicaldoc.impex.ArchiveCacheManager;
import com.logicaldoc.impex.ArchiveDAO;
import jakarta.annotation.Resource;
import jakarta.transaction.Transactional;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="archiveDAO")
@Transactional
public class HibernateArchiveDAO
extends HibernatePersistentObjectDAO<Archive>
implements ArchiveDAO {
    private static final String CREATION_ASC = ".creation asc";
    private static final String ORDER_BY = "order by ";
    private static final String DOT_MODE_EQUAL = ".mode =";
    private static final String DOT_TENANT_ID_EQUAL = ".tenantId=";
    private static final String AND = " and ";
    @Resource(name="archiveCacheManager")
    private ArchiveCacheManager cacheManager;

    public ArchiveCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(ArchiveCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    protected HibernateArchiveDAO() {
        super(Archive.class);
        this.log = LoggerFactory.getLogger(HibernateArchiveDAO.class);
    }

    @Override
    public void initialize(Archive archive) {
        this.refresh(archive);
        for (Version version : archive.getEntries()) {
            version.getFileName();
        }
    }

    @Override
    public Archive findByName(String name, long tenantId) throws PersistenceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", name);
        params.put("tenantId", tenantId);
        List archives = this.findByWhere("_entity.name = :name and _entity.tenantId = :tenantId", params, null, null);
        if (archives.isEmpty()) {
            return null;
        }
        return (Archive)archives.get(0);
    }

    @Override
    public void delete(long archiveId, int code) throws PersistenceException {
        if (!this.checkStoringAspect()) {
            return;
        }
        Archive archive = (Archive)this.findById(archiveId);
        archive.setDeleted(code);
        archive.setName(archive.getName() + "." + archive.getId());
        this.saveOrUpdate(archive);
        if (archive.getMode() == 0) {
            try {
                this.cacheManager.deleteCache(archive);
            }
            catch (IOException e) {
                this.log.warn(e.getMessage(), e);
            }
        }
    }

    @Override
    public List<Archive> findByStatus(int status, Long tenantId) throws PersistenceException {
        return this.findByWhere("_entity.status =" + status + (String)(tenantId == null ? "" : " and _entity.tenantId=" + String.valueOf(tenantId)), null, null);
    }

    @Override
    public void store(Archive archive) throws PersistenceException {
        this.store(archive, true);
    }

    @Override
    public void store(Archive archive, boolean updateSize) throws PersistenceException {
        if (updateSize) {
            long size = 0L;
            for (AbstractDocument abstractDocument : archive.getEntries()) {
                size += abstractDocument.getFileSize();
            }
            archive.setSize(size);
        }
        super.store(archive);
    }

    @Override
    public List<Long> findArchivedIds(long archiveId) throws PersistenceException {
        return this.queryForList("select ld_versionid from ld_archive_entry where ld_archiveid = " + archiveId, Long.class, null);
    }

    @Override
    public List<Archive> findByMode(int mode, Long tenantId) throws PersistenceException {
        return this.findByWhere("_entity.mode =" + mode + (String)(tenantId == null ? "" : " and _entity.tenantId=" + String.valueOf(tenantId)), "order by _entity.creation desc", null);
    }

    @Override
    public List<Archive> findByModeAndStatus(int mode, int status, Long tenantId) throws PersistenceException {
        return this.findByWhere("_entity.mode =" + mode + " and _entity.status = " + status + (String)(tenantId == null ? "" : " and _entity.tenantId=" + String.valueOf(tenantId)), null, "order by _entity.creation asc", null);
    }

    @Override
    public List<Archive> findByModeAndType(int mode, int type, Long tenantId) throws PersistenceException {
        return this.findByWhere("_entity.mode =" + mode + " and _entity.type = " + type + (String)(tenantId == null ? "" : " and _entity.tenantId=" + String.valueOf(tenantId)), "order by _entity.creation asc", null);
    }

    @Override
    public List<Archive> findByModeAndName(int mode, String name, Long tenantId) throws PersistenceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", name);
        return this.findByWhere("_entity.mode = " + mode + " and _entity.name = :name" + (String)(tenantId == null ? "" : " and _entity.tenantId=" + String.valueOf(tenantId)), params, null, null);
    }

    @Override
    public boolean removeVersions(long archiveId, Set<Long> versionIds) throws PersistenceException {
        if (!this.checkStoringAspect()) {
            return false;
        }
        if (CollectionUtils.isEmpty(versionIds)) {
            return true;
        }
        String versionIdsString = versionIds.stream().map(id -> Long.toString(id)).collect(Collectors.joining(","));
        List<Long> docIds = this.queryForList("select ld_documentid from ld_version where ld_id in (" + versionIdsString + ")", Long.class);
        String docIdsString = docIds.stream().map(id -> Long.toString(id)).collect(Collectors.joining(","));
        this.jdbcUpdate("delete from ld_archive_entry where ld_archiveid=" + archiveId + " and ld_versionid in(" + versionIdsString + ")");
        this.jdbcUpdate("update ld_document set ld_exportstatus=0 where ld_id in(" + docIdsString + ")");
        return true;
    }

    @Override
    public List<Archive> findByModeAndStatusAndType(int mode, int status, int type, Long tenantId) throws PersistenceException {
        if (!this.checkStoringAspect()) {
            return new ArrayList<Archive>();
        }
        return this.findByWhere("_entity.mode =" + mode + " and _entity.status = " + status + " and _entity.type = " + type + (String)(tenantId == null ? "" : " and _entity.tenantId=" + String.valueOf(tenantId)), "order by _entity.creation asc", null);
    }
}

