/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.impex;

import com.logicaldoc.i18n.I18N;
import com.logicaldoc.impex.ArchiveVerifier;
import com.logicaldoc.impex.Index;
import com.logicaldoc.impex.IndexHandler;
import com.logicaldoc.util.io.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class DefaultVerifier
extends ArchiveVerifier {
    private static final String INDEX_XML = "index.xml";
    private static final String INDEX_ZIP = "index.zip";

    public DefaultVerifier(File dir, IndexHandler handler) throws ParserConfigurationException, SAXException, IOException {
        block10: {
            this.rootDir = dir;
            if (new File(dir, INDEX_ZIP).exists()) {
                Throwable throwable = null;
                Object var4_5 = null;
                try (ZipUtil zipUtil = new ZipUtil();){
                    this.index = new Index(zipUtil.getEntryBytes(new File(dir, INDEX_ZIP), INDEX_XML), handler);
                    break block10;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            this.index = new Index(new File(dir, INDEX_XML), handler);
        }
    }

    @Override
    public boolean verify() {
        this.checkResources();
        this.initFilesMap(this.getDocsDir());
        this.validateDocsNumber();
        this.validateDocs();
        this.validateHashes();
        this.valid = this.checkResources && this.checkDocsNumber && this.checkDocs && this.checkHashes;
        return this.valid;
    }

    private void checkResources() {
        this.addLocalizedInfo("checkresourcesstart");
        this.checkIndexFileExistence();
        this.checkDocsFolderExistence();
        if (this.rootDir.listFiles().length != 4) {
            this.addLocalizedError("checkresourcesnumber");
            this.checkPresenceOfUnknownResources();
        }
        if (this.checkResources) {
            this.addLocalizedInfo("checkresources", I18N.message("passed", this.logsLocale));
        } else {
            this.addLocalizedError("checkresources", I18N.message("failed", this.logsLocale));
        }
    }

    private void checkPresenceOfUnknownResources() {
        List<String> attendedFileNames = Arrays.asList(INDEX_XML, INDEX_ZIP, "index.html", "impex.xsd", "index.csv.zip");
        File[] fileArray = this.rootDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                if (!f.getName().equals("docs")) {
                    this.addLocalizedError("checkfoldererror", f.getName());
                    this.checkResources = false;
                }
            } else if (!attendedFileNames.contains(f.getName())) {
                this.addLocalizedError("checkfileerror", f.getName());
                this.checkResources = false;
            }
            ++n2;
        }
    }

    private void checkDocsFolderExistence() {
        File file = new File(this.rootDir, "docs");
        if (!file.exists() || !file.isDirectory()) {
            this.addLocalizedError("checkfoldernotfound", "'docs'");
            this.checkResources = false;
        }
    }

    private void checkIndexFileExistence() {
        File file = new File(this.rootDir, INDEX_ZIP);
        if (!(file.exists() && file.isFile() || (file = new File(this.rootDir, INDEX_XML)).exists() && file.isFile())) {
            this.addLocalizedError("checkfilenotfound", INDEX_XML);
            this.checkResources = false;
        }
    }
}

