/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.impex;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.i18n.I18N;
import com.logicaldoc.impex.Archive;
import com.logicaldoc.impex.ArchiveDAO;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.data.AbstractDataServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class ArchivesDataServlet
extends AbstractDataServlet {
    private static final long serialVersionUID = 1L;

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response, Session session, Integer max, Locale locale) throws PersistenceException, IOException {
        int mode = Integer.parseInt(request.getParameter("mode"));
        Integer status = this.getStatus(request);
        Integer type = this.getType(request);
        List<Archive> archives = this.getArchives(session, mode, status, type);
        DateFormat df = this.getDateFormat();
        PrintWriter writer = response.getWriter();
        writer.write("<list>");
        for (Archive archive : archives) {
            if (type != null && type == 1 && status == null && archive.getStatus() == 2) continue;
            writer.print("<archive>");
            writer.print("<id>" + archive.getId() + "</id>");
            writer.print("<name><![CDATA[" + archive.getName() + "]]></name>");
            writer.print("<description><![CDATA[" + archive.getDescription() + "]]></description>");
            writer.print("<size>" + archive.getSize() + "</size>");
            writer.print("<status>" + archive.getStatus() + "</status>");
            writer.print("<mode>" + archive.getMode() + "</mode>");
            writer.print("<type>" + archive.getType() + "</type>");
            writer.print("<typelabel>" + I18N.message("default", locale) + "</typelabel>");
            writer.print("<created>" + df.format(archive.getCreation()) + "</created>");
            writer.print("<creator><![CDATA[" + StringUtils.defaultString(archive.getCreatorName()) + "]]></creator>");
            writer.print("<closer><![CDATA[" + StringUtils.defaultString(archive.getCloserName()) + "]]></closer>");
            writer.print("<pathonserver><![CDATA[" + (archive.getMode() == 1 ? new File(Context.get().getProperties().getProperty("conf.exportdir"), archive.getName()).getAbsolutePath() : new File(Context.get().getProperties().getProperty("conf.importdir"), archive.getName()).getAbsolutePath()) + "]]></pathonserver>");
            writer.print("</archive>");
        }
        writer.write("</list>");
    }

    private List<Archive> getArchives(Session session, int mode, Integer status, Integer type) throws PersistenceException {
        ArchiveDAO archiveDao = Context.get(ArchiveDAO.class);
        List<Archive> archives = null;
        archives = status != null && type != null ? archiveDao.findByModeAndStatusAndType(mode, status, type, session.getTenantId()) : (status == null && type != null ? archiveDao.findByModeAndType(mode, type, session.getTenantId()) : (status != null ? archiveDao.findByModeAndStatus(mode, status, session.getTenantId()) : archiveDao.findByMode(mode, session.getTenantId())));
        return archives;
    }

    private Integer getType(HttpServletRequest request) {
        Integer type = null;
        if (request.getParameter("type") != null) {
            type = Integer.parseInt(request.getParameter("type"));
        }
        return type;
    }

    private Integer getStatus(HttpServletRequest request) {
        Integer status = null;
        if (request.getParameter("status") != null) {
            status = Integer.parseInt(request.getParameter("status"));
        }
        return status;
    }
}

