/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.impex;

import com.logicaldoc.core.document.Version;
import com.logicaldoc.i18n.I18N;
import com.logicaldoc.impex.DefaultVerifier;
import com.logicaldoc.impex.Index;
import com.logicaldoc.impex.IndexHandler;
import com.logicaldoc.impex.IndexVersion;
import com.logicaldoc.impex.application.Database;
import com.logicaldoc.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public abstract class ArchiveVerifier {
    private static final String FAILED = "failed";
    private static final String PASSED = "passed";
    private static final Logger log = LoggerFactory.getLogger(ArchiveVerifier.class);
    protected boolean checkResources = true;
    protected boolean checkDocsNumber = true;
    protected boolean checkDocs = true;
    protected boolean checkHashes = true;
    protected boolean valid = true;
    protected File rootDir;
    protected Locale logsLocale = Locale.getDefault();
    private List<String> report = new ArrayList<String>();
    protected Index index;
    protected Map<String, String> digestMap = new HashMap<String, String>();

    public boolean isCheckResources() {
        return this.checkResources;
    }

    public boolean isCheckDocsNumber() {
        return this.checkDocsNumber;
    }

    public boolean isCheckDocs() {
        return this.checkDocsNumber && this.checkDocs;
    }

    public boolean isCheckHashes() {
        return this.checkDocsNumber && this.checkDocs && this.checkHashes;
    }

    public static ArchiveVerifier getInstance(File dir) throws ParserConfigurationException, SAXException, IOException {
        return ArchiveVerifier.getInstance(dir, new IndexHandler());
    }

    public static ArchiveVerifier getInstance(File dir, IndexHandler handler) throws ParserConfigurationException, SAXException, IOException {
        if (dir == null || !dir.isDirectory()) {
            throw new IOException("Not a valid folder");
        }
        if (new File(dir, "index.zip").exists() || new File(dir, "index.xml").exists()) {
            return new DefaultVerifier(dir, handler);
        }
        throw new IOException("The folder " + dir.getPath() + " is not recognized as an archive folder");
    }

    public abstract boolean verify();

    protected void addLocalizedInfo(String messageKey) {
        this.addLocalizedInfo(messageKey, null);
    }

    protected void addLocalizedInfo(String messageKey, String param1) {
        String message = I18N.message(messageKey, this.logsLocale, new Object[]{param1});
        log.info(message);
        this.report.add(message);
    }

    protected void addLocalizedError(String messageKey) {
        this.addLocalizedError(messageKey, null);
    }

    protected void addLocalizedError(String messageKey, String param1) {
        String message = I18N.message(messageKey, this.logsLocale, new Object[]{param1});
        log.info(message);
        this.report.add(I18N.message("error", this.logsLocale) + ": " + message);
    }

    public boolean isValid() {
        return this.valid;
    }

    public File getDocsDir() {
        return new File(this.rootDir, "docs");
    }

    protected void initFilesMap(File parent) {
        File[] filesArray = null;
        filesArray = parent.listFiles();
        if (filesArray != null) {
            int i = 0;
            while (i < filesArray.length) {
                if (filesArray[i].isDirectory()) {
                    this.initFilesMap(filesArray[i]);
                } else {
                    int basepathLength = this.rootDir.getPath().length() + 1;
                    this.digestMap.put(filesArray[i].getPath().replace("\\", "/").substring(basepathLength), FileUtil.computeDigest(filesArray[i]));
                }
                ++i;
            }
        }
    }

    protected void validateDocsNumber() {
        this.addLocalizedInfo("checkdocsnumstart");
        long count = this.index.getCount();
        int entriesCount = 0;
        entriesCount = this.index.getArchive() != null && CollectionUtils.isNotEmpty(this.index.getArchive().getEntries()) ? this.index.getArchive().getEntries().size() : Database.getInstance().countDocuments();
        if (count != (long)entriesCount) {
            this.addLocalizedError("checkdocsnumindexarchive");
            this.checkDocsNumber = false;
        }
        if ((long)this.digestMap.size() != count) {
            this.addLocalizedError("checkdocsnumindexdocs");
        }
        if (this.checkDocsNumber) {
            this.addLocalizedInfo("checkdocsnum", I18N.message(PASSED, this.logsLocale));
        } else {
            this.addLocalizedError("checkdocsnum", I18N.message(FAILED, this.logsLocale));
        }
    }

    protected void validateDocs() {
        this.addLocalizedInfo("checkdocsexistencestart");
        for (Version entry : this.index.getArchive().getEntries()) {
            IndexVersion indexEntry = (IndexVersion)entry;
            if (this.digestMap.containsKey(indexEntry.getDiskPath())) continue;
            this.addLocalizedError("checkfilenotfound", "'" + indexEntry.getDiskPath() + "'");
            this.checkDocs = false;
        }
        if (this.checkDocsNumber && this.checkDocs) {
            this.addLocalizedInfo("checkdocsexistence", I18N.message(PASSED, this.logsLocale));
        } else {
            this.addLocalizedError("checkdocsexistence", I18N.message(FAILED, this.logsLocale));
        }
    }

    protected void validateHashes() {
        this.addLocalizedInfo("checkhashesstart");
        for (Version entry : this.index.getArchive().getEntries()) {
            IndexVersion indexEntry = (IndexVersion)entry;
            String digest = indexEntry.getDigest();
            if (digest.equals(this.digestMap.get(indexEntry.getDiskPath()))) continue;
            this.addLocalizedError("checkhashesfilealtered", "'" + indexEntry.getFileName() + "'");
            this.checkHashes = false;
        }
        if (this.checkDocsNumber && this.checkDocs && this.checkHashes) {
            this.addLocalizedInfo("checkhashes", I18N.message(PASSED, this.logsLocale));
        } else {
            this.addLocalizedError("checkhashes", I18N.message(FAILED, this.logsLocale));
        }
    }

    public List<String> getReport() {
        return this.report;
    }

    public void setReport(List<String> report) {
        this.report = report;
    }

    public void setLogsLocale(Locale logsLocale) {
        this.logsLocale = logsLocale;
    }

    public String getArchiveName() {
        return this.index.getArchive().getName();
    }

    public Index getIndex() {
        return this.index;
    }
}

