/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.impex;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.RunLevel;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.DocumentEvent;
import com.logicaldoc.core.document.DocumentHistory;
import com.logicaldoc.core.document.Version;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.security.TenantDAO;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.i18n.I18N;
import com.logicaldoc.impex.Archive;
import com.logicaldoc.impex.ArchiveDAO;
import com.logicaldoc.impex.Index;
import com.logicaldoc.impex.IndexCSV;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.io.ResourceUtil;
import jakarta.annotation.Resource;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="archiveManager")
public class ArchiveManager {
    private static final Logger log = LoggerFactory.getLogger(ArchiveManager.class);
    @Resource(name="ContextProperties")
    private ContextProperties config;
    @Resource(name="archiveDAO")
    private ArchiveDAO archiveDao;
    @Resource(name="tenantDAO")
    private TenantDAO tenantDao;
    @Resource(name="documentDAO")
    private DocumentDAO documentDao;
    @Resource(name="folderDAO")
    private FolderDAO folderDao;

    public File getArchiveDirectory(Archive archive) throws PersistenceException {
        return this.getArchiveDirectory(archive.getMode(), archive.getName(), Long.toString(archive.getId()), archive.getTenantId());
    }

    public File getArchiveDirectory(int mode, String archiveName, String id, long tenantId) throws PersistenceException {
        return this.getArchiveDirectory(mode, archiveName, id, this.tenantDao.getTenantName(tenantId));
    }

    public File getArchiveDirectory(int mode, String archiveName, String id, String tenantName) {
        File archiveDir = null;
        if (mode == 0) {
            String importDir = this.config.getProperty("conf.importdir");
            archiveDir = new File(importDir + File.separator + tenantName + File.separator + archiveName + ".archive." + id);
            archiveDir.mkdirs();
            archiveDir.mkdir();
        } else if (mode == 1) {
            String exportDir = this.config.getProperty("conf.exportdir");
            archiveDir = new File(exportDir + File.separator + tenantName + File.separator + archiveName);
            archiveDir.mkdirs();
            archiveDir.mkdir();
        }
        return archiveDir;
    }

    public void writeIndex(Archive archive) throws IOException, PersistenceException {
        File indexFileTmp = new File(this.getArchiveDirectory(archive), "index.xml.tmp");
        boolean created = indexFileTmp.createNewFile();
        if (!created) {
            throw new IOException("Cannot create file " + indexFileTmp.getAbsolutePath());
        }
        log.info("Generating index file index.xml");
        Index index = new Index(indexFileTmp);
        index.setArchive(archive);
        index.marshall();
        log.info("Index file index.xml completed");
        File indexFile = new File(this.getArchiveDirectory(archive), "index.xml");
        FileUtils.moveFile(indexFileTmp, indexFile);
        indexFileTmp = new File(this.getArchiveDirectory(archive), "index.csv.tmp");
        created = indexFileTmp.createNewFile();
        if (!created) {
            throw new IOException("Cannot create file " + indexFileTmp.getAbsolutePath());
        }
        log.info("Generating index file index.csv");
        Throwable throwable = null;
        Object var7_8 = null;
        try (IndexCSV csv = new IndexCSV(indexFileTmp, archive);){
            csv.marshall();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        log.info("Index file index.csv completed");
        indexFile = new File(this.getArchiveDirectory(archive), "index.csv");
        FileUtils.moveFile(indexFileTmp, indexFile);
    }

    public void writeIndex(Archive archive, Writer writer) throws IOException, PersistenceException {
        Index index = new Index(archive);
        index.marshall(writer);
    }

    public void writeHtmlIndex(Archive archive) throws IOException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedWriter writer = new BufferedWriter(new PrintWriter(new File(this.getArchiveDirectory(archive), "index.html"), "UTF-8"), 4096);){
                Object[] impexParams = this.getImpexParams(archive);
                writer.write(MessageFormat.format(ResourceUtil.readAsString("/templates/impex_template.html"), impexParams));
                for (Version version : archive.getEntries()) {
                    Object[] docParams = this.getDocumentParams(version);
                    writer.write(MessageFormat.format(ResourceUtil.readAsString("/templates/document_template.html"), docParams));
                }
                writer.write("\n            </tbody>");
                writer.write("\n           </table>");
                writer.write("\n         </td>");
                writer.write("\n       </tr>");
                writer.write("\n     </tbody>");
                writer.write("\n   </table>");
                writer.write("\n </body>");
                writer.write("\n</html>");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    private Object[] getDocumentParams(Version version) throws PersistenceException {
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        Object[] docParams = new Object[7];
        int i = 0;
        while (i < docParams.length) {
            String value = null;
            switch (i) {
                case 0: {
                    value = Long.toString(version.getDocId());
                    break;
                }
                case 1: {
                    value = StringUtils.trimToEmpty(version.getCustomId());
                    break;
                }
                case 2: {
                    value = StringUtils.trimToEmpty(version.getFileName());
                    break;
                }
                case 3: {
                    value = StringUtils.trimToEmpty(version.getVersion());
                    break;
                }
                case 4: {
                    value = version.getCreation() != null ? df1.format(version.getCreation()) : "";
                    break;
                }
                case 5: {
                    value = this.getFileSize(version);
                    break;
                }
                case 6: {
                    value = this.getPath(version);
                    break;
                }
            }
            docParams[i] = value;
            ++i;
        }
        return docParams;
    }

    private String getFileSize(Version version) {
        return StringUtils.isNotEmpty(Long.toString(version.getFileSize())) ? FileUtil.getDisplaySize(version.getFileSize(), "en") : "";
    }

    private String getPath(Version version) throws PersistenceException {
        String path = "docs" + this.folderDao.computePathExtended(version.getFolderId()) + File.separator + version.getFileName();
        return path.replace("//", "/");
    }

    private Object[] getImpexParams(Archive archive) throws IOException, PersistenceException {
        ContextProperties context = new ContextProperties();
        Object[] impexParams = new Object[12];
        int i = 0;
        while (i < impexParams.length) {
            Object value = null;
            switch (i) {
                case 0: {
                    value = Long.toString(archive.getId());
                    break;
                }
                case 1: {
                    value = archive.getName();
                    break;
                }
                case 2: {
                    value = context.getProperty("product.release");
                    break;
                }
                case 3: {
                    value = "9.2.1";
                    break;
                }
                case 4: {
                    value = archive.getType() == 0 ? I18N.message("default", Locale.getDefault()) : I18N.message("paperdematerialization", Locale.getDefault());
                    break;
                }
                case 5: {
                    value = FileUtil.getDisplaySize(archive.getSize(), "en");
                    break;
                }
                case 6: {
                    value = Integer.toString(this.archiveDao.findArchivedIds(archive.getId()).size());
                    break;
                }
                case 7: {
                    value = archive.getCreatorName();
                    break;
                }
                case 8: {
                    value = archive.getCreation();
                    break;
                }
                case 9: {
                    value = archive.getCloserName();
                    break;
                }
                case 10: {
                    value = archive.getClosure();
                    break;
                }
                case 11: {
                    value = !StringUtils.isEmpty(archive.getDescription()) ? archive.getDescription() : "-";
                    break;
                }
            }
            impexParams[i] = value;
            ++i;
        }
        return impexParams;
    }

    public boolean addEntry(Archive archive, Version version, User user, String sid) {
        return this.addEntry(archive, version, user, I18N.message("archivecommentadded", user.getLocale(), new Object[]{version.getVersion(), archive.getName()}), sid);
    }

    public boolean addEntry(Archive archive, Version version, User user, String comment, String sid) {
        boolean added = archive.addEntry(version);
        if (added) {
            try {
                Document doc = (Document)this.documentDao.findById(version.getDocId());
                this.documentDao.initialize(doc);
                doc.setExportStatus(1);
                doc.setExportId(archive.getId());
                doc.setExportName(archive.getName());
                doc.setExportVersion(version.getVersion());
                this.documentDao.store(doc);
                added = true;
                this.createHistoryEntry(doc.getId(), user, DocumentEvent.EXPORTED, comment, sid);
            }
            catch (Exception e) {
                log.error(e.getMessage(), e);
            }
        }
        return added;
    }

    public void delete(long archiveId, User user, String comment) throws PersistenceException {
        this.documentDao.jdbcUpdate("update ld_document set ld_exportstatus=0 where ld_exportstatus=1 and ld_exportid=" + archiveId);
        this.archiveDao.delete(archiveId);
    }

    private void createHistoryEntry(long docId, User user, DocumentEvent eventType, String reason, String sid) throws PersistenceException {
        if (!RunLevel.current().aspectEnabled("saveHistory")) {
            return;
        }
        DocumentHistory history = new DocumentHistory();
        history.setDocId(docId);
        Document doc = (Document)this.documentDao.findById(docId);
        history.setDocument(doc);
        history.setPath(this.folderDao.computePathExtended(doc.getFolder().getId()));
        history.setDate(new Date());
        history.setUser(user);
        history.setEvent(eventType);
        history.setComment(reason);
        if (sid != null) {
            history.setSessionId(sid);
        }
        try {
            this.documentDao.saveDocumentHistory(doc, history);
        }
        catch (PersistenceException e) {
            log.warn(e.getMessage(), e);
        }
    }

    public void closeArchive(long id, User user) throws PersistenceException {
        Archive archive = (Archive)this.archiveDao.findById(id);
        this.archiveDao.initialize(archive);
        archive.setCloserId(user.getId());
        archive.setCloserName(user.getFullName());
        archive.setClosure(new Date());
        archive.setStatus(1);
        this.archiveDao.store(archive);
        this.documentDao.jdbcUpdate("update ld_document set ld_exportstatus = :exportStatus where ld_exportid = :id", Map.of("exportStatus", 0, "id", id));
    }
}

