/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.impex;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.DocumentManager;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.metadata.Template;
import com.logicaldoc.core.metadata.TemplateDAO;
import com.logicaldoc.core.security.Tenant;
import com.logicaldoc.core.security.TenantDAO;
import com.logicaldoc.core.task.Task;
import com.logicaldoc.core.task.TaskException;
import com.logicaldoc.i18n.I18N;
import com.logicaldoc.impex.Archive;
import com.logicaldoc.impex.ArchiveCacheManager;
import com.logicaldoc.impex.ArchiveDAO;
import com.logicaldoc.impex.ArchiveManager;
import com.logicaldoc.impex.ArchiveVerifier;
import com.logicaldoc.impex.CustomIdsExtractorHandler;
import com.logicaldoc.impex.ImpexServiceImpl;
import com.logicaldoc.impex.Index;
import com.logicaldoc.impex.IndexHandler;
import com.logicaldoc.impex.IndexHeaderHandler;
import com.logicaldoc.impex.IndexImportHandler;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.io.ZipUtil;
import com.logicaldoc.util.spring.Context;
import com.logicalobjects.jlicense.license.LicenseManager;
import jakarta.annotation.Resource;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.xml.sax.SAXException;

@Component(value="archiveImporter")
public class ArchiveImporter
extends Task {
    private static final String INDEX_XML = "index.xml";
    private static final String INDEX_ZIP = "index.zip";
    public static final String NAME = "ArchiveImporter";
    @Resource(name="tenantDAO")
    private TenantDAO tenantDao;
    @Resource(name="archiveDAO")
    private ArchiveDAO archiveDao;
    @Resource(name="archiveManager")
    private ArchiveManager archiveManager;
    @Resource(name="documentManager")
    private DocumentManager documentManager;
    @Resource(name="archiveCacheManager")
    private ArchiveCacheManager cacheManager;
    @Resource(name="documentDAO")
    private DocumentDAO documentDao;
    @Resource(name="folderDAO")
    private FolderDAO folderDao;
    private long importCount = 0L;
    private long imported = 0L;
    private long updated = 0L;
    private long errors = 0L;

    public ArchiveImporter() {
        super(NAME);
        this.log = LoggerFactory.getLogger(ArchiveImporter.class);
    }

    @Override
    public boolean isIndeterminate() {
        return false;
    }

    @Override
    public boolean isConcurrent() {
        return false;
    }

    public long getImported() {
        return this.imported;
    }

    public long getUpdated() {
        return this.updated;
    }

    public long getErrors() {
        return this.errors;
    }

    private long count() throws PersistenceException {
        long count = 0L;
        List<Archive> archives = this.archiveDao.findByModeAndStatus(0, 0, null);
        for (Archive archive : archives) {
            long docsCount = archive.getSize();
            if (docsCount == 0L) {
                docsCount = this.updateSizeAndType(archive);
            }
            count += docsCount;
            this.importCount += docsCount;
            ++count;
            ++count;
            ++count;
        }
        return count;
    }

    @Override
    protected void runTask() throws TaskException {
        this.log.info("Start importing of all archives");
        this.imported = 0L;
        this.updated = 0L;
        this.errors = 0L;
        this.importCount = 0L;
        try {
            try {
                this.size = this.count();
                this.log.info("Found a total of {} documents", (Object)this.importCount);
                this.importArchives();
            }
            catch (PersistenceException e) {
                throw new TaskException(e.getMessage(), e);
            }
        }
        finally {
            this.log.info("Import finished");
            this.log.info("Imported documents: {}", (Object)this.imported);
            this.log.info("Updated Documents: {}", (Object)this.updated);
            this.log.info("Errors: {}", (Object)this.errors);
        }
    }

    @Override
    protected String prepareReport(Locale locale) {
        StringBuilder sb = new StringBuilder();
        sb.append(I18N.message("importeddocs", locale) + ": ");
        sb.append(this.imported);
        sb.append("\n");
        sb.append(I18N.message("updateddocs", locale) + ": ");
        sb.append(this.updated);
        sb.append("\n");
        sb.append(I18N.message("errors", locale) + ": ");
        sb.append(this.errors);
        return sb.toString();
    }

    private void importArchives() throws PersistenceException {
        if (!LicenseManager.getInstance().isEnabled("Feature_4")) {
            this.log.error("Feature not enabled, exit building");
            return;
        }
        this.imported = 0L;
        this.updated = 0L;
        List<Archive> archives = this.archiveDao.findByModeAndStatus(0, 0, null);
        this.log.info("Found {} archives to import", (Object)archives.size());
        try {
            this.processArchives(archives);
        }
        finally {
            this.removeTransactionReference();
        }
    }

    private void removeTransactionReference() {
        try {
            this.documentDao.jdbcUpdate("update ld_document set ld_transactionid = null where ld_transactionId = :transactionId", Map.of("transactionId", this.transactionId));
        }
        catch (PersistenceException e) {
            this.log.warn(e.getMessage(), e);
        }
    }

    private void processArchives(Collection<Archive> archives) throws PersistenceException {
        for (Archive archive : archives) {
            if (this.interruptRequested) break;
            Tenant tenant = (Tenant)this.tenantDao.findById(archive.getTenantId());
            this.log.info("Process archive {}", (Object)archive.getName());
            try {
                this.importArchive(archive);
                archive = (Archive)this.archiveDao.findById(archive.getId());
                this.archiveDao.initialize(archive);
                if (this.errors == 0L) {
                    this.log.info("Set the {} as finalized", (Object)archive.getName());
                    archive.setStatus(2);
                    this.archiveDao.store(archive, false);
                    FileUtil.delete(new File(ImpexServiceImpl.getImportDirectory(tenant.getName()).getPath() + File.separator + archive.getName() + ".archive." + archive.getId()));
                    this.next();
                    continue;
                }
                archive.setStatus(4);
                this.archiveDao.store(archive, false);
                this.errors = 0L;
                this.log.error("Unable to finalize archive {}, because some errors occurred.", (Object)archive.getName());
            }
            catch (Exception e) {
                this.log.error("Unable to process archive {}", (Object)archive.getName(), (Object)e);
            }
        }
    }

    void following() {
        super.next();
    }

    private void importArchive(Archive archive) throws IOException, PersistenceException, ParserConfigurationException, SAXException {
        Tenant tenant = (Tenant)this.tenantDao.findById(archive.getTenantId());
        File archiveDir = this.archiveManager.getArchiveDirectory(archive);
        if (!archiveDir.exists()) {
            this.log.error("The archive directory not exists");
            ++this.errors;
            this.setProgress(this.getProgress() + 1L + archive.getSize());
            return;
        }
        this.log.info("Initialize the archive {}", (Object)archive.getName());
        this.archiveDao.initialize(archive);
        this.log.info("Verify the archive");
        boolean valid = true;
        ArchiveVerifier verifier = null;
        if (archive.getType() == 0) {
            this.log.info("The archive is 'Default'");
            verifier = ArchiveVerifier.getInstance(archiveDir);
            valid = verifier.verify();
        }
        if (!valid) {
            this.log.error("The archive is not valid");
            ++this.errors;
            this.setProgress(this.getProgress() + 1L + archive.getSize());
            for (String line : verifier.getReport()) {
                this.log.warn(line);
            }
            return;
        }
        this.log.info("The archive is valid");
        this.next();
        if (this.errors > 0L) {
            return;
        }
        archive.setStatus(1);
        this.archiveDao.store(archive, false);
        this.log.info("The archive {} - {} has been closed", (Object)archive.getId(), (Object)archive.getName());
        if (archive.getImportCustomId() == 1 || archive.getImportCustomId() == 2) {
            this.assignTransactionIdToExistingCustomIds(archive, tenant, archiveDir);
        }
        IndexImportHandler handler = null;
        if (archive.getImportTemplate() == 1) {
            TemplateDAO templateDao = Context.get(TemplateDAO.class);
            List allTemplates = templateDao.findAll(archive.getTenantId());
            HashMap<String, Template> templates = new HashMap<String, Template>();
            for (Template template : allTemplates) {
                templates.put(template.getName(), template);
            }
            handler = new IndexImportHandler(archive, this, templates, this.folderDao.findWorkspaces(archive.getTenantId()), tenant, this.transactionId);
        } else if (archive.getImportTemplate() == 0) {
            handler = new IndexImportHandler(archive, this, null, this.folderDao.findWorkspaces(archive.getTenantId()), tenant, this.transactionId);
        }
        if (handler == null) {
            this.log.error("Unable to initialize the handler for the index file");
            ++this.errors;
            this.setProgress(this.getProgress() + 1L + archive.getSize());
            return;
        }
        this.log.info("Initialize the index");
        this.initializeIndex(archiveDir, handler);
        this.log.info("Index initialized");
        this.next();
    }

    private void assignTransactionIdToExistingCustomIds(Archive archive, Tenant tenant, File archiveDir) throws PersistenceException, IOException, ParserConfigurationException, SAXException {
        String currentTransactionIds = this.lockManager.getAllTransactions().stream().map(t -> "'" + t + "'").collect(Collectors.joining(","));
        CustomIdsExtractorHandler handler = new CustomIdsExtractorHandler(archive, this, this.folderDao.findWorkspaces(archive.getTenantId()), tenant);
        Index extractCustomIdsIndex = this.initializeIndex(archiveDir, handler);
        String customIdsInArchive = extractCustomIdsIndex.getArchive().getEntries().stream().map(v -> "'" + v.getCustomId() + "'").collect(Collectors.joining(","));
        this.documentDao.jdbcUpdate(" update ld_document set ld_transactionid = :transactionId where (ld_transactionid is null or not ld_transactionid in (" + StringUtils.defaultString((String)currentTransactionIds, (String)"'unexisting'") + ")) and  ld_customid in (" + StringUtils.defaultString((String)customIdsInArchive, (String)"'unexisting'") + ")", Map.of("transactionId", this.transactionId));
    }

    private Index initializeIndex(File archiveDir, IndexHandler handler) throws IOException, ParserConfigurationException, SAXException {
        Index index;
        block10: {
            if (new File(archiveDir, INDEX_ZIP).exists()) {
                Throwable throwable = null;
                Object var5_5 = null;
                try (ZipUtil zipUtil = new ZipUtil();){
                    index = new Index(zipUtil.getEntryBytes(new File(archiveDir, INDEX_ZIP), INDEX_XML), handler);
                    break block10;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            index = new Index(FileUtils.readFileToByteArray(new File(archiveDir, INDEX_XML)), handler);
        }
        return index;
    }

    public Logger getLog() {
        return this.log;
    }

    public void setImported(long imported) {
        this.imported = imported;
    }

    public void setUpdated(long updated) {
        this.updated = updated;
    }

    public void setErrors(long errors) {
        this.errors = errors;
    }

    private long updateSizeAndType(Archive archive) throws PersistenceException {
        this.log.info("Get the total number of documents into the archive {}", (Object)archive.getName());
        IndexHeaderHandler handler = new IndexHeaderHandler();
        Index index = null;
        File indexFileZip = null;
        File rootDir = this.archiveManager.getArchiveDirectory(archive);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (ZipUtil zipUtil = new ZipUtil();){
                if (new File(rootDir, INDEX_ZIP).exists()) {
                    indexFileZip = new File(rootDir, INDEX_ZIP);
                    index = new Index(zipUtil.getEntryBytes(indexFileZip, INDEX_XML), (IndexHandler)handler);
                } else if (new File(rootDir, INDEX_XML).exists()) {
                    index = new Index(FileUtils.readFileToByteArray(new File(rootDir, INDEX_XML)), (IndexHandler)handler);
                }
                this.archiveDao.initialize(archive);
                archive.setSize(index != null ? index.getCount() : 0L);
                archive.setType(handler.getType());
                this.archiveDao.store(archive, false);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.log.error("Error retrieving the documents count of the archive {}", (Object)archive.getName());
            this.log.error(e.getMessage(), e);
            ++this.errors;
        }
        return index != null ? index.getCount() : 0L;
    }
}

