/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.impex;

import com.logicaldoc.enterprise.cleaner.Cleaner;
import com.logicaldoc.impex.ArchiveManager;
import com.logicaldoc.util.spring.Context;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.io.FileUtils;

public class ArchiveCleaner
extends Cleaner {
    private Collection<String> deletedArchivePaths = new ArrayList<String>();

    public ArchiveCleaner() {
        this.setDbScript("sql/clean-impex.sql");
    }

    protected void afterDbUpdate() {
        for (String archivePath : this.deletedArchivePaths) {
            try {
                FileUtils.deleteDirectory(new File(archivePath));
            }
            catch (IOException e) {
                this.log.warn(e.getMessage());
            }
        }
    }

    protected void beforeDbUpdate() {
        this.deletedArchivePaths.clear();
        this.log.debug("Looking for deleted archives");
        ArchiveManager archiveManager = Context.get(ArchiveManager.class);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Statement stmt = this.connection.createStatement();){
                ResultSet rs = stmt.executeQuery("select A.ld_name, A.ld_tenantid from ld_archive A where A.ld_deleted > 0;");
                while (rs.next()) {
                    this.deletedArchivePaths.add(archiveManager.getArchiveDirectory(1, rs.getString(1), "", rs.getLong(2)).getPath().replace("//", "/"));
                }
                this.log.debug("The number of deleted archives is: {}", (Object)this.deletedArchivePaths.size());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), e);
        }
    }
}

