/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.impex;

import com.logicaldoc.impex.Archive;
import com.logicaldoc.impex.ArchiveCache;
import com.logicaldoc.util.plugin.LogicalDOCPlugin;
import com.logicaldoc.util.plugin.PluginRegistry;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="archiveCacheManager")
public class ArchiveCacheManager {
    private static final Logger log = LoggerFactory.getLogger(ArchiveCacheManager.class);

    public ArchiveCache getCache(Archive archive) throws IOException {
        File cacheFile = new File(this.getCacheDirectory(), "cache-" + archive.getId() + ".txt");
        FileUtils.touch(cacheFile);
        return new ArchiveCache(cacheFile);
    }

    public void deleteCache(Archive archive) throws IOException {
        File cacheFile = new File(this.getCacheDirectory(), "cache-" + archive.getId() + ".txt");
        if (cacheFile.exists()) {
            FileUtils.forceDelete(cacheFile);
        }
    }

    private File getCacheDirectory() {
        File file = new File("");
        try {
            LogicalDOCPlugin impexPlugin = (LogicalDOCPlugin)PluginRegistry.getInstance().getManager().getPlugin("logicaldoc-impex");
            file = impexPlugin.resolveDataPath("cache");
            if (!file.exists()) {
                file.mkdir();
            }
        }
        catch (Exception t) {
            log.error(t.getMessage(), t);
        }
        return file;
    }
}

